/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.HeapSnapshotVerifier;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisField;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public abstract class ImageHeapScanner {
    protected final BigBang bb;
    protected final ImageHeap imageHeap;
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisUniverse universe;
    protected final HostVM hostVM;
    protected final SnippetReflectionProvider snippetReflection;
    protected final ConstantReflectionProvider constantReflection;
    protected final HostedValuesProvider hostedValuesProvider;
    protected final ConstantReflectionProvider hostedConstantReflection;
    protected final SnippetReflectionProvider hostedSnippetReflection;
    protected ObjectScanningObserver scanningObserver;
    private boolean sealed;

    public ImageHeapScanner(BigBang bb, ImageHeap heap, AnalysisMetaAccess aMetaAccess, SnippetReflectionProvider aSnippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver, HostedValuesProvider aHostedValuesProvider) {
        this.bb = bb;
        this.imageHeap = heap;
        this.metaAccess = aMetaAccess;
        this.universe = aMetaAccess.getUniverse();
        this.hostVM = aMetaAccess.getUniverse().hostVM();
        this.snippetReflection = aSnippetReflection;
        this.constantReflection = aConstantReflection;
        this.hostedValuesProvider = aHostedValuesProvider;
        this.scanningObserver = aScanningObserver;
        this.hostedConstantReflection = GraalAccess.getOriginalProviders().getConstantReflection();
        this.hostedSnippetReflection = GraalAccess.getOriginalProviders().getSnippetReflection();
    }

    public ConstantReflectionProvider getConstantReflection() {
        return this.constantReflection;
    }

    public void seal() {
        this.sealed = true;
    }

    public void scanEmbeddedRoot(JavaConstant root, BytecodePosition position) {
        if (this.isNonNullObjectConstant(root)) {
            ObjectScanner.EmbeddedRootScan reason = new ObjectScanner.EmbeddedRootScan(position, root);
            ImageHeapConstant value = this.getOrCreateImageHeapConstant(root, reason);
            this.markReachable(value, reason);
        }
    }

    public void onFieldRead(AnalysisField field) {
        assert (field.isRead()) : field;
        AnalysisType declaringClass = field.getDeclaringClass();
        if (field.isStatic()) {
            ObjectScanner.FieldScan reason = new ObjectScanner.FieldScan(field);
            if (field.isInBaseLayer()) {
                if (field.getStorageKind().isObject()) {
                    this.bb.injectFieldTypes(field, List.of(field.getType()), true);
                } else if (this.bb.trackPrimitiveValues() && field.getStorageKind().isPrimitive()) {
                    ((PointsToAnalysisField)field).saturatePrimitiveField();
                }
                return;
            }
            if (this.isValueAvailable(field)) {
                JavaConstant fieldValue = this.readStaticFieldValue(field);
                this.markReachable(fieldValue, reason);
                this.notifyAnalysis(field, null, fieldValue, reason);
            }
        } else {
            this.postTask(() -> this.onInstanceFieldRead(field, declaringClass));
        }
    }

    private void onInstanceFieldRead(AnalysisField field, AnalysisType type) {
        for (AnalysisType subtype : type.getSubTypes()) {
            for (ImageHeapConstant imageHeapConstant : this.imageHeap.getReachableObjects(subtype)) {
                ObjectScanner.FieldScan reason = new ObjectScanner.FieldScan(field, (JavaConstant)imageHeapConstant);
                if (imageHeapConstant instanceof ImageHeapRelocatableConstant) continue;
                ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant;
                this.updateInstanceField(field, imageHeapInstance, reason, null);
            }
            if (subtype.equals(type)) continue;
            this.onInstanceFieldRead(field, subtype);
        }
    }

    public TypeData computeTypeData(AnalysisType type) {
        GraalError.guarantee((boolean)type.isReachable(), (String)"TypeData is only available for reachable types");
        ResolvedJavaField[] staticFields = type.getStaticFields();
        TypeData data = new TypeData(staticFields.length);
        for (ResolvedJavaField javaField : staticFields) {
            AnalysisField field = (AnalysisField)javaField;
            ValueSupplier<JavaConstant> rawFieldValue = this.readHostedFieldValue(field, null);
            data.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                JavaConstant value = this.createFieldValue(field, rawFieldValue, new ObjectScanner.FieldScan(field));
                data.setFieldValue(field, value);
                return value;
            }));
        }
        return data;
    }

    void markTypeReachable(AnalysisType type, ObjectScanner.ScanReason reason) {
        if (this.universe.sealed() && !type.isReachable()) {
            throw AnalysisError.typeNotFound(type);
        }
        type.registerAsReachable(reason);
    }

    void markTypeInstantiated(AnalysisType type, ObjectScanner.ScanReason reason) {
        if (this.universe.sealed() && !type.isInstantiated()) {
            throw AnalysisError.typeNotFound(type);
        }
        type.registerAsInstantiated(reason);
    }

    public JavaConstant getImageHeapConstant(JavaConstant constant) {
        if (this.isNonNullObjectConstant(constant)) {
            return (ImageHeapConstant)this.imageHeap.getSnapshot(constant);
        }
        return constant;
    }

    public JavaConstant createImageHeapConstant(Object object, ObjectScanner.ScanReason reason) {
        JavaConstant hostedConstant = this.hostedValuesProvider.forObject(object);
        return this.createImageHeapConstant(hostedConstant, reason);
    }

    public JavaConstant createImageHeapConstant(JavaConstant constant, ObjectScanner.ScanReason reason) {
        if (this.isNonNullObjectConstant(constant)) {
            return this.getOrCreateImageHeapConstant(constant, reason);
        }
        return constant;
    }

    public ImageHeapConstant toImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason) {
        assert (constant != null && this.isNonNullObjectConstant(constant)) : constant;
        return this.markReachable(this.getOrCreateImageHeapConstant(constant, reason), reason, (Consumer<ObjectScanner.ScanReason>)null);
    }

    protected ImageHeapConstant getOrCreateImageHeapConstant(JavaConstant javaConstant, ObjectScanner.ScanReason reason) {
        ObjectScanner.ScanReason nonNullReason = Objects.requireNonNull(reason);
        Object existingTask = this.imageHeap.getSnapshot(javaConstant);
        if (existingTask == null) {
            AnalysisFuture<ImageHeapConstant> newTask;
            ImageLayerLoader imageLayerLoader = this.universe.getImageLayerLoader();
            if (this.hostVM.useBaseLayer() && imageLayerLoader.hasValueForConstant(javaConstant)) {
                ImageHeapConstant value = imageLayerLoader.getValueForConstant(javaConstant);
                this.ensureFieldPositionsComputed(value, nonNullReason);
                AnalysisError.guarantee(value.getHostedObject().equals((Object)javaConstant));
                newTask = new AnalysisFuture<ImageHeapConstant>(() -> {
                    this.imageHeap.setValue(javaConstant, value);
                    return value;
                });
            } else {
                this.checkSealed(reason, "Trying to create a new ImageHeapConstant for %s after the ImageHeapScanner is sealed.", javaConstant);
                newTask = new AnalysisFuture<ImageHeapConstant>(() -> {
                    ImageHeapConstant imageHeapConstant = this.createImageHeapObject(javaConstant, nonNullReason);
                    this.imageHeap.setValue(javaConstant, imageHeapConstant);
                    return imageHeapConstant;
                });
            }
            existingTask = this.imageHeap.setTask(javaConstant, newTask);
            if (existingTask == null) {
                return newTask.ensureDone();
            }
        }
        return existingTask instanceof ImageHeapConstant ? (ImageHeapConstant)existingTask : (ImageHeapConstant)((AnalysisFuture)existingTask).ensureDone();
    }

    private void ensureFieldPositionsComputed(ImageHeapConstant baseLayerConstant, ObjectScanner.ScanReason reason) {
        AnalysisType objectType = baseLayerConstant.getType();
        this.markTypeReachable(objectType, reason);
        objectType.getStaticFields();
        objectType.getInstanceFields(true);
    }

    private void checkSealed(ObjectScanner.ScanReason reason, String format, Object ... args) {
        if (this.sealed && reason != ObjectScanner.OtherReason.LATE_SCAN) {
            throw AnalysisError.sealedHeapError(HeapSnapshotVerifier.formatReason(this.bb, reason, format, args));
        }
    }

    protected ImageHeapConstant createImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason) {
        assert (constant.getJavaKind() == JavaKind.Object && !constant.isNull()) : constant;
        Optional<JavaConstant> replaced = this.maybeReplace(constant, reason);
        if (replaced.isPresent()) {
            return this.getOrCreateImageHeapConstant(replaced.get(), reason);
        }
        AnalysisType type = this.universe.lookup((JavaType)GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(constant));
        if (type.isArray()) {
            Integer length = this.hostedValuesProvider.readArrayLength(constant);
            if (type.getComponentType().isPrimitive()) {
                return new ImageHeapPrimitiveArray(type, constant, this.snippetReflection.asObject(Object.class, constant), length);
            }
            return this.createImageHeapObjectArray(constant, type, length, reason);
        }
        return this.createImageHeapInstance(constant, type, reason);
    }

    private ImageHeapArray createImageHeapObjectArray(JavaConstant constant, AnalysisType type, int length, ObjectScanner.ScanReason reason) {
        ImageHeapObjectArray array = new ImageHeapObjectArray(type, constant, length);
        array.constantData.hostedValuesReader = new AnalysisFuture(() -> {
            this.checkSealed(reason, "Trying to materialize an ImageHeapObjectArray for %s after the ImageHeapScanner is sealed.", constant);
            this.markTypeReachable(type, reason);
            ObjectScanner.ArrayScan arrayReason = new ObjectScanner.ArrayScan(type, array, reason);
            Object[] elementValues = new Object[length];
            for (int idx = 0; idx < length; ++idx) {
                JavaConstant rawElementValue = this.hostedValuesProvider.readArrayElement(constant, idx);
                int finalIdx = idx;
                elementValues[idx] = new AnalysisFuture<JavaConstant>(() -> {
                    JavaConstant arrayElement = this.createImageHeapConstant(rawElementValue, (ObjectScanner.ScanReason)arrayReason);
                    array.setElement(finalIdx, arrayElement);
                    return arrayElement;
                });
            }
            array.setElementValues(elementValues);
        });
        return array;
    }

    public void registerBaseLayerValue(ImageHeapConstant constant, Object reason) {
        JavaConstant hostedValue = constant.getHostedObject();
        Object existingSnapshot = this.imageHeap.getSnapshot(hostedValue);
        if (existingSnapshot != null) {
            AnalysisFuture task;
            AnalysisError.guarantee(existingSnapshot == constant || existingSnapshot instanceof AnalysisFuture && (task = (AnalysisFuture)existingSnapshot).ensureDone() == constant, "Found unexpected snapshot value for base layer value. Reason: %s.", reason);
        } else {
            this.imageHeap.setValue(hostedValue, constant);
        }
    }

    private ImageHeapInstance createImageHeapInstance(JavaConstant constant, AnalysisType type, ObjectScanner.ScanReason reason) {
        ImageHeapInstance instance = new ImageHeapInstance(type, constant);
        instance.constantData.hostedValuesReader = new AnalysisFuture(() -> {
            this.checkSealed(reason, "Trying to materialize an ImageHeapInstance for %s after the ImageHeapScanner is sealed.", constant);
            AnalysisType typeFromClassConstant = (AnalysisType)this.constantReflection.asJavaType((Constant)instance);
            if (typeFromClassConstant != null) {
                this.markTypeReachable(typeFromClassConstant, reason);
            }
            this.markTypeReachable(type, reason);
            ResolvedJavaField[] instanceFields = type.getInstanceFields(true);
            Object[] hostedFieldValues = new Object[instanceFields.length];
            for (ResolvedJavaField javaField : instanceFields) {
                ValueSupplier<JavaConstant> rawFieldValue;
                AnalysisField field = (AnalysisField)javaField;
                if (!type.isInitialized()) {
                    rawFieldValue = ValueSupplier.lazyValue(() -> null, () -> false);
                } else {
                    try {
                        rawFieldValue = this.readHostedFieldValue(field, constant);
                    }
                    catch (InternalError | LinkageError | TypeNotPresentException e) {
                        continue;
                    }
                }
                hostedFieldValues[field.getPosition()] = new AnalysisFuture<JavaConstant>(() -> {
                    ObjectScanner.FieldScan fieldReason = new ObjectScanner.FieldScan(field, instance, reason);
                    JavaConstant value = this.createFieldValue(field, instance, rawFieldValue, fieldReason);
                    instance.setFieldValue(field, value);
                    return value;
                });
            }
            instance.setFieldValues(hostedFieldValues);
        });
        return instance;
    }

    private Optional<JavaConstant> maybeReplace(JavaConstant constant, ObjectScanner.ScanReason reason) {
        Object unwrapped = this.snippetReflection.asObject(Object.class, constant);
        if (unwrapped == null) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Could not unwrap constant", reason));
        }
        if (unwrapped instanceof ImageHeapConstant) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Double wrapping of constant. Most likely, the reachability analysis code itself is seen as reachable.", reason));
        }
        ImageHeapScanner.maybeForceHashCodeComputation(unwrapped);
        if (constant.getJavaKind() == JavaKind.Object) {
            try {
                JavaConstant replaced = this.universe.replaceObjectWithConstant(unwrapped);
                if (!replaced.equals((Object)constant)) {
                    return Optional.of(this.hostedValuesProvider.validateReplacedConstant(replaced));
                }
            }
            catch (UnsupportedFeatureException e) {
                StringBuilder backtrace = new StringBuilder();
                ObjectScanner.buildObjectBacktrace(this.bb, reason, backtrace);
                throw new UnsupportedFeatureException(e.getMessage() + System.lineSeparator() + String.valueOf(backtrace), e);
            }
        }
        return Optional.empty();
    }

    public static void maybeForceHashCodeComputation(Object constant) {
        if (constant instanceof String) {
            String stringConstant = (String)constant;
            ImageHeapScanner.forceHashCodeComputation(stringConstant);
        } else if (constant instanceof Enum) {
            Enum enumConstant = (Enum)constant;
            ImageHeapScanner.forceHashCodeComputation(enumConstant);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="eager hash field computation")
    private static void forceHashCodeComputation(Object object) {
        object.hashCode();
    }

    JavaConstant onFieldValueReachable(AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, null, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, receiver, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ImageHeapInstance receiver, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisError.guarantee(field.isStatic() || field.isReachable(), "Field value is only reachable when field is reachable: %s", field);
        JavaConstant fieldValue = this.createFieldValue(field, receiver, rawValue, reason);
        this.markReachable(fieldValue, reason, onAnalysisModified);
        this.notifyAnalysis(field, receiver, fieldValue, reason, onAnalysisModified);
        return fieldValue;
    }

    protected JavaConstant createFieldValue(AnalysisField field, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason) {
        return this.createFieldValue(field, null, rawValue, reason);
    }

    protected JavaConstant createFieldValue(AnalysisField field, ImageHeapInstance receiver, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason) {
        AnalysisError.guarantee(rawValue.isAvailable(), "Value not yet available for %s", field);
        return this.createImageHeapConstant(rawValue.get(), reason);
    }

    private void notifyAnalysis(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        this.notifyAnalysis(field, receiver, fieldValue, reason, null);
    }

    private void notifyAnalysis(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        boolean analysisModified;
        if (this.scanningObserver != null && (analysisModified = this.doNotifyAnalysis(field, receiver, fieldValue, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
    }

    private boolean doNotifyAnalysis(AnalysisField field, JavaConstant receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean analysisModified = false;
        if (fieldValue.getJavaKind() == JavaKind.Object && this.hostVM.isRelocatedPointer(fieldValue)) {
            analysisModified = this.scanningObserver.forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
        } else if (fieldValue.isNull()) {
            analysisModified = this.scanningObserver.forNullFieldValue(receiver, field, reason);
        } else if (fieldValue.getJavaKind() == JavaKind.Object) {
            analysisModified = this.scanningObserver.forNonNullFieldValue(receiver, field, fieldValue, reason);
        } else if (this.bb.trackPrimitiveValues() && fieldValue.getJavaKind().isNumericInteger()) {
            analysisModified = this.scanningObserver.forPrimitiveFieldValue(receiver, field, fieldValue, reason);
        }
        return analysisModified;
    }

    protected JavaConstant onArrayElementReachable(ImageHeapArray array, AnalysisType arrayType, JavaConstant rawElementValue, int elementIndex, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        JavaConstant elementValue = this.createImageHeapConstant(rawElementValue, reason);
        this.markReachable(elementValue, reason, onAnalysisModified);
        this.notifyAnalysis(array, arrayType, elementIndex, reason, onAnalysisModified, elementValue);
        return elementValue;
    }

    private void notifyAnalysis(ImageHeapArray array, AnalysisType arrayType, int elementIndex, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified, JavaConstant elementValue) {
        if (this.scanningObserver != null && arrayType.getComponentType().getJavaKind() == JavaKind.Object) {
            if (elementValue.getJavaKind() != JavaKind.Object) {
                return;
            }
            boolean analysisModified = this.notifyAnalysis(array, arrayType, elementValue, elementIndex, reason);
            if (analysisModified && onAnalysisModified != null) {
                onAnalysisModified.accept(reason);
            }
        }
    }

    private boolean isNonNullObjectConstant(JavaConstant constant) {
        return constant.getJavaKind() == JavaKind.Object && constant.isNonNull() && !this.universe.hostVM().isRelocatedPointer(constant);
    }

    private boolean notifyAnalysis(JavaConstant array, AnalysisType arrayType, JavaConstant elementValue, int elementIndex, ObjectScanner.ScanReason reason) {
        boolean analysisModified;
        if (elementValue.isNull()) {
            analysisModified = this.scanningObserver.forNullArrayElement(array, arrayType, elementIndex, reason);
        } else {
            if (this.universe.hostVM().isRelocatedPointer(elementValue)) {
                return false;
            }
            AnalysisType elementType = this.metaAccess.lookupJavaType(elementValue);
            analysisModified = this.scanningObserver.forNonNullArrayElement(array, arrayType, elementValue, elementType, elementIndex, reason);
        }
        return analysisModified;
    }

    protected JavaConstant markReachable(JavaConstant constant, ObjectScanner.ScanReason reason) {
        return this.markReachable(constant, reason, null);
    }

    private JavaConstant markReachable(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (this.isNonNullObjectConstant(constant)) {
            return this.markReachable((ImageHeapConstant)constant, reason, onAnalysisModified);
        }
        return constant;
    }

    private ImageHeapConstant markReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (imageHeapConstant.markReachable(reason)) {
            this.maybeRunInExecutor(unused -> this.onObjectReachable(imageHeapConstant, reason, onAnalysisModified));
        }
        return imageHeapConstant;
    }

    protected void onObjectReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisType objectType = this.metaAccess.lookupJavaType(imageHeapConstant);
        this.imageHeap.addReachableObject(objectType, imageHeapConstant);
        AnalysisType type = imageHeapConstant.getType();
        Object object = this.bb.getSnippetReflectionProvider().asObject(Object.class, (JavaConstant)imageHeapConstant);
        if (object != null) {
            try {
                type.notifyObjectReachable(this.universe.getConcurrentAnalysisAccess(), object, reason);
            }
            catch (UnsupportedFeatureException e) {
                StringBuilder backtrace = new StringBuilder();
                ObjectScanner.buildObjectBacktrace(this.bb, reason, backtrace);
                throw new UnsupportedFeatureException(e.getMessage() + System.lineSeparator() + String.valueOf(backtrace), e);
            }
        }
        this.markTypeInstantiated(objectType, reason);
        if (imageHeapConstant instanceof ImageHeapObjectArray) {
            ImageHeapObjectArray imageHeapArray = (ImageHeapObjectArray)imageHeapConstant;
            AnalysisType arrayType = imageHeapArray.getType();
            for (int idx = 0; idx < imageHeapArray.getLength(); ++idx) {
                JavaConstant elementValue = imageHeapArray.readElementValue(idx);
                ObjectScanner.ArrayScan arrayScanReason = new ObjectScanner.ArrayScan(arrayType, imageHeapArray, reason, idx);
                this.markReachable(elementValue, (ObjectScanner.ScanReason)arrayScanReason, onAnalysisModified);
                this.notifyAnalysis(imageHeapArray, arrayType, idx, arrayScanReason, onAnalysisModified, elementValue);
            }
        } else if (imageHeapConstant instanceof ImageHeapInstance) {
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant;
            for (ResolvedJavaField javaField : objectType.getInstanceFields(true)) {
                AnalysisField field = (AnalysisField)javaField;
                if (!field.isRead()) continue;
                this.updateInstanceField(field, imageHeapInstance, new ObjectScanner.FieldScan(field, imageHeapInstance, reason), onAnalysisModified);
            }
        } else if (imageHeapConstant instanceof ImageHeapRelocatableConstant) {
            // empty if block
        }
    }

    private void updateInstanceField(AnalysisField field, ImageHeapInstance imageHeapInstance, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (this.isValueAvailable(field)) {
            JavaConstant fieldValue = imageHeapInstance.readFieldValue(field);
            this.markReachable(fieldValue, reason, onAnalysisModified);
            this.notifyAnalysis(field, imageHeapInstance, fieldValue, reason, onAnalysisModified);
        }
    }

    public boolean isValueAvailable(AnalysisField field) {
        return true;
    }

    protected String formatReason(String message, ObjectScanner.ScanReason reason) {
        return message + " " + String.valueOf(reason);
    }

    public JavaConstant readStaticFieldValue(AnalysisField field) {
        return field.getDeclaringClass().getOrComputeData().readFieldValue(field);
    }

    protected ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        return this.hostedValuesProvider.readFieldValue(field, receiver);
    }

    public void rescanRoot(Field reflectionField) {
        this.maybeRunInExecutor(unused -> {
            ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
            if (type.isReachable()) {
                AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
                JavaConstant fieldValue = this.readHostedFieldValue(field, null).get();
                TypeData typeData = field.getDeclaringClass().getOrComputeData();
                AnalysisFuture<JavaConstant> fieldTask = this.patchStaticField(typeData, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
                if (field.isRead() || field.isFolded()) {
                    this.rescanCollectionElements(fieldTask.ensureDone());
                }
            }
        });
    }

    public void rescanField(Object receiver, Field reflectionField) {
        this.rescanField(receiver, reflectionField, ObjectScanner.OtherReason.RESCAN);
    }

    public void rescanField(Object receiver, Field reflectionField, ObjectScanner.ScanReason reason) {
        this.maybeRunInExecutor(unused -> {
            ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
            if (type.isReachable()) {
                JavaConstant fieldValue;
                AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
                assert (!field.isStatic()) : field;
                if (!field.isReachable()) {
                    return;
                }
                JavaConstant receiverConstant = this.asConstant(receiver);
                Optional<JavaConstant> replaced = this.maybeReplace(receiverConstant, reason);
                if (replaced.isPresent()) {
                    if (replaced.get().isNull()) {
                        return;
                    }
                    receiverConstant = replaced.get();
                }
                if ((fieldValue = this.readHostedFieldValue(field, receiverConstant).get()) != null) {
                    ImageHeapConstant ihc;
                    ImageHeapInstance receiverObject = (ImageHeapInstance)this.toImageHeapObject(receiverConstant, reason);
                    JavaConstant fieldSnapshot = receiverObject.readFieldValue(field);
                    JavaConstant unwrappedSnapshot = HeapSnapshotVerifier.ScanningObserver.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant);
                    if (fieldSnapshot instanceof ImageHeapConstant && (ihc = (ImageHeapConstant)fieldSnapshot).isInBaseLayer() && ihc.getHostedObject() == null) {
                        return;
                    }
                    if (!Objects.equals(unwrappedSnapshot, fieldValue)) {
                        AnalysisFuture<JavaConstant> fieldTask = this.patchInstanceField(receiverObject, field, fieldValue, reason, null);
                        if (field.isRead() || field.isFolded()) {
                            JavaConstant constant = fieldTask.ensureDone();
                            this.ensureReaderInstalled(constant);
                            this.rescanCollectionElements(constant);
                        }
                    } else {
                        HeapSnapshotVerifier.ScanningObserver.patchPrimitiveArrayValue(this.bb, fieldSnapshot, fieldValue);
                    }
                }
            }
        });
    }

    void ensureReaderInstalled(JavaConstant constant) {
        if (this.isNonNullObjectConstant(constant)) {
            ((ImageHeapConstant)constant).ensureReaderInstalled();
        }
    }

    protected AnalysisFuture<JavaConstant> patchStaticField(TypeData typeData, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, fieldValue, reason, onAnalysisModified);
            typeData.setFieldValue(field, value);
            return value;
        });
        typeData.setFieldTask(field, task);
        return task;
    }

    protected AnalysisFuture<JavaConstant> patchInstanceField(ImageHeapInstance receiverObject, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, receiverObject, fieldValue, reason, onAnalysisModified);
            receiverObject.setFieldValue(field, value);
            return value;
        });
        receiverObject.setFieldTask(field, task);
        return task;
    }

    protected AnalysisFuture<JavaConstant> patchArrayElement(ImageHeapObjectArray arrayObject, int index, JavaConstant elementValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onArrayElementReachable(arrayObject, arrayObject.getType(), elementValue, index, reason, onAnalysisModified);
            arrayObject.setElement(index, value);
            return value;
        });
        arrayObject.setElementTask(index, task);
        return task;
    }

    public boolean isObjectReachable(Object object) {
        JavaConstant javaConstant = this.asConstant(Objects.requireNonNull(object));
        Object existingTask = this.imageHeap.getSnapshot(javaConstant);
        if (existingTask instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)existingTask;
            return imageHeapConstant.isReachable();
        }
        return false;
    }

    public void rescanObject(Object object) {
        this.rescanObject(object, ObjectScanner.OtherReason.RESCAN);
    }

    public void rescanObject(Object object, ObjectScanner.ScanReason reason) {
        if (object == null) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            this.doScan(this.asConstant(object), reason);
            this.rescanCollectionElements(object);
        });
    }

    private void rescanCollectionElements(JavaConstant constant) {
        if (this.isNonNullObjectConstant(constant)) {
            this.rescanCollectionElements(this.snippetReflection.asObject(Object.class, constant));
        }
    }

    private void rescanCollectionElements(Object object) {
        if (object instanceof Object[]) {
            Object[] array;
            for (Object element : array = (Object[])object) {
                this.doScan(this.asConstant(element));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.forEach(e -> this.doScan(this.asConstant(e)));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.forEach((k, v) -> {
                this.doScan(this.asConstant(k));
                this.doScan(this.asConstant(v));
            });
        } else if (object instanceof EconomicMap) {
            this.rescanEconomicMap((EconomicMap)object);
        }
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> object) {
        MapCursor cursor = object.getEntries();
        while (cursor.advance()) {
            this.doScan(this.asConstant(cursor.getKey()));
            this.doScan(this.asConstant(cursor.getValue()));
        }
    }

    void doScan(JavaConstant constant) {
        this.doScan(constant, ObjectScanner.OtherReason.RESCAN);
    }

    void doScan(JavaConstant constant, ObjectScanner.ScanReason reason) {
        JavaConstant value = this.createImageHeapConstant(constant, reason);
        this.markReachable(value, reason, null);
    }

    private JavaConstant asConstant(Object object) {
        return this.hostedValuesProvider.forObject(object);
    }

    public void cleanupAfterAnalysis() {
        this.scanningObserver = null;
    }

    protected abstract Class<?> getClass(String var1);

    public HostedValuesProvider getHostedValuesProvider() {
        return this.hostedValuesProvider;
    }

    protected AnalysisType lookupJavaType(String className) {
        return this.metaAccess.lookupJavaType((Class)this.getClass(className));
    }

    protected AnalysisField lookupJavaField(String className, String fieldName) {
        return this.metaAccess.lookupJavaField(ReflectionUtil.lookupField(this.getClass(className), (String)fieldName));
    }

    private void maybeRunInExecutor(CompletionExecutor.DebugContextRunnable task) {
        if (this.bb.executorIsStarted()) {
            this.bb.postTask(task);
        } else {
            task.run(null);
        }
    }

    private void postTask(Runnable task) {
        this.bb.postTask((DebugContext debug) -> task.run());
    }
}

