/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.GlobalFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.common.JVMCIError;

public class FieldTypeFlow
extends TypeFlow<AnalysisField>
implements GlobalFlow {
    private static final AtomicReferenceFieldUpdater<FieldTypeFlow, FieldFilterTypeFlow> FILTER_FLOW_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldTypeFlow.class, FieldFilterTypeFlow.class, "filterFlow");
    private final AnalysisObject object;
    private volatile FieldFilterTypeFlow filterFlow;

    public FieldTypeFlow(AnalysisField field, AnalysisType type) {
        this(field, type, (AnalysisObject)null);
    }

    public FieldTypeFlow(AnalysisField field, AnalysisType type, AnalysisObject object) {
        super(field, FieldTypeFlow.filterUncheckedInterface(type), TypeState.forEmpty());
        this.object = object;
    }

    public AnalysisObject object() {
        return this.object;
    }

    @Override
    public TypeFlow<AnalysisField> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        throw JVMCIError.shouldNotReachHere((String)"The field flow should not be cloned. Use Load/StoreFieldTypeFlow.");
    }

    @Override
    public boolean canSaturate(PointsToAnalysis bb) {
        return !bb.isClosed(this.declaredType);
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        if (bb.isClosed(this.declaredType)) {
            this.declaredType.getTypeFlow(bb, true).addUse(bb, this);
        } else {
            super.onInputSaturated(bb, input);
        }
    }

    public FieldFilterTypeFlow filterFlow(PointsToAnalysis bb) {
        assert (((AnalysisField)this.source).isUnsafeAccessed()) : "Filter flow requested for non unsafe accessed field.";
        if (this.filterFlow == null && FILTER_FLOW_UPDATER.compareAndSet(this, null, new FieldFilterTypeFlow((AnalysisField)this.source))) {
            this.filterFlow.addUse(bb, this);
        }
        return this.filterFlow;
    }

    @Override
    public String toString() {
        return "FieldFlow<" + ((AnalysisField)this.source).format("%h.%n") + System.lineSeparator() + this.getStateDescription() + ">";
    }
}

