/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.BooleanCheckTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class BooleanInstanceOfCheckTypeFlow
extends BooleanCheckTypeFlow {
    private final AnalysisType checkedType;
    private final boolean isExact;
    private final boolean includeNull;

    public BooleanInstanceOfCheckTypeFlow(BytecodePosition position, AnalysisType checkedType, boolean isExact, boolean includeNull, AnalysisType longType) {
        super(position, longType);
        this.checkedType = checkedType;
        this.isExact = isExact;
        this.includeNull = includeNull;
    }

    private BooleanInstanceOfCheckTypeFlow(MethodFlowsGraph methodFlows, BooleanInstanceOfCheckTypeFlow original) {
        super(original, methodFlows);
        this.checkedType = original.checkedType;
        this.isExact = original.isExact;
        this.includeNull = original.includeNull;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BooleanInstanceOfCheckTypeFlow(methodFlows, this);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState update) {
        TypeState canBeFalse;
        TypeState canBeTrue;
        if (this.isExact) {
            canBeTrue = TypeState.forIntersection(bb, update, TypeState.forExactType(bb, this.checkedType, this.includeNull));
            canBeFalse = TypeState.forSubtraction(bb, update, TypeState.forExactType(bb, this.checkedType, this.includeNull));
        } else {
            canBeTrue = TypeState.forIntersection(bb, update, this.checkedType.getAssignableTypes(this.includeNull));
            canBeFalse = TypeState.forSubtraction(bb, update, this.checkedType.getAssignableTypes(this.includeNull));
        }
        return BooleanInstanceOfCheckTypeFlow.convertToBoolean(canBeTrue, canBeFalse);
    }
}

