/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.DefaultInvokeTypeFlowUtil;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

final class DefaultStaticInvokeTypeFlow
extends AbstractStaticInvokeTypeFlow {
    DefaultStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        JVMCIError.guarantee((boolean)LightImmutableCollection.isEmpty(this, CALLEES_ACCESSOR), (String)"static invoke updated multiple times!", (Object[])new Object[0]);
        if (!this.targetMethod.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        this.initializeCallees(bb);
        LightImmutableCollection.forEach(this, CALLEES_ACCESSOR, callee -> {
            MethodFlowsGraphInfo calleeFlows = callee.getTypeFlow().getOrCreateMethodFlowsGraphInfo(bb, this);
            this.linkCallee(bb, true, calleeFlows);
        });
    }

    @Override
    protected Collection<MethodFlowsGraph> getAllCalleesFlows(PointsToAnalysis bb) {
        return DefaultInvokeTypeFlowUtil.getAllCalleesFlows(this);
    }
}

