/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class CloneTypeFlow
extends TypeFlow<BytecodePosition> {
    private TypeFlow<?> input;
    protected final AnalysisContext allocationContext;

    public CloneTypeFlow(BytecodePosition cloneLocation, AnalysisType inputType, TypeFlow<?> input) {
        super(cloneLocation, inputType);
        this.allocationContext = null;
        this.input = input;
    }

    public CloneTypeFlow(PointsToAnalysis bb, CloneTypeFlow original, MethodFlowsGraph methodFlows, AnalysisContext allocationContext) {
        super(original, methodFlows);
        this.allocationContext = allocationContext;
        this.input = methodFlows.lookupCloneOf(bb, original.input);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        AnalysisContext allocContext = bb.analysisPolicy().allocationContext(bb, methodFlows);
        return new CloneTypeFlow(bb, this, methodFlows, allocContext);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        TypeState inputState = this.input.getState();
        TypeState resultState = bb.analysisPolicy().cloneState(bb, this.state, inputState, (BytecodePosition)this.source, this.allocationContext);
        this.addState(bb, resultState);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        bb.analysisPolicy().linkClonedObjects(bb, this.input, this, (BytecodePosition)this.source);
        super.update(bb);
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        if (!this.isSaturated()) {
            this.replaceObservedWith(bb, this.declaredType);
        }
    }

    @Override
    protected void onSaturated() {
        this.input.removeObserver(this);
    }

    @Override
    public void setObserved(TypeFlow<?> newInputFlow) {
        this.input = newInputFlow;
    }

    @Override
    public String toString() {
        return "Clone<" + super.toString() + ">";
    }
}

