/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ConcurrentLightHashMap {
    private ConcurrentLightHashMap() {
    }

    public static <K, V, U> V putIfAbsent(U holder, AtomicReferenceFieldUpdater<U, Object> updater, K newKey, V newValue) {
        AbstractMap.SimpleImmutableEntry oldEntry;
        block5: {
            if (newKey == null || newValue == null) {
                throw new NullPointerException();
            }
            while (true) {
                Object oldEntries;
                if ((oldEntries = updater.get(holder)) == null) {
                    if (!updater.compareAndSet(holder, null, new AbstractMap.SimpleImmutableEntry<K, V>(newKey, newValue))) continue;
                    return null;
                }
                if (oldEntries instanceof ConcurrentHashMap) {
                    return ((ConcurrentHashMap)oldEntries).putIfAbsent(newKey, newValue);
                }
                oldEntry = (AbstractMap.SimpleImmutableEntry)oldEntries;
                if (oldEntry.getKey().equals(newKey)) break block5;
                ConcurrentHashMap<K, V> newMap = new ConcurrentHashMap<K, V>();
                newMap.put(oldEntry.getKey(), oldEntry.getValue());
                newMap.put(newKey, newValue);
                if (updater.compareAndSet(holder, oldEntries, newMap)) break;
            }
            return null;
        }
        assert (oldEntry.getKey() == newKey);
        return oldEntry.getValue();
    }

    public static <K, V, U> V computeIfAbsent(U holder, AtomicReferenceFieldUpdater<U, Object> updater, K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        V oldValue = ConcurrentLightHashMap.get(holder, updater, key);
        if (oldValue == null && (newValue = mappingFunction.apply(key)) != null && (oldValue = ConcurrentLightHashMap.putIfAbsent(holder, updater, key, newValue)) == null) {
            return newValue;
        }
        return oldValue;
    }

    public static <K, V, U> V getOrDefault(U holder, AtomicReferenceFieldUpdater<U, Object> updater, K key, V defaultValue) {
        V v = ConcurrentLightHashMap.get(holder, updater, key);
        return v == null ? defaultValue : v;
    }

    public static <K, V, U> V get(U holder, AtomicReferenceFieldUpdater<U, Object> updater, K key) {
        Object u = updater.get(holder);
        if (u == null) {
            return null;
        }
        if (u instanceof ConcurrentHashMap) {
            return ((ConcurrentHashMap)u).get(key);
        }
        AbstractMap.SimpleImmutableEntry entry = (AbstractMap.SimpleImmutableEntry)u;
        if (key.equals(entry.getKey())) {
            return entry.getValue();
        }
        return null;
    }

    public static <K, V, U> Map<K, V> getEntries(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        Object u = updater.get(holder);
        if (u == null) {
            return Collections.emptyMap();
        }
        if (u instanceof ConcurrentHashMap) {
            return (ConcurrentHashMap)u;
        }
        AbstractMap.SimpleImmutableEntry entry = (AbstractMap.SimpleImmutableEntry)u;
        return Collections.singletonMap(entry.getKey(), entry.getValue());
    }

    public static <K, V, U> void forEach(U holder, AtomicReferenceFieldUpdater<U, Object> updater, BiConsumer<? super K, ? super V> action) {
        Object u = updater.get(holder);
        if (u == null) {
            return;
        }
        if (u instanceof ConcurrentHashMap) {
            ((ConcurrentHashMap)u).forEach(action);
        } else {
            AbstractMap.SimpleImmutableEntry entry = (AbstractMap.SimpleImmutableEntry)u;
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V, U> boolean remove(U holder, AtomicReferenceFieldUpdater<U, Object> updater, K key) {
        block3: {
            Object e;
            do {
                if ((e = updater.get(holder)) == null) {
                    return false;
                }
                if (e instanceof ConcurrentHashMap) {
                    return ((ConcurrentHashMap)e).remove(key) != null;
                }
                AbstractMap.SimpleImmutableEntry entry = (AbstractMap.SimpleImmutableEntry)e;
                if (!key.equals(entry.getKey())) break block3;
            } while (!updater.compareAndSet(holder, e, null));
            return true;
        }
        return false;
    }

    public static <K, V, U> boolean removeIf(U holder, AtomicReferenceFieldUpdater<U, Object> updater, Predicate<Map.Entry<K, V>> filter) {
        block3: {
            Object e;
            do {
                if ((e = updater.get(holder)) == null) {
                    return false;
                }
                if (e instanceof ConcurrentHashMap) {
                    return ((ConcurrentHashMap)e).entrySet().removeIf(filter);
                }
                AbstractMap.SimpleImmutableEntry entry = (AbstractMap.SimpleImmutableEntry)e;
                if (!filter.test(entry)) break block3;
            } while (!updater.compareAndSet(holder, e, null));
            return true;
        }
        return false;
    }

    public static <U> void clear(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        updater.set(holder, null);
    }
}

