/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestore;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;

public class SplitFieldTypeStore
extends FieldTypeStore {
    private final FieldTypeFlow writeFlow;
    private final FieldTypeFlow readFlow;

    public SplitFieldTypeStore(AnalysisField field, AnalysisObject object) {
        this(field, object, new FieldTypeFlow(field, field.getType(), object), new FieldTypeFlow(field, field.getType(), object));
    }

    public SplitFieldTypeStore(AnalysisField field, AnalysisObject object, FieldTypeFlow writeFlow, FieldTypeFlow readFlow) {
        super(field, object);
        this.writeFlow = writeFlow;
        this.readFlow = readFlow;
    }

    @Override
    public FieldTypeFlow writeFlow() {
        return this.writeFlow;
    }

    @Override
    public FieldTypeFlow readFlow() {
        return this.readFlow;
    }

    @Override
    public void init(PointsToAnalysis bb) {
        this.writeFlow.addUse(bb, this.readFlow);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("SplitFieldStore<").append(this.field.format("%h.%n")).append(System.lineSeparator()).append(this.object).append(">");
        return str.toString();
    }
}

