/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.UnsafePartitionKind;
import jdk.vm.ci.code.BytecodePosition;

public abstract class OffsetLoadTypeFlow
extends TypeFlow<BytecodePosition> {
    private final AnalysisType objectType;
    protected TypeFlow<?> objectFlow;

    public OffsetLoadTypeFlow(BytecodePosition loadLocation, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow) {
        super(loadLocation, componentType);
        this.objectType = objectType;
        this.objectFlow = objectFlow;
    }

    public OffsetLoadTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, OffsetLoadTypeFlow original) {
        super(original, methodFlows);
        this.objectType = original.objectType;
        this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
    }

    @Override
    public void setObserved(TypeFlow<?> newObjectFlow) {
        this.objectFlow = newObjectFlow;
    }

    @Override
    public abstract void onObservedUpdate(PointsToAnalysis var1);

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        if (!this.isSaturated()) {
            this.replaceObservedWith(bb, this.objectType);
        }
    }

    @Override
    protected void onSaturated() {
        this.objectFlow.removeObserver(this);
    }

    @Override
    public TypeFlow<?> receiver() {
        return this.objectFlow;
    }

    public TypeState getObjectState() {
        return this.objectFlow.getState();
    }

    public static class UnsafePartitionLoadTypeFlow
    extends AbstractUnsafeLoadTypeFlow {
        protected final UnsafePartitionKind partitionKind;
        protected final AnalysisType partitionType;

        public UnsafePartitionLoadTypeFlow(BytecodePosition loadLocation, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> arrayFlow, UnsafePartitionKind partitionKind, AnalysisType partitionType) {
            super(loadLocation, objectType, componentType, arrayFlow);
            this.partitionKind = partitionKind;
            this.partitionType = partitionType;
        }

        private UnsafePartitionLoadTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, UnsafePartitionLoadTypeFlow original) {
            super(bb, methodFlows, original);
            this.partitionKind = original.partitionKind;
            this.partitionType = original.partitionType;
        }

        public AbstractUnsafeLoadTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new UnsafePartitionLoadTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeState filter(PointsToAnalysis bb, TypeState update) {
            if (this.partitionType.equals(bb.getObjectType())) {
                return update;
            }
            return TypeState.forIntersection(bb, update, this.partitionType.getAssignableTypes(true));
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            TypeState objectState = this.getObjectState();
            for (AnalysisObject object : objectState.objects(bb)) {
                AnalysisType objectType = object.type();
                assert (!objectType.isArray());
                for (AnalysisField field : objectType.unsafeAccessedFields(this.partitionKind)) {
                    FieldTypeFlow fieldFlow = object.getInstanceFieldFlow(bb, this.objectFlow, (BytecodePosition)this.source, field, false);
                    fieldFlow.addUse(bb, this);
                }
            }
        }

        @Override
        public String toString() {
            return "UnsafePartitionLoadTypeFlow<" + this.getState() + "> : " + this.partitionKind;
        }
    }

    public static class UnsafeLoadTypeFlow
    extends AbstractUnsafeLoadTypeFlow {
        public UnsafeLoadTypeFlow(BytecodePosition loadLocation, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> arrayFlow) {
            super(loadLocation, objectType, componentType, arrayFlow);
        }

        private UnsafeLoadTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, UnsafeLoadTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public AbstractUnsafeLoadTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new UnsafeLoadTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            TypeState objectState = this.getObjectState();
            for (AnalysisObject object : objectState.objects(bb)) {
                AnalysisType objectType = object.type();
                if (objectType.isArray()) {
                    if (object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, false);
                    elementsFlow.addUse(bb, this);
                    continue;
                }
                for (AnalysisField field : objectType.unsafeAccessedFields()) {
                    assert (field != null);
                    FieldTypeFlow fieldFlow = object.getInstanceFieldFlow(bb, this.objectFlow, (BytecodePosition)this.source, field, false);
                    fieldFlow.addUse(bb, this);
                }
            }
        }

        @Override
        public String toString() {
            return "UnsafeLoadTypeFlow<" + this.getState() + ">";
        }
    }

    public static abstract class AbstractUnsafeLoadTypeFlow
    extends OffsetLoadTypeFlow {
        AbstractUnsafeLoadTypeFlow(BytecodePosition loadLocation, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow) {
            super(loadLocation, objectType, AbstractUnsafeLoadTypeFlow.filterUncheckedInterface(componentType), objectFlow);
        }

        AbstractUnsafeLoadTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, AbstractUnsafeLoadTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public void initFlow(PointsToAnalysis bb) {
            assert (!bb.analysisPolicy().isContextSensitiveAnalysis() || this.isClone());
            bb.registerUnsafeLoad(this);
            this.forceUpdate(bb);
        }

        @Override
        public boolean needsInitialization() {
            return true;
        }

        public void forceUpdate(PointsToAnalysis bb) {
            for (AnalysisField field : bb.getUniverse().getUnsafeAccessedStaticFields()) {
                field.getStaticFieldFlow().addUse(bb, this);
            }
        }
    }

    public static class LoadIndexedTypeFlow
    extends OffsetLoadTypeFlow {
        public LoadIndexedTypeFlow(BytecodePosition loadLocation, AnalysisType arrayType, TypeFlow<?> arrayFlow) {
            super(loadLocation, arrayType, arrayType.getComponentType(), arrayFlow);
        }

        public LoadIndexedTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, LoadIndexedTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public LoadIndexedTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new LoadIndexedTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            TypeState arrayState = this.getObjectState();
            for (AnalysisObject object : arrayState.objects(bb)) {
                if (bb.analysisPolicy().relaxTypeFlowConstraints() && !object.type().isArray() || object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, false);
                elementsFlow.addUse(bb, this);
            }
        }

        @Override
        public String toString() {
            return "LoadIndexedTypeFlow<" + this.getState() + ">";
        }
    }
}

