/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.AnalysisHeapHistogramPrinter;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.CallTreePrinter;
import com.oracle.graal.pointsto.reports.ObjectTreePrinter;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestate.TypeStateUtils;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.compiler.options.OptionValues;

public class AnalysisReporter {
    public static void printAnalysisReports(String imageName, OptionValues options, String reportsPath, BigBang bb) {
        if (bb != null) {
            if (((Boolean)AnalysisReportsOptions.PrintAnalysisStatistics.getValue(options)).booleanValue()) {
                StatisticsPrinter.print(bb, reportsPath, ReportUtils.extractImageName(imageName));
            }
            if (((Boolean)AnalysisReportsOptions.PrintAnalysisCallTree.getValue(options)).booleanValue()) {
                CallTreePrinter.print(bb, reportsPath, ReportUtils.extractImageName(imageName));
            }
            if (((Boolean)AnalysisReportsOptions.PrintImageObjectTree.getValue(options)).booleanValue()) {
                ObjectTreePrinter.print(bb, reportsPath, ReportUtils.extractImageName(imageName));
                AnalysisHeapHistogramPrinter.print(bb, reportsPath, ReportUtils.extractImageName(imageName));
            }
            if (((Boolean)PointstoOptions.PrintPointsToStatistics.getValue(options)).booleanValue()) {
                PointsToStats.report(bb, ReportUtils.extractImageName(imageName));
            }
            if (((Boolean)PointstoOptions.PrintSynchronizedAnalysis.getValue(options)).booleanValue()) {
                TypeState allSynchronizedTypeState = bb.getAllSynchronizedTypeState();
                String typesString = TypeStateUtils.closeToAllInstantiated((PointsToAnalysis)bb, allSynchronizedTypeState) ? "close to all instantiated" : StreamSupport.stream(allSynchronizedTypeState.types(bb).spliterator(), false).map(AnalysisType::getName).collect(Collectors.joining(", "));
                System.out.println();
                System.out.println("AllSynchronizedTypes");
                System.out.println("Synchronized types #: " + allSynchronizedTypeState.typesCount());
                System.out.println("Types: " + typesString);
                System.out.println();
            }
        }
    }
}

