/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FrozenFieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.EmptyTypeState;
import com.oracle.graal.pointsto.typestate.NullTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.ClassUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.ValueNode;

public class PointsToStats {
    static boolean reportStatistics;
    private static List<TypeFlowBuilder<?>> typeFlowBuilders;
    private static ConcurrentHashMap<TypeFlow<?>, TypeFlowStats> typeFlowStats;
    private static ConcurrentHashMap<TypeFlow<?>, String> retainReson;
    static final Comparator<Long> longComparator;
    private static ConcurrentHashMap<TypeState, Integer> stateToId;
    private static ConcurrentHashMap<Integer, TypeState> idToState;
    private static final Comparator<AtomicInteger> atomicIntegerComparator;
    private static final AtomicInteger nextStateId;
    private static ConcurrentHashMap<TypeState, AtomicInteger> typeStateStats;
    private static ConcurrentHashMap<UnionOperation, AtomicInteger> unionStats;

    public static void init(PointsToAnalysis bb) {
        PointsToStats.registerTypeState(bb, EmptyTypeState.SINGLETON);
        PointsToStats.registerTypeState(bb, NullTypeState.SINGLETON);
        reportStatistics = bb.reportAnalysisStatistics();
    }

    public static void report(BigBang bb, String reportNameRoot) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
            String timeStamp = LocalDateTime.now().format(formatter);
            Path statsDirectory = Files.createDirectories(FileSystems.getDefault().getPath("svmbuild", new String[0]).resolve("stats"), new FileAttribute[0]);
            PointsToStats.doReport(statsDirectory, reportNameRoot, "type state stats", timeStamp, PointsToStats::reportTypeStateStats);
            PointsToStats.doReport(statsDirectory, reportNameRoot, "union operation stats", timeStamp, PointsToStats::reportUnionOpertationsStats);
            PointsToStats.doReport(statsDirectory, reportNameRoot, "type flow stats", timeStamp, PointsToStats::reportTypeFlowStats);
            PointsToStats.doReport(statsDirectory, reportNameRoot, "pruned type flow stats", timeStamp, PointsToStats::reportPrunedTypeFlows);
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    private static void doReport(Path dir, String reportNameRoot, String whatIsReported, String timeStamp, Consumer<BufferedWriter> reporter) {
        try {
            Path reportFile = dir.resolve(reportNameRoot + "_" + whatIsReported.replace(' ', '_') + "_" + timeStamp + ".tsv");
            Files.deleteIfExists(reportFile);
            try (FileWriter fw = new FileWriter(Files.createFile(reportFile, new FileAttribute[0]).toFile());
                 BufferedWriter writer = new BufferedWriter(fw);){
                System.out.println("Printing " + whatIsReported + " to " + reportFile.toAbsolutePath());
                reporter.accept(writer);
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static void registerTypeFlowBuilder(PointsToAnalysis bb, TypeFlowBuilder<?> builder) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        typeFlowBuilders.add(builder);
    }

    private static void reportPrunedTypeFlows(BufferedWriter out) {
        PointsToStats.doWrite(out, String.format("%-35s\n", "Summary"));
        PointsToStats.doWrite(out, String.format("%-35s\t%-10s\n", "Type Flow Class", "Removed Count"));
        typeFlowBuilders.stream().filter(Objects::nonNull).filter(b -> !b.isMaterialized()).collect(Collectors.groupingBy(TypeFlowBuilder::getFlowClass)).forEach((flowClass, providers) -> PointsToStats.doWrite(out, String.format("%-35s\t%-10d\n", ClassUtil.getUnqualifiedName((Class)flowClass), providers.size())));
        PointsToStats.doWrite(out, String.format("\n%-35s\n", "Removed flows"));
        PointsToStats.doWrite(out, String.format("%-35s\t%-10s\n", "Type Flow Class", "Location"));
        typeFlowBuilders.stream().filter(Objects::nonNull).filter(b -> !b.isMaterialized()).forEach(provider -> {
            ValueNode value;
            NodeSourcePosition srcPosition;
            Object source = provider.getSource();
            Object sourceStr = source instanceof ValueNode ? ((srcPosition = (value = (ValueNode)source).getNodeSourcePosition()) != null ? srcPosition.toString() : value.toString() + " @ " + value.graph().method().format("%H.%n(%p)")) : source.toString();
            PointsToStats.doWrite(out, String.format("%-35s\t%-10s\n", ClassUtil.getUnqualifiedName(provider.getFlowClass()), sourceStr));
        });
    }

    public static void registerTypeFlowRetainReason(PointsToAnalysis bb, TypeFlow<?> flow, String reason) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        retainReson.put(flow, reason);
    }

    public static void registerTypeFlowRetainReason(TypeFlow<?> flow, TypeFlow<?> original) {
        if (!reportStatistics) {
            return;
        }
        String originalFlowReason = retainReson.getOrDefault(original, "");
        retainReson.put(flow, originalFlowReason);
    }

    public static void registerTypeFlowUpdate(PointsToAnalysis bb, TypeFlow<?> flow, TypeState state) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        if (state.isEmpty()) {
            return;
        }
        TypeFlowStats stats = typeFlowStats.computeIfAbsent(flow, TypeFlowStats::new);
        stats.registerUpdate(state);
    }

    public static void registerTypeFlowSuccessfulUpdate(PointsToAnalysis bb, TypeFlow<?> flow, TypeState state) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        if (state.isEmpty()) {
            return;
        }
        TypeFlowStats stats = typeFlowStats.computeIfAbsent(flow, TypeFlowStats::new);
        stats.registerSuccessfulUpdate(state);
    }

    public static void registerTypeFlowQueuedUpdate(PointsToAnalysis bb, TypeFlow<?> flow) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        TypeFlowStats stats = typeFlowStats.computeIfAbsent(flow, TypeFlowStats::new);
        stats.registerQueuedUpdate();
    }

    private static void reportTypeFlowStats(BufferedWriter out) {
        PointsToStats.doWrite(out, String.format("%-35s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%-10s\t%10s\n", "TypeFlow", "TypeStateID", "StateObjects#", "CanBeNull", "IsClone", "Uses", "Observers", "Uses+Observers", "RetainReason", "QueuedUpdates", "AllUpdates", "TypeStateAdds", "All Updates History (<update frequency>x<type state id>)"));
        typeFlowStats.entrySet().stream().forEach(e -> {
            TypeFlow flow = (TypeFlow)e.getKey();
            TypeFlowStats stats = (TypeFlowStats)e.getValue();
            PointsToStats.doWrite(out, String.format("%-35s\t%-10d\t%-10d\t%-10b\t%-10b\t%-10d\t%-10d\t%-10d\t%-10s\t%-10d\t%10d\t%10d\t%10s\n", PointsToStats.asString(flow), stateToId.get(flow.getState()), PointsToStats.objectsCount(flow.getState()), flow.getState().canBeNull(), flow.isClone(), flow.getUses().size(), flow.getObservers().size(), flow.getUses().size() + flow.getObservers().size(), retainReson.getOrDefault(flow, ""), stats.queuedUpdatesCount(), stats.successfulUpdatesCount(), stats.allUpdatesCount(), stats.allUpdatesHistory()));
        });
    }

    static void registerTypeState(PointsToAnalysis bb, TypeState state) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        Integer id = stateToId.computeIfAbsent(state, s -> nextStateId.incrementAndGet());
        TypeState actualState = idToState.computeIfAbsent(id, i -> state);
        typeStateStats.computeIfAbsent(actualState, s -> new AtomicInteger()).incrementAndGet();
    }

    private static int objectsCount(TypeState state) {
        return state.objectsCount();
    }

    private static int typesCount(TypeState state) {
        return state.typesCount();
    }

    private static void reportTypeStateStats(BufferedWriter out) {
        PointsToStats.doWrite(out, String.format("%10s\t%10s\t%10s\t%10s\t%10s\n", "Id", "Frequency", "Types#", "Object#", "Types"));
        typeStateStats.entrySet().stream().sorted(Map.Entry.comparingByValue(atomicIntegerComparator.reversed())).forEach(entry -> {
            TypeState s = (TypeState)entry.getKey();
            int frequency = ((AtomicInteger)entry.getValue()).intValue();
            PointsToStats.doWrite(out, String.format("%10d\t%10d\t%10d\t%10d\t%10s\n", stateToId.get(s), frequency, PointsToStats.typesCount(s), PointsToStats.objectsCount(s), PointsToStats.asString(s)));
        });
    }

    static void registerUnionOperation(PointsToAnalysis bb, TypeState s1, TypeState s2, TypeState result) {
        if (!bb.reportAnalysisStatistics()) {
            return;
        }
        assert (typeStateStats.containsKey(s1) && typeStateStats.containsKey(s2) && typeStateStats.containsKey(result));
        UnionOperation union = new UnionOperation(s1, s2, result);
        AtomicInteger counter = unionStats.computeIfAbsent(union, k -> new AtomicInteger());
        counter.incrementAndGet();
    }

    private static void reportUnionOpertationsStats(BufferedWriter out) {
        PointsToStats.doWrite(out, String.format("%10s + %10s = %10s\t%10s\n", "State1ID", "State2ID", "ResultID", "Frequency"));
        unionStats.entrySet().stream().filter(e -> ((AtomicInteger)e.getValue()).intValue() > 1).sorted(Map.Entry.comparingByValue(atomicIntegerComparator.reversed())).forEach(entry -> {
            UnionOperation union = (UnionOperation)entry.getKey();
            Integer frequency = ((AtomicInteger)entry.getValue()).intValue();
            PointsToStats.doWrite(out, String.format("%10d + %10d = %10d\t%10d\t%10s + %10s = %10s\n", union.getState1Id(), union.getState2Id(), union.getResultId(), frequency, PointsToStats.asString(union.getState1()), PointsToStats.asString(union.getState2()), PointsToStats.asString(union.getResult())));
        });
    }

    private static String asString(TypeFlow<?> flow) {
        if (flow instanceof AllInstantiatedTypeFlow) {
            return "AllInstantiated(" + PointsToStats.formatType(flow.getDeclaredType(), true) + ")";
        }
        if (flow instanceof AllSynchronizedTypeFlow) {
            return "AllSynchronized";
        }
        if (flow instanceof ContextInsensitiveFieldTypeFlow) {
            ContextInsensitiveFieldTypeFlow sink = (ContextInsensitiveFieldTypeFlow)flow;
            return "FieldSink(" + PointsToStats.formatField((AnalysisField)sink.getSource()) + ")";
        }
        if (flow instanceof FieldTypeFlow) {
            FieldTypeFlow fieldFlow = (FieldTypeFlow)flow;
            AnalysisField field = (AnalysisField)fieldFlow.getSource();
            return (field.isStatic() ? "StaticField" : "InstanceField") + "(" + PointsToStats.formatField(field) + ")";
        }
        if (flow instanceof StoreFieldTypeFlow.StoreInstanceFieldTypeFlow) {
            StoreFieldTypeFlow.StoreInstanceFieldTypeFlow store = (StoreFieldTypeFlow.StoreInstanceFieldTypeFlow)flow;
            return "InstanceStore(" + PointsToStats.formatField(store.field()) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof StoreFieldTypeFlow.StoreStaticFieldTypeFlow) {
            StoreFieldTypeFlow.StoreStaticFieldTypeFlow store = (StoreFieldTypeFlow.StoreStaticFieldTypeFlow)flow;
            return "StaticStore(" + PointsToStats.formatField(store.field()) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof LoadFieldTypeFlow.LoadInstanceFieldTypeFlow) {
            LoadFieldTypeFlow.LoadInstanceFieldTypeFlow load = (LoadFieldTypeFlow.LoadInstanceFieldTypeFlow)flow;
            return "InstanceLoad(" + PointsToStats.formatField(load.field()) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof LoadFieldTypeFlow.LoadStaticFieldTypeFlow) {
            LoadFieldTypeFlow.LoadStaticFieldTypeFlow load = (LoadFieldTypeFlow.LoadStaticFieldTypeFlow)flow;
            return "StaticLoad(" + PointsToStats.formatField(load.field()) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof OffsetStoreTypeFlow.StoreIndexedTypeFlow) {
            return "IndexedStore @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof OffsetStoreTypeFlow.UnsafeStoreTypeFlow) {
            return "UnsafeStore @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow) {
            return "UnsafePartitionStore @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof UnsafeWriteSinkTypeFlow) {
            UnsafeWriteSinkTypeFlow sink = (UnsafeWriteSinkTypeFlow)flow;
            return "UnsafeWriteSink(" + PointsToStats.formatField((AnalysisField)sink.getSource()) + ")";
        }
        if (flow instanceof OffsetLoadTypeFlow.LoadIndexedTypeFlow) {
            return "IndexedLoad @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof OffsetLoadTypeFlow.UnsafeLoadTypeFlow) {
            return "UnsafeLoad @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow) {
            return "UnsafePartitionLoad @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof ArrayElementsTypeFlow) {
            ArrayElementsTypeFlow arrayFlow = (ArrayElementsTypeFlow)flow;
            return "ArrayElements(" + (arrayFlow.object() != null ? arrayFlow.object().type().toJavaName(false) : "?") + ")";
        }
        if (flow instanceof NullCheckTypeFlow) {
            NullCheckTypeFlow nullCheck = (NullCheckTypeFlow)flow;
            return "NullCheck(" + (nullCheck.isBlockingNull() ? "not-null" : "only-null") + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof FilterTypeFlow) {
            FilterTypeFlow filter = (FilterTypeFlow)flow;
            Object properties = filter.isExact() ? "exact" : "not-exact";
            properties = (String)properties + ", " + (filter.isAssignable() ? "assignable" : "not-assignable");
            properties = (String)properties + ", " + (filter.includeNull() ? "include-null" : "not-include-null");
            return "Filter(" + (String)properties + ", " + PointsToStats.formatType(filter.getDeclaredType(), true) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof FieldFilterTypeFlow) {
            FieldFilterTypeFlow filter = (FieldFilterTypeFlow)flow;
            return "FieldFilter(" + PointsToStats.formatField((AnalysisField)filter.getSource()) + ")";
        }
        if (flow instanceof FrozenFieldFilterTypeFlow) {
            FrozenFieldFilterTypeFlow filter = (FrozenFieldFilterTypeFlow)flow;
            return "FrozenFieldFilter(" + PointsToStats.formatField((AnalysisField)filter.getSource()) + ")";
        }
        if (flow instanceof InstanceOfTypeFlow) {
            InstanceOfTypeFlow instanceOf = (InstanceOfTypeFlow)flow;
            return "InstanceOf(" + PointsToStats.formatType(instanceOf.getDeclaredType(), true) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof NewInstanceTypeFlow) {
            return "NewInstance(" + flow.getDeclaredType().toJavaName(false) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof DynamicNewInstanceTypeFlow) {
            return "DynamicNewInstance @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof InvokeTypeFlow) {
            InvokeTypeFlow invoke = (InvokeTypeFlow)flow;
            return "Invoke(" + PointsToStats.formatMethod(invoke.getTargetMethod()) + ")@" + PointsToStats.formatSource(flow);
        }
        if (flow instanceof InitialParamTypeFlow) {
            InitialParamTypeFlow param = (InitialParamTypeFlow)flow;
            return "InitialParam(" + param.position() + ")@" + PointsToStats.formatMethod(param.method());
        }
        if (flow instanceof FormalParamTypeFlow) {
            FormalParamTypeFlow param = (FormalParamTypeFlow)flow;
            return "Parameter(" + param.position() + ")@" + PointsToStats.formatMethod(param.method());
        }
        if (flow instanceof FormalReturnTypeFlow) {
            return "Return @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof ActualReturnTypeFlow) {
            ActualReturnTypeFlow ret = (ActualReturnTypeFlow)flow;
            InvokeTypeFlow invoke = ret.invokeFlow();
            return "ActualReturn(" + (invoke == null ? "null" : PointsToStats.formatMethod(invoke.getTargetMethod())) + ")@ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof MergeTypeFlow) {
            return "Merge @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof SourceTypeFlow) {
            return "Source @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof CloneTypeFlow) {
            return "Clone @ " + PointsToStats.formatSource(flow);
        }
        if (flow instanceof MonitorEnterTypeFlow) {
            MonitorEnterTypeFlow monitor = (MonitorEnterTypeFlow)flow;
            return "MonitorEnter @ " + PointsToStats.formatMethod(monitor.getMethod());
        }
        return ClassUtil.getUnqualifiedName(flow.getClass()) + "@" + PointsToStats.formatSource(flow);
    }

    private static String formatSource(TypeFlow<?> flow) {
        Object source = flow.getSource();
        if (source instanceof BytecodePosition) {
            BytecodePosition nodeSource = (BytecodePosition)source;
            return PointsToStats.formatMethod(nodeSource.getMethod()) + ":" + nodeSource.getBCI();
        }
        if (source instanceof AnalysisType) {
            return PointsToStats.formatType((AnalysisType)source);
        }
        if (source instanceof AnalysisField) {
            return PointsToStats.formatField((AnalysisField)source);
        }
        if (flow.graphRef() != null) {
            return PointsToStats.formatMethod(flow.graphRef().getMethod());
        }
        if (source == null) {
            return "<no-source>";
        }
        return ClassUtil.getUnqualifiedName(source.getClass());
    }

    private static String formatMethod(ResolvedJavaMethod method) {
        return method.format("%H.%n(%p)");
    }

    private static String formatField(AnalysisField field) {
        return field.format("%H.%n");
    }

    private static String formatType(AnalysisType type) {
        return PointsToStats.formatType(type, false);
    }

    private static String formatType(AnalysisType type, boolean qualified) {
        return type.toJavaName(qualified);
    }

    private static String asDetailedString(BigBang bb, TypeState s) {
        if (s.isEmpty()) {
            return "<Empty>";
        }
        if (s.isNull()) {
            return "<Null>";
        }
        String canBeNull = s.canBeNull() ? "null" : "!null";
        String types = s.typesStream(bb).map(JavaType::getUnqualifiedName).sorted().collect(Collectors.joining(", "));
        return canBeNull + ", " + types;
    }

    public static String asString(TypeState s) {
        if (s.isEmpty()) {
            return "<Empty>";
        }
        if (s.isNull()) {
            return "<Null>";
        }
        String sKind = s.isAllocation() ? "Alloc" : (s.isConstant() ? "Const" : (s.isSingleTypeState() ? "Single" : (s.isMultiTypeState() ? "Multi" : "")));
        Object sSizeOrType = s.isMultiTypeState() ? "" + s.typesCount() : s.exactType().toJavaName(false);
        int objectsNumber = s.objectsCount();
        String canBeNull = s.canBeNull() ? "null" : "!null";
        return "<" + sKind + "," + canBeNull + ",T:" + (String)sSizeOrType + ",O:" + objectsNumber + ">";
    }

    private static void doWrite(BufferedWriter out, String str) {
        try {
            out.write(str);
        }
        catch (IOException ex) {
            throw JVMCIError.shouldNotReachHere((Throwable)ex);
        }
    }

    static {
        typeFlowBuilders = new CopyOnWriteArrayList();
        typeFlowStats = new ConcurrentHashMap();
        retainReson = new ConcurrentHashMap();
        longComparator = Comparator.naturalOrder();
        stateToId = new ConcurrentHashMap();
        idToState = new ConcurrentHashMap();
        atomicIntegerComparator = Comparator.comparingInt(AtomicInteger::intValue);
        nextStateId = new AtomicInteger();
        typeStateStats = new ConcurrentHashMap();
        unionStats = new ConcurrentHashMap();
    }

    static class FilterOperation {
        int filterId;
        int inputId;
        int resultId;

        FilterOperation(int filterId, int inputId, int resultId) {
            this.filterId = filterId;
            this.inputId = inputId;
            this.resultId = resultId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilterOperation) {
                FilterOperation other = (FilterOperation)obj;
                return this.filterId == other.filterId && this.inputId == other.inputId && this.resultId == other.resultId;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.filterId;
            result = 31 * result + this.inputId;
            result = 31 * result + this.resultId;
            return result;
        }
    }

    static class UnionOperation {
        int state1Id;
        int state2Id;
        int resultId;

        UnionOperation(TypeState state1, TypeState state2, TypeState result) {
            this.state1Id = stateToId.get(state1);
            this.state2Id = stateToId.get(state2);
            this.resultId = stateToId.get(result);
        }

        int getState1Id() {
            return this.state1Id;
        }

        TypeState getState1() {
            return idToState.get(this.state1Id);
        }

        int getState2Id() {
            return this.state2Id;
        }

        TypeState getState2() {
            return idToState.get(this.state2Id);
        }

        int getResultId() {
            return this.resultId;
        }

        public TypeState getResult() {
            return idToState.get(this.resultId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnionOperation) {
                UnionOperation other = (UnionOperation)obj;
                return this.state1Id == other.state1Id && this.state2Id == other.state2Id && this.resultId == other.resultId;
            }
            return false;
        }

        public int hashCode() {
            return 0x1F ^ this.state1Id ^ this.state2Id ^ this.resultId;
        }
    }

    static class TypeFlowStats {
        static final Comparator<TypeFlowStats> totalUpdatesCountComparator = Comparator.comparingInt(TypeFlowStats::allUpdatesCount);
        String retainReason = "";
        final TypeFlow<?> flow;
        final List<TypeState> allUpdates;
        final List<TypeState> successfulUpdates;
        final AtomicInteger queuedUpdates;

        TypeFlowStats(TypeFlow<?> flow) {
            this.flow = flow;
            this.allUpdates = new CopyOnWriteArrayList<TypeState>();
            this.successfulUpdates = new CopyOnWriteArrayList<TypeState>();
            this.queuedUpdates = new AtomicInteger(0);
        }

        public void setRetainReason(String retainReason) {
            this.retainReason = retainReason;
        }

        public String getRetainReason() {
            return this.retainReason;
        }

        int allUpdatesCount() {
            return this.allUpdates.size();
        }

        int successfulUpdatesCount() {
            return this.successfulUpdates.size();
        }

        int queuedUpdatesCount() {
            return this.queuedUpdates.get();
        }

        void registerUpdate(TypeState state) {
            this.allUpdates.add(state);
        }

        void registerSuccessfulUpdate(TypeState state) {
            this.successfulUpdates.add(state);
        }

        void registerQueuedUpdate() {
            this.queuedUpdates.incrementAndGet();
        }

        String allUpdatesHistory() {
            return TypeFlowStats.updatesHistory(this.allUpdates);
        }

        private static String updatesHistory(List<TypeState> updates) {
            return updates.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue(longComparator.reversed())).map(entry -> entry.getValue() + "x" + stateToId.get(entry.getKey())).collect(Collectors.joining(", "));
        }
    }
}

