/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.SourceTypeFlowBase;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public class NewInstanceTypeFlow
extends SourceTypeFlowBase {
    private static final AtomicReferenceFieldUpdater<NewInstanceTypeFlow, ConcurrentMap> HEAP_OBJECTS_CACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(NewInstanceTypeFlow.class, ConcurrentMap.class, "heapObjectsCache");
    protected volatile ConcurrentMap<AnalysisContext, AnalysisObject> heapObjectsCache;
    protected final AnalysisType type;
    protected final BytecodeLocation allocationSite;

    public NewInstanceTypeFlow(ValueNode node, AnalysisType type, BytecodeLocation allocationLabel) {
        this(node, type, allocationLabel, TypeState.forNull());
    }

    protected NewInstanceTypeFlow(ValueNode node, AnalysisType type, BytecodeLocation allocationLabel, TypeState typeState) {
        super(node, type, typeState);
        this.type = type;
        this.allocationSite = allocationLabel;
    }

    protected NewInstanceTypeFlow(PointsToAnalysis bb, NewInstanceTypeFlow original, MethodFlowsGraph methodFlows) {
        super(bb, original, methodFlows, original.cloneSourceState(bb, methodFlows));
        this.type = original.type;
        this.allocationSite = original.allocationSite;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new NewInstanceTypeFlow(bb, this, methodFlows);
    }

    protected TypeState cloneSourceState(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        assert (!this.isClone());
        AnalysisContext allocatorContext = methodFlows.context();
        AnalysisContext allocationContext = bb.contextPolicy().allocationContext(allocatorContext, (Integer)PointstoOptions.MaxHeapContextDepth.getValue(bb.getOptions()));
        if (bb.analysisPolicy().isContextSensitiveAllocation(bb, this.type, allocationContext)) {
            AnalysisObject newHeapObject = this.createHeapObject(bb, allocationContext);
            return TypeState.forNonNullObject(bb, newHeapObject);
        }
        return TypeState.forExactType(bb, this.type, false);
    }

    private AnalysisObject createHeapObject(PointsToAnalysis bb, AnalysisContext objContext) {
        AnalysisObject result;
        assert (!this.isClone());
        if (this.heapObjectsCache == null) {
            HEAP_OBJECTS_CACHE_UPDATER.compareAndSet(this, null, new ConcurrentHashMap());
        }
        if ((result = (AnalysisObject)this.heapObjectsCache.get(objContext)) == null) {
            AnalysisObject newValue = bb.analysisPolicy().createHeapObject(bb, this.type, this.allocationSite, objContext);
            AnalysisObject oldValue = this.heapObjectsCache.putIfAbsent(objContext, newValue);
            result = oldValue != null ? oldValue : newValue;
        }
        return result;
    }

    public BytecodeLocation allocationSite() {
        return this.allocationSite;
    }

    public AnalysisType type() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("NewInstanceFlow<").append(this.getState()).append(">");
        return str.toString();
    }
}

