/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.ArrayCopyTypeFlow;
import com.oracle.graal.pointsto.flow.BoxTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.ExceptionObjectTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.WordToObjectTypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.flow.builder.TypeFlowGraphBuilder;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.nodes.UnsafePartitionLoadNode;
import com.oracle.graal.pointsto.nodes.UnsafePartitionStoreNode;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysis;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.graph.MergeableState;
import org.graalvm.compiler.phases.graph.PostOrderNodeIterator;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.ObjectClone;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.word.WordCastNode;
import org.graalvm.util.GuardedAnnotationAccess;

public class MethodTypeFlowBuilder {
    protected final PointsToAnalysis bb;
    protected final MethodTypeFlow methodFlow;
    protected final PointsToAnalysisMethod method;
    protected StructuredGraph graph;
    private NodeBitMap processedNodes;
    private Map<PhiNode, TypeFlowBuilder<?>> loopPhiFlows;
    protected final TypeFlowGraphBuilder typeFlowGraphBuilder;

    public MethodTypeFlowBuilder(PointsToAnalysis bb, MethodTypeFlow methodFlow) {
        this.bb = bb;
        this.methodFlow = methodFlow;
        this.method = methodFlow.getMethod();
        this.typeFlowGraphBuilder = new TypeFlowGraphBuilder(bb);
    }

    public MethodTypeFlowBuilder(PointsToAnalysis bb, StructuredGraph graph) {
        this.bb = bb;
        this.graph = graph;
        this.method = (PointsToAnalysisMethod)graph.method();
        this.methodFlow = this.method.getTypeFlow();
        this.typeFlowGraphBuilder = null;
    }

    private boolean parse() {
        boolean bl;
        block13: {
            AnalysisParsedGraph analysisParsedGraph = this.method.ensureGraphParsed(this.bb);
            if (analysisParsedGraph.isIntrinsic()) {
                this.method.registerAsIntrinsicMethod();
            }
            if (analysisParsedGraph.getEncodedGraph() == null) {
                return false;
            }
            this.graph = InlineBeforeAnalysis.decodeGraph(this.bb, this.method, analysisParsedGraph);
            DebugContext.Scope s = this.graph.getDebug().scope((Object)"MethodTypeFlowBuilder", (Object)this.graph);
            try {
                if (!this.bb.strengthenGraalGraphs()) {
                    this.registerUsedElements(false);
                }
                CanonicalizerPhase canonicalizerPhase = CanonicalizerPhase.create();
                canonicalizerPhase.apply(this.graph, (Object)this.bb.getProviders());
                if (this.bb.strengthenGraalGraphs()) {
                    new IterativeConditionalEliminationPhase(canonicalizerPhase, false).apply(this.graph, (Object)this.bb.getProviders());
                }
                this.registerUsedElements(true);
                if (this.bb.strengthenGraalGraphs()) {
                    this.graph.minimizeSize();
                    this.method.setAnalyzedGraph(this.graph);
                }
                bl = true;
                if (s == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    throw this.graph.getDebug().handle(ex);
                }
            }
            s.close();
        }
        return bl;
    }

    public void registerUsedElements(boolean registerEmbeddedRoots) {
        for (Node n : this.graph.getNodes()) {
            AnalysisField field;
            AnalysisType type;
            InstanceOfNode node;
            if (n instanceof InstanceOfNode) {
                node = (InstanceOfNode)n;
                type = (AnalysisType)node.type().getType();
                type.registerAsReachable();
                continue;
            }
            if (n instanceof NewInstanceNode) {
                node = (NewInstanceNode)n;
                type = (AnalysisType)node.instanceClass();
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof VirtualObjectNode) {
                node = (VirtualObjectNode)n;
                type = (AnalysisType)node.type();
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof CommitAllocationNode) {
                node = (CommitAllocationNode)n;
                List values = node.getValues();
                int objectStartIndex = 0;
                for (VirtualObjectNode virtualObject : node.getVirtualObjects()) {
                    AnalysisType type2 = (AnalysisType)virtualObject.type();
                    if (!type2.isArray()) {
                        for (int i = 0; i < virtualObject.entryCount(); ++i) {
                            ValueNode value = (ValueNode)values.get(objectStartIndex + i);
                            if (value.isJavaConstant() && value.asJavaConstant().isDefaultForKind()) continue;
                            AnalysisField field2 = (AnalysisField)((VirtualInstanceNode)virtualObject).field(i);
                            field2.registerAsWritten(this.methodFlow);
                        }
                    }
                    objectStartIndex += virtualObject.entryCount();
                }
                continue;
            }
            if (n instanceof NewArrayNode) {
                node = (NewArrayNode)n;
                type = ((AnalysisType)node.elementType()).getArrayClass();
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                node = (NewMultiArrayNode)n;
                type = (AnalysisType)node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    type.registerAsAllocated((Node)node);
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof BoxNode) {
                node = (BoxNode)n;
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)node);
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof LoadFieldNode) {
                node = (LoadFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsRead(this.methodFlow);
                continue;
            }
            if (n instanceof StoreFieldNode) {
                node = (StoreFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsWritten(this.methodFlow);
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode cn = (ConstantNode)n;
                if (!cn.hasUsages() || !cn.isJavaConstant() || cn.asJavaConstant().getJavaKind() != JavaKind.Object || !cn.asJavaConstant().isNonNull()) continue;
                assert (StampTool.isExactType((ValueNode)cn));
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)cn);
                type.registerAsInHeap();
                if (!registerEmbeddedRoots) continue;
                this.registerEmbeddedRoot(cn);
                continue;
            }
            if (n instanceof FrameState) {
                node = (FrameState)n;
                AnalysisMethod frameStateMethod = (AnalysisMethod)node.getMethod();
                if (frameStateMethod == null) continue;
                frameStateMethod.getDeclaringClass().registerAsReachable();
                continue;
            }
            if (n instanceof ForeignCall) {
                node = (ForeignCall)n;
                MethodTypeFlowBuilder.registerForeignCall(this.bb, node.getDescriptor());
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                node = (UnaryMathIntrinsicNode)n;
                MethodTypeFlowBuilder.registerForeignCall(this.bb, this.bb.getProviders().getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature));
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            node = (BinaryMathIntrinsicNode)n;
            MethodTypeFlowBuilder.registerForeignCall(this.bb, this.bb.getProviders().getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature));
        }
    }

    private void registerEmbeddedRoot(ConstantNode cn) {
        JavaConstant root = cn.asJavaConstant();
        if (this.bb.scanningPolicy().trackConstant(this.bb, root)) {
            NodeSourcePosition position = cn.getNodeSourcePosition();
            if (position == null) {
                position = new BytecodePosition(null, (ResolvedJavaMethod)this.method, 0);
            }
            this.bb.getUniverse().registerEmbeddedRoot(root, (BytecodePosition)position);
        }
    }

    private static void registerForeignCall(PointsToAnalysis bb, ForeignCallDescriptor foreignCallDescriptor) {
        Optional<AnalysisMethod> targetMethod = bb.getHostVM().handleForeignCall(foreignCallDescriptor, bb.getProviders().getForeignCalls());
        targetMethod.ifPresent(analysisMethod -> bb.addRootMethod((AnalysisMethod)analysisMethod, true));
    }

    protected void apply() {
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)this.method), Node.NodeIntrinsic.class)) {
            this.graph.getDebug().log("apply MethodTypeFlow on node intrinsic %s", (Object)this.method);
            AnalysisType returnType = (AnalysisType)this.method.getSignature().getReturnType(this.method.getDeclaringClass());
            if (returnType.getJavaKind() == JavaKind.Object) {
                TypeFlow returnTypeFlow = this.methodFlow.getResultFlow().getDeclaredType().getTypeFlow(this.bb, true);
                BytecodePosition source = new BytecodePosition(null, (ResolvedJavaMethod)this.method, 0);
                returnTypeFlow = new ProxyTypeFlow(source, returnTypeFlow);
                FormalReturnTypeFlow resultFlow = new FormalReturnTypeFlow(source, returnType, (AnalysisMethod)this.method);
                returnTypeFlow.addOriginalUse(this.bb, resultFlow);
                this.methodFlow.addMiscEntry(returnTypeFlow);
                this.methodFlow.setResult(resultFlow);
            }
            return;
        }
        if (!this.parse()) {
            return;
        }
        this.bb.getHostVM().methodBeforeTypeFlowCreationHook(this.bb, this.method, this.graph);
        this.processedNodes = new NodeBitMap((Graph)this.graph);
        TypeFlowsOfNodes typeFlows = new TypeFlowsOfNodes();
        for (Node n : this.graph.getNodes()) {
            Object node;
            if (n instanceof ParameterNode) {
                node = (ParameterNode)n;
                if (node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<FormalParamTypeFlow> paramBuilder = TypeFlowBuilder.create(this.bb, node, FormalParamTypeFlow.class, () -> this.lambda$apply$1((ParameterNode)node));
                    this.typeFlowGraphBuilder.checkFormalParameterBuilder(paramBuilder);
                    typeFlows.add((ValueNode)node, paramBuilder);
                    if (this.bb.strengthenGraalGraphs()) {
                        this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
                    }
                }
            } else if (n instanceof BoxNode) {
                node = (BoxNode)n;
                Object key = this.uniqueKey((Node)node);
                BytecodeLocation boxSite = this.bb.analysisPolicy().createAllocationSite(this.bb, key, (AnalysisMethod)this.methodFlow.getMethod());
                AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node);
                TypeFlowBuilder<BoxTypeFlow> boxBuilder = TypeFlowBuilder.create(this.bb, node, BoxTypeFlow.class, () -> this.lambda$apply$2((BoxNode)node, type, boxSite));
                typeFlows.add((ValueNode)node, boxBuilder);
            }
            for (Node input : n.inputs()) {
                if (!(input instanceof ConstantNode) || typeFlows.contains((ValueNode)((ConstantNode)input))) continue;
                ConstantNode node2 = (ConstantNode)input;
                Constant constant = node2.getValue();
                if (node2.asJavaConstant() == null && constant instanceof VMConstant) continue;
                if (node2.asJavaConstant().isNull()) {
                    TypeFlowBuilder<SourceTypeFlow> sourceBuilder = TypeFlowBuilder.create(this.bb, node2, SourceTypeFlow.class, () -> {
                        SourceTypeFlow constantSource = new SourceTypeFlow((ValueNode)node2, TypeState.forNull());
                        this.methodFlow.addMiscEntry(constantSource);
                        return constantSource;
                    });
                    typeFlows.add((ValueNode)node2, sourceBuilder);
                    continue;
                }
                if (node2.asJavaConstant().getJavaKind() != JavaKind.Object) continue;
                assert (StampTool.isExactType((ValueNode)node2));
                AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node2);
                assert (type.isInstantiated());
                TypeFlowBuilder<SourceTypeFlow> sourceBuilder = TypeFlowBuilder.create(this.bb, node2, SourceTypeFlow.class, () -> {
                    SourceTypeFlow constantSource = new SourceTypeFlow((ValueNode)node2, TypeState.forConstant(this.bb, node2.asJavaConstant(), type));
                    this.methodFlow.addMiscEntry(constantSource);
                    return constantSource;
                });
                typeFlows.add((ValueNode)node2, sourceBuilder);
            }
        }
        new NodeIterator((FixedNode)this.graph.start(), typeFlows).apply();
        this.typeFlowGraphBuilder.build();
        for (Node n : this.graph.getNodes()) {
            if (n instanceof InstanceOfNode) {
                InstanceOfNode instanceOf = (InstanceOfNode)n;
                MethodTypeFlowBuilder.markFieldsUsedInComparison(instanceOf.getValue());
                continue;
            }
            if (!(n instanceof ObjectEqualsNode)) continue;
            ObjectEqualsNode compareNode = (ObjectEqualsNode)n;
            MethodTypeFlowBuilder.markFieldsUsedInComparison(compareNode.getX());
            MethodTypeFlowBuilder.markFieldsUsedInComparison(compareNode.getY());
        }
    }

    private static void markFieldsUsedInComparison(ValueNode comparedValue) {
        LoadFieldNode load;
        AnalysisField field;
        if (comparedValue instanceof LoadFieldNode && !(field = (AnalysisField)(load = (LoadFieldNode)comparedValue).field()).isStatic()) {
            field.markAsUsedInComparison();
        }
    }

    protected void delegateNodeProcessing(FixedNode n, TypeFlowsOfNodes state) {
    }

    protected Object uniqueKey(Node node) {
        if (this.bb.strengthenGraalGraphs()) {
            return node;
        }
        NodeSourcePosition position = node.getNodeSourcePosition();
        if (position != null && position.getCaller() == null && position.getBCI() >= 0) {
            return position.getBCI();
        }
        return new Object();
    }

    protected void processCommitAllocation(CommitAllocationNode commitAllocationNode, TypeFlowsOfNodes state) {
        HashMap<VirtualObjectNode, AllocatedObjectNode> allocatedObjects = new HashMap<VirtualObjectNode, AllocatedObjectNode>();
        for (AllocatedObjectNode allocatedObjectNode : commitAllocationNode.usages().filter(AllocatedObjectNode.class)) {
            AnalysisType type = (AnalysisType)allocatedObjectNode.getVirtualObject().type();
            this.processNewInstance((ValueNode)allocatedObjectNode, type, state);
            allocatedObjects.put(allocatedObjectNode.getVirtualObject(), allocatedObjectNode);
        }
        List values = commitAllocationNode.getValues();
        int objectStartIndex = 0;
        for (VirtualObjectNode virtualObject : commitAllocationNode.getVirtualObjects()) {
            AnalysisType type = (AnalysisType)virtualObject.type();
            ValueNode object = (ValueNode)allocatedObjects.get(virtualObject);
            if (object == null) {
                object = virtualObject;
            }
            for (int i = 0; i < virtualObject.entryCount(); ++i) {
                ValueNode value = (ValueNode)values.get(objectStartIndex + i);
                if (value.isJavaConstant() && value.asJavaConstant().isDefaultForKind()) continue;
                if (type.isArray()) {
                    this.processStoreIndexed((ValueNode)commitAllocationNode, object, value, state);
                    continue;
                }
                AnalysisField field = (AnalysisField)((VirtualInstanceNode)virtualObject).field(i);
                this.processStoreField((ValueNode)commitAllocationNode, field, object, value, state);
            }
            objectStartIndex += virtualObject.entryCount();
        }
        assert (values.size() == objectStartIndex);
    }

    protected void processNewInstance(NewInstanceNode node, TypeFlowsOfNodes state) {
        this.processNewInstance((ValueNode)node, (AnalysisType)node.instanceClass(), state);
    }

    protected void processNewArray(NewArrayNode node, TypeFlowsOfNodes state) {
        this.processNewInstance((ValueNode)node, ((AnalysisType)node.elementType()).getArrayClass(), state);
    }

    protected void processNewInstance(ValueNode node, AnalysisType type, TypeFlowsOfNodes state) {
        assert (type.isInstantiated());
        Object key = this.uniqueKey((Node)node);
        BytecodeLocation allocationLabel = this.bb.analysisPolicy().createAllocationSite(this.bb, key, (AnalysisMethod)this.method);
        TypeFlowBuilder<NewInstanceTypeFlow> newInstanceBuilder = TypeFlowBuilder.create(this.bb, node, NewInstanceTypeFlow.class, () -> {
            NewInstanceTypeFlow newInstance = new NewInstanceTypeFlow(node, type, allocationLabel);
            this.methodFlow.addMiscEntry(newInstance);
            return newInstance;
        });
        state.add(node, newInstanceBuilder);
    }

    protected void processStoreField(StoreFieldNode node, TypeFlowsOfNodes state) {
        this.processStoreField((ValueNode)node, (AnalysisField)node.field(), node.object(), node.value(), state);
    }

    protected void processStoreField(ValueNode node, AnalysisField field, ValueNode object, ValueNode value, TypeFlowsOfNodes state) {
        assert (field.isWritten());
        if (value.getStackKind() == JavaKind.Object) {
            TypeFlowBuilder<StoreFieldTypeFlow> storeFieldBuilder;
            TypeFlowBuilder<?> valueBuilder = state.lookup(value);
            NodeSourcePosition storeLocation = node.getNodeSourcePosition();
            if (field.isStatic()) {
                storeFieldBuilder = TypeFlowBuilder.create(this.bb, node, StoreFieldTypeFlow.class, () -> {
                    FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                    StoreFieldTypeFlow.StoreStaticFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreStaticFieldTypeFlow((BytecodePosition)storeLocation, field, (TypeFlow<?>)valueBuilder.get(), fieldFlow);
                    this.methodFlow.addMiscEntry(storeFieldFlow);
                    return storeFieldFlow;
                });
                storeFieldBuilder.addUseDependency(valueBuilder);
            } else {
                TypeFlowBuilder<?> objectBuilder = state.lookup(object);
                storeFieldBuilder = TypeFlowBuilder.create(this.bb, node, StoreFieldTypeFlow.class, () -> {
                    StoreFieldTypeFlow.StoreInstanceFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreInstanceFieldTypeFlow((BytecodePosition)storeLocation, field, (TypeFlow<?>)valueBuilder.get(), (TypeFlow<?>)objectBuilder.get());
                    this.methodFlow.addMiscEntry(storeFieldFlow);
                    return storeFieldFlow;
                });
                storeFieldBuilder.addUseDependency(valueBuilder);
                storeFieldBuilder.addObserverDependency(objectBuilder);
            }
            this.typeFlowGraphBuilder.registerSinkBuilder(storeFieldBuilder);
        }
    }

    private void processStoreIndexed(StoreIndexedNode node, TypeFlowsOfNodes state) {
        this.processStoreIndexed((ValueNode)node, node.array(), node.value(), state);
    }

    private void processStoreIndexed(ValueNode node, ValueNode array, ValueNode value, TypeFlowsOfNodes state) {
        if (value.getStackKind() == JavaKind.Object) {
            AnalysisType arrayType = (AnalysisType)StampTool.typeOrNull((ValueNode)array);
            AnalysisType nonNullArrayType = Optional.ofNullable(arrayType).orElseGet(this.bb::getObjectArrayType);
            TypeFlowBuilder<?> arrayBuilder = state.lookup(array);
            TypeFlowBuilder<?> valueBuilder = state.lookup(value);
            TypeFlowBuilder<OffsetStoreTypeFlow.StoreIndexedTypeFlow> storeIndexedBuilder = TypeFlowBuilder.create(this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                OffsetStoreTypeFlow.StoreIndexedTypeFlow storeIndexedFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((BytecodePosition)node.getNodeSourcePosition(), nonNullArrayType, (TypeFlow<?>)arrayBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                this.methodFlow.addMiscEntry(storeIndexedFlow);
                return storeIndexedFlow;
            });
            storeIndexedBuilder.addUseDependency(valueBuilder);
            storeIndexedBuilder.addObserverDependency(arrayBuilder);
            this.typeFlowGraphBuilder.registerSinkBuilder(storeIndexedBuilder);
        }
    }

    protected void checkUnsafeOffset(ValueNode base, ValueNode offset) {
    }

    private /* synthetic */ BoxTypeFlow lambda$apply$2(BoxNode node, AnalysisType type, BytecodeLocation boxSite) {
        BoxTypeFlow boxFlow = new BoxTypeFlow((ValueNode)node, type, boxSite);
        this.methodFlow.addMiscEntry(boxFlow);
        return boxFlow;
    }

    private /* synthetic */ FormalParamTypeFlow lambda$apply$1(ParameterNode node) {
        FormalParamTypeFlow parameter;
        boolean isStatic = Modifier.isStatic(this.method.getModifiers());
        int index = node.index();
        if (!isStatic && index == 0) {
            AnalysisType paramType = this.method.getDeclaringClass();
            parameter = new FormalReceiverTypeFlow(node, paramType, this.method);
        } else {
            int offset = isStatic ? 0 : 1;
            AnalysisType paramType = (AnalysisType)this.method.getSignature().getParameterType(index - offset, this.method.getDeclaringClass());
            parameter = new FormalParamTypeFlow(node, paramType, this.method, index);
        }
        this.methodFlow.setParameter(index, parameter);
        return parameter;
    }

    class NodeIterator
    extends PostOrderNodeIterator<TypeFlowsOfNodes> {
        private HashMap<Object, TypeFlowBuilder<?>> instanceOfFlows;
        private TypeFlowBuilder<?> returnBuilder;

        NodeIterator(FixedNode start, TypeFlowsOfNodes typeFlows) {
            super(start, (MergeableState)typeFlows);
            this.instanceOfFlows = new HashMap();
            this.returnBuilder = null;
        }

        private TypeFlowBuilder<?> uniqueReturnFlowBuilder(ReturnNode node) {
            AnalysisType returnType;
            if (this.returnBuilder == null && (returnType = (AnalysisType)MethodTypeFlowBuilder.this.method.getSignature().getReturnType(MethodTypeFlowBuilder.this.method.getDeclaringClass())).getJavaKind() == JavaKind.Object) {
                this.returnBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, FormalReturnTypeFlow.class, () -> {
                    FormalReturnTypeFlow resultFlow = new FormalReturnTypeFlow((ValueNode)node, returnType, (AnalysisMethod)MethodTypeFlowBuilder.this.method);
                    MethodTypeFlowBuilder.this.methodFlow.setResult(resultFlow);
                    return resultFlow;
                });
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(this.returnBuilder);
            }
            return this.returnBuilder;
        }

        private TypeFlowBuilder<?> uniqueInstanceOfFlow(InstanceOfNode node, AnalysisType declaredType) {
            Object key = MethodTypeFlowBuilder.this.uniqueKey((Node)node);
            return this.instanceOfFlows.computeIfAbsent(key, bciKey -> {
                BytecodeLocation location = BytecodeLocation.create(bciKey, (AnalysisMethod)MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<InstanceOfTypeFlow> instanceOfBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, InstanceOfTypeFlow.class, () -> {
                    InstanceOfTypeFlow instanceOf = new InstanceOfTypeFlow((ValueNode)node, location, declaredType);
                    MethodTypeFlowBuilder.this.methodFlow.addInstanceOf(key, instanceOf);
                    return instanceOf;
                });
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(instanceOfBuilder);
                return instanceOfBuilder;
            });
        }

        private void handleCondition(ValueNode source, LogicNode condition, boolean isTrue) {
            if (condition instanceof IsNullNode) {
                IsNullNode nullCheck = (IsNullNode)condition;
                ValueNode object = nullCheck.getValue();
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                TypeFlowBuilder<NullCheckTypeFlow> nullCheckBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, source, NullCheckTypeFlow.class, () -> {
                    NullCheckTypeFlow nullCheckFlow = new NullCheckTypeFlow(source, ((TypeFlow)inputBuilder.get()).getDeclaredType(), !isTrue);
                    MethodTypeFlowBuilder.this.methodFlow.addNodeFlow(MethodTypeFlowBuilder.this.bb, (Node)source, nullCheckFlow);
                    return nullCheckFlow;
                });
                nullCheckBuilder.addUseDependency(inputBuilder);
                if (MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs()) {
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(nullCheckBuilder);
                }
                ((TypeFlowsOfNodes)this.state).update(object, nullCheckBuilder);
            } else if (condition instanceof InstanceOfNode) {
                InstanceOfNode instanceOf = (InstanceOfNode)condition;
                ValueNode object = instanceOf.getValue();
                TypeReference typeReference = instanceOf.type();
                AnalysisType type = (AnalysisType)instanceOf.type().getType();
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                NodeSourcePosition instanceOfPosition = instanceOf.getNodeSourcePosition();
                if (!MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs() && instanceOfPosition != null && instanceOfPosition.getBCI() >= 0) {
                    TypeFlowBuilder<?> instanceOfBuilder = this.uniqueInstanceOfFlow(instanceOf, type);
                    instanceOfBuilder.addUseDependency(objectBuilder);
                }
                TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, source, FilterTypeFlow.class, () -> {
                    FilterTypeFlow filterFlow = new FilterTypeFlow(source, type, typeReference.isExact(), isTrue, !isTrue ^ instanceOf.allowsNull());
                    MethodTypeFlowBuilder.this.methodFlow.addNodeFlow(MethodTypeFlowBuilder.this.bb, (Node)source, filterFlow);
                    return filterFlow;
                });
                filterBuilder.addUseDependency(objectBuilder);
                if (MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs()) {
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(filterBuilder);
                }
                ((TypeFlowsOfNodes)this.state).update(object, filterBuilder);
            }
        }

        protected void node(FixedNode n) {
            MethodTypeFlowBuilder.this.processedNodes.mark((Node)n);
            if (n instanceof LoopEndNode) {
                LoopEndNode end = (LoopEndNode)n;
                LoopBeginNode merge = end.loopBegin();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (phi.getStackKind() != JavaKind.Object) continue;
                    MethodTypeFlowBuilder.this.loopPhiFlows.get(phi).addUseDependency(((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof LoopBeginNode) {
                LoopBeginNode merge = (LoopBeginNode)n;
                for (PhiNode phi : merge.phis()) {
                    if (phi.getStackKind() != JavaKind.Object) continue;
                    TypeFlowBuilder<MergeTypeFlow> newFlowBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, merge, MergeTypeFlow.class, () -> {
                        MergeTypeFlow newFlow = new MergeTypeFlow((Node)merge);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newFlow);
                        return newFlow;
                    });
                    newFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup((ValueNode)phi));
                    ((TypeFlowsOfNodes)this.state).update((ValueNode)phi, newFlowBuilder);
                    if (MethodTypeFlowBuilder.this.loopPhiFlows == null) {
                        MethodTypeFlowBuilder.this.loopPhiFlows = new HashMap();
                    }
                    MethodTypeFlowBuilder.this.loopPhiFlows.put(phi, newFlowBuilder);
                }
            } else if (n instanceof EndNode) {
                EndNode end = (EndNode)n;
                AbstractMergeNode merge = end.merge();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (phi.getStackKind() != JavaKind.Object) continue;
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)phi, ((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof ExceptionObjectNode) {
                ExceptionObjectNode node = (ExceptionObjectNode)n;
                TypeFlowBuilder<ExceptionObjectTypeFlow> exceptionObjectBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ExceptionObjectTypeFlow.class, () -> {
                    AllInstantiatedTypeFlow input = ((AnalysisType)StampTool.typeOrNull((ValueNode)node)).getTypeFlow(MethodTypeFlowBuilder.this.bb, false);
                    ExceptionObjectTypeFlow exceptionObjectFlow = new ExceptionObjectTypeFlow((Node)node, input);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(exceptionObjectFlow);
                    return exceptionObjectFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, exceptionObjectBuilder);
            } else if (n instanceof BeginNode) {
                BeginNode node = (BeginNode)n;
                Node pred = node.predecessor();
                if (pred instanceof IfNode) {
                    IfNode ifNode = (IfNode)pred;
                    this.handleCondition((ValueNode)node, ifNode.condition(), node == ifNode.trueSuccessor());
                }
            } else if (n instanceof FixedGuardNode) {
                FixedGuardNode node = (FixedGuardNode)n;
                this.handleCondition((ValueNode)node, node.condition(), !node.isNegated());
            } else if (n instanceof ReturnNode) {
                ReturnNode node = (ReturnNode)n;
                TypeFlowBuilder<?> returnFlowBuilder = this.uniqueReturnFlowBuilder(node);
                if (node.result() != null && node.result().getStackKind() == JavaKind.Object) {
                    returnFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup(node.result()));
                }
            } else if (n instanceof CommitAllocationNode) {
                MethodTypeFlowBuilder.this.processCommitAllocation((CommitAllocationNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof NewInstanceNode) {
                MethodTypeFlowBuilder.this.processNewInstance((NewInstanceNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewInstanceNode) {
                TypeFlowBuilder<AllInstantiatedTypeFlow> instanceTypeBuilder;
                AnalysisType instanceType;
                DynamicNewInstanceNode node = (DynamicNewInstanceNode)n;
                ValueNode instanceTypeNode = node.getInstanceType();
                if (instanceTypeNode instanceof GetClassNode) {
                    GetClassNode getClassNode = (GetClassNode)instanceTypeNode;
                    ValueNode getClassReceiver = getClassNode.getObject();
                    instanceType = (AnalysisType)StampTool.typeOrNull((ValueNode)getClassReceiver);
                    instanceTypeBuilder = ((TypeFlowsOfNodes)this.state).lookup(getClassReceiver);
                } else {
                    instanceType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    instanceTypeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, instanceType, AllInstantiatedTypeFlow.class, () -> instanceType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false));
                }
                AnalysisType nonNullInstanceType = Optional.ofNullable(instanceType).orElseGet(MethodTypeFlowBuilder.this.bb::getObjectType);
                Object key = MethodTypeFlowBuilder.this.uniqueKey((Node)node);
                BytecodeLocation allocationLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, (AnalysisMethod)MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewInstanceBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newInstanceTypeFlow = new DynamicNewInstanceTypeFlow((BytecodePosition)node.getNodeSourcePosition(), (TypeFlow<?>)instanceTypeBuilder.get(), nonNullInstanceType, allocationLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newInstanceTypeFlow);
                    return newInstanceTypeFlow;
                });
                if (instanceTypeNode instanceof GetClassNode) {
                    dynamicNewInstanceBuilder.addObserverDependency(instanceTypeBuilder);
                }
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewInstanceBuilder);
            } else if (n instanceof NewArrayNode) {
                MethodTypeFlowBuilder.this.processNewArray((NewArrayNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewArrayNode) {
                DynamicNewArrayNode node = (DynamicNewArrayNode)n;
                AnalysisType arrayType = MethodTypeFlowBuilder.this.bb.getObjectType();
                Object key = MethodTypeFlowBuilder.this.uniqueKey((Node)node);
                BytecodeLocation allocationLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, (AnalysisMethod)MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newArrayTypeFlow = new DynamicNewInstanceTypeFlow((BytecodePosition)node.getNodeSourcePosition(), arrayType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false), arrayType, allocationLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newArrayTypeFlow);
                    return newArrayTypeFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewArrayBuilder);
            } else if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                AnalysisType type = (AnalysisType)node.type();
                assert (type.isInstantiated());
                Object key = MethodTypeFlowBuilder.this.uniqueKey((Node)node);
                BytecodeLocation allocationLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, (AnalysisMethod)MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<NewInstanceTypeFlow> newArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, NewInstanceTypeFlow.class, () -> {
                    NewInstanceTypeFlow newArray = new NewInstanceTypeFlow((ValueNode)node, type, allocationLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newArray);
                    return newArray;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, newArrayBuilder);
            } else if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                AnalysisField field = (AnalysisField)node.field();
                assert (field.isAccessed());
                if (node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<LoadFieldTypeFlow> loadFieldBuilder;
                    NodeSourcePosition loadLocation = node.getNodeSourcePosition();
                    if (node.isStatic()) {
                        loadFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, LoadFieldTypeFlow.LoadStaticFieldTypeFlow.class, () -> {
                            FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                            LoadFieldTypeFlow.LoadStaticFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadStaticFieldTypeFlow((BytecodePosition)loadLocation, field, fieldFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addNodeFlow(MethodTypeFlowBuilder.this.bb, (Node)node, loadFieldFLow);
                            return loadFieldFLow;
                        });
                    } else {
                        TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                        loadFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, LoadFieldTypeFlow.LoadInstanceFieldTypeFlow.class, () -> {
                            LoadFieldTypeFlow.LoadInstanceFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadInstanceFieldTypeFlow((BytecodePosition)loadLocation, field, (TypeFlow<?>)objectBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addNodeFlow(MethodTypeFlowBuilder.this.bb, (Node)node, loadFieldFLow);
                            return loadFieldFLow;
                        });
                        loadFieldBuilder.addObserverDependency(objectBuilder);
                    }
                    if (MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs()) {
                        MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(loadFieldBuilder);
                    }
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadFieldBuilder);
                }
            } else if (n instanceof StoreFieldNode) {
                MethodTypeFlowBuilder.this.processStoreField((StoreFieldNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof LoadIndexedNode) {
                LoadIndexedNode node = (LoadIndexedNode)n;
                TypeFlowBuilder<?> arrayBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.array());
                if (node.getStackKind() == JavaKind.Object) {
                    AnalysisType arrayType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.array());
                    AnalysisType nonNullArrayType = Optional.ofNullable(arrayType).orElseGet(MethodTypeFlowBuilder.this.bb::getObjectArrayType);
                    TypeFlowBuilder<OffsetLoadTypeFlow.LoadIndexedTypeFlow> loadIndexedBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.LoadIndexedTypeFlow loadIndexedFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow((BytecodePosition)node.getNodeSourcePosition(), nonNullArrayType, (TypeFlow<?>)arrayBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                        MethodTypeFlowBuilder.this.methodFlow.addNodeFlow(MethodTypeFlowBuilder.this.bb, (Node)node, loadIndexedFlow);
                        return loadIndexedFlow;
                    });
                    if (MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs()) {
                        MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(loadIndexedBuilder);
                    }
                    loadIndexedBuilder.addObserverDependency(arrayBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadIndexedBuilder);
                }
            } else if (n instanceof StoreIndexedNode) {
                MethodTypeFlowBuilder.this.processStoreIndexed((StoreIndexedNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof UnsafePartitionLoadNode) {
                UnsafePartitionLoadNode node = (UnsafePartitionLoadNode)n;
                assert (node.object().getStackKind() == JavaKind.Object);
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                AnalysisType partitionType = (AnalysisType)node.partitionType();
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                assert (MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(objectType));
                AnalysisType componentType = MethodTypeFlowBuilder.this.bb.getObjectType();
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow> unsafeLoadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow.class, () -> {
                    OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow((BytecodePosition)node.getNodeSourcePosition(), objectType, componentType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow, node.unsafePartitionKind(), partitionType);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                    return loadTypeFlow;
                });
                unsafeLoadBuilder.addObserverDependency(objectBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, unsafeLoadBuilder);
            } else if (n instanceof UnsafePartitionStoreNode) {
                UnsafePartitionStoreNode node = (UnsafePartitionStoreNode)n;
                assert (node.object().getStackKind() == JavaKind.Object);
                assert (node.value().getStackKind() == JavaKind.Object);
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                AnalysisType partitionType = (AnalysisType)node.partitionType();
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                assert (MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(objectType));
                AnalysisType componentType = MethodTypeFlowBuilder.this.bb.getObjectType();
                AnalysisType valueType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.value());
                assert (valueType == null || MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(valueType) || MethodTypeFlowBuilder.this.bb.getGraalNodeListType().isAssignableFrom(valueType));
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                TypeFlowBuilder<OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow> unsafeStoreBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow.class, () -> {
                    OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow((BytecodePosition)node.getNodeSourcePosition(), objectType, componentType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get(), node.partitionKind(), partitionType);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                    return storeTypeFlow;
                });
                unsafeStoreBuilder.addUseDependency(valueBuilder);
                unsafeStoreBuilder.addObserverDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(unsafeStoreBuilder);
            } else if (n instanceof RawLoadNode) {
                RawLoadNode node = (RawLoadNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetLoadTypeFlow> loadBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    NodeSourcePosition loadLocation = node.getNodeSourcePosition();
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                            OffsetLoadTypeFlow.LoadIndexedTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow((BytecodePosition)loadLocation, objectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                            return loadTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, () -> {
                            OffsetLoadTypeFlow.UnsafeLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafeLoadTypeFlow((BytecodePosition)loadLocation, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                            return loadTypeFlow;
                        });
                    }
                    loadBuilder.addObserverDependency(objectBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadBuilder);
                }
            } else if (n instanceof RawStoreNode) {
                RawStoreNode node = (RawStoreNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.value().getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                    NodeSourcePosition storeLocation = node.getNodeSourcePosition();
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((BytecodePosition)storeLocation, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow((BytecodePosition)storeLocation, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    }
                    storeBuilder.addUseDependency(valueBuilder);
                    storeBuilder.addObserverDependency(objectBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                }
            } else if (n instanceof UnsafeCompareAndSwapNode) {
                UnsafeCompareAndSwapNode node = (UnsafeCompareAndSwapNode)n;
                ValueNode object = node.object();
                ValueNode newValue = node.newValue();
                MethodTypeFlowBuilder.this.checkUnsafeOffset(object, node.offset());
                if (object.getStackKind() == JavaKind.Object && newValue.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)object);
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                    TypeFlowBuilder<?> newValueBuilder = ((TypeFlowsOfNodes)this.state).lookup(newValue);
                    NodeSourcePosition storeLocation = node.getNodeSourcePosition();
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((BytecodePosition)storeLocation, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow((BytecodePosition)storeLocation, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    }
                    storeBuilder.addUseDependency(newValueBuilder);
                    storeBuilder.addObserverDependency(objectBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                }
            } else if (n instanceof UnsafeCompareAndExchangeNode) {
                UnsafeCompareAndExchangeNode node = (UnsafeCompareAndExchangeNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.offset());
            } else if (n instanceof AtomicReadAndWriteNode) {
                AtomicReadAndWriteNode node = (AtomicReadAndWriteNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.offset());
            } else if (n instanceof BasicArrayCopyNode) {
                TypeFlowBuilder<?> dstBuilder;
                BasicArrayCopyNode node = (BasicArrayCopyNode)n;
                TypeFlowBuilder<?> srcBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getSource());
                if (srcBuilder != (dstBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getDestination()))) {
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node.asNode());
                    TypeFlowBuilder<ArrayCopyTypeFlow> arrayCopyBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ArrayCopyTypeFlow.class, () -> {
                        ArrayCopyTypeFlow arrayCopyFlow = new ArrayCopyTypeFlow((BytecodePosition)node.asNode().getNodeSourcePosition(), type, (TypeFlow<?>)srcBuilder.get(), (TypeFlow<?>)dstBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(arrayCopyFlow);
                        return arrayCopyFlow;
                    });
                    arrayCopyBuilder.addObserverDependency(srcBuilder);
                    arrayCopyBuilder.addObserverDependency(dstBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(arrayCopyBuilder);
                }
            } else if (n instanceof WordCastNode) {
                WordCastNode node = (WordCastNode)n;
                ValueNode input = node.getInput();
                if (input.getStackKind() != JavaKind.Object) {
                    TypeFlowBuilder<WordToObjectTypeFlow> wordToObjectBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, WordToObjectTypeFlow.class, () -> {
                        WordToObjectTypeFlow objectFlow = new WordToObjectTypeFlow((Node)node, MethodTypeFlowBuilder.this.bb.getAllInstantiatedTypeFlow());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(objectFlow);
                        return objectFlow;
                    });
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, wordToObjectBuilder);
                }
            } else if (n instanceof InvokeNode || n instanceof InvokeWithExceptionNode) {
                Invoke invoke = (Invoke)n;
                if (invoke.callTarget() instanceof MethodCallTargetNode) {
                    JVMCIError.guarantee((MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs() || invoke.stateAfter().outerFrameState() == null ? 1 : 0) != 0, (String)"Outer FrameState of %s must be null, but was %s. A non-null outer FrameState indicates that a method inlining has happened, but inlining should only happen after analysis.", (Object[])new Object[]{invoke.stateAfter(), invoke.stateAfter().outerFrameState()});
                    MethodCallTargetNode target = (MethodCallTargetNode)invoke.callTarget();
                    this.processMethodInvocation((ValueNode)invoke.asFixedNode(), target.invokeKind(), invoke.bci(), (PointsToAnalysisMethod)target.targetMethod(), (NodeInputList<ValueNode>)target.arguments());
                }
            } else if (n instanceof ObjectClone) {
                ObjectClone node = (ObjectClone)n;
                BytecodeLocation cloneLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, node.bci(), (AnalysisMethod)MethodTypeFlowBuilder.this.methodFlow.getMethod());
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getObject());
                AnalysisType inputType = Optional.ofNullable((AnalysisType)StampTool.typeOrNull((ValueNode)node.getObject())).orElseGet(MethodTypeFlowBuilder.this.bb::getObjectType);
                TypeFlowBuilder<CloneTypeFlow> cloneBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, CloneTypeFlow.class, () -> {
                    CloneTypeFlow cloneFlow = new CloneTypeFlow((BytecodePosition)node.asNode().getNodeSourcePosition(), inputType, cloneLabel, (TypeFlow<?>)inputBuilder.get());
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(cloneFlow);
                    return cloneFlow;
                });
                cloneBuilder.addObserverDependency(inputBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node.asFixedNode(), cloneBuilder);
            } else if (n instanceof MonitorEnterNode) {
                MonitorEnterNode node = (MonitorEnterNode)n;
                BytecodeLocation monitorLocation = BytecodeLocation.create(MethodTypeFlowBuilder.this.uniqueKey((Node)node), (AnalysisMethod)MethodTypeFlowBuilder.this.methodFlow.getMethod());
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<MonitorEnterTypeFlow> monitorEntryBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, MonitorEnterTypeFlow.class, () -> {
                    MonitorEnterTypeFlow monitorEntryFlow = new MonitorEnterTypeFlow(MethodTypeFlowBuilder.this.bb, node, monitorLocation, MethodTypeFlowBuilder.this.methodFlow.getMethod());
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(monitorEntryFlow);
                    return monitorEntryFlow;
                });
                monitorEntryBuilder.addUseDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(monitorEntryBuilder);
            } else if (n instanceof MacroInvokable) {
                MacroInvokable node = (MacroInvokable)n;
                this.processMethodInvocation((ValueNode)n, node.getInvokeKind(), node.bci(), (PointsToAnalysisMethod)node.getTargetMethod(), (NodeInputList<ValueNode>)node.getArguments());
            } else {
                MethodTypeFlowBuilder.this.delegateNodeProcessing(n, (TypeFlowsOfNodes)this.state);
            }
        }

        private void processMethodInvocation(ValueNode invoke, CallTargetNode.InvokeKind invokeKind, int bci, PointsToAnalysisMethod targetMethod, NodeInputList<ValueNode> arguments) {
            PointsToAnalysisMethod callerMethod = MethodTypeFlowBuilder.this.methodFlow.getMethod();
            MethodTypeFlowBuilder.this.bb.isCallAllowed(MethodTypeFlowBuilder.this.bb, callerMethod, targetMethod, invoke.getNodeSourcePosition());
            Object key = MethodTypeFlowBuilder.this.uniqueKey((Node)invoke);
            BytecodeLocation location = BytecodeLocation.create(key, (AnalysisMethod)MethodTypeFlowBuilder.this.methodFlow.getMethod());
            boolean targetIsStatic = Modifier.isStatic(targetMethod.getModifiers());
            TypeFlowBuilder[] actualParametersBuilders = new TypeFlowBuilder[arguments.size()];
            for (int i = 0; i < actualParametersBuilders.length; ++i) {
                TypeFlowBuilder<?> paramBuilder;
                ValueNode actualParam = (ValueNode)arguments.get(i);
                if (actualParam.getStackKind() != JavaKind.Object) continue;
                actualParametersBuilders[i] = paramBuilder = ((TypeFlowsOfNodes)this.state).lookup(actualParam);
                paramBuilder.markAsBuildingAnActualParameter();
                if (i == 0 && !targetIsStatic) {
                    paramBuilder.markAsBuildingAnActualReceiver();
                }
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
            }
            TypeFlowBuilder<InvokeTypeFlow> invokeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, invoke, InvokeTypeFlow.class, () -> {
                NodeSourcePosition invokeLocation;
                TypeFlow[] actualParameters = new TypeFlow[actualParametersBuilders.length];
                for (int i = 0; i < actualParameters.length; ++i) {
                    actualParameters[i] = actualParametersBuilders[i] != null ? actualParametersBuilders[i].get() : null;
                }
                ActualReturnTypeFlow actualReturn = null;
                AnalysisType receiverType = null;
                if (invokeKind.hasReceiver() && (receiverType = (AnalysisType)StampTool.typeOrNull((ValueNode)((ValueNode)arguments.get(0)))) == null) {
                    receiverType = targetMethod.getDeclaringClass();
                }
                if ((invokeLocation = invoke.getNodeSourcePosition()) == null) {
                    invokeLocation = new BytecodePosition(null, invoke.graph().method(), bci);
                }
                InvokeTypeFlow invokeFlow = null;
                switch (invokeKind) {
                    case Static: {
                        invokeFlow = new StaticInvokeTypeFlow((BytecodePosition)invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
                        break;
                    }
                    case Special: {
                        invokeFlow = MethodTypeFlowBuilder.this.bb.analysisPolicy().createSpecialInvokeTypeFlow((BytecodePosition)invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
                        break;
                    }
                    case Virtual: 
                    case Interface: {
                        invokeFlow = MethodTypeFlowBuilder.this.bb.analysisPolicy().createVirtualInvokeTypeFlow((BytecodePosition)invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
                        break;
                    }
                    default: {
                        throw JVMCIError.shouldNotReachHere();
                    }
                }
                MethodTypeFlowBuilder.this.methodFlow.addInvoke(key, invokeFlow);
                return invokeFlow;
            });
            if (invokeKind == CallTargetNode.InvokeKind.Special || invokeKind == CallTargetNode.InvokeKind.Virtual || invokeKind == CallTargetNode.InvokeKind.Interface) {
                invokeBuilder.addObserverDependency(actualParametersBuilders[0]);
            }
            if (invoke.asNode().getStackKind() == JavaKind.Object) {
                AnalysisType returnType = (AnalysisType)targetMethod.getSignature().getReturnType(null);
                TypeFlowBuilder<TypeFlow> actualReturnBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, invoke.asNode(), ActualReturnTypeFlow.class, () -> {
                    InvokeTypeFlow invokeFlow = (InvokeTypeFlow)invokeBuilder.get();
                    ActualReturnTypeFlow actualReturn = new ActualReturnTypeFlow((BytecodePosition)invokeFlow.source, returnType);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(actualReturn);
                    invokeFlow.setActualReturn(actualReturn);
                    actualReturn.setInvokeFlow(invokeFlow);
                    return actualReturn;
                });
                ObjectStamp stamp = (ObjectStamp)invoke.stamp(NodeView.DEFAULT);
                if (stamp.nonNull() && !returnType.equals(stamp.type()) && returnType.isAssignableFrom(stamp.type())) {
                    TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, invoke, FilterTypeFlow.class, () -> {
                        FilterTypeFlow filterFlow = new FilterTypeFlow(invoke, (AnalysisType)stamp.type(), stamp.isExactType(), true, true);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(filterFlow);
                        return filterFlow;
                    });
                    filterBuilder.addUseDependency(actualReturnBuilder);
                    actualReturnBuilder = filterBuilder;
                }
                if (MethodTypeFlowBuilder.this.bb.strengthenGraalGraphs()) {
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(actualReturnBuilder);
                }
                ((TypeFlowsOfNodes)this.state).add(invoke.asNode(), actualReturnBuilder);
            }
            MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(invokeBuilder);
        }

        private void modelUnsafeReadAndWriteFlow(ValueNode node, ValueNode object, ValueNode newValue, ValueNode offset) {
            assert (node instanceof UnsafeCompareAndExchangeNode || node instanceof AtomicReadAndWriteNode);
            MethodTypeFlowBuilder.this.checkUnsafeOffset(object, offset);
            if (object.getStackKind() == JavaKind.Object && newValue.getStackKind() == JavaKind.Object) {
                TypeFlowBuilder<OffsetLoadTypeFlow> loadBuilder;
                TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)object);
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                TypeFlowBuilder<?> newValueBuilder = ((TypeFlowsOfNodes)this.state).lookup(newValue);
                NodeSourcePosition location = node.getNodeSourcePosition();
                if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                    storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((BytecodePosition)location, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                        return storeTypeFlow;
                    });
                    loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.LoadIndexedTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow((BytecodePosition)location, objectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                        return loadTypeFlow;
                    });
                } else {
                    AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow((BytecodePosition)location, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                        return storeTypeFlow;
                    });
                    loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.UnsafeLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafeLoadTypeFlow((BytecodePosition)location, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                        return loadTypeFlow;
                    });
                }
                storeBuilder.addUseDependency(newValueBuilder);
                storeBuilder.addObserverDependency(objectBuilder);
                loadBuilder.addObserverDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                ((TypeFlowsOfNodes)this.state).add(node, loadBuilder);
            }
        }
    }

    protected class TypeFlowsOfNodes
    extends MergeableState<TypeFlowsOfNodes>
    implements Cloneable {
        private final Map<Node, TypeFlowBuilder<?>> flows;

        TypeFlowsOfNodes() {
            this.flows = new HashMap();
        }

        protected TypeFlowsOfNodes(TypeFlowsOfNodes copyFrom) {
            this.flows = new HashMap(copyFrom.flows);
        }

        public boolean contains(ValueNode node) {
            return this.flows.containsKey(GraphUtil.unproxify((ValueNode)node));
        }

        public TypeFlowBuilder<?> lookup(ValueNode n) {
            assert (n.stamp(NodeView.DEFAULT) instanceof ObjectStamp);
            ValueNode node = GraphUtil.unproxify((ValueNode)n);
            TypeFlowBuilder<Object> result = this.flows.get(node);
            if (result == null) {
                ObjectStamp stamp = (ObjectStamp)n.stamp(NodeView.DEFAULT);
                if (stamp.isEmpty()) {
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, SourceTypeFlow.class, () -> new SourceTypeFlow(node, TypeState.forEmpty()));
                } else if (stamp.isExactType()) {
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, SourceTypeFlow.class, () -> {
                        SourceTypeFlow src = new SourceTypeFlow(node, TypeState.forExactType(MethodTypeFlowBuilder.this.bb, (AnalysisType)stamp.type(), !stamp.nonNull()));
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(src);
                        return src;
                    });
                } else {
                    AnalysisType type = stamp.type() == null ? MethodTypeFlowBuilder.this.bb.getObjectType() : stamp.type();
                    result = type.isJavaLangObject() ? TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ProxyTypeFlow.class, () -> {
                        ProxyTypeFlow proxy = new ProxyTypeFlow((Node)node, MethodTypeFlowBuilder.this.bb.getAllInstantiatedTypeFlow());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(proxy);
                        return proxy;
                    }) : TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ProxyTypeFlow.class, () -> {
                        ProxyTypeFlow proxy = new ProxyTypeFlow((Node)node, type.getTypeFlow(MethodTypeFlowBuilder.this.bb, true));
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(proxy);
                        return proxy;
                    });
                }
                this.flows.put((Node)node, result);
            }
            return result;
        }

        public void add(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (!this.contains(node));
            this.flows.put((Node)GraphUtil.unproxify((ValueNode)node), flow);
        }

        public void update(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (this.contains(node));
            this.flows.put((Node)GraphUtil.unproxify((ValueNode)node), flow);
        }

        public boolean merge(AbstractMergeNode merge, List<TypeFlowsOfNodes> withStates) {
            for (AbstractEndNode end : merge.forwardEnds()) {
                if (MethodTypeFlowBuilder.this.processedNodes.contains((Node)end)) continue;
                return false;
            }
            Iterator<Map.Entry<Node, TypeFlowBuilder<?>>> iterator = this.flows.entrySet().iterator();
            block1: while (iterator.hasNext()) {
                Map.Entry<Node, TypeFlowBuilder<?>> entry = iterator.next();
                Node node = entry.getKey();
                TypeFlowBuilder<?> oldFlow = entry.getValue();
                TypeFlowBuilder<Object> newFlow = oldFlow;
                for (TypeFlowsOfNodes other : withStates) {
                    TypeFlowBuilder<?> mergeFlow = other.flows.get(node);
                    if (mergeFlow == null) {
                        iterator.remove();
                        continue block1;
                    }
                    if (mergeFlow == newFlow) continue;
                    if (newFlow == oldFlow) {
                        newFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, merge, MergeTypeFlow.class, () -> {
                            MergeTypeFlow newMergeFlow = new MergeTypeFlow((Node)merge);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newMergeFlow);
                            return newMergeFlow;
                        });
                        newFlow.addUseDependency(oldFlow);
                        entry.setValue(newFlow);
                    }
                    newFlow.addUseDependency(mergeFlow);
                }
            }
            return true;
        }

        public TypeFlowsOfNodes clone() {
            return new TypeFlowsOfNodes(this);
        }
    }
}

