/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.EnumClassEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.ForeignTypeEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.LoaderEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DebugInfoBase {
    protected ByteOrder byteOrder;
    private final StringTable stringTable = new StringTable();
    private final List<DirEntry> dirs = new ArrayList<DirEntry>();
    private final EconomicMap<Path, DirEntry> dirsIndex = EconomicMap.create();
    private final List<TypeEntry> types = new ArrayList<TypeEntry>();
    private final Map<ResolvedJavaType, TypeEntry> typesIndex = new HashMap<ResolvedJavaType, TypeEntry>();
    private final List<ClassEntry> instanceClasses = new ArrayList<ClassEntry>();
    private final EconomicMap<ResolvedJavaType, ClassEntry> instanceClassesIndex = EconomicMap.create();
    private HeaderTypeEntry headerType;
    private TypeEntry voidType;
    private ClassEntry objectClass;
    private final List<CompiledMethodEntry> compiledMethods = new ArrayList<CompiledMethodEntry>();
    private final List<FileEntry> files = new ArrayList<FileEntry>();
    private final EconomicMap<Path, FileEntry> filesIndex = EconomicMap.create();
    private final List<LoaderEntry> loaders = new ArrayList<LoaderEntry>();
    private final EconomicMap<String, LoaderEntry> loaderIndex = EconomicMap.create();
    private boolean useHeapBase;
    private int oopCompressShift;
    private int oopTagsCount;
    private int oopReferenceSize;
    private int pointerSize;
    private int oopAlignment;
    private int oopAlignShift;
    private String cachePath;
    private int compiledCodeMax;
    private ClassEntry hubClassEntry;
    static final Path EMPTY_PATH = Paths.get("", new String[0]);

    public DebugInfoBase(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.useHeapBase = true;
        this.oopTagsCount = 0;
        this.oopCompressShift = 0;
        this.oopReferenceSize = 0;
        this.pointerSize = 0;
        this.oopAlignment = 0;
        this.oopAlignShift = 0;
        this.hubClassEntry = null;
        this.compiledCodeMax = 0;
        this.ensureDirEntry(EMPTY_PATH);
    }

    public int compiledCodeMax() {
        return this.compiledCodeMax;
    }

    public void installDebugInfo(DebugInfoProvider debugInfoProvider) {
        this.useHeapBase = debugInfoProvider.useHeapBase();
        int oopTagsMask = debugInfoProvider.oopTagsMask();
        assert (oopTagsMask >= 0 && oopTagsMask < 32);
        assert ((oopTagsMask + 1 & oopTagsMask) == 0);
        this.oopTagsCount = Integer.bitCount(oopTagsMask);
        this.oopCompressShift = debugInfoProvider.oopCompressShift();
        assert (this.oopCompressShift == 0 || this.oopCompressShift == 3);
        this.oopReferenceSize = debugInfoProvider.oopReferenceSize();
        this.pointerSize = debugInfoProvider.pointerSize();
        this.oopAlignment = debugInfoProvider.oopAlignment();
        this.oopAlignShift = Integer.bitCount(this.oopAlignment - 1);
        assert (this.oopAlignment == 8);
        this.compiledCodeMax = debugInfoProvider.compiledCodeMax();
        String uniqueNullString = this.stringTable.uniqueDebugString("");
        this.cachePath = debugInfoProvider.getCachePath() != null ? this.stringTable.uniqueDebugString(debugInfoProvider.getCachePath().toString()) : uniqueNullString;
        debugInfoProvider.typeInfoProvider().forEach(debugTypeInfo -> debugTypeInfo.debugContext(debugContext -> {
            ResolvedJavaType idType = debugTypeInfo.idType();
            String typeName = debugTypeInfo.typeName();
            typeName = this.stringTable.uniqueDebugString(typeName);
            DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind = debugTypeInfo.typeKind();
            int byteSize = debugTypeInfo.size();
            debugContext.log(2, "Register %s type %s ", (Object)typeKind.toString(), (Object)typeName);
            String fileName = debugTypeInfo.fileName();
            Path filePath = debugTypeInfo.filePath();
            this.addTypeEntry(idType, typeName, fileName, filePath, byteSize, typeKind);
        }));
        debugInfoProvider.recordActivity();
        debugInfoProvider.typeInfoProvider().forEach(debugTypeInfo -> debugTypeInfo.debugContext(debugContext -> {
            ResolvedJavaType idType = debugTypeInfo.idType();
            String typeName = debugTypeInfo.typeName();
            DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind = debugTypeInfo.typeKind();
            debugContext.log(2, "Process %s type %s ", (Object)typeKind.toString(), (Object)typeName);
            TypeEntry typeEntry = idType != null ? this.lookupTypeEntry(idType) : this.lookupHeaderType();
            typeEntry.addDebugInfo(this, (DebugInfoProvider.DebugTypeInfo)debugTypeInfo, (DebugContext)debugContext);
        }));
        debugInfoProvider.recordActivity();
        debugInfoProvider.codeInfoProvider().forEach(debugCodeInfo -> debugCodeInfo.debugContext(debugContext -> {
            String fileName = debugCodeInfo.fileName();
            Path filePath = debugCodeInfo.filePath();
            ResolvedJavaType ownerType = debugCodeInfo.ownerType();
            String methodName = debugCodeInfo.name();
            int lo = debugCodeInfo.addressLo();
            int hi = debugCodeInfo.addressHi();
            int primaryLine = debugCodeInfo.line();
            ClassEntry classEntry = this.lookupClassEntry(ownerType);
            MethodEntry methodEntry = classEntry.ensureMethodEntryForDebugRangeInfo((DebugInfoProvider.DebugRangeInfo)debugCodeInfo, this, (DebugContext)debugContext);
            PrimaryRange primaryRange = Range.createPrimary(methodEntry, lo, hi, primaryLine);
            debugContext.log(2, "PrimaryRange %s.%s %s %s:%d [0x%x, 0x%x]", (Object)ownerType.toJavaName(), (Object)methodName, (Object)filePath, (Object)fileName, (Object)primaryLine, (Object)lo, (Object)hi);
            this.addPrimaryRange(primaryRange, (DebugInfoProvider.DebugCodeInfo)debugCodeInfo, classEntry);
            EconomicMap subRangeIndex = EconomicMap.create();
            debugCodeInfo.locationInfoProvider().forEach(debugLocationInfo -> this.addSubrange((DebugInfoProvider.DebugLocationInfo)debugLocationInfo, primaryRange, classEntry, (EconomicMap<DebugInfoProvider.DebugLocationInfo, SubRange>)subRangeIndex, (DebugContext)debugContext));
            debugInfoProvider.recordActivity();
        }));
        debugInfoProvider.dataInfoProvider().forEach(debugDataInfo -> debugDataInfo.debugContext(debugContext -> {
            if (debugContext.isLogEnabled(2)) {
                String provenance = debugDataInfo.getProvenance();
                String typeName = debugDataInfo.getTypeName();
                String partitionName = debugDataInfo.getPartition();
                long address = debugDataInfo.getAddress();
                long size = debugDataInfo.getSize();
                debugContext.log(2, "Data: address 0x%x size 0x%x type %s partition %s provenance %s ", (Object)address, (Object)size, (Object)typeName, (Object)partitionName, (Object)provenance);
            }
        }));
        this.getInstanceClasses().forEach(classEntry -> DebugInfoBase.collectFilesAndDirs(classEntry));
    }

    private TypeEntry createTypeEntry(String typeName, String fileName, Path filePath, int size, DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind) {
        TypeEntry typeEntry = null;
        switch (typeKind) {
            case INSTANCE: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath);
                typeEntry = new ClassEntry(typeName, fileEntry, size);
                if (!typeEntry.getTypeName().equals("java.lang.Class")) break;
                this.hubClassEntry = (ClassEntry)typeEntry;
                break;
            }
            case INTERFACE: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath);
                typeEntry = new InterfaceClassEntry(typeName, fileEntry, size);
                break;
            }
            case ENUM: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath);
                typeEntry = new EnumClassEntry(typeName, fileEntry, size);
                break;
            }
            case PRIMITIVE: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new PrimitiveTypeEntry(typeName, size);
                break;
            }
            case ARRAY: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new ArrayTypeEntry(typeName, size);
                break;
            }
            case HEADER: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new HeaderTypeEntry(typeName, size);
                break;
            }
            case FOREIGN: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath);
                typeEntry = new ForeignTypeEntry(typeName, fileEntry, size);
                break;
            }
        }
        return typeEntry;
    }

    private TypeEntry addTypeEntry(ResolvedJavaType idType, String typeName, String fileName, Path filePath, int size, DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind) {
        TypeEntry typeEntry;
        TypeEntry typeEntry2 = typeEntry = idType != null ? this.typesIndex.get(idType) : null;
        if (typeEntry == null) {
            typeEntry = this.createTypeEntry(typeName, fileName, filePath, size, typeKind);
            this.types.add(typeEntry);
            if (idType != null) {
                this.typesIndex.put(idType, typeEntry);
            }
            if (idType == null) {
                this.headerType = (HeaderTypeEntry)typeEntry;
            }
            if (typeName.equals("java.lang.Object")) {
                this.objectClass = (ClassEntry)typeEntry;
            }
            if (typeName.equals("void")) {
                this.voidType = typeEntry;
            }
            if (typeEntry instanceof ClassEntry) {
                this.indexInstanceClass(idType, (ClassEntry)typeEntry);
            }
        } else if (!typeEntry.isClass()) assert (((ClassEntry)typeEntry).getFileName().equals(fileName));
        return typeEntry;
    }

    public TypeEntry lookupTypeEntry(ResolvedJavaType type) {
        TypeEntry typeEntry = this.typesIndex.get(type);
        if (typeEntry == null) {
            throw new RuntimeException("Type entry not found " + type.getName());
        }
        return typeEntry;
    }

    ClassEntry lookupClassEntry(ResolvedJavaType type) {
        assert (type.isInstanceClass() || type.isInterface());
        ClassEntry classEntry = (ClassEntry)this.instanceClassesIndex.get((Object)type);
        if (classEntry == null || !classEntry.isClass()) {
            throw new RuntimeException("Class entry not found " + type.getName());
        }
        assert (this.typesIndex.get(type) != null);
        return classEntry;
    }

    public HeaderTypeEntry lookupHeaderType() {
        assert (this.headerType != null);
        return this.headerType;
    }

    public TypeEntry lookupVoidType() {
        assert (this.voidType != null);
        return this.voidType;
    }

    public ClassEntry lookupObjectClass() {
        assert (this.objectClass != null);
        return this.objectClass;
    }

    private void addPrimaryRange(PrimaryRange primaryRange, DebugInfoProvider.DebugCodeInfo debugCodeInfo, ClassEntry classEntry) {
        CompiledMethodEntry compiledMethod = classEntry.indexPrimary(primaryRange, debugCodeInfo.getFrameSizeChanges(), debugCodeInfo.getFrameSize());
        this.indexCompiledMethod(compiledMethod);
    }

    private Range addSubrange(DebugInfoProvider.DebugLocationInfo locationInfo, PrimaryRange primaryRange, ClassEntry classEntry, EconomicMap<DebugInfoProvider.DebugLocationInfo, SubRange> subRangeIndex, DebugContext debugContext) {
        PrimaryRange caller;
        boolean isTopLevel;
        DebugInfoProvider.DebugLocationInfo callerLocationInfo = locationInfo.getCaller();
        boolean bl = isTopLevel = callerLocationInfo == null;
        assert (!isTopLevel || locationInfo.name().equals(primaryRange.getMethodName()) && locationInfo.ownerType().toJavaName().equals(primaryRange.getClassName()));
        Range range = caller = isTopLevel ? primaryRange : (Range)subRangeIndex.get((Object)callerLocationInfo);
        assert (caller != null);
        String fileName = locationInfo.fileName();
        Path filePath = locationInfo.filePath();
        String fullPath = (String)(filePath == null ? "" : filePath.toString() + "/") + fileName;
        ResolvedJavaType ownerType = locationInfo.ownerType();
        String methodName = locationInfo.name();
        int loOff = locationInfo.addressLo();
        int hiOff = locationInfo.addressHi() - 1;
        int lo = primaryRange.getLo() + locationInfo.addressLo();
        int hi = primaryRange.getLo() + locationInfo.addressHi();
        int line = locationInfo.line();
        ClassEntry subRangeClassEntry = this.lookupClassEntry(ownerType);
        MethodEntry subRangeMethodEntry = subRangeClassEntry.ensureMethodEntryForDebugRangeInfo(locationInfo, this, debugContext);
        SubRange subRange = Range.createSubrange(subRangeMethodEntry, lo, hi, line, primaryRange, caller, locationInfo.isLeaf());
        classEntry.indexSubRange(subRange);
        subRangeIndex.put((Object)locationInfo, (Object)subRange);
        debugContext.log(4, "SubRange %s.%s %d %s:%d [0x%x, 0x%x] (%d, %d)", (Object)ownerType.toJavaName(), (Object)methodName, (Object)subRange.getDepth(), (Object)fullPath, (Object)line, (Object)lo, (Object)hi, (Object)loOff, (Object)hiOff);
        assert (callerLocationInfo == null || callerLocationInfo.addressLo() <= loOff && callerLocationInfo.addressHi() >= hiOff) : "parent range should enclose subrange!";
        DebugInfoProvider.DebugLocalValueInfo[] localValueInfos = locationInfo.getLocalValueInfo();
        for (int i = 0; i < localValueInfos.length; ++i) {
            DebugInfoProvider.DebugLocalValueInfo localValueInfo = localValueInfos[i];
            debugContext.log(4, "  locals[%d] %s:%s = %s", (Object)localValueInfo.slot(), (Object)localValueInfo.name(), (Object)localValueInfo.typeName(), (Object)localValueInfo);
        }
        subRange.setLocalValueInfo(localValueInfos);
        return subRange;
    }

    private void indexInstanceClass(ResolvedJavaType idType, ClassEntry classEntry) {
        this.instanceClasses.add(classEntry);
        this.instanceClassesIndex.put((Object)idType, (Object)classEntry);
    }

    private void indexCompiledMethod(CompiledMethodEntry compiledMethod) {
        assert (this.verifyMethodOrder(compiledMethod));
        this.compiledMethods.add(compiledMethod);
    }

    private boolean verifyMethodOrder(CompiledMethodEntry next) {
        int size = this.compiledMethods.size();
        if (size > 0) {
            CompiledMethodEntry last = this.compiledMethods.get(size - 1);
            PrimaryRange lastRange = last.getPrimary();
            PrimaryRange nextRange = next.getPrimary();
            if (lastRange.getHi() > nextRange.getLo()) {
                assert (false) : "methods %s [0x%x, 0x%x] and %s [0x%x, 0x%x] presented out of order".formatted(lastRange.getFullMethodName(), lastRange.getLo(), lastRange.getHi(), nextRange.getFullMethodName(), nextRange.getLo(), nextRange.getHi());
                return false;
            }
        }
        return true;
    }

    private FileEntry addFileEntry(String fileName, Path filePath) {
        Path fileAsPath;
        assert (fileName != null);
        Path dirPath = filePath;
        if (filePath != null) {
            fileAsPath = dirPath.resolve(fileName);
        } else {
            fileAsPath = Paths.get(fileName, new String[0]);
            dirPath = EMPTY_PATH;
        }
        FileEntry fileEntry = (FileEntry)this.filesIndex.get((Object)fileAsPath);
        if (fileEntry == null) {
            DirEntry dirEntry = this.ensureDirEntry(dirPath);
            this.uniqueDebugString(fileName);
            this.uniqueDebugString(this.cachePath);
            fileEntry = new FileEntry(fileName, dirEntry);
            this.files.add(fileEntry);
            this.filesIndex.put((Object)fileAsPath, (Object)fileEntry);
        } else assert (fileEntry.getDirEntry().getPath().equals(dirPath));
        return fileEntry;
    }

    protected FileEntry ensureFileEntry(DebugInfoProvider.DebugFileInfo debugFileInfo) {
        String fileName = debugFileInfo.fileName();
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        Path filePath = debugFileInfo.filePath();
        Path fileAsPath = filePath == null ? Paths.get(fileName, new String[0]) : filePath.resolve(fileName);
        FileEntry fileEntry = this.findFile(fileAsPath);
        if (fileEntry == null) {
            fileEntry = this.addFileEntry(fileName, filePath);
        }
        return fileEntry;
    }

    private DirEntry ensureDirEntry(Path filePath) {
        if (filePath == null) {
            return null;
        }
        DirEntry dirEntry = (DirEntry)this.dirsIndex.get((Object)filePath);
        if (dirEntry == null) {
            this.uniqueDebugString(filePath.toString());
            dirEntry = new DirEntry(filePath);
            this.dirsIndex.put((Object)filePath, (Object)dirEntry);
            this.dirs.add(dirEntry);
        }
        return dirEntry;
    }

    protected LoaderEntry ensureLoaderEntry(String loaderId) {
        LoaderEntry loaderEntry = (LoaderEntry)this.loaderIndex.get((Object)loaderId);
        if (loaderEntry == null) {
            loaderEntry = new LoaderEntry(this.uniqueDebugString(loaderId));
            this.loaderIndex.put((Object)loaderEntry.getLoaderId(), (Object)loaderEntry);
        }
        return loaderEntry;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public List<TypeEntry> getTypes() {
        return this.types;
    }

    public List<ClassEntry> getInstanceClasses() {
        return this.instanceClasses;
    }

    public List<CompiledMethodEntry> getCompiledMethods() {
        return this.compiledMethods;
    }

    public List<FileEntry> getFiles() {
        return this.files;
    }

    public List<DirEntry> getDirs() {
        return this.dirs;
    }

    public FileEntry findFile(Path fullFileName) {
        return (FileEntry)this.filesIndex.get((Object)fullFileName);
    }

    public List<LoaderEntry> getLoaders() {
        return this.loaders;
    }

    public LoaderEntry findLoader(String id) {
        return (LoaderEntry)this.loaderIndex.get((Object)id);
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public String uniqueDebugString(String string) {
        return this.stringTable.uniqueDebugString(string);
    }

    public int debugStringIndex(String string) {
        return this.stringTable.debugStringIndex(string);
    }

    public boolean useHeapBase() {
        return this.useHeapBase;
    }

    public byte oopTagsMask() {
        return (byte)((1 << this.oopTagsCount) - 1);
    }

    public byte oopTagsShift() {
        return (byte)this.oopTagsCount;
    }

    public int oopCompressShift() {
        return this.oopCompressShift;
    }

    public int oopReferenceSize() {
        return this.oopReferenceSize;
    }

    public int pointerSize() {
        return this.pointerSize;
    }

    public int oopAlignment() {
        return this.oopAlignment;
    }

    public int oopAlignShift() {
        return this.oopAlignShift;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public boolean isHubClassEntry(ClassEntry classEntry) {
        return classEntry.getTypeName().equals("java.lang.Class");
    }

    public ClassEntry getHubClassEntry() {
        return this.hubClassEntry;
    }

    private static void collectFilesAndDirs(ClassEntry classEntry) {
        EconomicSet visitedFiles = EconomicSet.create();
        EconomicSet visitedDirs = EconomicSet.create();
        DebugInfoBase.includeOnce(classEntry, classEntry.getFileEntry(), (EconomicSet<FileEntry>)visitedFiles, (EconomicSet<DirEntry>)visitedDirs);
        for (FieldEntry fieldEntry : classEntry.fields) {
            DebugInfoBase.includeOnce(classEntry, fieldEntry.getFileEntry(), (EconomicSet<FileEntry>)visitedFiles, (EconomicSet<DirEntry>)visitedDirs);
        }
        for (MethodEntry methodEntry : classEntry.getMethods()) {
            DebugInfoBase.includeOnce(classEntry, methodEntry.getFileEntry(), (EconomicSet<FileEntry>)visitedFiles, (EconomicSet<DirEntry>)visitedDirs);
        }
        classEntry.compiledEntries().forEachOrdered(compiledMethodEntry -> {
            DebugInfoBase.includeOnce(classEntry, compiledMethodEntry.getPrimary().getFileEntry(), (EconomicSet<FileEntry>)visitedFiles, (EconomicSet<DirEntry>)visitedDirs);
            compiledMethodEntry.leafRangeIterator().forEachRemaining(subRange -> DebugInfoBase.includeOnce(classEntry, subRange.getFileEntry(), (EconomicSet<FileEntry>)visitedFiles, (EconomicSet<DirEntry>)visitedDirs));
            compiledMethodEntry.topDownRangeIterator().forEachRemaining(subRange -> {
                if (!subRange.isLeaf()) {
                    DebugInfoBase.includeOnce(classEntry, subRange.getFileEntry(), (EconomicSet<FileEntry>)visitedFiles, (EconomicSet<DirEntry>)visitedDirs);
                }
            });
        });
        classEntry.buildFileAndDirIndexes();
    }

    private static void includeOnce(ClassEntry classEntry, FileEntry fileEntry, EconomicSet<FileEntry> visitedFiles, EconomicSet<DirEntry> visitedDirs) {
        if (fileEntry != null && !visitedFiles.contains((Object)fileEntry)) {
            visitedFiles.add((Object)fileEntry);
            classEntry.includeFile(fileEntry);
            DirEntry dirEntry = fileEntry.getDirEntry();
            if (dirEntry != null && !dirEntry.getPathString().isEmpty() && !visitedDirs.contains((Object)dirEntry)) {
                visitedDirs.add((Object)dirEntry);
                classEntry.includeDir(dirEntry);
            }
        }
    }
}

