/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfARangesSectionImpl
extends DwarfSectionImpl {
    private static final int DW_AR_HEADER_SIZE = 12;
    private static final int DW_AR_HEADER_PAD_SIZE = 4;
    private static final String TARGET_SECTION_NAME = ".debug_frame";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfARangesSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_aranges";
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this);
        this.instanceClassStream().filter(ClassEntry::hasCompiledEntries).forEach(classEntry -> cursor.add(DwarfARangesSectionImpl.normalEntrySize(classEntry)));
        this.instanceClassStream().filter(ClassEntry::hasDeoptCompiledEntries).forEach(classEntry -> cursor.add(DwarfARangesSectionImpl.deoptEntrySize(classEntry)));
        byte[] buffer = new byte[cursor.get()];
        super.setContent(buffer);
    }

    private static int normalEntrySize(ClassEntry classEntry) {
        assert (classEntry.hasCompiledEntries());
        return DwarfARangesSectionImpl.entrySize(classEntry.normalCompiledEntries());
    }

    private static int deoptEntrySize(ClassEntry classEntry) {
        assert (classEntry.hasDeoptCompiledEntries());
        return DwarfARangesSectionImpl.entrySize(classEntry.deoptCompiledEntries());
    }

    private static int entrySize(Stream<CompiledMethodEntry> compiledEntries) {
        int size = 0;
        size += 12;
        size += 4;
        size = (int)((long)size + compiledEntries.count() * 16L);
        return size += 16;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(".text");
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        int cuIndex;
        int lengthPos;
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        List classEntries = this.instanceClassStream().filter(ClassEntry::hasCompiledEntries).collect(Collectors.toList());
        classEntries.sort(this::sortByLowPC);
        this.log(context, "  [0x%08x] DEBUG_ARANGES", pos);
        for (ClassEntry classEntry : classEntries) {
            lengthPos = pos;
            cuIndex = this.getCUIndex(classEntry);
            this.log(context, "  [0x%08x] %s CU %d ", pos, classEntry.getFileName(), cuIndex);
            pos = this.writeHeader(cuIndex, buffer, pos);
            pos = this.writeARanges(context, classEntry.normalCompiledEntries(), buffer, pos);
            pos = this.writeLong(0L, buffer, pos);
            pos = this.writeLong(0L, buffer, pos);
            this.patchLength(lengthPos, buffer, pos);
        }
        classEntries = this.instanceClassStream().filter(ClassEntry::hasDeoptCompiledEntries).collect(Collectors.toList());
        classEntries.sort(this::sortByLowPCDeopt);
        for (ClassEntry classEntry : classEntries) {
            lengthPos = pos;
            cuIndex = this.getDeoptCUIndex(classEntry);
            this.log(context, "  [0x%08x] %s CU (deopt) %d ", pos, classEntry.getFileName(), cuIndex);
            pos = this.writeHeader(cuIndex, buffer, pos);
            pos = this.writeARanges(context, classEntry.deoptCompiledEntries(), buffer, pos);
            pos = this.writeLong(0L, buffer, pos);
            pos = this.writeLong(0L, buffer, pos);
            this.patchLength(lengthPos, buffer, pos);
        }
        assert (pos == size);
    }

    private int writeHeader(int cuIndex, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeShort((short)2, buffer, pos);
        pos = this.writeInfoSectionOffset(cuIndex, buffer, pos);
        pos = this.writeByte((byte)8, buffer, pos);
        pos = this.writeByte((byte)0, buffer, pos);
        assert (pos - p == 12);
        for (int i = 0; i < 4; ++i) {
            pos = this.writeByte((byte)0, buffer, pos);
        }
        return pos;
    }

    int writeARanges(DebugContext context, Stream<CompiledMethodEntry> compiledEntries, byte[] buffer, int p) {
        return compiledEntries.reduce(p, (p1, compiledEntry) -> {
            int pos = p1;
            Range primary = compiledEntry.getPrimary();
            this.log(context, "  [0x%08x] %016x %016x %s", pos, this.debugTextBase + (long)primary.getLo(), primary.getHi() - primary.getLo(), primary.getFullMethodNameWithParams());
            pos = this.writeRelocatableCodeOffset(primary.getLo(), buffer, pos);
            pos = this.writeLong(primary.getHi() - primary.getLo(), buffer, pos);
            return pos;
        }, (oldpos, newpos) -> newpos);
    }

    private int sortByLowPC(ClassEntry classEntry1, ClassEntry classEntry2) {
        return classEntry1.lowpc() - classEntry2.lowpc();
    }

    private int sortByLowPCDeopt(ClassEntry classEntry1, ClassEntry classEntry2) {
        return classEntry1.lowpcDeopt() - classEntry2.lowpcDeopt();
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

