/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public class ClassEntry
extends StructureTypeEntry {
    protected ClassEntry superClass;
    protected List<InterfaceClassEntry> interfaces = new ArrayList<InterfaceClassEntry>();
    private FileEntry fileEntry;
    protected List<MethodEntry> methods;
    private Map<ResolvedJavaMethod, MethodEntry> methodsIndex;
    private List<CompiledMethodEntry> normalCompiledEntries;
    private List<CompiledMethodEntry> deoptCompiledEntries;
    private Map<Range, CompiledMethodEntry> compiledMethodIndex;
    private Map<FileEntry, Integer> localFilesIndex;
    private List<FileEntry> localFiles;
    private HashMap<DirEntry, Integer> localDirsIndex;
    private List<DirEntry> localDirs;

    public ClassEntry(String className, FileEntry fileEntry, int size) {
        super(className, size);
        this.fileEntry = fileEntry;
        this.methods = new ArrayList<MethodEntry>();
        this.methodsIndex = new HashMap<ResolvedJavaMethod, MethodEntry>();
        this.normalCompiledEntries = new ArrayList<CompiledMethodEntry>();
        this.deoptCompiledEntries = null;
        this.compiledMethodIndex = new HashMap<Range, CompiledMethodEntry>();
        this.localFiles = new ArrayList<FileEntry>();
        this.localFilesIndex = new HashMap<FileEntry, Integer>();
        this.localDirs = new ArrayList<DirEntry>();
        this.localDirsIndex = new HashMap();
        if (fileEntry != null) {
            this.localFiles.add(fileEntry);
            this.localFilesIndex.put(fileEntry, this.localFiles.size());
            DirEntry dirEntry = fileEntry.getDirEntry();
            if (dirEntry != null) {
                this.localDirs.add(dirEntry);
                this.localDirsIndex.put(dirEntry, this.localDirs.size());
            }
        }
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INSTANCE;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        assert (debugTypeInfo.typeName().equals(this.typeName));
        DebugInfoProvider.DebugInstanceTypeInfo debugInstanceTypeInfo = (DebugInfoProvider.DebugInstanceTypeInfo)debugTypeInfo;
        ResolvedJavaType superType = debugInstanceTypeInfo.superClass();
        String superName = superType != null ? superType.toJavaName() : "";
        debugContext.log("typename %s adding super %s\n", (Object)this.typeName, (Object)superName);
        if (superType != null) {
            this.superClass = debugInfoBase.lookupClassEntry(superType);
        }
        debugInstanceTypeInfo.interfaces().forEach(interfaceType -> this.processInterface((ResolvedJavaType)interfaceType, debugInfoBase, debugContext));
        debugInstanceTypeInfo.fieldInfoProvider().forEach(debugFieldInfo -> this.processField((DebugInfoProvider.DebugFieldInfo)debugFieldInfo, debugInfoBase, debugContext));
        debugInstanceTypeInfo.methodInfoProvider().forEach(debugMethodInfo -> this.processMethod((DebugInfoProvider.DebugMethodInfo)debugMethodInfo, debugInfoBase, debugContext));
    }

    public void indexPrimary(Range primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize) {
        if (this.compiledMethodIndex.get(primary) == null) {
            CompiledMethodEntry compiledEntry = new CompiledMethodEntry(primary, frameSizeInfos, frameSize, this);
            this.compiledMethodIndex.put(primary, compiledEntry);
            if (primary.isDeoptTarget()) {
                if (this.deoptCompiledEntries == null) {
                    this.deoptCompiledEntries = new ArrayList<CompiledMethodEntry>();
                }
                this.deoptCompiledEntries.add(compiledEntry);
            } else {
                this.normalCompiledEntries.add(compiledEntry);
                assert (this.deoptCompiledEntries == null);
            }
            FileEntry primaryFileEntry = primary.getFileEntry();
            if (primaryFileEntry != null) {
                this.indexLocalFileEntry(primaryFileEntry);
            }
        }
    }

    public void indexSubRange(Range subrange) {
        Range primary = subrange.getPrimary();
        assert (primary != null);
        CompiledMethodEntry compiledEntry = this.compiledMethodIndex.get(primary);
        assert (compiledEntry != null);
        assert (compiledEntry.getClassEntry() == this);
        FileEntry subFileEntry = subrange.getFileEntry();
        if (subFileEntry != null) {
            this.indexLocalFileEntry(subFileEntry);
        }
    }

    private void indexMethodEntry(MethodEntry methodEntry, ResolvedJavaMethod idMethod) {
        assert (this.methodsIndex.get(idMethod) == null) : methodEntry.getSymbolName();
        this.methods.add(methodEntry);
        this.methodsIndex.put(idMethod, methodEntry);
    }

    private void indexLocalFileEntry(FileEntry localFileEntry) {
        if (this.localFilesIndex.get(localFileEntry) == null) {
            this.localFiles.add(localFileEntry);
            this.localFilesIndex.put(localFileEntry, this.localFiles.size());
            DirEntry dirEntry = localFileEntry.getDirEntry();
            if (dirEntry != null && this.localDirsIndex.get(dirEntry) == null) {
                this.localDirs.add(dirEntry);
                this.localDirsIndex.put(dirEntry, this.localDirs.size());
            }
        }
    }

    public int localDirsIdx(DirEntry dirEntry) {
        if (dirEntry != null) {
            return this.localDirsIndex.get(dirEntry);
        }
        return 0;
    }

    public int localFilesIdx() {
        return this.localFilesIndex.get(this.fileEntry);
    }

    public int localFilesIdx(FileEntry fileEntry) {
        return this.localFilesIndex.get(fileEntry);
    }

    public String getFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFileName();
        }
        return "";
    }

    String getFullFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFullName();
        }
        return null;
    }

    String getDirName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getPathName();
        }
        return "";
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public Stream<CompiledMethodEntry> compiledEntries() {
        Stream<CompiledMethodEntry> stream = this.normalCompiledEntries.stream();
        if (this.deoptCompiledEntries != null) {
            stream = Stream.concat(stream, this.deoptCompiledEntries.stream());
        }
        return stream;
    }

    public Stream<CompiledMethodEntry> normalCompiledEntries() {
        return this.normalCompiledEntries.stream();
    }

    public Stream<CompiledMethodEntry> deoptCompiledEntries() {
        if (this.hasDeoptCompiledEntries()) {
            return this.deoptCompiledEntries.stream();
        }
        return Stream.empty();
    }

    public List<DirEntry> getLocalDirs() {
        return this.localDirs;
    }

    public List<FileEntry> getLocalFiles() {
        return this.localFiles;
    }

    public boolean hasDeoptCompiledEntries() {
        return this.deoptCompiledEntries != null;
    }

    public String getCachePath() {
        Path cachePath;
        if (this.fileEntry != null && (cachePath = this.fileEntry.getCachePath()) != null) {
            return cachePath.toString();
        }
        return "";
    }

    private void processInterface(ResolvedJavaType interfaceType, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        String interfaceName = interfaceType.toJavaName();
        debugContext.log("typename %s adding interface %s\n", (Object)this.typeName, (Object)interfaceName);
        ClassEntry entry = debugInfoBase.lookupClassEntry(interfaceType);
        assert (entry instanceof InterfaceClassEntry);
        InterfaceClassEntry interfaceClassEntry = (InterfaceClassEntry)entry;
        this.interfaces.add(interfaceClassEntry);
        interfaceClassEntry.addImplementor(this, debugContext);
    }

    protected MethodEntry processMethod(DebugInfoProvider.DebugMethodInfo debugMethodInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        String methodName = debugMethodInfo.name();
        int line = debugMethodInfo.line();
        ResolvedJavaType resultType = debugMethodInfo.valueType();
        String resultTypeName = resultType.toJavaName();
        int modifiers = debugMethodInfo.modifiers();
        DebugInfoProvider.DebugLocalInfo[] paramInfos = debugMethodInfo.getParamInfo();
        DebugInfoProvider.DebugLocalInfo thisParam = debugMethodInfo.getThisParamInfo();
        int paramCount = paramInfos.length;
        debugContext.log("typename %s adding %s method %s %s(%s)\n", (Object)this.typeName, (Object)this.memberModifiers(modifiers), (Object)resultTypeName, (Object)methodName, (Object)ClassEntry.formatParams(paramInfos));
        TypeEntry resultTypeEntry = debugInfoBase.lookupTypeEntry(resultType);
        TypeEntry[] typeEntries = new TypeEntry[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            typeEntries[i] = debugInfoBase.lookupTypeEntry(paramInfos[i].valueType());
        }
        FileEntry methodFileEntry = debugInfoBase.ensureFileEntry(debugMethodInfo);
        MethodEntry methodEntry = new MethodEntry(debugInfoBase, debugMethodInfo, methodFileEntry, line, methodName, this, resultTypeEntry, typeEntries, paramInfos, thisParam);
        this.indexMethodEntry(methodEntry, debugMethodInfo.idMethod());
        return methodEntry;
    }

    @Override
    protected FieldEntry addField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        FieldEntry fieldEntry = super.addField(debugFieldInfo, debugInfoBase, debugContext);
        FileEntry fieldFileEntry = fieldEntry.getFileEntry();
        if (fieldFileEntry != null) {
            this.indexLocalFileEntry(fieldFileEntry);
        }
        return fieldEntry;
    }

    private static String formatParams(DebugInfoProvider.DebugLocalInfo[] paramInfo) {
        if (paramInfo.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < paramInfo.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(paramInfo[i].typeName());
            builder.append(' ');
            builder.append(paramInfo[i].name());
        }
        return builder.toString();
    }

    public boolean hasCompiledEntries() {
        return this.normalCompiledEntries.size() != 0;
    }

    public ClassEntry getSuperClass() {
        return this.superClass;
    }

    public MethodEntry ensureMethodEntryForDebugRangeInfo(DebugInfoProvider.DebugRangeInfo debugRangeInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        MethodEntry methodEntry = this.methodsIndex.get(debugRangeInfo.idMethod());
        if (methodEntry == null) {
            methodEntry = this.processMethod(debugRangeInfo, debugInfoBase, debugContext);
        } else {
            methodEntry.updateRangeInfo(debugInfoBase, debugRangeInfo);
            FileEntry methodFileEntry = methodEntry.fileEntry;
            if (methodFileEntry != null) {
                this.indexLocalFileEntry(methodFileEntry);
            }
        }
        return methodEntry;
    }

    public List<MethodEntry> getMethods() {
        return this.methods;
    }

    public int lowpc() {
        assert (this.hasCompiledEntries());
        return this.normalCompiledEntries.get(0).getPrimary().getLo();
    }

    public int lowpcDeopt() {
        assert (this.hasCompiledEntries());
        assert (this.hasDeoptCompiledEntries());
        return this.deoptCompiledEntries.get(0).getPrimary().getLo();
    }

    public int hipc() {
        assert (this.hasCompiledEntries());
        return this.normalCompiledEntries.get(this.normalCompiledEntries.size() - 1).getPrimary().getHi();
    }

    public int hipcDeopt() {
        assert (this.hasCompiledEntries());
        assert (this.hasDeoptCompiledEntries());
        return this.deoptCompiledEntries.get(this.deoptCompiledEntries.size() - 1).getPrimary().getHi();
    }
}

