/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public class ArrayTypeEntry
extends StructureTypeEntry {
    private TypeEntry elementType;
    private int baseSize;
    private int lengthOffset;

    public ArrayTypeEntry(String typeName, int size) {
        super(typeName, size);
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ARRAY;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        DebugInfoProvider.DebugArrayTypeInfo debugArrayTypeInfo = (DebugInfoProvider.DebugArrayTypeInfo)debugTypeInfo;
        ResolvedJavaType eltType = debugArrayTypeInfo.elementType();
        this.elementType = debugInfoBase.lookupTypeEntry(eltType);
        this.baseSize = debugArrayTypeInfo.baseSize();
        this.lengthOffset = debugArrayTypeInfo.lengthOffset();
        debugArrayTypeInfo.fieldInfoProvider().forEach(debugFieldInfo -> this.processField((DebugInfoProvider.DebugFieldInfo)debugFieldInfo, debugInfoBase, debugContext));
        debugContext.log("typename %s element type %s base size %d length offset %d\n", (Object)this.typeName, (Object)this.elementType.getTypeName(), (Object)this.baseSize, (Object)this.lengthOffset);
    }

    public TypeEntry getElementType() {
        return this.elementType;
    }
}

