/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVLineRecord;
import com.oracle.objectfile.pecoff.cv.CVLineRecordBuilder;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubrecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubsection;
import com.oracle.objectfile.pecoff.cv.CVTypeRecord;

final class CVSymbolSubsectionBuilder {
    private final CVDebugInfo cvDebugInfo;
    private final CVSymbolSubsection cvSymbolSubsection;
    private final CVLineRecordBuilder lineRecordBuilder;
    private boolean noMainFound = true;

    CVSymbolSubsectionBuilder(CVDebugInfo cvDebugInfo) {
        this.cvDebugInfo = cvDebugInfo;
        this.cvSymbolSubsection = new CVSymbolSubsection(cvDebugInfo);
        this.lineRecordBuilder = new CVLineRecordBuilder(cvDebugInfo);
    }

    void build() {
        for (ClassEntry classEntry : this.cvDebugInfo.getPrimaryClasses()) {
            this.build(classEntry);
        }
        this.cvDebugInfo.getCVSymbolSection().addRecord(this.cvSymbolSubsection);
    }

    private void build(ClassEntry classEntry) {
        for (PrimaryEntry primaryEntry : classEntry.getPrimaryEntries()) {
            this.build(primaryEntry);
        }
    }

    private void build(PrimaryEntry primaryEntry) {
        Range primaryRange = primaryEntry.getPrimary();
        String debuggerName = this.getDebuggerName(primaryRange);
        String externalName = primaryRange.getSymbolName();
        int functionTypeIndex = this.addTypeRecords(primaryEntry);
        byte funcFlags = 0;
        CVSymbolSubrecord.CVSymbolGProc32Record proc32 = new CVSymbolSubrecord.CVSymbolGProc32Record(this.cvDebugInfo, externalName, debuggerName, 0, 0, 0, primaryRange.getHi() - primaryRange.getLo(), 0, 0, functionTypeIndex, primaryRange.getLo(), 0, funcFlags);
        this.addToSymbolSubsection(proc32);
        int asynceh = 512;
        int localBP = 16384;
        int paramBP = 65536;
        int frameFlags = asynceh + localBP + paramBP;
        this.addToSymbolSubsection(new CVSymbolSubrecord.CVSymbolFrameProcRecord(this.cvDebugInfo, primaryEntry.getFrameSize(), frameFlags));
        this.addToSymbolSubsection(new CVSymbolSubrecord.CVSymbolEndRecord(this.cvDebugInfo));
        this.addLineNumberRecords(primaryEntry);
    }

    private String getDebuggerName(Range range) {
        String methodName;
        if (this.noMainFound && range.getMethodName().equals("main")) {
            this.noMainFound = false;
            methodName = range.getFullMethodName();
        } else {
            methodName = range.getSymbolName();
        }
        return methodName;
    }

    private void addLineNumberRecords(PrimaryEntry primaryEntry) {
        CVLineRecord record = this.lineRecordBuilder.build(primaryEntry);
        if (!record.isEmpty()) {
            this.cvDebugInfo.getCVSymbolSection().addRecord(record);
        }
    }

    private void addToSymbolSubsection(CVSymbolSubrecord record) {
        this.cvSymbolSubsection.addRecord(record);
    }

    private int addTypeRecords(PrimaryEntry entry) {
        CVTypeRecord.CVTypeArglistRecord argListType = this.addTypeRecord(new CVTypeRecord.CVTypeArglistRecord().add(0));
        CVTypeRecord.CVTypeProcedureRecord funcType = this.addTypeRecord(new CVTypeRecord.CVTypeProcedureRecord().returnType(3).argList(argListType));
        return funcType.getSequenceNumber();
    }

    private <T extends CVTypeRecord> T addTypeRecord(T record) {
        return this.cvDebugInfo.getCVTypeSection().addOrReference(record);
    }
}

