/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVLineRecord;
import java.util.Iterator;

public class CVLineRecordBuilder {
    private final CVDebugInfo cvDebugInfo;
    private CVLineRecord lineRecord;
    private PrimaryEntry primaryEntry;

    CVLineRecordBuilder(CVDebugInfo cvDebugInfo) {
        this.cvDebugInfo = cvDebugInfo;
    }

    public void debug(String format, Object ... args) {
        this.cvDebugInfo.getCVSymbolSection().verboseLog(format, args);
    }

    CVLineRecord build(PrimaryEntry entry) {
        this.primaryEntry = entry;
        Range primaryRange = this.primaryEntry.getPrimary();
        this.debug("DEBUG_S_LINES linerecord for 0x%05x file: %s:%d", primaryRange.getLo(), primaryRange.getFileName(), primaryRange.getLine());
        this.lineRecord = new CVLineRecord(this.cvDebugInfo, primaryRange.getSymbolName());
        this.debug("CVLineRecord.computeContents: processing primary range %s", primaryRange);
        this.processRange(primaryRange);
        Iterator<Range> iterator = this.primaryEntry.leafRangeIterator();
        while (iterator.hasNext()) {
            Range subRange = iterator.next();
            this.debug("CVLineRecord.computeContents: processing range %s", subRange);
            this.processRange(subRange);
        }
        return this.lineRecord;
    }

    private void processRange(Range range) {
        FileEntry file = range.getFileEntry();
        if (file == null) {
            this.debug("  processRange: range has no file: %s", range);
            return;
        }
        if (range.getLine() < 0) {
            this.debug("  processRange: ignoring: bad line number: %d", range.getLine());
            return;
        }
        int fileId = this.cvDebugInfo.getCVSymbolSection().getFileTableRecord().addFile(file);
        if (this.lineRecord.isEmpty() || this.lineRecord.getCurrentFileId() != fileId) {
            this.debug("  processRange: addNewFile: %s", file);
            this.lineRecord.addNewFile(fileId);
        }
        int lineLoAddr = range.getLo() - this.primaryEntry.getPrimary().getLo();
        int line = Math.max(range.getLine(), 1);
        this.debug("  processRange:   addNewLine: 0x%05x-0x%05x %s", lineLoAddr, range.getHi() - this.primaryEntry.getPrimary().getLo(), line);
        this.lineRecord.addNewLine(lineLoAddr, line);
    }
}

