/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffByteBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

final class PECoffSectionStruct {
    private final ByteBuffer section = PECoffByteBuffer.allocate(PECoff.IMAGE_SECTION_HEADER.totalsize);
    private final int sectionIndex;
    private final int align;

    PECoffSectionStruct(String sectName, int sectFlags0, int sectAlign, int sectIndex) {
        int max;
        byte[] sectionName = sectName.getBytes(StandardCharsets.UTF_8);
        int n = max = sectionName.length <= PECoff.IMAGE_SECTION_HEADER.Name.sz ? sectionName.length : PECoff.IMAGE_SECTION_HEADER.Name.sz;
        assert (sectAlign >= 1 && sectAlign <= 1024 && (sectAlign & sectAlign - 1) == 0) : "section alignment is not valid: " + sectAlign;
        this.align = sectAlign;
        int sectAlignBits = 32 - Integer.numberOfLeadingZeros(this.align) << 20;
        int sectFlags = sectFlags0 & 0xFF0FFFFF | sectAlignBits & 0xF00000;
        this.section.put(sectionName, PECoff.IMAGE_SECTION_HEADER.Name.off, max);
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.VirtualSize.off, 0);
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.VirtualAddress.off, 0);
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.PointerToLinenumbers.off, 0);
        this.section.putChar(PECoff.IMAGE_SECTION_HEADER.NumberOfLinenumbers.off, '\u0000');
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.Characteristics.off, sectFlags);
        this.sectionIndex = sectIndex;
    }

    int getSize() {
        return this.section.getInt(PECoff.IMAGE_SECTION_HEADER.SizeOfRawData.off);
    }

    int getDataAlign() {
        return this.align;
    }

    static int getShdrAlign() {
        return 4;
    }

    byte[] getArray() {
        return this.section.array();
    }

    void setOffset(int offset) {
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.PointerToRawData.off, offset);
    }

    void setSize(int size) {
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.SizeOfRawData.off, size);
    }

    void setVirtualAddress(int addr) {
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.VirtualAddress.off, addr);
    }

    int getOffset() {
        return this.section.getInt(PECoff.IMAGE_SECTION_HEADER.PointerToRawData.off);
    }

    void setReloff(int offset) {
        this.section.putInt(PECoff.IMAGE_SECTION_HEADER.PointerToRelocations.off, offset);
    }

    void setRelcount(int count) {
        if (count > 65535) {
            this.section.putChar(PECoff.IMAGE_SECTION_HEADER.NumberOfRelocations.off, '\uffff');
            int flags = this.section.getInt(PECoff.IMAGE_SECTION_HEADER.Characteristics.off);
            this.section.putInt(PECoff.IMAGE_SECTION_HEADER.Characteristics.off, flags |= 0x1000000);
        } else {
            this.section.putChar(PECoff.IMAGE_SECTION_HEADER.NumberOfRelocations.off, (char)count);
        }
    }

    int getSectionId() {
        return this.sectionIndex;
    }
}

