/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfInfoSectionImpl
extends DwarfSectionImpl {
    public static final String OBJECT_HEADER_STRUCT_NAME = "_objhdr";
    private static final int DW_DIE_HEADER_SIZE = 11;
    protected static final String TARGET_SECTION_NAME = ".debug_loc";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfInfoSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_info";
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        byte[] buffer = null;
        int len = this.generateContent(null, buffer);
        buffer = new byte[len];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_INFO", pos);
        this.log(context, "  [0x%08x] size = 0x%08x", pos, size);
        pos = this.generateContent(context, buffer);
        assert (pos == size);
    }

    byte computeEncoding(int flags, int bitCount) {
        assert (bitCount > 0);
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                if ((flags & 4) != 0) {
                    switch (bitCount) {
                        case 8: {
                            return 6;
                        }
                    }
                    assert (bitCount == 16 || bitCount == 32 || bitCount == 64);
                    return 5;
                }
                assert (bitCount == 16);
                return 7;
            }
            assert (bitCount == 32 || bitCount == 64);
            return 4;
        }
        assert (bitCount == 1);
        return 2;
    }

    public int generateContent(DebugContext context, byte[] buffer) {
        int pos = 0;
        pos = this.writeBuiltInUnit(context, buffer, pos);
        pos = this.writeNonPrimaryClasses(context, buffer, pos);
        pos = this.writePrimaryClasses(context, buffer, pos);
        pos = this.writeArrayTypes(context, buffer, pos);
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            if (!classEntry.includesDeoptTarget()) continue;
            this.setDeoptCUIndex(classEntry, pos);
            int lengthPos = pos;
            pos = this.writeCUHeader(buffer, pos);
            this.log(context, "  [0x%08x] Compilation Unit (deopt targets)", pos);
            assert (pos == lengthPos + 11);
            pos = this.writeDeoptMethodsCU(context, classEntry, buffer, pos);
            this.patchLength(lengthPos, buffer, pos);
        }
        return pos;
    }

    public int writeBuiltInUnit(DebugContext context, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] <0> builtin unit", pos);
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        int abbrevCode = 1;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrData1((byte)11, buffer, pos);
        pos = this.getTypes().filter(TypeEntry::isPrimitive).reduce(pos, (pos1, typeEntry) -> {
            PrimitiveTypeEntry primitiveTypeEntry = (PrimitiveTypeEntry)typeEntry;
            if (primitiveTypeEntry.getBitCount() > 0) {
                return this.writePrimitiveType(context, primitiveTypeEntry, buffer, (int)pos1);
            }
            return this.writeVoidType(context, primitiveTypeEntry, buffer, (int)pos1);
        }, (oldpos, newpos) -> newpos);
        pos = this.getTypes().filter(TypeEntry::isHeader).reduce(pos, (pos1, typeEntry) -> {
            HeaderTypeEntry headerTypeEntry = (HeaderTypeEntry)typeEntry;
            return this.writeHeaderType(context, headerTypeEntry, buffer, (int)pos1);
        }, (oldpos, newpos) -> newpos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    public int writePrimitiveType(DebugContext context, PrimitiveTypeEntry primitiveTypeEntry, byte[] buffer, int p) {
        assert (primitiveTypeEntry.getBitCount() > 0);
        int pos = p;
        this.log(context, "  [0x%08x] primitive type %s", pos, primitiveTypeEntry.getTypeName());
        this.setTypeIndex(primitiveTypeEntry, pos);
        this.setIndirectTypeIndex(primitiveTypeEntry, pos);
        int abbrevCode = 6;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        byte byteSize = (byte)primitiveTypeEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)primitiveTypeEntry.getBitCount();
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        byte encoding = this.computeEncoding(primitiveTypeEntry.getFlags(), bitCount);
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding);
        pos = this.writeAttrData1(encoding, buffer, pos);
        String name = primitiveTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeAttrStrp(name, buffer, pos);
    }

    public int writeVoidType(DebugContext context, PrimitiveTypeEntry primitiveTypeEntry, byte[] buffer, int p) {
        assert (primitiveTypeEntry.getBitCount() == 0);
        int pos = p;
        this.log(context, "  [0x%08x] primitive type void", pos);
        this.setTypeIndex(primitiveTypeEntry, pos);
        this.setIndirectTypeIndex(primitiveTypeEntry, pos);
        int abbrevCode = 7;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = primitiveTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeAttrStrp(name, buffer, pos);
    }

    public int writeHeaderType(DebugContext context, HeaderTypeEntry headerTypeEntry, byte[] buffer, int p) {
        int pos = p;
        String name = headerTypeEntry.getTypeName();
        byte size = (byte)headerTypeEntry.getSize();
        this.log(context, "  [0x%08x] header type %s", pos, name);
        this.setTypeIndex(headerTypeEntry, pos);
        this.setIndirectTypeIndex(headerTypeEntry, pos);
        int abbrevCode = 8;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        pos = this.writeAttrData1(size, buffer, pos);
        pos = this.writeHeaderFields(context, headerTypeEntry, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeHeaderFields(DebugContext context, HeaderTypeEntry headerTypeEntry, byte[] buffer, int p) {
        return headerTypeEntry.fields().reduce(p, (pos, fieldEntry) -> this.writeHeaderField(context, (FieldEntry)fieldEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private int writeHeaderField(DebugContext context, FieldEntry fieldEntry, byte[] buffer, int p) {
        int pos = p;
        String fieldName = fieldEntry.fieldName();
        TypeEntry valueType = fieldEntry.getValueType();
        String valueTypeName = valueType.getTypeName();
        int valueTypeIdx = this.getIndirectTypeIndex(valueTypeName);
        this.log(context, "  [0x%08x] header field", pos);
        int abbrevCode = 27;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fieldName), fieldName);
        pos = this.writeAttrStrp(fieldName, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, valueTypeIdx, valueTypeName);
        pos = this.writeAttrRefAddr(valueTypeIdx, buffer, pos);
        byte offset = (byte)fieldEntry.getOffset();
        int size = fieldEntry.getSize();
        this.log(context, "  [0x%08x]     offset 0x%x (size 0x%x)", pos, offset, size);
        pos = this.writeAttrData1(offset, buffer, pos);
        int modifiers = fieldEntry.getModifiers();
        this.log(context, "  [0x%08x]     modifiers %s", pos, fieldEntry.getModifiersString());
        return this.writeAttrAccessibility(modifiers, buffer, pos);
    }

    private int writeNonPrimaryClasses(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] non primary classes", pos);
        return this.getTypes().filter(TypeEntry::isClass).reduce(pos, (p, typeEntry) -> {
            ClassEntry classEntry = (ClassEntry)typeEntry;
            return classEntry.isPrimary() ? p.intValue() : this.writeNonPrimaryClassUnit(context, classEntry, buffer, (int)p);
        }, (oldpos, newpos) -> newpos);
    }

    private int writeNonPrimaryClassUnit(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.setCUIndex(classEntry, pos);
        int lengthPos = pos;
        this.log(context, "  [0x%08x] non primary class unit %s", pos, classEntry.getTypeName());
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        int abbrevCode = 4;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrData1((byte)11, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(classEntry.getFileName()), classEntry.getFileName());
        pos = this.writeAttrStrp(classEntry.getFileName(), buffer, pos);
        String compilationDirectory = classEntry.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeAttrStrp(compilationDirectory, buffer, pos);
        if (classEntry.isInterface()) {
            InterfaceClassEntry interfaceClassEntry = (InterfaceClassEntry)classEntry;
            pos = this.writeInterfaceLayout(context, interfaceClassEntry, buffer, pos);
            pos = this.writeInterfaceType(context, interfaceClassEntry, buffer, pos);
        } else {
            pos = this.writeClassLayout(context, classEntry, buffer, pos);
            pos = this.writeClassType(context, classEntry, buffer, pos);
        }
        pos = this.writeAbstractInlineMethods(context, classEntry, buffer, pos);
        pos = this.writeStaticFieldLocations(context, classEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writePrimaryClasses(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] primary classes", pos);
        return this.getTypes().filter(TypeEntry::isClass).reduce(pos, (p, typeEntry) -> {
            ClassEntry classEntry = (ClassEntry)typeEntry;
            return classEntry.isPrimary() ? this.writePrimaryClassUnit(context, classEntry, buffer, (int)p) : p.intValue();
        }, (oldpos, newpos) -> newpos);
    }

    private int writePrimaryClassUnit(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        int lineIndex = this.getLineIndex(classEntry);
        String fileName = classEntry.getFileName();
        List<PrimaryEntry> classPrimaryEntries = classEntry.getPrimaryEntries();
        int lo = DwarfInfoSectionImpl.findLo(classPrimaryEntries, false);
        int hi = DwarfInfoSectionImpl.findHi(classPrimaryEntries, classEntry.includesDeoptTarget(), false);
        assert (hi > 0);
        int abbrevCode = fileName.length() > 0 ? 2 : 3;
        this.setCUIndex(classEntry, pos);
        int lengthPos = pos;
        this.log(context, "  [0x%08x] primary class unit %s", pos, classEntry.getTypeName());
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrData1((byte)11, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fileName), fileName);
        pos = this.writeAttrStrp(fileName, buffer, pos);
        String compilationDirectory = classEntry.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeAttrStrp(compilationDirectory, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, lo);
        pos = this.writeAttrAddress(lo, buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, hi);
        pos = this.writeAttrAddress(hi, buffer, pos);
        if (abbrevCode == 2) {
            this.log(context, "  [0x%08x]     stmt_list  0x%08x", pos, lineIndex);
            pos = this.writeAttrSecOffset(lineIndex, buffer, pos);
        }
        if (classEntry.isInterface()) {
            InterfaceClassEntry interfaceClassEntry = (InterfaceClassEntry)classEntry;
            pos = this.writeInterfaceLayout(context, interfaceClassEntry, buffer, pos);
            pos = this.writeInterfaceType(context, interfaceClassEntry, buffer, pos);
        } else {
            pos = this.writeClassLayout(context, classEntry, buffer, pos);
            pos = this.writeClassType(context, classEntry, buffer, pos);
        }
        pos = this.writeMethodLocations(context, classEntry, false, buffer, pos);
        pos = this.writeAbstractInlineMethods(context, classEntry, buffer, pos);
        pos = this.writeStaticFieldLocations(context, classEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeClassLayout(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int superTypeOffset;
        String superName;
        ClassEntry superClassEntry;
        int pos;
        int layoutIndex = pos = p;
        this.setLayoutIndex(classEntry, layoutIndex);
        this.log(context, "  [0x%08x] class layout", pos);
        int abbrevCode = 9;
        if (!this.dwarfSections.useHeapBase() && this.dwarfSections.isHubClassEntry(classEntry)) {
            abbrevCode = 10;
        }
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = classEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        int size = classEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData2((short)size, buffer, pos);
        int fileIdx = classEntry.localFilesIdx();
        this.log(context, "  [0x%08x]     file  0x%x (%s)", pos, fileIdx, classEntry.getFileName());
        pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        if (abbrevCode == 10) {
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeIndirectOopConversionExpression(true, buffer, pos);
        }
        if ((superClassEntry = classEntry.getSuperClass()) != null) {
            superName = superClassEntry.getTypeName();
            superTypeOffset = this.getLayoutIndex(superClassEntry);
        } else {
            superName = OBJECT_HEADER_STRUCT_NAME;
            superTypeOffset = this.getTypeIndex(superName);
        }
        pos = this.writeSuperReference(context, superTypeOffset, superName, buffer, pos);
        pos = this.writeFields(context, classEntry, buffer, pos);
        pos = this.writeMethodDeclarations(context, classEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectLayoutIndex(classEntry, pos);
            this.log(context, "  [0x%08x] indirect class layout", pos);
            abbrevCode = 19;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            String indirectName = this.uniqueDebugString("_z_." + classEntry.getTypeName());
            this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(indirectName), name);
            pos = this.writeAttrStrp(indirectName, buffer, pos);
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
            pos = this.writeAttrData2((short)size, buffer, pos);
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeIndirectOopConversionExpression(this.dwarfSections.isHubClassEntry(classEntry), buffer, pos);
            superTypeOffset = layoutIndex;
            pos = this.writeSuperReference(context, superTypeOffset, superName, buffer, pos);
            pos = this.writeAttrNull(buffer, pos);
        }
        return pos;
    }

    private int writeSuperReference(DebugContext context, int superTypeOffset, String superName, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] super reference", pos);
        int abbrevCode = 29;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, superTypeOffset, superName);
        pos = this.writeAttrRefAddr(superTypeOffset, buffer, pos);
        this.log(context, "  [0x%08x]     data_member_location (super) 0x%x", pos, 0);
        pos = this.writeAttrData1((byte)0, buffer, pos);
        this.log(context, "  [0x%08x]     modifiers public", pos);
        int modifiers = 1;
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        return pos;
    }

    private int writeFields(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        return classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedField).reduce(p, (pos, fieldEntry) -> this.writeField(context, classEntry, (FieldEntry)fieldEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private static boolean isManifestedField(FieldEntry fieldEntry) {
        return fieldEntry.getOffset() >= 0;
    }

    private int writeField(DebugContext context, StructureTypeEntry entry, FieldEntry fieldEntry, byte[] buffer, int p) {
        int abbrevCode;
        int pos = p;
        int modifiers = fieldEntry.getModifiers();
        boolean hasFile = fieldEntry.getFileName().length() > 0;
        this.log(context, "  [0x%08x] field definition", pos);
        boolean isStatic = Modifier.isStatic(modifiers);
        if (!isStatic) {
            abbrevCode = !hasFile ? 23 : 24;
        } else {
            abbrevCode = !hasFile ? 25 : 26;
            this.setFieldDeclarationIndex(entry, fieldEntry.fieldName(), pos);
        }
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = fieldEntry.fieldName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        if (hasFile) {
            assert (entry instanceof ClassEntry);
            int fileIdx = ((ClassEntry)entry).localFilesIdx(fieldEntry.getFileEntry());
            assert (fileIdx > 0);
            this.log(context, "  [0x%08x]     filename  0x%x (%s)", pos, fileIdx, fieldEntry.getFileName());
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        }
        String valueTypeName = fieldEntry.getValueType().getTypeName();
        int typeIdx = this.getIndirectTypeIndex(valueTypeName);
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, typeIdx, valueTypeName);
        pos = this.writeAttrRefAddr(typeIdx, buffer, pos);
        if (!isStatic) {
            int memberOffset = fieldEntry.getOffset();
            this.log(context, "  [0x%08x]     member offset 0x%x", pos, memberOffset);
            pos = this.writeAttrData2((short)memberOffset, buffer, pos);
        }
        this.log(context, "  [0x%08x]     accessibility %s", pos, fieldEntry.getModifiersString());
        pos = this.writeAttrAccessibility(fieldEntry.getModifiers(), buffer, pos);
        if (isStatic) {
            this.log(context, "  [0x%08x]     external(true)", pos);
            pos = this.writeFlag((byte)1, buffer, pos);
            this.log(context, "  [0x%08x]     definition(true)", pos);
            pos = this.writeFlag((byte)1, buffer, pos);
        }
        return pos;
    }

    private int writeMethodDeclarations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        for (MethodEntry method : classEntry.getMethods()) {
            if (!method.isInRange() && !method.isInlined()) continue;
            pos = this.writeMethodDeclaration(context, classEntry, method, buffer, pos);
        }
        return pos;
    }

    private int writeMethodDeclaration(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        String methodKey = method.getSymbolName();
        this.setMethodDeclarationIndex(classEntry, methodKey, pos);
        int modifiers = method.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        this.log(context, "  [0x%08x] method declaration %s", pos, methodKey);
        int abbrevCode = isStatic ? 22 : 21;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        String name = this.uniqueDebugString(method.methodName());
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        FileEntry fileEntry = method.getFileEntry();
        if (fileEntry == null) {
            fileEntry = classEntry.getFileEntry();
        }
        assert (fileEntry != null);
        int fileIdx = classEntry.localFilesIdx(fileEntry);
        this.log(context, "  [0x%08x]     file 0x%x (%s)", pos, fileIdx, fileEntry.getFullName());
        pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        String returnTypeName = method.getValueType().getTypeName();
        int retTypeIdx = this.getTypeIndex(returnTypeName);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, retTypeIdx, returnTypeName);
        pos = this.writeAttrRefAddr(retTypeIdx, buffer, pos);
        this.log(context, "  [0x%08x]     artificial %s", pos, method.isDeopt() ? "true" : "false");
        pos = this.writeFlag(method.isDeopt() ? (byte)1 : 0, buffer, pos);
        this.log(context, "  [0x%08x]     accessibility %s", pos, "public");
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        int typeIdx = this.getLayoutIndex(classEntry);
        this.log(context, "  [0x%08x]     containing_type 0x%x (%s)", pos, typeIdx, classEntry.getTypeName());
        pos = this.writeAttrRefAddr(typeIdx, buffer, pos);
        if (abbrevCode == 21) {
            int objectPointerIndex = pos;
            pos = this.writeAttrRefAddr(0, buffer, pos);
            this.log(context, "  [0x%08x]     object_pointer 0x%x", objectPointerIndex, pos);
            this.writeAttrRefAddr(pos, buffer, objectPointerIndex);
        }
        pos = this.writeMethodParameterDeclarations(context, method, fileIdx, 3, buffer, pos);
        pos = this.writeMethodLocalDeclarations(context, method, fileIdx, 3, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodParameterDeclarations(DebugContext context, MethodEntry method, int fileIdx, int level, byte[] buffer, int p) {
        int refAddr;
        int pos = p;
        if (!Modifier.isStatic(method.getModifiers())) {
            refAddr = pos;
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getThisParam();
            this.setMethodLocalIndex(method, paramInfo, refAddr);
            pos = this.writeMethodParameterDeclaration(context, paramInfo, fileIdx, true, level, buffer, pos);
        }
        for (int i = 0; i < method.getParamCount(); ++i) {
            refAddr = pos;
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getParam(i);
            this.setMethodLocalIndex(method, paramInfo, refAddr);
            pos = this.writeMethodParameterDeclaration(context, paramInfo, fileIdx, false, level, buffer, pos);
        }
        return pos;
    }

    private int writeMethodParameterDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, int fileIdx, boolean artificial, int level, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method parameter declaration", pos);
        String paramName = paramInfo.name();
        String paramTypeName = paramInfo.typeName();
        int line = paramInfo.line();
        int abbrevCode = artificial ? 33 : (line >= 0 ? 34 : 35);
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, level, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name %s", pos, paramName);
        pos = this.writeAttrStrp(this.uniqueDebugString(paramName), buffer, pos);
        if (abbrevCode == 34) {
            this.log(context, "  [0x%08x]     file 0x%x", pos, fileIdx);
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
            this.log(context, "  [0x%08x]     line 0x%x", pos, line);
            pos = this.writeAttrData2((short)line, buffer, pos);
        }
        int typeIdx = this.getTypeIndex(paramTypeName);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeIdx, paramTypeName);
        pos = this.writeAttrRefAddr(typeIdx, buffer, pos);
        if (abbrevCode == 33) {
            this.log(context, "  [0x%08x]     artificial true", pos);
            pos = this.writeFlag((byte)1, buffer, pos);
        }
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        return pos;
    }

    private int writeMethodLocalDeclarations(DebugContext context, MethodEntry method, int fileIdx, int level, byte[] buffer, int p) {
        int pos = p;
        for (int i = 0; i < method.getLocalCount(); ++i) {
            int refAddr = pos;
            DebugInfoProvider.DebugLocalInfo localInfo = method.getLocal(i);
            this.setMethodLocalIndex(method, localInfo, refAddr);
            pos = this.writeMethodLocalDeclaration(context, localInfo, fileIdx, level, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, int fileIdx, int level, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method local declaration", pos);
        String paramName = paramInfo.name();
        String paramTypeName = paramInfo.typeName();
        int line = paramInfo.line();
        int abbrevCode = line >= 0 ? 36 : 37;
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, level, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name %s", pos, paramName);
        pos = this.writeAttrStrp(this.uniqueDebugString(paramName), buffer, pos);
        if (abbrevCode == 36) {
            this.log(context, "  [0x%08x]     file 0x%x", pos, fileIdx);
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
            this.log(context, "  [0x%08x]     line 0x%x", pos, line);
            pos = this.writeAttrData2((short)line, buffer, pos);
        }
        int typeIdx = this.getTypeIndex(paramTypeName);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeIdx, paramTypeName);
        pos = this.writeAttrRefAddr(typeIdx, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        return pos;
    }

    private int writeInterfaceLayout(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        int pos;
        int layoutOffset = pos = p;
        this.setLayoutIndex(interfaceClassEntry, layoutOffset);
        this.log(context, "  [0x%08x] interface layout", pos);
        int abbrevCode = 17;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = interfaceClassEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        pos = this.writeInterfaceImplementors(context, interfaceClassEntry, buffer, pos);
        pos = this.writeMethodDeclarations(context, interfaceClassEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectLayoutIndex(interfaceClassEntry, pos);
            this.log(context, "  [0x%08x] indirect class layout", pos);
            abbrevCode = 19;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            String indirectName = this.uniqueDebugString("_z_." + interfaceClassEntry.getTypeName());
            this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(indirectName), name);
            pos = this.writeAttrStrp(indirectName, buffer, pos);
            int size = interfaceClassEntry.getSize();
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
            pos = this.writeAttrData2((short)size, buffer, pos);
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeIndirectOopConversionExpression(false, buffer, pos);
            pos = this.writeSuperReference(context, layoutOffset, name, buffer, pos);
            pos = this.writeAttrNull(buffer, pos);
        }
        return pos;
    }

    private int writeInterfaceImplementors(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        return interfaceClassEntry.implementors().reduce(p, (pos, classEntry) -> this.writeInterfaceImplementor(context, (ClassEntry)classEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private int writeInterfaceImplementor(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] interface implementor", pos);
        int abbrevCode = 30;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString("_" + classEntry.getTypeName());
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        int layoutOffset = this.getLayoutIndex(classEntry);
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, layoutOffset, classEntry.getTypeName());
        pos = this.writeAttrRefAddr(layoutOffset, buffer, pos);
        int modifiers = 1;
        this.log(context, "  [0x%08x]     modifiers %s", pos, "public");
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        return pos;
    }

    private int writeClassType(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos;
        int typeIdx = pos = p;
        this.setTypeIndex(classEntry, typeIdx);
        this.log(context, "  [0x%08x] class pointer type", pos);
        int abbrevCode = 11;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        int layoutOffset = this.getLayoutIndex(classEntry);
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
        pos = this.writeAttrRefAddr(layoutOffset, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectTypeIndex(classEntry, pos);
            this.log(context, "  [0x%08x] class indirect pointer type", pos);
            abbrevCode = 20;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            int oopReferenceSize = this.dwarfSections.oopReferenceSize();
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, oopReferenceSize);
            pos = this.writeAttrData1((byte)oopReferenceSize, buffer, pos);
            layoutOffset = this.getIndirectLayoutIndex(classEntry);
            this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
            pos = this.writeAttrRefAddr(layoutOffset, buffer, pos);
        } else {
            this.setIndirectTypeIndex(classEntry, typeIdx);
        }
        return pos;
    }

    private int writeInterfaceType(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        int pos;
        int typeIdx = pos = p;
        this.setTypeIndex(interfaceClassEntry, typeIdx);
        this.log(context, "  [0x%08x] interface pointer type", pos);
        int abbrevCode = 18;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        int layoutOffset = this.getLayoutIndex(interfaceClassEntry);
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
        pos = this.writeAttrRefAddr(layoutOffset, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectTypeIndex(interfaceClassEntry, pos);
            this.log(context, "  [0x%08x] interface indirect pointer type", pos);
            abbrevCode = 20;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            int byteSize = this.dwarfSections.oopReferenceSize();
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, byteSize);
            pos = this.writeAttrData1((byte)byteSize, buffer, pos);
            layoutOffset = this.getIndirectLayoutIndex(interfaceClassEntry);
            this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
            pos = this.writeAttrRefAddr(layoutOffset, buffer, pos);
        } else {
            this.setIndirectTypeIndex(interfaceClassEntry, typeIdx);
        }
        return pos;
    }

    private int writeMethodLocations(DebugContext context, ClassEntry classEntry, boolean deoptTargets, byte[] buffer, int p) {
        int pos = p;
        List<PrimaryEntry> classPrimaryEntries = classEntry.getPrimaryEntries();
        assert (classEntry.localFilesIdx(classEntry.getFileEntry()) == 1);
        for (PrimaryEntry primaryEntry : classPrimaryEntries) {
            Range primary = primaryEntry.getPrimary();
            if (primary.isDeoptTarget() != deoptTargets) continue;
            pos = this.writeMethodLocation(context, classEntry, primaryEntry, buffer, pos);
        }
        return pos;
    }

    private int writeAbstractInlineMethods(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        for (MethodEntry method : classEntry.getMethods()) {
            if (!method.isInlined()) continue;
            String methodKey = method.getSymbolName();
            this.setAbstractInlineMethodIndex(classEntry, methodKey, pos);
            pos = this.writeAbstractInlineMethod(context, classEntry, method, buffer, pos);
        }
        return pos;
    }

    private int generateConcreteInlinedMethods(DebugContext context, PrimaryEntry primaryEntry, byte[] buffer, int p) {
        Range primary = primaryEntry.getPrimary();
        if (primary.isLeaf()) {
            return p;
        }
        int pos = p;
        this.log(context, "  [0x%08x] concrete entries [0x%x,0x%x] %s", pos, primary.getLo(), primary.getHi(), primary.getFullMethodName());
        int depth = 0;
        Iterator<Range> iterator = primaryEntry.topDownRangeIterator();
        while (iterator.hasNext()) {
            Range subrange = iterator.next();
            if (subrange.isLeaf()) continue;
            while (depth > subrange.getDepth()) {
                pos = this.writeAttrNull(buffer, pos);
                --depth;
            }
            depth = subrange.getDepth();
            pos = this.writeInlineSubroutine(context, subrange, depth + 2, buffer, pos);
            HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap = subrange.getVarRangeMap();
            pos = this.writeMethodParameterLocations(context, varRangeMap, subrange, ++depth + 2, buffer, pos);
            pos = this.writeMethodLocalLocations(context, varRangeMap, subrange, depth + 2, buffer, pos);
        }
        while (depth > 0) {
            pos = this.writeAttrNull(buffer, pos);
            --depth;
        }
        return pos;
    }

    private int writeStaticFieldLocations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        return classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedStaticField).reduce(p, (pos, fieldEntry) -> this.writeStaticFieldLocation(context, classEntry, (FieldEntry)fieldEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private static boolean isManifestedStaticField(FieldEntry fieldEntry) {
        return Modifier.isStatic(fieldEntry.getModifiers()) && fieldEntry.getOffset() >= 0;
    }

    private int writeStaticFieldLocation(DebugContext context, ClassEntry classEntry, FieldEntry fieldEntry, byte[] buffer, int p) {
        int pos = p;
        String fieldName = fieldEntry.fieldName();
        int fieldDefinitionOffset = this.getFieldDeclarationIndex(classEntry, fieldName);
        this.log(context, "  [0x%08x] static field location %s.%s", pos, classEntry.getTypeName(), fieldName);
        int abbrevCode = 14;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, fieldDefinitionOffset);
        pos = this.writeAttrRefAddr(fieldDefinitionOffset, buffer, pos);
        int offset = fieldEntry.getOffset();
        this.log(context, "  [0x%08x]     location  heapbase + 0x%x (%s)", pos, offset, fieldEntry.getValueType().isPrimitive() ? "primitive" : "object");
        pos = this.writeHeapLocationExprLoc(offset, buffer, pos);
        return pos;
    }

    private int writeArrayTypes(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] array classes", pos);
        return this.getTypes().filter(TypeEntry::isArray).reduce(pos, (p, typeEntry) -> {
            ArrayTypeEntry arrayTypeEntry = (ArrayTypeEntry)typeEntry;
            return this.writeArrayTypeUnit(context, arrayTypeEntry, buffer, (int)p);
        }, (oldpos, newpos) -> newpos);
    }

    private int writeArrayTypeUnit(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] array class unit %s", pos, arrayTypeEntry.getTypeName());
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        int abbrevCode = 5;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DwarfDebugInfo.DW_LANG_Java");
        pos = this.writeAttrData1((byte)11, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        TypeEntry elementType = arrayTypeEntry.getElementType();
        int size = arrayTypeEntry.getSize();
        int layoutIdx = pos;
        int indirectLayoutIdx = pos = this.writeArrayLayout(context, arrayTypeEntry, elementType, size, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            pos = this.writeIndirectArrayLayout(context, arrayTypeEntry, size, layoutIdx, buffer, pos);
        }
        pos = this.writeArrayTypes(context, arrayTypeEntry, layoutIdx, indirectLayoutIdx, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeArrayLayout(DebugContext context, ArrayTypeEntry arrayTypeEntry, TypeEntry elementType, int size, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array layout", pos);
        int abbrevCode = 15;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeAttrStrp(name, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        int arrayDataTypeIdx = pos = this.writeAttrData2((short)size, buffer, pos);
        pos = this.writeArrayDataType(context, elementType, buffer, pos);
        pos = this.writeFields(context, arrayTypeEntry, buffer, pos);
        pos = this.writeArrayElementField(context, size, arrayDataTypeIdx, buffer, pos);
        pos = this.writeArraySuperReference(context, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeFields(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        return arrayTypeEntry.fields().filter(DwarfInfoSectionImpl::isManifestedField).reduce(p, (pos, fieldEntry) -> this.writeField(context, arrayTypeEntry, (FieldEntry)fieldEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private int writeIndirectArrayLayout(DebugContext context, ArrayTypeEntry arrayTypeEntry, int size, int layoutOffset, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] indirect class layout", pos);
        int abbrevCode = 19;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        String indirectName = this.uniqueDebugString("_z_." + name);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(indirectName), name);
        pos = this.writeAttrStrp(indirectName, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData2((short)size, buffer, pos);
        this.log(context, "  [0x%08x]     data_location", pos);
        pos = this.writeIndirectOopConversionExpression(false, buffer, pos);
        pos = this.writeSuperReference(context, layoutOffset, name, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeArrayDataType(DebugContext context, TypeEntry elementType, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array element data type", pos);
        int abbrevCode = 28;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int size = elementType.isPrimitive() ? elementType.getSize() : 8;
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData1((byte)size, buffer, pos);
        String elementTypeName = elementType.getTypeName();
        int elementTypeIdx = this.getIndirectTypeIndex(elementTypeName);
        this.log(context, "  [0x%08x]     type idx 0x%x (%s)", pos, elementTypeIdx, elementTypeName);
        pos = this.writeAttrRefAddr(elementTypeIdx, buffer, pos);
        return pos;
    }

    private int writeArrayElementField(DebugContext context, int offset, int arrayDataTypeIdx, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array element data field", pos);
        int abbrevCode = 27;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String fieldName = this.uniqueDebugString("data");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fieldName), fieldName);
        pos = this.writeAttrStrp(fieldName, buffer, pos);
        this.log(context, "  [0x%08x]     type idx 0x%x", pos, arrayDataTypeIdx);
        pos = this.writeAttrRefAddr(arrayDataTypeIdx, buffer, pos);
        int size = 0;
        this.log(context, "  [0x%08x]     offset 0x%x (size 0x%x)", pos, offset, size);
        pos = this.writeAttrData1((byte)offset, buffer, pos);
        int modifiers = 1;
        this.log(context, "  [0x%08x]     modifiers %s", pos, "public");
        return this.writeAttrAccessibility(modifiers, buffer, pos);
    }

    private int writeArraySuperReference(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        String superName = "java.lang.Object";
        TypeEntry objectType = this.lookupType(superName);
        assert (objectType instanceof ClassEntry);
        int superOffset = this.getLayoutIndex((ClassEntry)objectType);
        return this.writeSuperReference(context, superOffset, superName, buffer, pos);
    }

    private int writeArrayTypes(DebugContext context, ArrayTypeEntry arrayTypeEntry, int layoutOffset, int indirectLayoutOffset, byte[] buffer, int p) {
        int pos = p;
        String name = this.uniqueDebugString(arrayTypeEntry.getTypeName());
        int typeIdx = pos;
        this.setTypeIndex(arrayTypeEntry, pos);
        this.log(context, "  [0x%08x] array pointer type", pos);
        int abbrevCode = 16;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        this.log(context, "  [0x%08x]     type (pointer) 0x%x (%s)", pos, layoutOffset, name);
        pos = this.writeAttrRefAddr(layoutOffset, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectTypeIndex(arrayTypeEntry, pos);
            this.log(context, "  [0x%08x] array indirect pointer type", pos);
            abbrevCode = 20;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            int byteSize = this.dwarfSections.oopReferenceSize();
            this.log(context, "  [0x%08x]     byte_size  0x%x", pos, byteSize);
            pos = this.writeAttrData1((byte)byteSize, buffer, pos);
            this.log(context, "  [0x%08x]     type (pointer) 0x%x (%s)", pos, indirectLayoutOffset, name);
            pos = this.writeAttrRefAddr(indirectLayoutOffset, buffer, pos);
        } else {
            this.setIndirectTypeIndex(arrayTypeEntry, typeIdx);
        }
        return pos;
    }

    private int writeDeoptMethodsCU(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        assert (classEntry.includesDeoptTarget());
        List<PrimaryEntry> classPrimaryEntries = classEntry.getPrimaryEntries();
        assert (!classPrimaryEntries.isEmpty());
        String fileName = classEntry.getFileName();
        int lineIndex = this.getLineIndex(classEntry);
        int lo = DwarfInfoSectionImpl.findLo(classPrimaryEntries, true);
        int hi = DwarfInfoSectionImpl.findHi(classPrimaryEntries, true, true);
        assert (hi > 0) : hi;
        int abbrevCode = fileName.length() > 0 ? 2 : 3;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DwarfDebugInfo.DW_LANG_Java");
        pos = this.writeAttrData1((byte)11, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(classEntry.getFileName()), classEntry.getFileName());
        pos = this.writeAttrStrp(classEntry.getFileName(), buffer, pos);
        String compilationDirectory = classEntry.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeAttrStrp(compilationDirectory, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, lo);
        pos = this.writeAttrAddress(lo, buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, hi);
        pos = this.writeAttrAddress(hi, buffer, pos);
        if (abbrevCode == 2) {
            this.log(context, "  [0x%08x]     stmt_list  0x%08x", pos, lineIndex);
            pos = this.writeAttrData4(lineIndex, buffer, pos);
        }
        pos = this.writeMethodLocations(context, classEntry, true, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodLocation(DebugContext context, ClassEntry classEntry, PrimaryEntry primaryEntry, byte[] buffer, int p) {
        int pos = p;
        Range primary = primaryEntry.getPrimary();
        this.log(context, "  [0x%08x] method location", pos);
        int abbrevCode = 12;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, primary.getLo());
        pos = this.writeAttrAddress(primary.getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, primary.getHi());
        pos = this.writeAttrAddress(primary.getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        String methodKey = primary.getSymbolName();
        int methodSpecOffset = this.getMethodDeclarationIndex(classEntry, methodKey);
        this.log(context, "  [0x%08x]     specification  0x%x (%s)", pos, methodSpecOffset, methodKey);
        pos = this.writeAttrRefAddr(methodSpecOffset, buffer, pos);
        HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap = primary.getVarRangeMap();
        pos = this.writeMethodParameterLocations(context, varRangeMap, primary, 2, buffer, pos);
        pos = this.writeMethodLocalLocations(context, varRangeMap, primary, 2, buffer, pos);
        if (primary.includesInlineRanges()) {
            pos = this.generateConcreteInlinedMethods(context, primaryEntry, buffer, pos);
        }
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodParameterLocations(DebugContext context, HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap, Range range, int depth, byte[] buffer, int p) {
        MethodEntry methodEntry;
        int pos = p;
        if (range.isPrimary()) {
            methodEntry = range.getMethodEntry();
        } else {
            assert (!range.isLeaf()) : "should only be looking up var ranges for inlined calls";
            methodEntry = range.getFirstCallee().getMethodEntry();
        }
        if (!Modifier.isStatic(methodEntry.getModifiers())) {
            DebugInfoProvider.DebugLocalInfo thisParamInfo = methodEntry.getThisParam();
            int refAddr = this.getMethodLocalIndex(methodEntry, thisParamInfo);
            List<Range> ranges = varRangeMap.get(thisParamInfo);
            pos = this.writeMethodLocalLocation(context, range, thisParamInfo, refAddr, ranges, depth, true, buffer, pos);
        }
        for (int i = 0; i < methodEntry.getParamCount(); ++i) {
            DebugInfoProvider.DebugLocalInfo paramInfo = methodEntry.getParam(i);
            int refAddr = this.getMethodLocalIndex(methodEntry, paramInfo);
            List<Range> ranges = varRangeMap.get(paramInfo);
            pos = this.writeMethodLocalLocation(context, range, paramInfo, refAddr, ranges, depth, true, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalLocations(DebugContext context, HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap, Range range, int depth, byte[] buffer, int p) {
        MethodEntry methodEntry;
        int pos = p;
        if (range.isPrimary()) {
            methodEntry = range.getMethodEntry();
        } else {
            assert (!range.isLeaf()) : "should only be looking up var ranges for inlined calls";
            methodEntry = range.getFirstCallee().getMethodEntry();
        }
        int count = methodEntry.getLocalCount();
        for (int i = 0; i < count; ++i) {
            DebugInfoProvider.DebugLocalInfo localInfo = methodEntry.getLocal(i);
            int refAddr = this.getMethodLocalIndex(methodEntry, localInfo);
            List<Range> ranges = varRangeMap.get(localInfo);
            pos = this.writeMethodLocalLocation(context, range, localInfo, refAddr, ranges, depth, false, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalLocation(DebugContext context, Range range, DebugInfoProvider.DebugLocalInfo localInfo, int refAddr, List<Range> ranges, int depth, boolean isParam, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method %s location %s:%s", pos, isParam ? "parameter" : "local", localInfo.name(), localInfo.typeName());
        ArrayList<DebugInfoProvider.DebugLocalValueInfo> localValues = new ArrayList<DebugInfoProvider.DebugLocalValueInfo>();
        for (Range subrange : ranges) {
            DebugInfoProvider.DebugLocalValueInfo value = subrange.lookupValue(localInfo);
            if (value == null) continue;
            this.log(context, "  [0x%08x]     local  %s:%s [0x%x, 0x%x] = %s", pos, value.name(), value.typeName(), subrange.getLo(), subrange.getHi(), DwarfInfoSectionImpl.formatValue(value));
            switch (value.localKind()) {
                case REGISTER: 
                case STACKSLOT: {
                    localValues.add(value);
                    break;
                }
                case CONSTANT: {
                    JavaConstant constant = value.constantValue();
                    if (!(constant instanceof PrimitiveConstant) && constant.getJavaKind() != JavaKind.Object) break;
                    localValues.add(value);
                    break;
                }
            }
        }
        int abbrevCode = localValues.isEmpty() ? (isParam ? 38 : 40) : (isParam ? 39 : 41);
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, depth, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, refAddr);
        pos = this.writeAttrRefAddr(refAddr, buffer, pos);
        if (abbrevCode == 41 || abbrevCode == 39) {
            int locRefAddr = this.getRangeLocalIndex(range, localInfo);
            this.log(context, "  [0x%08x]     loc list  0x%x", pos, locRefAddr);
            pos = this.writeAttrLocList(locRefAddr, buffer, pos);
        }
        return pos;
    }

    private int writeAbstractInlineMethod(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        String methodKey = method.getSymbolName();
        this.log(context, "  [0x%08x] abstract inline method %s", pos, method.getSymbolName());
        int abbrevCode = 13;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode);
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     inline  0x%x", pos, (byte)1);
        pos = this.writeAttrData1((byte)1, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        int methodSpecOffset = this.getMethodDeclarationIndex(classEntry, methodKey);
        this.log(context, "  [0x%08x]     specification  0x%x (%s)", pos, methodSpecOffset, methodKey);
        pos = this.writeAttrRefAddr(methodSpecOffset, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeInlineSubroutine(DebugContext context, Range caller, int depth, byte[] buffer, int p) {
        Integer fileIndex;
        assert (!caller.isLeaf());
        Range callee = caller.getFirstCallee();
        MethodEntry methodEntry = callee.getMethodEntry();
        ClassEntry methodClassEntry = methodEntry.ownerType();
        String methodKey = methodEntry.getSymbolName();
        int specificationIndex = this.getAbstractInlineMethodIndex(methodClassEntry, methodKey);
        int pos = p;
        this.log(context, "  [0x%08x] concrete inline subroutine [0x%x, 0x%x] %s", pos, caller.getLo(), caller.getHi(), methodKey);
        int callLine = caller.getLine();
        assert (callLine >= -1) : callLine;
        if (callLine == -1) {
            this.log(context, "  Unable to retrieve call line for inlined method %s", callee.getFullMethodName());
            callLine = 0;
            fileIndex = 1;
        } else {
            FileEntry subFileEntry = caller.getFileEntry();
            assert (subFileEntry != null) : caller.getClassName() + "." + caller.getMethodName() + "(" + caller.getFileName() + ":" + callLine + ")";
            fileIndex = caller.getFileIndex();
            assert (fileIndex != null);
        }
        int code = 32;
        this.log(context, "  [0x%08x] <%d> Abbrev Number  %d", pos, depth, code);
        pos = this.writeAbbrevCode(code, buffer, pos);
        this.log(context, "  [0x%08x]     abstract_origin  0x%x", pos, specificationIndex);
        pos = this.writeAttrRef4(specificationIndex, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, caller.getLo());
        pos = this.writeAttrAddress(caller.getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, caller.getHi());
        pos = this.writeAttrAddress(caller.getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     call_file  %d", pos, fileIndex);
        pos = this.writeAttrData4(fileIndex, buffer, pos);
        this.log(context, "  [0x%08x]     call_line  %d", pos, callLine);
        pos = this.writeAttrData4(callLine, buffer, pos);
        return pos;
    }

    private int writeAttrRef4(int reference, byte[] buffer, int p) {
        return this.writeAttrData4(reference, buffer, p);
    }

    private int writeCUHeader(byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeShort((short)4, buffer, pos);
        pos = this.writeInt(0, buffer, pos);
        return this.writeByte((byte)8, buffer, pos);
    }

    private static int findLo(List<PrimaryEntry> classPrimaryEntries, boolean isDeoptTargetCU) {
        if (!isDeoptTargetCU) {
            return classPrimaryEntries.get(0).getPrimary().getLo();
        }
        for (PrimaryEntry primaryEntry : classPrimaryEntries) {
            Range range = primaryEntry.getPrimary();
            if (!range.isDeoptTarget()) continue;
            return range.getLo();
        }
        assert (false) : "should not reach";
        return 0;
    }

    private static int findHi(List<PrimaryEntry> classPrimaryEntries, boolean includesDeoptTarget, boolean isDeoptTargetCU) {
        if (isDeoptTargetCU || !includesDeoptTarget) {
            assert (classPrimaryEntries.size() > 0) : "expected to find primary methods";
            return classPrimaryEntries.get(classPrimaryEntries.size() - 1).getPrimary().getHi();
        }
        int hi = 0;
        for (PrimaryEntry primaryEntry : classPrimaryEntries) {
            Range range = primaryEntry.getPrimary();
            if (!range.isDeoptTarget()) {
                hi = range.getHi();
                continue;
            }
            return hi;
        }
        assert (false) : "should not reach";
        return 0;
    }

    private int writeAttrStrp(String value, byte[] buffer, int p) {
        int pos = p;
        int idx = this.debugStringIndex(value);
        return this.writeInt(idx, buffer, pos);
    }

    public int writeAttrString(String value, byte[] buffer, int p) {
        int pos = p;
        return this.writeUTF8StringBytes(value, buffer, pos);
    }

    public int writeAttrAccessibility(int modifiers, byte[] buffer, int p) {
        int access = Modifier.isPublic(modifiers) ? 1 : (Modifier.isProtected(modifiers) ? 2 : (Modifier.isPrivate(modifiers) ? 3 : 1));
        return this.writeAttrData1((byte)access, buffer, p);
    }

    public int writeIndirectOopConversionExpression(boolean isHub, byte[] buffer, int p) {
        int pos = p;
        boolean useHeapBase = this.dwarfSections.useHeapBase();
        int oopCompressShift = this.dwarfSections.oopCompressShift();
        byte oopTagsShift = this.dwarfSections.oopTagsShift();
        int oopAlignShift = this.dwarfSections.oopAlignShift();
        byte mask = 0;
        byte rightShift = 0;
        int leftShift = 0;
        int exprSize = 0;
        if (!useHeapBase) {
            assert (isHub);
            mask = this.dwarfSections.oopTagsMask();
            assert (mask != 0);
            exprSize += 4;
        } else {
            exprSize += 10;
            if (isHub) {
                if (oopCompressShift == 0) {
                    oopCompressShift = oopAlignShift;
                }
                if (oopCompressShift == oopTagsShift) {
                    mask = this.dwarfSections.oopTagsMask();
                    exprSize += 3;
                } else {
                    rightShift = oopTagsShift;
                    leftShift = oopCompressShift;
                    exprSize += 4;
                }
            } else if (oopCompressShift != 0) {
                leftShift = oopCompressShift;
                exprSize += 2;
            }
        }
        int exprStart = pos = this.writeULEB(exprSize, buffer, pos);
        if (!useHeapBase) {
            pos = this.writeByte((byte)-105, buffer, pos);
            pos = this.writeByte((byte)(48 + mask), buffer, pos);
            pos = this.writeByte((byte)32, buffer, pos);
            pos = this.writeByte((byte)26, buffer, pos);
        } else {
            pos = this.writeByte((byte)-105, buffer, pos);
            pos = this.writeByte((byte)18, buffer, pos);
            pos = this.writeByte((byte)48, buffer, pos);
            pos = this.writeByte((byte)41, buffer, pos);
            int skipStart = pos + 3;
            short offsetToEnd = (short)(exprSize - (skipStart - exprStart));
            pos = this.writeByte((byte)40, buffer, pos);
            pos = this.writeShort(offsetToEnd, buffer, pos);
            if (mask != 0) {
                pos = this.writeByte((byte)(48 + mask), buffer, pos);
                pos = this.writeByte((byte)32, buffer, pos);
                pos = this.writeByte((byte)26, buffer, pos);
            } else {
                if (rightShift != 0) {
                    pos = this.writeByte((byte)(48 + rightShift), buffer, pos);
                    pos = this.writeByte((byte)37, buffer, pos);
                }
                if (leftShift != 0) {
                    pos = this.writeByte((byte)(48 + leftShift), buffer, pos);
                    pos = this.writeByte((byte)36, buffer, pos);
                }
            }
            byte regOp = (byte)(112 + this.dwarfSections.getHeapbaseRegister());
            pos = this.writeByte(regOp, buffer, pos);
            pos = this.writeSLEB(0L, buffer, pos);
            pos = this.writeByte((byte)34, buffer, pos);
            assert (pos == skipStart + offsetToEnd);
            assert (pos == exprStart + exprSize);
        }
        return pos;
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

