/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSymbolRecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubrecord;
import java.util.ArrayList;
import org.graalvm.compiler.debug.DebugContext;

final class CVSymbolSubsection
extends CVSymbolRecord {
    private static final int SUBCMD_INITIAL_CAPACITY = 100;
    private ArrayList<CVSymbolSubrecord> subcmds = new ArrayList(100);

    CVSymbolSubsection(CVDebugInfo cvDebugInfo) {
        super(cvDebugInfo, 241);
    }

    void addRecord(CVSymbolSubrecord subcmd) {
        this.subcmds.add(subcmd);
    }

    @Override
    protected int computeSize(int initialPos) {
        return this.computeContents(null, initialPos);
    }

    @Override
    protected int computeContents(byte[] buffer, int initialPos) {
        int pos = initialPos;
        for (CVSymbolSubrecord subcmd : this.subcmds) {
            pos = subcmd.computeFullContents(buffer, pos);
        }
        return pos;
    }

    @Override
    public void logContents(DebugContext debugContext) {
        CVSymbolSectionImpl section = this.cvDebugInfo.getCVSymbolSection();
        for (CVSymbolSubrecord subcmd : this.subcmds) {
            section.log(debugContext, "     [0x%08x]  %s", subcmd.getPos(), subcmd.toString());
        }
    }

    @Override
    public String toString() {
        return String.format("DEBUG_S_SYMBOLS type=0x%04x pos=0x%05x subrecordcount=%d", this.type, this.recordStartPosition, this.subcmds.size());
    }
}

