/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.StringTable;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Range {
    private static final String CLASS_DELIMITER = ".";
    private final String cachePath;
    private String fileName;
    private Path filePath;
    private String className;
    private String methodName;
    private String symbolName;
    private String paramNames;
    private String returnTypeName;
    private String fullMethodName;
    private int lo;
    private int hi;
    private int line;
    private boolean isDeoptTarget;
    private Range primary;

    public Range(String fileName, Path filePath, Path cachePath, String className, String methodName, String symbolName, String paramNames, String returnTypeName, StringTable stringTable, int lo, int hi, int line, boolean isDeoptTarget) {
        this(fileName, filePath, cachePath, className, methodName, symbolName, paramNames, returnTypeName, stringTable, lo, hi, line, isDeoptTarget, null);
    }

    public Range(String fileName, Path filePath, Path cachePath, String className, String methodName, String symbolName, String paramNames, String returnTypeName, StringTable stringTable, int lo, int hi, int line, Range primary) {
        this(fileName, filePath, cachePath, className, methodName, symbolName, paramNames, returnTypeName, stringTable, lo, hi, line, false, primary);
    }

    private Range(String fileName, Path filePath, Path cachePath, String className, String methodName, String symbolName, String paramNames, String returnTypeName, StringTable stringTable, int lo, int hi, int line, boolean isDeoptTarget, Range primary) {
        this.fileName = fileName == null ? null : stringTable.uniqueDebugString(fileName);
        this.filePath = filePath;
        this.cachePath = cachePath == null ? "" : stringTable.uniqueDebugString(cachePath.toString());
        this.className = stringTable.uniqueString(className);
        this.methodName = stringTable.uniqueString(methodName);
        this.symbolName = stringTable.uniqueString(symbolName);
        this.paramNames = stringTable.uniqueString(paramNames);
        this.returnTypeName = stringTable.uniqueString(returnTypeName);
        this.fullMethodName = stringTable.uniqueDebugString(this.constructClassAndMethodNameWithParams());
        this.lo = lo;
        this.hi = hi;
        this.line = line;
        this.isDeoptTarget = isDeoptTarget;
        this.primary = primary;
    }

    public boolean contains(Range other) {
        return this.lo <= other.lo && this.hi >= other.hi;
    }

    public boolean isPrimary() {
        return this.getPrimary() == null;
    }

    public Range getPrimary() {
        return this.primary;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public Path getFileAsPath() {
        if (this.filePath != null) {
            return this.filePath.resolve(this.fileName);
        }
        if (this.fileName != null) {
            return Paths.get(this.fileName, new String[0]);
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public int getHi() {
        return this.hi;
    }

    public int getLo() {
        return this.lo;
    }

    public int getLine() {
        return this.line;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public boolean isDeoptTarget() {
        return this.isDeoptTarget;
    }

    public String getParamNames() {
        return this.paramNames;
    }

    public String getClassAndMethodName() {
        return this.getExtendedMethodName(false, false);
    }

    private String getExtendedMethodName(boolean includeParams, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType && this.returnTypeName.length() > 0) {
            builder.append(this.returnTypeName);
            builder.append(' ');
        }
        if (this.className != null) {
            builder.append(this.className);
            builder.append(CLASS_DELIMITER);
        }
        builder.append(this.methodName);
        if (includeParams && !this.paramNames.isEmpty()) {
            builder.append('(');
            builder.append(this.paramNames);
            builder.append(')');
        }
        return builder.toString();
    }

    private String constructClassAndMethodNameWithParams() {
        return this.getExtendedMethodName(true, false);
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public String toString() {
        return String.format("Range(lo=0x%05x hi=0x%05x %s %s:%d)", this.lo, this.hi, this.constructClassAndMethodNameWithParams(), this.getFileAsPath(), this.line);
    }
}

