/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.util.LinkedList;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfInfoSectionImpl
extends DwarfSectionImpl {
    private static final int DW_DIE_HEADER_SIZE = 11;
    private static final String TARGET_SECTION_NAME = ".debug_abbrev";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.OFFSET};

    public DwarfInfoSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_info";
    }

    @Override
    public void createContent() {
        byte[] buffer = null;
        int pos = 0;
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            int lengthPos = pos;
            pos = this.writeCUHeader(buffer, pos);
            assert (pos == lengthPos + 11);
            pos = this.writeCU(null, classEntry, buffer, pos);
        }
        buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_INFO", pos);
        this.log(context, "  [0x%08x] size = 0x%08x", pos, size);
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            classEntry.setCUIndex(pos);
            int lengthPos = pos;
            pos = this.writeCUHeader(buffer, pos);
            this.log(context, "  [0x%08x] Compilation Unit", pos, size);
            assert (pos == lengthPos + 11);
            pos = this.writeCU(context, classEntry, buffer, pos);
            this.patchLength(lengthPos, buffer, pos);
        }
        assert (pos == size);
    }

    private int writeCUHeader(byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            pos += this.putInt(0, scratch, 0);
            pos += this.putShort((short)2, scratch, 0);
            return (pos += this.putInt(0, scratch, 0)) + this.putByte((byte)8, scratch, 0);
        }
        pos = this.putInt(0, buffer, pos);
        pos = this.putShort((short)2, buffer, pos);
        pos = this.putInt(0, buffer, pos);
        return this.putByte((byte)8, buffer, pos);
    }

    private int writeCU(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        LinkedList<PrimaryEntry> classPrimaryEntries = classEntry.getPrimaryEntries();
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, 1);
        pos = this.writeAbbrevCode(1L, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrData1((byte)11, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(classEntry.getFileName()), classEntry.getFileName());
        pos = this.writeAttrStrp(classEntry.getFileName(), buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, classPrimaryEntries.getFirst().getPrimary().getLo());
        pos = this.writeAttrAddress(classPrimaryEntries.getFirst().getPrimary().getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, classPrimaryEntries.getLast().getPrimary().getHi());
        pos = this.writeAttrAddress(classPrimaryEntries.getLast().getPrimary().getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     stmt_list  0x%08x", pos, classEntry.getLineIndex());
        pos = this.writeAttrData4(classEntry.getLineIndex(), buffer, pos);
        for (PrimaryEntry primaryEntry : classPrimaryEntries) {
            pos = this.writePrimary(context, primaryEntry, buffer, pos);
        }
        return this.writeAttrNull(buffer, pos);
    }

    private int writePrimary(DebugContext context, PrimaryEntry primaryEntry, byte[] buffer, int p) {
        int pos = p;
        Range primary = primaryEntry.getPrimary();
        this.verboseLog(context, "  [0x%08x] <1> Abbrev Number  %d", pos, 2);
        pos = this.writeAbbrevCode(2L, buffer, pos);
        this.verboseLog(context, "  [0x%08x]     name  0x%X (%s)", pos, this.debugStringIndex(primary.getFullMethodName()), primary.getFullMethodName());
        pos = this.writeAttrStrp(primary.getFullMethodName(), buffer, pos);
        this.verboseLog(context, "  [0x%08x]     lo_pc  0x%08x", pos, primary.getLo());
        pos = this.writeAttrAddress(primary.getLo(), buffer, pos);
        this.verboseLog(context, "  [0x%08x]     hi_pc  0x%08x", pos, primary.getHi());
        pos = this.writeAttrAddress(primary.getHi(), buffer, pos);
        this.verboseLog(context, "  [0x%08x]     external  true", pos);
        return this.writeFlag((byte)1, buffer, pos);
    }

    private int writeAttrStrp(String value, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            return pos + this.putInt(0, scratch, 0);
        }
        int idx = this.debugStringIndex(value);
        return this.putInt(idx, buffer, pos);
    }

    public int writeAttrString(String value, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            return pos + value.length() + 1;
        }
        return this.putAsciiStringBytes(value, buffer, pos);
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

