/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfAbbrevSectionImpl
extends DwarfSectionImpl {
    private static final String TARGET_SECTION_NAME = ".debug_frame";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.OFFSET};

    public DwarfAbbrevSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_abbrev";
    }

    @Override
    public void createContent() {
        int pos = 0;
        pos = this.writeAbbrev1(null, null, pos);
        pos = this.writeAbbrev2(null, null, pos);
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        pos = this.writeAbbrev1(context, buffer, pos);
        pos = this.writeAbbrev2(context, buffer, pos);
        assert (pos == size);
    }

    private int writeAttrType(long code, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putSLEB(code, scratch, 0);
        }
        return this.putSLEB(code, buffer, pos);
    }

    private int writeAttrForm(long code, byte[] buffer, int pos) {
        if (buffer == null) {
            return pos + this.putSLEB(code, scratch, 0);
        }
        return this.putSLEB(code, buffer, pos);
    }

    private int writeAbbrev1(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(1L, buffer, pos);
        pos = this.writeTag(17L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(19L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(17L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(18L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(16L, buffer, pos);
        pos = this.writeAttrForm(6L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeAbbrev2(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(2L, buffer, pos);
        pos = this.writeTag(46L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(17L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(18L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(63L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

