/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DebugInfoBase {
    protected ByteOrder byteOrder;
    private StringTable stringTable = new StringTable();
    private Map<Path, DirEntry> dirsIndex = new HashMap<Path, DirEntry>();
    private LinkedList<ClassEntry> primaryClasses = new LinkedList();
    private Map<String, ClassEntry> primaryClassesIndex = new HashMap<String, ClassEntry>();
    private Map<Path, FileEntry> filesIndex = new HashMap<Path, FileEntry>();
    private LinkedList<FileEntry> files = new LinkedList();

    public DebugInfoBase(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void installDebugInfo(DebugInfoProvider debugInfoProvider) {
        this.stringTable.uniqueDebugString("");
        debugInfoProvider.codeInfoProvider().forEach(debugCodeInfo -> debugCodeInfo.debugContext(debugContext -> {
            String fileName = debugCodeInfo.fileName();
            Path filePath = debugCodeInfo.filePath();
            String className = debugCodeInfo.className().replaceAll("\\$", ".");
            String methodName = debugCodeInfo.methodName();
            String paramNames = debugCodeInfo.paramNames();
            String returnTypeName = debugCodeInfo.returnTypeName();
            int lo = debugCodeInfo.addressLo();
            int hi = debugCodeInfo.addressHi();
            int primaryLine = debugCodeInfo.line();
            Range primaryRange = new Range(fileName, filePath, className, methodName, paramNames, returnTypeName, this.stringTable, lo, hi, primaryLine);
            debugContext.log(2, "PrimaryRange %s.%s %s %s:%d [0x%x, 0x%x]", (Object)className, (Object)methodName, (Object)filePath, (Object)fileName, (Object)primaryLine, (Object)lo, (Object)hi);
            this.addRange(primaryRange, debugCodeInfo.getFrameSizeChanges(), debugCodeInfo.getFrameSize());
            debugCodeInfo.lineInfoProvider().forEach(debugLineInfo -> {
                String fileNameAtLine = debugLineInfo.fileName();
                Path filePathAtLine = debugLineInfo.filePath();
                String classNameAtLine = debugLineInfo.className().replaceAll("\\$", ".");
                String methodNameAtLine = debugLineInfo.methodName();
                int loAtLine = lo + debugLineInfo.addressLo();
                int hiAtLine = lo + debugLineInfo.addressHi();
                int line = debugLineInfo.line();
                Range subRange = new Range(fileNameAtLine, filePathAtLine, classNameAtLine, methodNameAtLine, "", "", this.stringTable, loAtLine, hiAtLine, line, primaryRange);
                this.addSubRange(primaryRange, subRange);
                try (DebugContext.Scope s = debugContext.scope((Object)"Subranges");){
                    debugContext.log(3, "SubRange %s.%s %s %s:%d 0x%x, 0x%x]", (Object)classNameAtLine, (Object)methodNameAtLine, (Object)filePathAtLine, (Object)fileNameAtLine, (Object)line, (Object)loAtLine, (Object)hiAtLine);
                }
            });
        }));
    }

    private ClassEntry ensureClassEntry(Range range) {
        String className = range.getClassName();
        ClassEntry classEntry = this.primaryClassesIndex.get(className);
        if (classEntry == null) {
            FileEntry fileEntry = this.ensureFileEntry(range);
            classEntry = new ClassEntry(className, fileEntry);
            this.primaryClasses.add(classEntry);
            this.primaryClassesIndex.put(className, classEntry);
        }
        assert (classEntry.getClassName().equals(className));
        return classEntry;
    }

    private FileEntry ensureFileEntry(Range range) {
        String fileName = range.getFileName();
        if (fileName == null) {
            return null;
        }
        Path filePath = range.getFilePath();
        Path fileAsPath = range.getFileAsPath();
        FileEntry fileEntry = this.filesIndex.get(fileAsPath);
        if (fileEntry == null) {
            DirEntry dirEntry = this.ensureDirEntry(filePath);
            fileEntry = new FileEntry(fileName, dirEntry);
            this.files.add(fileEntry);
            this.filesIndex.put(fileAsPath, fileEntry);
            if (!range.isPrimary()) {
                Range primaryRange = range.getPrimary();
                FileEntry primaryFileEntry = this.filesIndex.get(primaryRange.getFileAsPath());
                assert (primaryFileEntry != null);
            }
        }
        return fileEntry;
    }

    private void addRange(Range primaryRange, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize) {
        assert (primaryRange.isPrimary());
        ClassEntry classEntry = this.ensureClassEntry(primaryRange);
        classEntry.addPrimary(primaryRange, frameSizeInfos, frameSize);
    }

    private void addSubRange(Range primaryRange, Range subrange) {
        assert (primaryRange.isPrimary());
        assert (!subrange.isPrimary());
        String className = primaryRange.getClassName();
        ClassEntry classEntry = this.primaryClassesIndex.get(className);
        FileEntry subrangeFileEntry = this.ensureFileEntry(subrange);
        assert (classEntry.primaryIndexFor(primaryRange) != null);
        if (subrangeFileEntry != null) {
            classEntry.addSubRange(subrange, subrangeFileEntry);
        }
    }

    private DirEntry ensureDirEntry(Path filePath) {
        if (filePath == null) {
            return null;
        }
        DirEntry dirEntry = this.dirsIndex.get(filePath);
        if (dirEntry == null) {
            dirEntry = new DirEntry(filePath);
            this.dirsIndex.put(filePath, dirEntry);
        }
        return dirEntry;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public LinkedList<ClassEntry> getPrimaryClasses() {
        return this.primaryClasses;
    }

    public LinkedList<FileEntry> getFiles() {
        return this.files;
    }

    public FileEntry findFile(Path fullFileName) {
        return this.filesIndex.get(fullFileName);
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public int debugStringIndex(String string) {
        return this.stringTable.debugStringIndex(string);
    }
}

