/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClassEntry {
    private String className;
    private FileEntry fileEntry;
    private LinkedList<PrimaryEntry> primaryEntries;
    private Map<Range, PrimaryEntry> primaryIndex;
    private Map<FileEntry, Integer> localFilesIndex;
    private LinkedList<FileEntry> localFiles;
    private HashMap<DirEntry, Integer> localDirsIndex;
    private LinkedList<DirEntry> localDirs;
    private int cuIndex;
    private int lineIndex;
    private int linePrologueSize;
    private int totalSize;

    public ClassEntry(String className, FileEntry fileEntry) {
        this.className = className;
        this.fileEntry = fileEntry;
        this.primaryEntries = new LinkedList();
        this.primaryIndex = new HashMap<Range, PrimaryEntry>();
        this.localFiles = new LinkedList();
        this.localFilesIndex = new HashMap<FileEntry, Integer>();
        this.localDirs = new LinkedList();
        this.localDirsIndex = new HashMap();
        if (fileEntry != null) {
            this.localFiles.add(fileEntry);
            this.localFilesIndex.put(fileEntry, this.localFiles.size());
            DirEntry dirEntry = fileEntry.getDirEntry();
            if (dirEntry != null) {
                this.localDirs.add(dirEntry);
                this.localDirsIndex.put(dirEntry, this.localDirs.size());
            }
        }
        this.cuIndex = -1;
        this.lineIndex = -1;
        this.linePrologueSize = -1;
        this.totalSize = -1;
    }

    public void addPrimary(Range primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize) {
        if (this.primaryIndex.get(primary) == null) {
            PrimaryEntry primaryEntry = new PrimaryEntry(primary, frameSizeInfos, frameSize, this);
            this.primaryEntries.add(primaryEntry);
            this.primaryIndex.put(primary, primaryEntry);
        }
    }

    public void addSubRange(Range subrange, FileEntry subFileEntry) {
        Range primary = subrange.getPrimary();
        assert (primary != null);
        PrimaryEntry primaryEntry = this.primaryIndex.get(primary);
        assert (primaryEntry != null);
        assert (primaryEntry.getClassEntry() == this);
        primaryEntry.addSubRange(subrange, subFileEntry);
        if (subFileEntry != null) {
            DirEntry dirEntry;
            if (this.localFilesIndex.get(subFileEntry) == null) {
                this.localFiles.add(subFileEntry);
                this.localFilesIndex.put(subFileEntry, this.localFiles.size());
            }
            if ((dirEntry = subFileEntry.getDirEntry()) != null && this.localDirsIndex.get(dirEntry) == null) {
                this.localDirs.add(dirEntry);
                this.localDirsIndex.put(dirEntry, this.localDirs.size());
            }
        }
    }

    public int localDirsIdx(DirEntry dirEntry) {
        if (dirEntry != null) {
            return this.localDirsIndex.get(dirEntry);
        }
        return 0;
    }

    public int localFilesIdx(FileEntry fileEntry) {
        return this.localFilesIndex.get(fileEntry);
    }

    public String getFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFileName();
        }
        return "";
    }

    String getFullFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFullName();
        }
        return null;
    }

    String getDirName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getPathName();
        }
        return "";
    }

    public void setCUIndex(int cuIndex) {
        assert (cuIndex >= 0);
        assert (this.cuIndex == -1);
        this.cuIndex = cuIndex;
    }

    public int getCUIndex() {
        assert (this.cuIndex >= 0);
        return this.cuIndex;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public void setLineIndex(int lineIndex) {
        this.lineIndex = lineIndex;
    }

    public void setLinePrologueSize(int linePrologueSize) {
        this.linePrologueSize = linePrologueSize;
    }

    public int getLinePrologueSize() {
        return this.linePrologueSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public String getClassName() {
        return this.className;
    }

    public LinkedList<PrimaryEntry> getPrimaryEntries() {
        return this.primaryEntries;
    }

    public Object primaryIndexFor(Range primaryRange) {
        return this.primaryIndex.get(primaryRange);
    }

    public LinkedList<DirEntry> getLocalDirs() {
        return this.localDirs;
    }

    public LinkedList<FileEntry> getLocalFiles() {
        return this.localFiles;
    }
}

