/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class LogUtils {
    public static void info(String message) {
        System.out.println("Info: " + message);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void info(String format, Object ... args) {
        LogUtils.info(format.formatted(args));
    }

    public static void warning(String message) {
        System.out.println("Warning: " + message);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void warning(String format, Object ... args) {
        LogUtils.warning(format.formatted(args));
    }

    public static void warningDeprecatedEnvironmentVariable(String environmentVariableName) {
        LogUtils.warning("The " + environmentVariableName + " environment variable is deprecated and might be removed in a future release. Please refer to the GraalVM release notes.");
    }
}

