/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.AnnotationExtracter;
import com.oracle.svm.util.DirectAnnotationAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;

public final class GuardedAnnotationAccess {
    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return GuardedAnnotationAccess.isAnnotationPresent((AnnotationExtracter)ImageSingletons.lookup(AnnotationExtracter.class), element, annotationClass);
        }
        return DirectAnnotationAccess.isAnnotationPresent(element, annotationClass);
    }

    public static boolean isAnnotationPresent(AnnotationExtracter extracter, AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        try {
            return extracter.hasAnnotation(element, annotationClass);
        }
        catch (ArrayStoreException | LinkageError e) {
            return false;
        }
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationType) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return GuardedAnnotationAccess.getAnnotation((AnnotationExtracter)ImageSingletons.lookup(AnnotationExtracter.class), element, annotationType);
        }
        return DirectAnnotationAccess.getAnnotation(element, annotationType);
    }

    public static <T extends Annotation> T getAnnotation(AnnotationExtracter extracter, AnnotatedElement element, Class<T> annotationType) {
        try {
            return extracter.extractAnnotation(element, annotationType, false);
        }
        catch (ArrayStoreException | LinkageError e) {
            return null;
        }
    }

    public static Annotation[] getAnnotations(AnnotatedElement element) {
        try {
            return DirectAnnotationAccess.getAnnotations(element);
        }
        catch (ArrayStoreException | LinkageError e) {
            return new Annotation[0];
        }
    }

    public static Class<? extends Annotation>[] getAnnotationTypes(AnnotatedElement element) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return ((AnnotationExtracter)ImageSingletons.lookup(AnnotationExtracter.class)).getAnnotationTypes(element);
        }
        return (Class[])Arrays.stream(DirectAnnotationAccess.getAnnotations(element)).map(Annotation::annotationType).toArray(Class[]::new);
    }

    public static <T extends Annotation> T getDeclaredAnnotation(AnnotatedElement element, Class<T> annotationType) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return GuardedAnnotationAccess.getDeclaredAnnotation((AnnotationExtracter)ImageSingletons.lookup(AnnotationExtracter.class), element, annotationType);
        }
        return DirectAnnotationAccess.getDeclaredAnnotation(element, annotationType);
    }

    public static <T extends Annotation> T getDeclaredAnnotation(AnnotationExtracter extracter, AnnotatedElement element, Class<T> annotationType) {
        try {
            return extracter.extractAnnotation(element, annotationType, true);
        }
        catch (ArrayStoreException | LinkageError e) {
            return null;
        }
    }

    public static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        try {
            return DirectAnnotationAccess.getDeclaredAnnotations(element);
        }
        catch (ArrayStoreException | LinkageError e) {
            return new Annotation[0];
        }
    }
}

