/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.ModuleSupportBase;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import jdk.internal.module.Modules;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ModuleSupport
extends ModuleSupportBase {
    private ModuleSupport() {
    }

    public static void openModuleByClass(Class<?> declaringClass, Class<?> accessingClass) {
        Module accessingModule;
        Module declaringModule = declaringClass.getModule();
        String packageName = declaringClass.getPackageName();
        Module namedAccessingModule = null;
        if (accessingClass != null && (accessingModule = accessingClass.getModule()).isNamed()) {
            namedAccessingModule = accessingModule;
        }
        if (namedAccessingModule != null ? declaringModule.isOpen(packageName, namedAccessingModule) : declaringModule.isOpen(packageName)) {
            return;
        }
        if (namedAccessingModule != null) {
            Modules.addOpens(declaringModule, packageName, namedAccessingModule);
        } else {
            Modules.addOpensToAllUnnamed(declaringModule, packageName);
        }
    }

    public static void exportAndOpenPackageToClass(String moduleName, String packageName, boolean optional, Class<?> accessingClass) {
        Module accessingModule;
        Optional<Module> value = ModuleLayer.boot().findModule(moduleName);
        if (value.isEmpty()) {
            if (!optional) {
                throw new NoSuchElementException(moduleName);
            }
            return;
        }
        Module declaringModule = value.get();
        Module module = accessingModule = accessingClass == null ? null : accessingClass.getModule();
        if (accessingModule != null && accessingModule.isNamed()) {
            if (!declaringModule.isOpen(packageName, accessingModule)) {
                Modules.addOpens(declaringModule, packageName, accessingModule);
            }
        } else {
            Modules.addOpensToAllUnnamed(declaringModule, packageName);
        }
    }

    public static void exportAndOpenAllPackagesToUnnamed(String name, boolean optional) {
        Optional<Module> value = ModuleLayer.boot().findModule(name);
        if (value.isEmpty()) {
            if (!optional) {
                throw new NoSuchElementException("No module in boot layer named " + name + ". Available modules: " + ModuleLayer.boot());
            }
            return;
        }
        Module module = value.get();
        Set<String> packages = module.getPackages();
        for (String pkg : packages) {
            Modules.addExportsToAllUnnamed(module, pkg);
            Modules.addOpensToAllUnnamed(module, pkg);
        }
    }

    public static void exportAndOpenPackageToUnnamed(String name, String pkg, boolean optional) {
        Optional<Module> value = ModuleLayer.boot().findModule(name);
        if (value.isEmpty()) {
            if (!optional) {
                throw new NoSuchElementException(name);
            }
            return;
        }
        Module module = value.get();
        Modules.addExportsToAllUnnamed(module, pkg);
        Modules.addOpensToAllUnnamed(module, pkg);
    }
}

