// CheckStyle: start generated
package com.oracle.truffle.llvm.nfi;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.nfi.SulongNFI.SulongNFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;

@GeneratedBy(SulongNFIBackend.class)
final class SulongNFIBackendGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(SulongNFIBackend.class, new NFIBackendLibraryExports());
    }

    private SulongNFIBackendGen() {
    }

    @GeneratedBy(SulongNFIBackend.class)
    private static final class NFIBackendLibraryExports extends LibraryExport<NFIBackendLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private NFIBackendLibraryExports() {
            super(NFIBackendLibrary.class, SulongNFIBackend.class, false, false, 0);
        }

        @Override
        protected NFIBackendLibrary createUncached(Object receiver) {
            assert receiver instanceof SulongNFIBackend;
            NFIBackendLibrary uncached = NFIBackendLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected NFIBackendLibrary createCached(Object receiver) {
            assert receiver instanceof SulongNFIBackend;
            return NFIBackendLibraryExports.CACHE;
        }

        @GeneratedBy(SulongNFIBackend.class)
        private static final class Cached extends NFIBackendLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SulongNFIBackend) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongNFIBackend;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((SulongNFIBackend) receiver)).getSimpleType(type);
            }

            @Override
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((SulongNFIBackend) receiver)).getArrayType(type);
            }

            @Override
            public Object getEnvType(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((SulongNFIBackend) receiver)).getEnvType();
            }

            @Override
            public Object createSignatureBuilder(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((SulongNFIBackend) receiver)).createSignatureBuilder();
            }

        }
        @GeneratedBy(SulongNFIBackend.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SulongNFIBackend) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongNFIBackend;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongNFIBackend) receiver) .getSimpleType(type);
            }

            @TruffleBoundary
            @Override
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongNFIBackend) receiver) .getArrayType(type);
            }

            @TruffleBoundary
            @Override
            public Object getEnvType(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongNFIBackend) receiver) .getEnvType();
            }

            @TruffleBoundary
            @Override
            public Object createSignatureBuilder(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongNFIBackend) receiver) .createSignatureBuilder();
            }

        }
    }
}
