// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToArrayLengthNode#doInt}
 *     Activation probability: 0.21250
 *     With/without class size: 6/0 bytes
 *   Specialization {@link ToArrayLengthNode#doSafeInteger}
 *     Activation probability: 0.18750
 *     With/without class size: 6/0 bytes
 *   Specialization {@link ToArrayLengthNode#rangeError(SafeInteger)}
 *     Activation probability: 0.16250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayLengthNode#doLong}
 *     Activation probability: 0.13750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayLengthNode#rangeError(long)}
 *     Activation probability: 0.11250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayLengthNode#doDouble}
 *     Activation probability: 0.08750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayLengthNode#rangeError(double)}
 *     Activation probability: 0.06250
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToArrayLengthNode#typeNotNumber}
 *     Activation probability: 0.03750
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(ToArrayLengthNode.class)
@SuppressWarnings("javadoc")
public final class ToArrayLengthNodeGen extends ToArrayLengthNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ToArrayLengthNode#doInt}
     *   1: SpecializationActive {@link ToArrayLengthNode#doSafeInteger}
     *   2: SpecializationActive {@link ToArrayLengthNode#rangeError(SafeInteger)}
     *   3: SpecializationActive {@link ToArrayLengthNode#doLong}
     *   4: SpecializationActive {@link ToArrayLengthNode#rangeError(long)}
     *   5: SpecializationActive {@link ToArrayLengthNode#doDouble}
     *   6: SpecializationActive {@link ToArrayLengthNode#rangeError(double)}
     *   7: SpecializationActive {@link ToArrayLengthNode#typeNotNumber}
     *   8-10: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;

    private ToArrayLengthNodeGen() {
    }

    @Override
    public long executeLong(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111) != 0 /* is SpecializationActive[ToArrayLengthNode.doInt(int)] || SpecializationActive[ToArrayLengthNode.doSafeInteger(SafeInteger)] || SpecializationActive[ToArrayLengthNode.rangeError(SafeInteger)] || SpecializationActive[ToArrayLengthNode.doLong(long)] || SpecializationActive[ToArrayLengthNode.rangeError(long)] || SpecializationActive[ToArrayLengthNode.doDouble(double)] || SpecializationActive[ToArrayLengthNode.rangeError(double)] || SpecializationActive[ToArrayLengthNode.typeNotNumber(Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToArrayLengthNode.doInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ToArrayLengthNode.doInt(arg0Value_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[ToArrayLengthNode.doSafeInteger(SafeInteger)] || SpecializationActive[ToArrayLengthNode.rangeError(SafeInteger)] */ && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToArrayLengthNode.doSafeInteger(SafeInteger)] */) {
                    if ((JSRuntime.isValidArrayLength(arg0Value_.longValue()))) {
                        return ToArrayLengthNode.doSafeInteger(arg0Value_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToArrayLengthNode.rangeError(SafeInteger)] */) {
                    if ((!(JSRuntime.isValidArrayLength(arg0Value_.longValue())))) {
                        return ToArrayLengthNode.rangeError(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[ToArrayLengthNode.doLong(long)] || SpecializationActive[ToArrayLengthNode.rangeError(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToArrayLengthNode.doLong(long)] */) {
                    if ((JSRuntime.isValidArrayLength(arg0Value_))) {
                        return ToArrayLengthNode.doLong(arg0Value_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToArrayLengthNode.rangeError(long)] */) {
                    if ((!(JSRuntime.isValidArrayLength(arg0Value_)))) {
                        return ToArrayLengthNode.rangeError(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[ToArrayLengthNode.doDouble(double)] || SpecializationActive[ToArrayLengthNode.rangeError(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000000) >>> 8 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000000) >>> 8 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToArrayLengthNode.doDouble(double)] */) {
                    if ((JSRuntime.isValidArrayLength(arg0Value_))) {
                        return ToArrayLengthNode.doDouble(arg0Value_);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToArrayLengthNode.rangeError(double)] */) {
                    if ((!(JSRuntime.isValidArrayLength(arg0Value_)))) {
                        return ToArrayLengthNode.rangeError(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToArrayLengthNode.typeNotNumber(Object)] */) {
                if ((!(JSRuntime.isNumber(arg0Value))) && (!(JSGuards.isNumberLong(arg0Value)))) {
                    return ToArrayLengthNode.typeNotNumber(arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private long executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[ToArrayLengthNode.doInt(int)] */;
            this.state_0_ = state_0;
            return ToArrayLengthNode.doInt(arg0Value_);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger) arg0Value;
            if ((JSRuntime.isValidArrayLength(arg0Value_.longValue()))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToArrayLengthNode.doSafeInteger(SafeInteger)] */;
                this.state_0_ = state_0;
                return ToArrayLengthNode.doSafeInteger(arg0Value_);
            }
            if ((!(JSRuntime.isValidArrayLength(arg0Value_.longValue())))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[ToArrayLengthNode.rangeError(SafeInteger)] */;
                this.state_0_ = state_0;
                return ToArrayLengthNode.rangeError(arg0Value_);
            }
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            if ((JSRuntime.isValidArrayLength(arg0Value_))) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[ToArrayLengthNode.doLong(long)] */;
                this.state_0_ = state_0;
                return ToArrayLengthNode.doLong(arg0Value_);
            }
            if ((!(JSRuntime.isValidArrayLength(arg0Value_)))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ToArrayLengthNode.rangeError(long)] */;
                this.state_0_ = state_0;
                return ToArrayLengthNode.rangeError(arg0Value_);
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                if ((JSRuntime.isValidArrayLength(arg0Value_))) {
                    state_0 = (state_0 | (doubleCast0 << 8) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[ToArrayLengthNode.doDouble(double)] */;
                    this.state_0_ = state_0;
                    return ToArrayLengthNode.doDouble(arg0Value_);
                }
                if ((!(JSRuntime.isValidArrayLength(arg0Value_)))) {
                    state_0 = (state_0 | (doubleCast0 << 8) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToArrayLengthNode.rangeError(double)] */;
                    this.state_0_ = state_0;
                    return ToArrayLengthNode.rangeError(arg0Value_);
                }
            }
        }
        if ((!(JSRuntime.isNumber(arg0Value))) && (!(JSGuards.isNumberLong(arg0Value)))) {
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToArrayLengthNode.typeNotNumber(Object)] */;
            this.state_0_ = state_0;
            return ToArrayLengthNode.typeNotNumber(arg0Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @NeverDefault
    public static ToArrayLengthNode create() {
        return new ToArrayLengthNodeGen();
    }

}
