// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSToInt32Node#doInteger}
 *     Activation probability: 0.11213
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToInt32Node#doSafeInteger}
 *     Activation probability: 0.10551
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToInt32Node#doBoolean}
 *     Activation probability: 0.09890
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToInt32Node#doLong}
 *     Activation probability: 0.09228
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToInt32Node#doLongNotSafeInteger}
 *     Activation probability: 0.08566
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToInt32Node#doDoubleFitsInt}
 *     Activation probability: 0.07904
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doDoubleRepresentableAsSafeInteger}
 *     Activation probability: 0.07243
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doDoubleRepresentableAsLong}
 *     Activation probability: 0.06581
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doDouble}
 *     Activation probability: 0.05919
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doUndefined}
 *     Activation probability: 0.05257
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doNull}
 *     Activation probability: 0.04596
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doString}
 *     Activation probability: 0.03934
 *     With/without class size: 4/4 bytes
 *   Specialization {@link JSToInt32Node#doSymbol}
 *     Activation probability: 0.03272
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doBigInt}
 *     Activation probability: 0.02610
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToInt32Node#doJSObject}
 *     Activation probability: 0.01949
 *     With/without class size: 4/4 bytes
 *   Specialization {@link JSToInt32Node#doForeignObject}
 *     Activation probability: 0.01287
 *     With/without class size: 4/8 bytes
 * </pre> */
@GeneratedBy(JSToInt32Node.class)
@SuppressWarnings("javadoc")
public final class JSToInt32NodeGen extends JSToInt32Node {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSToInt32Node#doInteger}
     *   1: SpecializationActive {@link JSToInt32Node#doSafeInteger}
     *   2: SpecializationActive {@link JSToInt32Node#doBoolean}
     *   3: SpecializationActive {@link JSToInt32Node#doLong}
     *   4: SpecializationActive {@link JSToInt32Node#doLongNotSafeInteger}
     *   5: SpecializationActive {@link JSToInt32Node#doDoubleFitsInt}
     *   6: SpecializationActive {@link JSToInt32Node#doDoubleRepresentableAsSafeInteger}
     *   7: SpecializationActive {@link JSToInt32Node#doDoubleRepresentableAsLong}
     *   8: SpecializationActive {@link JSToInt32Node#doDouble}
     *   9: SpecializationActive {@link JSToInt32Node#doUndefined}
     *   10: SpecializationActive {@link JSToInt32Node#doNull}
     *   11: SpecializationActive {@link JSToInt32Node#doString}
     *   12: SpecializationActive {@link JSToInt32Node#doSymbol}
     *   13: SpecializationActive {@link JSToInt32Node#doBigInt}
     *   14: SpecializationActive {@link JSToInt32Node#doJSObject}
     *   15: SpecializationActive {@link JSToInt32Node#doForeignObject}
     *   16-18: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToInt32Node#doString}
     *   Parameter: {@link JSStringToNumberNode} stringToNumberNode</pre> */
    @Child private JSStringToNumberNode string_stringToNumberNode_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToInt32Node#doJSObject}
     *   Parameter: {@link JSToDoubleNode} toDoubleNode</pre> */
    @Child private JSToDoubleNode jSObject_toDoubleNode_;
    @Child private ForeignObjectData foreignObject_cache;

    private JSToInt32NodeGen() {
    }

    @Override
    public int executeInt(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111111111111111) != 0 /* is SpecializationActive[JSToInt32Node.doInteger(int)] || SpecializationActive[JSToInt32Node.doSafeInteger(SafeInteger)] || SpecializationActive[JSToInt32Node.doBoolean(boolean)] || SpecializationActive[JSToInt32Node.doLong(long)] || SpecializationActive[JSToInt32Node.doLongNotSafeInteger(long)] || SpecializationActive[JSToInt32Node.doDoubleFitsInt(double)] || SpecializationActive[JSToInt32Node.doDoubleRepresentableAsSafeInteger(double)] || SpecializationActive[JSToInt32Node.doDoubleRepresentableAsLong(double)] || SpecializationActive[JSToInt32Node.doDouble(double)] || SpecializationActive[JSToInt32Node.doUndefined(Object)] || SpecializationActive[JSToInt32Node.doNull(Object)] || SpecializationActive[JSToInt32Node.doString(TruffleString, JSStringToNumberNode)] || SpecializationActive[JSToInt32Node.doSymbol(Symbol)] || SpecializationActive[JSToInt32Node.doBigInt(BigInt)] || SpecializationActive[JSToInt32Node.doJSObject(JSObject, JSToDoubleNode)] || SpecializationActive[JSToInt32Node.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToInt32Node.doInteger(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return doInteger(arg0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToInt32Node.doSafeInteger(SafeInteger)] */ && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                return doSafeInteger(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToInt32Node.doBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return doBoolean(arg0Value_);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSToInt32Node.doLong(long)] || SpecializationActive[JSToInt32Node.doLongNotSafeInteger(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToInt32Node.doLong(long)] */) {
                    if ((JSRuntime.isSafeInteger(arg0Value_))) {
                        return JSToInt32Node.doLong(arg0Value_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToInt32Node.doLongNotSafeInteger(long)] */) {
                    if ((!(JSRuntime.isSafeInteger(arg0Value_)))) {
                        return JSToInt32Node.doLongNotSafeInteger(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b111100000) != 0 /* is SpecializationActive[JSToInt32Node.doDoubleFitsInt(double)] || SpecializationActive[JSToInt32Node.doDoubleRepresentableAsSafeInteger(double)] || SpecializationActive[JSToInt32Node.doDoubleRepresentableAsLong(double)] || SpecializationActive[JSToInt32Node.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToInt32Node.doDoubleFitsInt(double)] */) {
                    if ((!(JSGuards.isDoubleLargerThan2e32(arg0Value_)))) {
                        return doDoubleFitsInt(arg0Value_);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToInt32Node.doDoubleRepresentableAsSafeInteger(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (JSGuards.isDoubleRepresentableAsLong(arg0Value_)) && (JSGuards.isDoubleSafeInteger(arg0Value_))) {
                        return doDoubleRepresentableAsSafeInteger(arg0Value_);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToInt32Node.doDoubleRepresentableAsLong(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (JSGuards.isDoubleRepresentableAsLong(arg0Value_))) {
                        return doDoubleRepresentableAsLong(arg0Value_);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToInt32Node.doDouble(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (!(JSGuards.isDoubleRepresentableAsLong(arg0Value_)))) {
                        return doDouble(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[JSToInt32Node.doUndefined(Object)] || SpecializationActive[JSToInt32Node.doNull(Object)] */) {
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToInt32Node.doUndefined(Object)] */) {
                    if ((JSGuards.isUndefined(arg0Value))) {
                        return doUndefined(arg0Value);
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToInt32Node.doNull(Object)] */) {
                    if ((JSGuards.isJSNull(arg0Value))) {
                        return doNull(arg0Value);
                    }
                }
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToInt32Node.doString(TruffleString, JSStringToNumberNode)] */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                {
                    JSStringToNumberNode stringToNumberNode__ = this.string_stringToNumberNode_;
                    if (stringToNumberNode__ != null) {
                        return doString(arg0Value_, stringToNumberNode__);
                    }
                }
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSToInt32Node.doSymbol(Symbol)] */ && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                return doSymbol(arg0Value_);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSToInt32Node.doBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return doBigInt(arg0Value_);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[JSToInt32Node.doJSObject(JSObject, JSToDoubleNode)] */ && arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject) arg0Value;
                {
                    JSToDoubleNode toDoubleNode__ = this.jSObject_toDoubleNode_;
                    if (toDoubleNode__ != null) {
                        return doJSObject(arg0Value_, toDoubleNode__);
                    }
                }
            }
            if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[JSToInt32Node.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */) {
                ForeignObjectData s15_ = this.foreignObject_cache;
                if (s15_ != null) {
                    if ((JSRuntime.isForeignObject(arg0Value))) {
                        return JSToInt32Node.doForeignObject(arg0Value, s15_.toPrimitiveNode_, s15_.toInt32Node_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private int executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSToInt32Node.doInteger(int)] */;
            this.state_0_ = state_0;
            return doInteger(arg0Value_);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSToInt32Node.doSafeInteger(SafeInteger)] */;
            this.state_0_ = state_0;
            return doSafeInteger(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSToInt32Node.doBoolean(boolean)] */;
            this.state_0_ = state_0;
            return doBoolean(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            if ((JSRuntime.isSafeInteger(arg0Value_))) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToInt32Node.doLong(long)] */;
                this.state_0_ = state_0;
                return JSToInt32Node.doLong(arg0Value_);
            }
            if ((!(JSRuntime.isSafeInteger(arg0Value_)))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToInt32Node.doLongNotSafeInteger(long)] */;
                this.state_0_ = state_0;
                return JSToInt32Node.doLongNotSafeInteger(arg0Value_);
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                if ((!(JSGuards.isDoubleLargerThan2e32(arg0Value_)))) {
                    state_0 = (state_0 | (doubleCast0 << 16) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[JSToInt32Node.doDoubleFitsInt(double)] */;
                    this.state_0_ = state_0;
                    return doDoubleFitsInt(arg0Value_);
                }
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[JSToInt32Node.doDoubleRepresentableAsLong(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (JSGuards.isDoubleRepresentableAsLong(arg0Value_)) && (JSGuards.isDoubleSafeInteger(arg0Value_))) {
                        state_0 = (state_0 | (doubleCast0 << 16) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSToInt32Node.doDoubleRepresentableAsSafeInteger(double)] */;
                        this.state_0_ = state_0;
                        return doDoubleRepresentableAsSafeInteger(arg0Value_);
                    }
                }
                if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (JSGuards.isDoubleRepresentableAsLong(arg0Value_))) {
                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSToInt32Node.doDoubleRepresentableAsSafeInteger(double)] */;
                    state_0 = (state_0 | (doubleCast0 << 16) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSToInt32Node.doDoubleRepresentableAsLong(double)] */;
                    this.state_0_ = state_0;
                    return doDoubleRepresentableAsLong(arg0Value_);
                }
                if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (!(JSGuards.isDoubleRepresentableAsLong(arg0Value_)))) {
                    state_0 = (state_0 | (doubleCast0 << 16) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSToInt32Node.doDouble(double)] */;
                    this.state_0_ = state_0;
                    return doDouble(arg0Value_);
                }
            }
        }
        if ((JSGuards.isUndefined(arg0Value))) {
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSToInt32Node.doUndefined(Object)] */;
            this.state_0_ = state_0;
            return doUndefined(arg0Value);
        }
        if ((JSGuards.isJSNull(arg0Value))) {
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSToInt32Node.doNull(Object)] */;
            this.state_0_ = state_0;
            return doNull(arg0Value);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString) arg0Value;
            JSStringToNumberNode stringToNumberNode__ = this.insert((JSStringToNumberNode.create()));
            Objects.requireNonNull(stringToNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.string_stringToNumberNode_ = stringToNumberNode__;
            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSToInt32Node.doString(TruffleString, JSStringToNumberNode)] */;
            this.state_0_ = state_0;
            return doString(arg0Value_, stringToNumberNode__);
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol) arg0Value;
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[JSToInt32Node.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            return doSymbol(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[JSToInt32Node.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return doBigInt(arg0Value_);
        }
        if (arg0Value instanceof JSObject) {
            JSObject arg0Value_ = (JSObject) arg0Value;
            JSToDoubleNode toDoubleNode__ = this.insert((JSToDoubleNode.create()));
            Objects.requireNonNull(toDoubleNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.jSObject_toDoubleNode_ = toDoubleNode__;
            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[JSToInt32Node.doJSObject(JSObject, JSToDoubleNode)] */;
            this.state_0_ = state_0;
            return doJSObject(arg0Value_, toDoubleNode__);
        }
        if ((JSRuntime.isForeignObject(arg0Value))) {
            ForeignObjectData s15_ = this.insert(new ForeignObjectData());
            JSToPrimitiveNode toPrimitiveNode__ = s15_.insert((JSToPrimitiveNode.create()));
            Objects.requireNonNull(toPrimitiveNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s15_.toPrimitiveNode_ = toPrimitiveNode__;
            JSToInt32Node toInt32Node__ = s15_.insert((JSToInt32Node.create()));
            Objects.requireNonNull(toInt32Node__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s15_.toInt32Node_ = toInt32Node__;
            VarHandle.storeStoreFence();
            this.foreignObject_cache = s15_;
            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[JSToInt32Node.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */;
            this.state_0_ = state_0;
            return JSToInt32Node.doForeignObject(arg0Value, toPrimitiveNode__, toInt32Node__);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
    }

    @NeverDefault
    public static JSToInt32Node create() {
        return new JSToInt32NodeGen();
    }

    @NeverDefault
    public static JSToInt32Node getUncached() {
        return JSToInt32NodeGen.UNCACHED;
    }

    @GeneratedBy(JSToInt32Node.class)
    @DenyReplace
    private static final class ForeignObjectData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32Node#doForeignObject}
         *   Parameter: {@link JSToPrimitiveNode} toPrimitiveNode</pre> */
        @Child JSToPrimitiveNode toPrimitiveNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32Node#doForeignObject}
         *   Parameter: {@link JSToInt32Node} toInt32Node</pre> */
        @Child JSToInt32Node toInt32Node_;

        ForeignObjectData() {
        }

    }
    @GeneratedBy(JSToInt32Node.class)
    @DenyReplace
    private static final class Uncached extends JSToInt32Node implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public int executeInt(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return doInteger(arg0Value_);
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                return doSafeInteger(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return doBoolean(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((JSRuntime.isSafeInteger(arg0Value_))) {
                    return JSToInt32Node.doLong(arg0Value_);
                }
                if ((!(JSRuntime.isSafeInteger(arg0Value_)))) {
                    return JSToInt32Node.doLongNotSafeInteger(arg0Value_);
                }
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                if ((!(JSGuards.isDoubleLargerThan2e32(arg0Value_)))) {
                    return doDoubleFitsInt(arg0Value_);
                }
                if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (JSGuards.isDoubleRepresentableAsLong(arg0Value_)) && (JSGuards.isDoubleSafeInteger(arg0Value_))) {
                    return doDoubleRepresentableAsSafeInteger(arg0Value_);
                }
                if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (JSGuards.isDoubleRepresentableAsLong(arg0Value_))) {
                    return doDoubleRepresentableAsLong(arg0Value_);
                }
                if ((JSGuards.isDoubleLargerThan2e32(arg0Value_)) && (!(JSGuards.isDoubleRepresentableAsLong(arg0Value_)))) {
                    return doDouble(arg0Value_);
                }
            }
            if ((JSGuards.isUndefined(arg0Value))) {
                return doUndefined(arg0Value);
            }
            if ((JSGuards.isJSNull(arg0Value))) {
                return doNull(arg0Value);
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return doString(arg0Value_, (JSStringToNumberNodeGen.getUncached()));
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                return doSymbol(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return doBigInt(arg0Value_);
            }
            if (arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject) arg0Value;
                return doJSObject(arg0Value_, (JSToDoubleNodeGen.getUncached()));
            }
            if ((JSRuntime.isForeignObject(arg0Value))) {
                return JSToInt32Node.doForeignObject(arg0Value, (JSToPrimitiveNode.getUncached()), (JSToInt32NodeGen.getUncached()));
            }
            throw newUnsupportedSpecializationException1(this, arg0Value);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link JSToInt32UnaryNode#doInteger}
     *     Activation probability: 0.10588
     *     With/without class size: 5/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doSafeInteger}
     *     Activation probability: 0.10000
     *     With/without class size: 5/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doBoolean}
     *     Activation probability: 0.09412
     *     With/without class size: 5/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doLong}
     *     Activation probability: 0.08824
     *     With/without class size: 5/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doLongNotSafeInteger}
     *     Activation probability: 0.08235
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doDoubleFitsInt}
     *     Activation probability: 0.07647
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doDoubleRepresentableAsSafeInteger}
     *     Activation probability: 0.07059
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doDoubleRepresentableAsLong}
     *     Activation probability: 0.06471
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doDouble}
     *     Activation probability: 0.05882
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doUndefined}
     *     Activation probability: 0.05294
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doNull}
     *     Activation probability: 0.04706
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doString}
     *     Activation probability: 0.04118
     *     With/without class size: 4/4 bytes
     *   Specialization {@link JSToInt32UnaryNode#doSymbol}
     *     Activation probability: 0.03529
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doBigInt}
     *     Activation probability: 0.02941
     *     With/without class size: 4/0 bytes
     *   Specialization {@link JSToInt32UnaryNode#doOverloadedOperator}
     *     Activation probability: 0.02353
     *     With/without class size: 4/4 bytes
     *   Specialization {@link JSToInt32UnaryNode#doJSObject}
     *     Activation probability: 0.01765
     *     With/without class size: 4/4 bytes
     *   Specialization {@link JSToInt32UnaryNode#doForeignObject}
     *     Activation probability: 0.01176
     *     With/without class size: 4/4 bytes
     * </pre> */
    @GeneratedBy(JSToInt32UnaryNode.class)
    @SuppressWarnings("javadoc")
    public static final class JSToInt32UnaryNodeGen extends JSToInt32UnaryNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSToInt32UnaryNode#doInteger}
         *   1: SpecializationActive {@link JSToInt32UnaryNode#doSafeInteger}
         *   2: SpecializationActive {@link JSToInt32UnaryNode#doBoolean}
         *   3: SpecializationActive {@link JSToInt32UnaryNode#doLong}
         *   4: SpecializationActive {@link JSToInt32UnaryNode#doLongNotSafeInteger}
         *   5: SpecializationActive {@link JSToInt32UnaryNode#doDoubleFitsInt}
         *   6: SpecializationActive {@link JSToInt32UnaryNode#doDoubleRepresentableAsSafeInteger}
         *   7: SpecializationActive {@link JSToInt32UnaryNode#doDoubleRepresentableAsLong}
         *   8: SpecializationActive {@link JSToInt32UnaryNode#doDouble}
         *   9: SpecializationActive {@link JSToInt32UnaryNode#doUndefined}
         *   10: SpecializationActive {@link JSToInt32UnaryNode#doNull}
         *   11: SpecializationActive {@link JSToInt32UnaryNode#doString}
         *   12: SpecializationActive {@link JSToInt32UnaryNode#doSymbol}
         *   13: SpecializationActive {@link JSToInt32UnaryNode#doBigInt}
         *   14: SpecializationActive {@link JSToInt32UnaryNode#doOverloadedOperator}
         *   15: SpecializationActive {@link JSToInt32UnaryNode#doJSObject}
         *   16: SpecializationActive {@link JSToInt32UnaryNode#doForeignObject}
         *   17-19: ImplicitCast[type=double, index=0]
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32UnaryNode#doOverloadedOperator}
         *   Parameter: {@link JSToInt32Node} toInt32Node</pre> */
        @Child private JSToInt32Node toInt32Node;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32UnaryNode#doString}
         *   Parameter: {@link JSStringToNumberNode} stringToNumberNode</pre> */
        @Child private JSStringToNumberNode string_stringToNumberNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32UnaryNode#doOverloadedOperator}
         *   Parameter: {@link JSOverloadedBinaryNode} overloadedOperatorNode</pre> */
        @Child private JSOverloadedBinaryNode overloadedOperator_overloadedOperatorNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32UnaryNode#doJSObject}
         *   Parameter: {@link JSToDoubleNode} toDoubleNode</pre> */
        @Child private JSToDoubleNode jSObject_toDoubleNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToInt32UnaryNode#doForeignObject}
         *   Parameter: {@link JSToPrimitiveNode} toPrimitiveNode</pre> */
        @Child private JSToPrimitiveNode foreignObject_toPrimitiveNode_;

        private JSToInt32UnaryNodeGen(JavaScriptNode operand, boolean bitwiseOr) {
            super(operand, bitwiseOr);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1fffe) == 0 /* only-active SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] */ && ((state_0 & 0x1ffff) != 0  /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */)) {
                return executeInt_int0(state_0, frameValue);
            } else if ((state_0 & 0x1fffb) == 0 /* only-active SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] */ && ((state_0 & 0x1ffff) != 0  /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */)) {
                return executeInt_boolean1(state_0, frameValue);
            } else if ((state_0 & 0x1fe1f) == 0 /* only-active SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] */ && ((state_0 & 0x1ffff) != 0  /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */)) {
                return executeInt_double2(state_0, frameValue);
            } else {
                return executeInt_generic3(state_0, frameValue);
            }
        }

        private int executeInt_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int operandNodeValue_;
            try {
                operandNodeValue_ = super.operandNode.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] */;
            return doInteger(operandNodeValue_);
        }

        private int executeInt_boolean1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean operandNodeValue_;
            try {
                operandNodeValue_ = super.operandNode.executeBoolean(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] */;
            return doBoolean(operandNodeValue_);
        }

        private int executeInt_double2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int operandNodeValue_int = 0;
            double operandNodeValue_;
            try {
                if ((state_0 & 0xc0000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffff) != 0  /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */)) {
                    operandNodeValue_ = super.operandNode.executeDouble(frameValue);
                } else if ((state_0 & 0xa0000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffff) != 0  /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */)) {
                    operandNodeValue_int = super.operandNode.executeInt(frameValue);
                    operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
                } else {
                    Object operandNodeValue__ = super.operandNode.execute(frameValue);
                    operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0b111100000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] */) {
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] */) {
                    if ((!(JSGuards.isDoubleLargerThan2e32(operandNodeValue_)))) {
                        return doDoubleFitsInt(operandNodeValue_);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) && (JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) && (JSGuards.isDoubleSafeInteger(operandNodeValue_))) {
                        return doDoubleRepresentableAsSafeInteger(operandNodeValue_);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) && (JSGuards.isDoubleRepresentableAsLong(operandNodeValue_))) {
                        return doDoubleRepresentableAsLong(operandNodeValue_);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] */) {
                    if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) && (!(JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)))) {
                        return doDouble(operandNodeValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state_0 & 0xa0000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffff) != 0  /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] && SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */) ? (Object) operandNodeValue_int : (Object) operandNodeValue_));
        }

        private int executeInt_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object operandNodeValue_ = super.operandNode.execute(frameValue);
            if ((state_0 & 0x1ffff) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] */ && operandNodeValue_ instanceof Integer) {
                    int operandNodeValue__ = (int) operandNodeValue_;
                    return doInteger(operandNodeValue__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] */ && operandNodeValue_ instanceof SafeInteger) {
                    SafeInteger operandNodeValue__ = (SafeInteger) operandNodeValue_;
                    return doSafeInteger(operandNodeValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] */ && operandNodeValue_ instanceof Boolean) {
                    boolean operandNodeValue__ = (boolean) operandNodeValue_;
                    return doBoolean(operandNodeValue__);
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] */ && operandNodeValue_ instanceof Long) {
                    long operandNodeValue__ = (long) operandNodeValue_;
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] */) {
                        if ((JSRuntime.isSafeInteger(operandNodeValue__))) {
                            return JSToInt32UnaryNode.doLong(operandNodeValue__);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] */) {
                        if ((!(JSRuntime.isSafeInteger(operandNodeValue__)))) {
                            return JSToInt32UnaryNode.doLongNotSafeInteger(operandNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b111100000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                    double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] */) {
                        if ((!(JSGuards.isDoubleLargerThan2e32(operandNodeValue__)))) {
                            return doDoubleFitsInt(operandNodeValue__);
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] */) {
                        if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue__)) && (JSGuards.isDoubleRepresentableAsLong(operandNodeValue__)) && (JSGuards.isDoubleSafeInteger(operandNodeValue__))) {
                            return doDoubleRepresentableAsSafeInteger(operandNodeValue__);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] */) {
                        if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue__)) && (JSGuards.isDoubleRepresentableAsLong(operandNodeValue__))) {
                            return doDoubleRepresentableAsLong(operandNodeValue__);
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] */) {
                        if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue__)) && (!(JSGuards.isDoubleRepresentableAsLong(operandNodeValue__)))) {
                            return doDouble(operandNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] || SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] */) {
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] */) {
                        if ((JSGuards.isUndefined(operandNodeValue_))) {
                            return doUndefined(operandNodeValue_);
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] */) {
                        if ((JSGuards.isJSNull(operandNodeValue_))) {
                            return doNull(operandNodeValue_);
                        }
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] */ && operandNodeValue_ instanceof TruffleString) {
                    TruffleString operandNodeValue__ = (TruffleString) operandNodeValue_;
                    {
                        JSStringToNumberNode stringToNumberNode__ = this.string_stringToNumberNode_;
                        if (stringToNumberNode__ != null) {
                            return doString(operandNodeValue__, stringToNumberNode__);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] */ && operandNodeValue_ instanceof Symbol) {
                    Symbol operandNodeValue__ = (Symbol) operandNodeValue_;
                    return doSymbol(operandNodeValue__);
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                    BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                    return doBigInt(operandNodeValue__);
                }
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] */ && operandNodeValue_ instanceof JSOverloadedOperatorsObject) {
                    JSOverloadedOperatorsObject operandNodeValue__ = (JSOverloadedOperatorsObject) operandNodeValue_;
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloadedOperator_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            JSToInt32Node toInt32Node_ = this.toInt32Node;
                            if (toInt32Node_ != null) {
                                assert DSLSupport.assertIdempotence((isBitwiseOr()));
                                return doOverloadedOperator(operandNodeValue__, overloadedOperatorNode__, toInt32Node_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] */ && operandNodeValue_ instanceof JSObject) {
                    JSObject operandNodeValue__ = (JSObject) operandNodeValue_;
                    {
                        JSToDoubleNode toDoubleNode__ = this.jSObject_toDoubleNode_;
                        if (toDoubleNode__ != null) {
                            if ((!(isBitwiseOr()) || !(hasOverloadedOperators(operandNodeValue__)))) {
                                return doJSObject(operandNodeValue__, toDoubleNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0x10000) != 0 /* is SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */) {
                    {
                        JSToPrimitiveNode toPrimitiveNode__ = this.foreignObject_toPrimitiveNode_;
                        if (toPrimitiveNode__ != null) {
                            JSToInt32Node toInt32Node_1 = this.toInt32Node;
                            if (toInt32Node_1 != null) {
                                if ((JSRuntime.isForeignObject(operandNodeValue_))) {
                                    return JSToInt32UnaryNode.doForeignObject(operandNodeValue_, toPrimitiveNode__, toInt32Node_1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
            return;
        }

        private int executeAndSpecialize(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doInteger(int)] */;
                this.state_0_ = state_0;
                return doInteger(operandNodeValue_);
            }
            if (operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSafeInteger(SafeInteger)] */;
                this.state_0_ = state_0;
                return doSafeInteger(operandNodeValue_);
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_ = (boolean) operandNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBoolean(boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(operandNodeValue_);
            }
            if (operandNodeValue instanceof Long) {
                long operandNodeValue_ = (long) operandNodeValue;
                if ((JSRuntime.isSafeInteger(operandNodeValue_))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLong(long)] */;
                    this.state_0_ = state_0;
                    return JSToInt32UnaryNode.doLong(operandNodeValue_);
                }
                if ((!(JSRuntime.isSafeInteger(operandNodeValue_)))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(long)] */;
                    this.state_0_ = state_0;
                    return JSToInt32UnaryNode.doLongNotSafeInteger(operandNodeValue_);
                }
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                    double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                    if ((!(JSGuards.isDoubleLargerThan2e32(operandNodeValue_)))) {
                        state_0 = (state_0 | (doubleCast0 << 17) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleFitsInt(double)] */;
                        this.state_0_ = state_0;
                        return doDoubleFitsInt(operandNodeValue_);
                    }
                    if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] */) {
                        if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) && (JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) && (JSGuards.isDoubleSafeInteger(operandNodeValue_))) {
                            state_0 = (state_0 | (doubleCast0 << 17) /* set-int ImplicitCast[type=double, index=0] */);
                            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] */;
                            this.state_0_ = state_0;
                            return doDoubleRepresentableAsSafeInteger(operandNodeValue_);
                        }
                    }
                    if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) && (JSGuards.isDoubleRepresentableAsLong(operandNodeValue_))) {
                        state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsSafeInteger(double)] */;
                        state_0 = (state_0 | (doubleCast0 << 17) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDoubleRepresentableAsLong(double)] */;
                        this.state_0_ = state_0;
                        return doDoubleRepresentableAsLong(operandNodeValue_);
                    }
                    if ((JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) && (!(JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)))) {
                        state_0 = (state_0 | (doubleCast0 << 17) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doDouble(double)] */;
                        this.state_0_ = state_0;
                        return doDouble(operandNodeValue_);
                    }
                }
            }
            if ((JSGuards.isUndefined(operandNodeValue))) {
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doUndefined(Object)] */;
                this.state_0_ = state_0;
                return doUndefined(operandNodeValue);
            }
            if ((JSGuards.isJSNull(operandNodeValue))) {
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doNull(Object)] */;
                this.state_0_ = state_0;
                return doNull(operandNodeValue);
            }
            if (operandNodeValue instanceof TruffleString) {
                TruffleString operandNodeValue_ = (TruffleString) operandNodeValue;
                JSStringToNumberNode stringToNumberNode__ = this.insert((JSStringToNumberNode.create()));
                Objects.requireNonNull(stringToNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_stringToNumberNode_ = stringToNumberNode__;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doString(TruffleString, JSStringToNumberNode)] */;
                this.state_0_ = state_0;
                return doString(operandNodeValue_, stringToNumberNode__);
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_ = (Symbol) operandNodeValue;
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doSymbol(Symbol)] */;
                this.state_0_ = state_0;
                return doSymbol(operandNodeValue_);
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doBigInt(BigInt)] */;
                this.state_0_ = state_0;
                return doBigInt(operandNodeValue_);
            }
            if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
                if ((isBitwiseOr())) {
                    JSOverloadedBinaryNode overloadedOperatorNode__ = this.insert((JSOverloadedBinaryNode.createNumeric(getOverloadedOperatorName())));
                    Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.overloadedOperator_overloadedOperatorNode_ = overloadedOperatorNode__;
                    JSToInt32Node toInt32Node_;
                    JSToInt32Node toInt32Node__shared = this.toInt32Node;
                    if (toInt32Node__shared != null) {
                        toInt32Node_ = toInt32Node__shared;
                    } else {
                        toInt32Node_ = this.insert((JSToInt32Node.create()));
                        if (toInt32Node_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toInt32Node == null) {
                        VarHandle.storeStoreFence();
                        this.toInt32Node = toInt32Node_;
                    }
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode, JSToInt32Node)] */;
                    this.state_0_ = state_0;
                    return doOverloadedOperator(operandNodeValue_, overloadedOperatorNode__, toInt32Node_);
                }
            }
            if (operandNodeValue instanceof JSObject) {
                JSObject operandNodeValue_ = (JSObject) operandNodeValue;
                if ((!(isBitwiseOr()) || !(hasOverloadedOperators(operandNodeValue_)))) {
                    JSToDoubleNode toDoubleNode__ = this.insert((JSToDoubleNode.create()));
                    Objects.requireNonNull(toDoubleNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.jSObject_toDoubleNode_ = toDoubleNode__;
                    state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doJSObject(JSObject, JSToDoubleNode)] */;
                    this.state_0_ = state_0;
                    return doJSObject(operandNodeValue_, toDoubleNode__);
                }
            }
            if ((JSRuntime.isForeignObject(operandNodeValue))) {
                JSToPrimitiveNode toPrimitiveNode__ = this.insert((JSToPrimitiveNode.create()));
                Objects.requireNonNull(toPrimitiveNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.foreignObject_toPrimitiveNode_ = toPrimitiveNode__;
                JSToInt32Node toInt32Node_1;
                JSToInt32Node toInt32Node_1_shared = this.toInt32Node;
                if (toInt32Node_1_shared != null) {
                    toInt32Node_1 = toInt32Node_1_shared;
                } else {
                    toInt32Node_1 = this.insert((JSToInt32Node.create()));
                    if (toInt32Node_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.toInt32Node == null) {
                    VarHandle.storeStoreFence();
                    this.toInt32Node = toInt32Node_1;
                }
                state_0 = state_0 | 0x10000 /* add SpecializationActive[JSToInt32Node.JSToInt32UnaryNode.doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)] */;
                this.state_0_ = state_0;
                return JSToInt32UnaryNode.doForeignObject(operandNodeValue, toPrimitiveNode__, toInt32Node_1);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
        }

        @NeverDefault
        public static JSToInt32UnaryNode create(JavaScriptNode operand, boolean bitwiseOr) {
            return new JSToInt32UnaryNodeGen(operand, bitwiseOr);
        }

    }
}
