/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.SerializedData;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.graalvm.collections.EconomicSet;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;

public final class WorkerAgent
extends JSAgent {
    private static final SerializedData WAKE_UP_MESSAGE = new SerializedData((Object)Undefined.instance);
    private final TruffleContext workerContext;
    private final BlockingQueue<SerializedData> outMessages = new LinkedBlockingQueue<SerializedData>();
    private final BlockingQueue<SerializedData> inMessages = new LinkedBlockingQueue<SerializedData>();
    private volatile boolean finished;

    @CompilerDirectives.TruffleBoundary
    public WorkerAgent() {
        super(true);
        TruffleContext truffleContext;
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        TruffleLanguage.Env parentEnv = realm.getEnv();
        this.workerContext = truffleContext = parentEnv.newInnerContextBuilder(new String[0]).inheritAllAccess(true).build();
    }

    public String toString() {
        return "WorkerAgent{signifier=" + this.getSignifier() + "}";
    }

    @CompilerDirectives.TruffleBoundary
    public void start(final String code) {
        this.workerContext.initializePublic(null, "js");
        JSRealm rlm = JavaScriptLanguage.getCurrentJSRealm();
        rlm.getAgent().registerChildAgent(this);
        Thread thread = rlm.getEnv().newTruffleThreadBuilder(new Runnable(){
            final /* synthetic */ WorkerAgent this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
                    realm.setAgent(this.this$0);
                    if (realm.getContextOptions().isTestV8Mode()) {
                        1.findAndEvalV8Mockup();
                    }
                    JSFunctionObject postMessage = realm.lookupFunction(GlobalBuiltins.GLOBAL_WORKER, Strings.POST_MESSAGE);
                    JSObjectUtil.putDataProperty(realm.getGlobalObject(), Strings.POST_MESSAGE, (Object)postMessage, JSAttributes.getDefaultNotEnumerable());
                    Source workerSource = Source.newBuilder((String)"js", (CharSequence)code, (String)"worker").build();
                    CallTarget callTarget = realm.getEnv().parsePublic(workerSource, new String[0]);
                    callTarget.call(new Object[0]);
                    this.this$0.processAllPromises(true);
                    Object messageHandler = JSObject.get(realm.getGlobalObject(), Strings.ONMESSAGE);
                    if (JSRuntime.isCallable(messageHandler)) {
                        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WorkerProcessMessage, c -> WorkerAgent.createProcessMessage(c));
                        JSFunctionObject processMessage = JSFunction.create(realm, functionData);
                        while (true) {
                            SerializedData message;
                            if ((message = this.this$0.inMessages.take()) != WAKE_UP_MESSAGE) {
                                Object deserialized = message.deserialize(realm);
                                JSFunction.call(processMessage, (Object)Undefined.instance, new Object[]{deserialized});
                            }
                            this.this$0.processAllPromises(true);
                        }
                    }
                }
                catch (InterruptedException realm) {
                }
                catch (AbstractTruffleException e) {
                    try {
                        ExceptionType type = InteropLibrary.getUncached((Object)((Object)e)).getExceptionType((Object)e);
                        if (type != ExceptionType.INTERRUPT && type != ExceptionType.EXIT) {
                            System.err.println("Uncaught error from " + String.valueOf(Thread.currentThread()) + ": " + e.getMessage());
                        }
                    }
                    catch (UnsupportedMessageException unsupportedMessageException) {
                        // empty catch block
                    }
                }
                finally {
                    this.this$0.markFinished();
                }
            }

            private static void findAndEvalV8Mockup() throws InterruptedException {
                Context context = Context.getCurrent();
                for (org.graalvm.polyglot.Source source : context.getEngine().getCachedSources()) {
                    if (!source.getName().startsWith("v8mockup")) continue;
                    try {
                        context.eval(source);
                        break;
                    }
                    catch (PolyglotException ex) {
                        if (ex.isCancelled() || ex.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        throw Errors.shouldNotReachHere(ex);
                    }
                }
            }
        }).context(this.workerContext).build();
        thread.setName("Worker-Thread-" + this.getSignifier());
        thread.start();
    }

    private static JSFunctionData createProcessMessage(JSContext context) {
        class ProcessMessageNode
        extends JavaScriptRootNode {
            @Node.Child
            PropertyGetNode getOnMessage;
            @Node.Child
            IsCallableNode isCallable;
            @Node.Child
            JSFunctionCallNode call;
            final /* synthetic */ JSContext val$context;

            ProcessMessageNode(JSContext jSContext) {
                this.val$context = jSContext;
                this.getOnMessage = PropertyGetNode.create(Strings.ONMESSAGE, this.val$context);
                this.isCallable = IsCallableNode.create();
                this.call = JSFunctionCallNode.createCall();
            }

            public Object execute(VirtualFrame frame) {
                Object onMessage = this.getOnMessage.getValue((Object)this.getRealm().getGlobalObject());
                if (this.isCallable.executeBoolean(onMessage)) {
                    Object message = JSFrameUtil.getArgumentsArray((Frame)frame)[0];
                    this.call.executeCall(JSArguments.create((Object)Undefined.instance, onMessage, message));
                }
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new ProcessMessageNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    @Override
    public void wake() {
        this.inMessages.add(WAKE_UP_MESSAGE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void terminate() {
        this.markFinished();
        this.workerContext.closeCancelled(null, "worker terminated");
    }

    private void markFinished() {
        this.finished = true;
        this.outMessages.add(new SerializedData((Object)Undefined.instance));
    }

    @CompilerDirectives.TruffleBoundary
    public void postInMessage(Object message, EconomicSet<JSArrayBufferObject> transferSet) {
        this.inMessages.add(new SerializedData(message, transferSet));
    }

    @CompilerDirectives.TruffleBoundary
    public void postOutMessage(Object message) {
        this.outMessages.add(new SerializedData(message));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOutMessage(JSRealm realm) {
        Object message = Undefined.instance;
        if (!this.finished || !this.outMessages.isEmpty()) {
            try {
                message = this.outMessages.take().deserialize(realm);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return message;
    }
}

