// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link RequireObjectCoercibleNode#doInt}
 *     Activation probability: 0.13626
 *     With/without class size: 5/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doSafeInteger}
 *     Activation probability: 0.12637
 *     With/without class size: 5/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doLong}
 *     Activation probability: 0.11648
 *     With/without class size: 5/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doDouble}
 *     Activation probability: 0.10659
 *     With/without class size: 5/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doTString}
 *     Activation probability: 0.09670
 *     With/without class size: 5/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doBoolean}
 *     Activation probability: 0.08681
 *     With/without class size: 5/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doSymbol}
 *     Activation probability: 0.07692
 *     With/without class size: 4/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doBigInt}
 *     Activation probability: 0.06703
 *     With/without class size: 4/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doCachedJSClass}
 *     Activation probability: 0.05714
 *     With/without class size: 4/4 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doJSObject}
 *     Activation probability: 0.04725
 *     With/without class size: 4/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doForeignObject}
 *     Activation probability: 0.03736
 *     With/without class size: 4/4 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doForeignObject}
 *     Activation probability: 0.02747
 *     With/without class size: 4/0 bytes
 *   Specialization {@link RequireObjectCoercibleNode#doNullOrUndefined}
 *     Activation probability: 0.01758
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(RequireObjectCoercibleNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class RequireObjectCoercibleNodeGen extends RequireObjectCoercibleNode {

    static final ReferenceField<CachedJSClassData> CACHED_JS_CLASS_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedJSClass_cache", CachedJSClassData.class);
    static final ReferenceField<ForeignObject0Data> FOREIGN_OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignObject0_cache", ForeignObject0Data.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link RequireObjectCoercibleNode#doInt}
     *   1: SpecializationActive {@link RequireObjectCoercibleNode#doSafeInteger}
     *   2: SpecializationActive {@link RequireObjectCoercibleNode#doLong}
     *   3: SpecializationActive {@link RequireObjectCoercibleNode#doDouble}
     *   4: SpecializationActive {@link RequireObjectCoercibleNode#doTString}
     *   5: SpecializationActive {@link RequireObjectCoercibleNode#doBoolean}
     *   6: SpecializationActive {@link RequireObjectCoercibleNode#doSymbol}
     *   7: SpecializationActive {@link RequireObjectCoercibleNode#doBigInt}
     *   8: SpecializationActive {@link RequireObjectCoercibleNode#doCachedJSClass}
     *   9: SpecializationActive {@link RequireObjectCoercibleNode#doJSObject}
     *   10: SpecializationActive {@link RequireObjectCoercibleNode#doForeignObject}
     *   11: SpecializationActive {@link RequireObjectCoercibleNode#doForeignObject}
     *   12: SpecializationActive {@link RequireObjectCoercibleNode#doNullOrUndefined}
     *   13-15: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private CachedJSClassData cachedJSClass_cache;
    @UnsafeAccessedField @Child private ForeignObject0Data foreignObject0_cache;

    private RequireObjectCoercibleNodeGen() {
    }

    @ExplodeLoop
    @Override
    public void executeVoid(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111111111111) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doInt(int)] || SpecializationActive[RequireObjectCoercibleNode.doSafeInteger(SafeInteger)] || SpecializationActive[RequireObjectCoercibleNode.doLong(long)] || SpecializationActive[RequireObjectCoercibleNode.doDouble(double)] || SpecializationActive[RequireObjectCoercibleNode.doTString(TruffleString)] || SpecializationActive[RequireObjectCoercibleNode.doBoolean(boolean)] || SpecializationActive[RequireObjectCoercibleNode.doSymbol(Symbol)] || SpecializationActive[RequireObjectCoercibleNode.doBigInt(BigInt)] || SpecializationActive[RequireObjectCoercibleNode.doCachedJSClass(Object, Class<?>)] || SpecializationActive[RequireObjectCoercibleNode.doJSObject(JSObject)] || SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[RequireObjectCoercibleNode.doNullOrUndefined(Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                RequireObjectCoercibleNode.doInt(arg0Value_);
                return;
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doSafeInteger(SafeInteger)] */ && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                RequireObjectCoercibleNode.doSafeInteger(arg0Value_);
                return;
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                RequireObjectCoercibleNode.doLong(arg0Value_);
                return;
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                RequireObjectCoercibleNode.doDouble(arg0Value_);
                return;
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doTString(TruffleString)] */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                RequireObjectCoercibleNode.doTString(arg0Value_);
                return;
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                RequireObjectCoercibleNode.doBoolean(arg0Value_);
                return;
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doSymbol(Symbol)] */ && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                RequireObjectCoercibleNode.doSymbol(arg0Value_);
                return;
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                RequireObjectCoercibleNode.doBigInt(arg0Value_);
                return;
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doCachedJSClass(Object, Class<?>)] */) {
                CachedJSClassData s8_ = this.cachedJSClass_cache;
                if (s8_ != null) {
                    assert DSLSupport.assertIdempotence((s8_.cachedClass_ != null));
                    if ((CompilerDirectives.isExact(arg0Value, s8_.cachedClass_))) {
                        RequireObjectCoercibleNode.doCachedJSClass(arg0Value, s8_.cachedClass_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doJSObject(JSObject)] */ && arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject) arg0Value;
                RequireObjectCoercibleNode.doJSObject(arg0Value_);
                return;
            }
            if ((state_0 & 0b1110000000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[RequireObjectCoercibleNode.doNullOrUndefined(Object)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] */) {
                    ForeignObject0Data s10_ = this.foreignObject0_cache;
                    while (s10_ != null) {
                        if ((s10_.interop_.accepts(arg0Value)) && (JSGuards.isForeignObject(arg0Value))) {
                            doForeignObject(arg0Value, s10_.interop_);
                            return;
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] */) {
                    if ((JSGuards.isForeignObject(arg0Value))) {
                        this.foreignObject1Boundary(state_0, arg0Value);
                        return;
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[RequireObjectCoercibleNode.doNullOrUndefined(Object)] */) {
                    if ((JSGuards.isNullOrUndefined(arg0Value))) {
                        doNullOrUndefined(arg0Value);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void foreignObject1Boundary(int state_0, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                doForeignObject(arg0Value, interop__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private void executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[RequireObjectCoercibleNode.doInt(int)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doInt(arg0Value_);
            return;
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[RequireObjectCoercibleNode.doSafeInteger(SafeInteger)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doSafeInteger(arg0Value_);
            return;
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[RequireObjectCoercibleNode.doLong(long)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doLong(arg0Value_);
            return;
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 13) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[RequireObjectCoercibleNode.doDouble(double)] */;
                this.state_0_ = state_0;
                RequireObjectCoercibleNode.doDouble(arg0Value_);
                return;
            }
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[RequireObjectCoercibleNode.doTString(TruffleString)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doTString(arg0Value_);
            return;
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[RequireObjectCoercibleNode.doBoolean(boolean)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doBoolean(arg0Value_);
            return;
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol) arg0Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[RequireObjectCoercibleNode.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doSymbol(arg0Value_);
            return;
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[RequireObjectCoercibleNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doBigInt(arg0Value_);
            return;
        }
        if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[RequireObjectCoercibleNode.doJSObject(JSObject)] */) {
            while (true) {
                int count8_ = 0;
                CachedJSClassData s8_ = CACHED_JS_CLASS_CACHE_UPDATER.getVolatile(this);
                CachedJSClassData s8_original = s8_;
                while (s8_ != null) {
                    assert DSLSupport.assertIdempotence((s8_.cachedClass_ != null));
                    if ((CompilerDirectives.isExact(arg0Value, s8_.cachedClass_))) {
                        break;
                    }
                    count8_++;
                    s8_ = null;
                    break;
                }
                if (s8_ == null && count8_ < 1) {
                    {
                        Class<?> cachedClass__ = (JSGuards.getClassIfJSObject(arg0Value));
                        if ((cachedClass__ != null) && (CompilerDirectives.isExact(arg0Value, cachedClass__))) {
                            s8_ = new CachedJSClassData();
                            s8_.cachedClass_ = cachedClass__;
                            if (!CACHED_JS_CLASS_CACHE_UPDATER.compareAndSet(this, s8_original, s8_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[RequireObjectCoercibleNode.doCachedJSClass(Object, Class<?>)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s8_ != null) {
                    RequireObjectCoercibleNode.doCachedJSClass(arg0Value, s8_.cachedClass_);
                    return;
                }
                break;
            }
        }
        if (arg0Value instanceof JSObject) {
            JSObject arg0Value_ = (JSObject) arg0Value;
            this.cachedJSClass_cache = null;
            state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[RequireObjectCoercibleNode.doCachedJSClass(Object, Class<?>)] */;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[RequireObjectCoercibleNode.doJSObject(JSObject)] */;
            this.state_0_ = state_0;
            RequireObjectCoercibleNode.doJSObject(arg0Value_);
            return;
        }
        if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] */) {
            while (true) {
                int count10_ = 0;
                ForeignObject0Data s10_ = FOREIGN_OBJECT0_CACHE_UPDATER.getVolatile(this);
                ForeignObject0Data s10_original = s10_;
                while (s10_ != null) {
                    if ((s10_.interop_.accepts(arg0Value)) && (JSGuards.isForeignObject(arg0Value))) {
                        break;
                    }
                    count10_++;
                    s10_ = s10_.next_;
                }
                if (s10_ == null) {
                    if ((JSGuards.isForeignObject(arg0Value)) && count10_ < (JSConfig.InteropLibraryLimit)) {
                        // assert (s10_.interop_.accepts(arg0Value));
                        s10_ = this.insert(new ForeignObject0Data(s10_original));
                        InteropLibrary interop__ = s10_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s10_.interop_ = interop__;
                        if (!FOREIGN_OBJECT0_CACHE_UPDATER.compareAndSet(this, s10_original, s10_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10000000000 /* add SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s10_ != null) {
                    doForeignObject(arg0Value, s10_.interop_);
                    return;
                }
                break;
            }
        }
        {
            InteropLibrary interop__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if ((JSGuards.isForeignObject(arg0Value))) {
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        this.foreignObject0_cache = null;
                        state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[RequireObjectCoercibleNode.doForeignObject(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        doForeignObject(arg0Value, interop__);
                        return;
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        if ((JSGuards.isNullOrUndefined(arg0Value))) {
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[RequireObjectCoercibleNode.doNullOrUndefined(Object)] */;
            this.state_0_ = state_0;
            doNullOrUndefined(arg0Value);
            return;
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @NeverDefault
    public static RequireObjectCoercibleNode create() {
        return new RequireObjectCoercibleNodeGen();
    }

    @GeneratedBy(RequireObjectCoercibleNode.class)
    @DenyReplace
    private static final class CachedJSClassData implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link RequireObjectCoercibleNode#doCachedJSClass}
         *   Parameter: {@link Class} cachedClass</pre> */
        @CompilationFinal Class<?> cachedClass_;

        CachedJSClassData() {
        }

    }
    @GeneratedBy(RequireObjectCoercibleNode.class)
    @DenyReplace
    private static final class ForeignObject0Data extends Node implements SpecializationDataNode {

        @Child ForeignObject0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link RequireObjectCoercibleNode#doForeignObject}
         *   Parameter: {@link InteropLibrary} interop</pre> */
        @Child InteropLibrary interop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RequireObjectCoercibleWrapperNode#doDefault}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre> */
    @GeneratedBy(RequireObjectCoercibleWrapperNode.class)
    @SuppressWarnings("javadoc")
    public static final class RequireObjectCoercibleWrapperNodeGen extends RequireObjectCoercibleWrapperNode {

        private RequireObjectCoercibleWrapperNodeGen(JavaScriptNode operand) {
            super(operand);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = super.operandNode.execute(frameValue);
            return doDefault(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
            return;
        }

        @NeverDefault
        public static RequireObjectCoercibleWrapperNode create(JavaScriptNode operand) {
            return new RequireObjectCoercibleWrapperNodeGen(operand);
        }

    }
}
