// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypesGen;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSReadCurrentFrameSlotNode#doBoolean}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSReadCurrentFrameSlotNode#doInt}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSReadCurrentFrameSlotNode#doDouble}
 *     Activation probability: 0.18810
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSReadCurrentFrameSlotNode#doObject}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSReadCurrentFrameSlotNode#doSafeInteger}
 *     Activation probability: 0.10238
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSReadCurrentFrameSlotNode#doDead}
 *     Activation probability: 0.05952
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(JSReadCurrentFrameSlotNode.class)
@SuppressWarnings("javadoc")
final class JSReadCurrentFrameSlotNodeGen extends JSReadCurrentFrameSlotNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSReadCurrentFrameSlotNode#doBoolean}
     *   1: SpecializationActive {@link JSReadCurrentFrameSlotNode#doInt}
     *   2: SpecializationActive {@link JSReadCurrentFrameSlotNode#doDouble}
     *   3: SpecializationActive {@link JSReadCurrentFrameSlotNode#doObject}
     *   4: SpecializationActive {@link JSReadCurrentFrameSlotNode#doSafeInteger}
     *   5: SpecializationActive {@link JSReadCurrentFrameSlotNode#doDead}
     * </pre> */
    @CompilationFinal private int state_0_;

    private JSReadCurrentFrameSlotNodeGen(int slot, Object identifier, boolean hasTemporalDeadZone) {
        super(slot, identifier, hasTemporalDeadZone);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doSafeInteger(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] */) {
                if ((frameValue.isBoolean(slot))) {
                    return doBoolean(frameValue);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] */) {
                if ((frameValue.isInt(slot))) {
                    return doInt(frameValue);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] */) {
                if ((frameValue.isDouble(slot) || frameValue.isInt(slot))) {
                    return doDouble(frameValue);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] */) {
                if ((frameValue.isObject(slot))) {
                    return doObject(frameValue);
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doSafeInteger(VirtualFrame)] */) {
                if ((frameValue.isLong(slot))) {
                    return doSafeInteger(frameValue);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */) {
                if ((isIllegal(frameValue))) {
                    return doDead(frameValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] */) {
            if ((frameValue.isBoolean(slot))) {
                return doBoolean(frameValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(executeAndSpecialize(frameValue));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] */) {
            if ((frameValue.isDouble(slot) || frameValue.isInt(slot))) {
                return doDouble(frameValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(frameValue));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] || SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] */) {
            if ((frameValue.isInt(slot))) {
                return doInt(frameValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(frameValue));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b111101) == 0 /* only-active SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] */ && (state_0 != 0  /* is-not SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doSafeInteger(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */)) {
                this.executeInt(frameValue);
                return;
            } else if ((state_0 & 0b111011) == 0 /* only-active SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] */ && (state_0 != 0  /* is-not SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doSafeInteger(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */)) {
                this.executeDouble(frameValue);
                return;
            } else if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] */ && (state_0 != 0  /* is-not SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doSafeInteger(VirtualFrame)] && SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */)) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((frameValue.isBoolean(slot))) {
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSReadCurrentFrameSlotNode.doBoolean(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doBoolean(frameValue);
        }
        if ((frameValue.isInt(slot))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSReadCurrentFrameSlotNode.doInt(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doInt(frameValue);
        }
        if ((frameValue.isDouble(slot) || frameValue.isInt(slot))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSReadCurrentFrameSlotNode.doDouble(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doDouble(frameValue);
        }
        if ((frameValue.isObject(slot))) {
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSReadCurrentFrameSlotNode.doObject(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doObject(frameValue);
        }
        if ((frameValue.isLong(slot))) {
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSReadCurrentFrameSlotNode.doSafeInteger(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doSafeInteger(frameValue);
        }
        if ((isIllegal(frameValue))) {
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSReadCurrentFrameSlotNode.doDead(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doDead(frameValue);
        }
        throw new UnsupportedSpecializationException(this, null);
    }

    @NeverDefault
    public static JSReadCurrentFrameSlotNode create(int slot, Object identifier, boolean hasTemporalDeadZone) {
        return new JSReadCurrentFrameSlotNodeGen(slot, identifier, hasTemporalDeadZone);
    }

}
