// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.builtins.JSProxyObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link IsExtensibleNode#doCachedShape}
 *     Activation probability: 0.32000
 *     With/without class size: 9/5 bytes
 *   Specialization {@link IsExtensibleNode#doCachedJSNonProxyClass}
 *     Activation probability: 0.26000
 *     With/without class size: 8/4 bytes
 *   Specialization {@link IsExtensibleNode#doJSNonProxy}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link IsExtensibleNode#doJSProxy}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link IsExtensibleNode#doOther}
 *     Activation probability: 0.08000
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(IsExtensibleNode.class)
@SuppressWarnings("javadoc")
public final class IsExtensibleNodeGen extends IsExtensibleNode {

    static final ReferenceField<CachedShapeData> CACHED_SHAPE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedShape_cache", CachedShapeData.class);
    static final ReferenceField<CachedJSNonProxyClassData> CACHED_JS_NON_PROXY_CLASS_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedJSNonProxyClass_cache", CachedJSNonProxyClassData.class);
    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link IsExtensibleNode#doCachedShape}
     *   1: SpecializationActive {@link IsExtensibleNode#doCachedJSNonProxyClass}
     *   2: SpecializationActive {@link IsExtensibleNode#doJSNonProxy}
     *   3: SpecializationActive {@link IsExtensibleNode#doJSProxy}
     *   4: SpecializationActive {@link IsExtensibleNode#doOther}
     * </pre> */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private CachedShapeData cachedShape_cache;
    @UnsafeAccessedField @CompilationFinal private CachedJSNonProxyClassData cachedJSNonProxyClass_cache;

    private IsExtensibleNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, JSDynamicObject arg0Value) {
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[IsExtensibleNode.doJSNonProxy(JSNonProxyObject)] */) && arg0Value instanceof JSNonProxyObject) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IsExtensibleNode.doJSProxy(JSProxyObject)] */) && arg0Value instanceof JSProxyObject) {
            return false;
        }
        return true;
    }

    @Override
    public boolean executeBoolean(JSDynamicObject arg0Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[IsExtensibleNode.doCachedShape(JSDynamicObject, Shape, boolean)] || SpecializationActive[IsExtensibleNode.doCachedJSNonProxyClass(JSDynamicObject, Class<? extends JSNonProxyObject>)] || SpecializationActive[IsExtensibleNode.doJSNonProxy(JSNonProxyObject)] || SpecializationActive[IsExtensibleNode.doJSProxy(JSProxyObject)] || SpecializationActive[IsExtensibleNode.doOther(JSDynamicObject)] */) {
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[IsExtensibleNode.doCachedShape(JSDynamicObject, Shape, boolean)] || SpecializationActive[IsExtensibleNode.doCachedJSNonProxyClass(JSDynamicObject, Class<? extends JSNonProxyObject>)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IsExtensibleNode.doCachedShape(JSDynamicObject, Shape, boolean)] */) {
                    CachedShapeData s0_ = this.cachedShape_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((JSShape.getJSClass(s0_.cachedShape_).usesOrdinaryIsExtensible()));
                        if ((s0_.cachedShape_.check(arg0Value))) {
                            return IsExtensibleNode.doCachedShape(arg0Value, s0_.cachedShape_, s0_.result_);
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[IsExtensibleNode.doCachedJSNonProxyClass(JSDynamicObject, Class<? extends JSNonProxyObject>)] */) {
                    CachedJSNonProxyClassData s1_ = this.cachedJSNonProxyClass_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((s1_.cachedJSClass_ != null));
                        if ((CompilerDirectives.isExact(arg0Value, s1_.cachedJSClass_))) {
                            return IsExtensibleNode.doCachedJSNonProxyClass(arg0Value, s1_.cachedJSClass_);
                        }
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IsExtensibleNode.doJSNonProxy(JSNonProxyObject)] */ && arg0Value instanceof JSNonProxyObject) {
                JSNonProxyObject arg0Value_ = (JSNonProxyObject) arg0Value;
                return IsExtensibleNode.doJSNonProxy(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IsExtensibleNode.doJSProxy(JSProxyObject)] */ && arg0Value instanceof JSProxyObject) {
                JSProxyObject arg0Value_ = (JSProxyObject) arg0Value;
                return IsExtensibleNode.doJSProxy(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IsExtensibleNode.doOther(JSDynamicObject)] */) {
                if (fallbackGuard_(state_0, arg0Value)) {
                    return IsExtensibleNode.doOther(arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("unused")
    private boolean executeAndSpecialize(JSDynamicObject arg0Value) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b110)) == 0 /* is-not SpecializationActive[IsExtensibleNode.doCachedJSNonProxyClass(JSDynamicObject, Class<? extends JSNonProxyObject>)] && SpecializationActive[IsExtensibleNode.doJSNonProxy(JSNonProxyObject)] */) {
            while (true) {
                int count0_ = 0;
                CachedShapeData s0_ = CACHED_SHAPE_CACHE_UPDATER.getVolatile(this);
                CachedShapeData s0_original = s0_;
                while (s0_ != null) {
                    assert DSLSupport.assertIdempotence((JSShape.getJSClass(s0_.cachedShape_).usesOrdinaryIsExtensible()));
                    if ((s0_.cachedShape_.check(arg0Value))) {
                        break;
                    }
                    count0_++;
                    s0_ = null;
                    break;
                }
                if (s0_ == null && count0_ < 1) {
                    {
                        Shape cachedShape__ = (arg0Value.getShape());
                        if ((JSShape.getJSClass(cachedShape__).usesOrdinaryIsExtensible()) && (cachedShape__.check(arg0Value))) {
                            s0_ = new CachedShapeData();
                            Objects.requireNonNull(cachedShape__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.cachedShape_ = cachedShape__;
                            s0_.result_ = (JSShape.isExtensible(cachedShape__));
                            if (!CACHED_SHAPE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IsExtensibleNode.doCachedShape(JSDynamicObject, Shape, boolean)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s0_ != null) {
                    return IsExtensibleNode.doCachedShape(arg0Value, s0_.cachedShape_, s0_.result_);
                }
                break;
            }
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[IsExtensibleNode.doJSNonProxy(JSNonProxyObject)] */) {
            while (true) {
                int count1_ = 0;
                CachedJSNonProxyClassData s1_ = CACHED_JS_NON_PROXY_CLASS_CACHE_UPDATER.getVolatile(this);
                CachedJSNonProxyClassData s1_original = s1_;
                while (s1_ != null) {
                    assert DSLSupport.assertIdempotence((s1_.cachedJSClass_ != null));
                    if ((CompilerDirectives.isExact(arg0Value, s1_.cachedJSClass_))) {
                        break;
                    }
                    count1_++;
                    s1_ = null;
                    break;
                }
                if (s1_ == null && count1_ < 1) {
                    {
                        Class<? extends JSNonProxyObject> cachedJSClass__ = (IsExtensibleNode.getClassIfJSNonProxyObject(arg0Value));
                        if ((cachedJSClass__ != null) && (CompilerDirectives.isExact(arg0Value, cachedJSClass__))) {
                            s1_ = new CachedJSNonProxyClassData();
                            s1_.cachedJSClass_ = cachedJSClass__;
                            if (!CACHED_JS_NON_PROXY_CLASS_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                continue;
                            }
                            this.cachedShape_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IsExtensibleNode.doCachedShape(JSDynamicObject, Shape, boolean)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[IsExtensibleNode.doCachedJSNonProxyClass(JSDynamicObject, Class<? extends JSNonProxyObject>)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s1_ != null) {
                    return IsExtensibleNode.doCachedJSNonProxyClass(arg0Value, s1_.cachedJSClass_);
                }
                break;
            }
        }
        if (arg0Value instanceof JSNonProxyObject) {
            JSNonProxyObject arg0Value_ = (JSNonProxyObject) arg0Value;
            this.cachedShape_cache = null;
            this.cachedJSNonProxyClass_cache = null;
            state_0 = state_0 & 0xfffffffc /* remove SpecializationActive[IsExtensibleNode.doCachedShape(JSDynamicObject, Shape, boolean)], SpecializationActive[IsExtensibleNode.doCachedJSNonProxyClass(JSDynamicObject, Class<? extends JSNonProxyObject>)] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[IsExtensibleNode.doJSNonProxy(JSNonProxyObject)] */;
            this.state_0_ = state_0;
            return IsExtensibleNode.doJSNonProxy(arg0Value_);
        }
        if (arg0Value instanceof JSProxyObject) {
            JSProxyObject arg0Value_ = (JSProxyObject) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[IsExtensibleNode.doJSProxy(JSProxyObject)] */;
            this.state_0_ = state_0;
            return IsExtensibleNode.doJSProxy(arg0Value_);
        }
        state_0 = state_0 | 0b10000 /* add SpecializationActive[IsExtensibleNode.doOther(JSDynamicObject)] */;
        this.state_0_ = state_0;
        return IsExtensibleNode.doOther(arg0Value);
    }

    @NeverDefault
    public static IsExtensibleNode create() {
        return new IsExtensibleNodeGen();
    }

    @NeverDefault
    public static IsExtensibleNode getUncached() {
        return IsExtensibleNodeGen.UNCACHED;
    }

    @GeneratedBy(IsExtensibleNode.class)
    @DenyReplace
    private static final class CachedShapeData implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link IsExtensibleNode#doCachedShape}
         *   Parameter: {@link Shape} cachedShape</pre> */
        @CompilationFinal Shape cachedShape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link IsExtensibleNode#doCachedShape}
         *   Parameter: boolean result</pre> */
        @CompilationFinal boolean result_;

        CachedShapeData() {
        }

    }
    @GeneratedBy(IsExtensibleNode.class)
    @DenyReplace
    private static final class CachedJSNonProxyClassData implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link IsExtensibleNode#doCachedJSNonProxyClass}
         *   Parameter: {@link Class} cachedJSClass</pre> */
        @CompilationFinal Class<? extends JSNonProxyObject> cachedJSClass_;

        CachedJSNonProxyClassData() {
        }

    }
    @GeneratedBy(IsExtensibleNode.class)
    @DenyReplace
    private static final class Uncached extends IsExtensibleNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean executeBoolean(JSDynamicObject arg0Value) {
            if (arg0Value instanceof JSNonProxyObject) {
                JSNonProxyObject arg0Value_ = (JSNonProxyObject) arg0Value;
                return IsExtensibleNode.doJSNonProxy(arg0Value_);
            }
            if (arg0Value instanceof JSProxyObject) {
                JSProxyObject arg0Value_ = (JSProxyObject) arg0Value;
                return IsExtensibleNode.doJSProxy(arg0Value_);
            }
            return IsExtensibleNode.doOther(arg0Value);
        }

    }
}
