/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.FunctionPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=FunctionPrototypeBuiltins.class)
public final class FunctionPrototypeBuiltinsFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=FunctionPrototypeBuiltins.HasInstanceNode.class)
    public static final class HasInstanceNodeGen
    extends FunctionPrototypeBuiltins.HasInstanceNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private HasInstanceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.hasInstance(arguments0Value_, arguments1Value_);
        }

        @NeverDefault
        public static FunctionPrototypeBuiltins.HasInstanceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new HasInstanceNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSCallNode.class)
    public static final class JSCallNodeGen
    extends FunctionPrototypeBuiltins.JSCallNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private JSCallNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state_0 != 0 && arguments2Value_ instanceof Object[]) {
                Object[] arguments2Value__ = (Object[])arguments2Value_;
                return this.call(arguments0Value_, arguments1Value_, arguments2Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state_0 = this.state_0_;
            if (arguments2Value instanceof Object[]) {
                Object[] arguments2Value_ = (Object[])arguments2Value;
                this.state_0_ = state_0 |= 1;
                return this.call(arguments0Value, arguments1Value, arguments2Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        @NeverDefault
        public static FunctionPrototypeBuiltins.JSCallNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSCallNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSApplyNode.class)
    public static final class JSApplyNodeGen
    extends FunctionPrototypeBuiltins.JSApplyNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private IsCallableNode isCallable;

        private JSApplyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state_0 != 0) {
                JSDynamicObject arguments0Value__;
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSDynamicObject && JSGuards.isJSFunction((Object)(arguments0Value__ = (JSDynamicObject)((Object)arguments0Value_)))) {
                    return this.applyFunction(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state_0 & 6) != 0) {
                    IsCallableNode isCallable_1;
                    IsCallableNode isCallable_;
                    if ((state_0 & 2) != 0 && (isCallable_ = this.isCallable) != null && isCallable_.executeBoolean(arguments0Value_)) {
                        return this.applyCallable(arguments0Value_, arguments1Value_, arguments2Value_, isCallable_);
                    }
                    if ((state_0 & 4) != 0 && (isCallable_1 = this.isCallable) != null && !isCallable_1.executeBoolean(arguments0Value_)) {
                        return this.error(arguments0Value_, arguments1Value_, arguments2Value_, isCallable_1);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            IsCallableNode isCallable_1;
            IsCallableNode isCallable_;
            JSDynamicObject arguments0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0 && arguments0Value instanceof JSDynamicObject && JSGuards.isJSFunction((Object)(arguments0Value_ = (JSDynamicObject)((Object)arguments0Value)))) {
                this.state_0_ = state_0 |= 1;
                return this.applyFunction(arguments0Value_, arguments1Value, arguments2Value);
            }
            IsCallableNode isCallable__shared = this.isCallable;
            if (isCallable__shared != null) {
                isCallable_ = isCallable__shared;
            } else {
                isCallable_ = (IsCallableNode)this.insert(IsCallableNode.create());
                if (isCallable_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (isCallable_.executeBoolean(arguments0Value)) {
                if (this.isCallable == null) {
                    VarHandle.storeStoreFence();
                    this.isCallable = isCallable_;
                }
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                return this.applyCallable(arguments0Value, arguments1Value, arguments2Value, isCallable_);
            }
            IsCallableNode isCallable_1_shared = this.isCallable;
            if (isCallable_1_shared != null) {
                isCallable_1 = isCallable_1_shared;
            } else {
                isCallable_1 = (IsCallableNode)this.insert(IsCallableNode.create());
                if (isCallable_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (!isCallable_1.executeBoolean(arguments0Value)) {
                if (this.isCallable == null) {
                    VarHandle.storeStoreFence();
                    this.isCallable = isCallable_1;
                }
                this.state_0_ = state_0 |= 4;
                return this.error(arguments0Value, arguments1Value, arguments2Value, isCallable_1);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        @NeverDefault
        public static FunctionPrototypeBuiltins.JSApplyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSApplyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSFunctionToStringNode.class)
    public static final class JSFunctionToStringNodeGen
    extends FunctionPrototypeBuiltins.JSFunctionToStringNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private IsCallableNode isCallable;
        @Node.Child
        private InteropLibrary toStringCallable_interop_;
        @Node.Child
        private InteropLibrary toStringCallable_interopStr_;
        @Node.Child
        private TruffleString.SwitchEncodingNode toStringCallable_switchEncoding_;

        private JSFunctionToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSFunctionObject) {
                    JSFunctionObject arguments0Value__ = (JSFunctionObject)((Object)arguments0Value_);
                    return this.toStringFunction(arguments0Value__);
                }
                if ((state_0 & 0xE) != 0) {
                    IsCallableNode isCallable_1;
                    TruffleString.SwitchEncodingNode switchEncoding__;
                    InteropLibrary interopStr__;
                    InteropLibrary interop__;
                    IsCallableNode isCallable_;
                    if ((state_0 & 2) != 0 && (isCallable_ = this.isCallable) != null && (interop__ = this.toStringCallable_interop_) != null && (interopStr__ = this.toStringCallable_interopStr_) != null && (switchEncoding__ = this.toStringCallable_switchEncoding_) != null) {
                        assert (DSLSupport.assertIdempotence((boolean)this.isES2019OrLater()));
                        if (!JSGuards.isJSFunction(arguments0Value_) && isCallable_.executeBoolean(arguments0Value_)) {
                            return FunctionPrototypeBuiltins.JSFunctionToStringNode.toStringCallable(arguments0Value_, isCallable_, interop__, interopStr__, switchEncoding__);
                        }
                    }
                    if ((state_0 & 4) != 0 && (isCallable_1 = this.isCallable) != null) {
                        assert (DSLSupport.assertIdempotence((boolean)this.isES2019OrLater()));
                        if (!isCallable_1.executeBoolean(arguments0Value_)) {
                            return FunctionPrototypeBuiltins.JSFunctionToStringNode.toStringNotCallable(arguments0Value_, isCallable_1);
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        assert (DSLSupport.assertIdempotence((!this.isES2019OrLater() ? 1 : 0) != 0));
                        if (!JSGuards.isJSFunction(arguments0Value_)) {
                            return FunctionPrototypeBuiltins.JSFunctionToStringNode.toStringNotFunction(arguments0Value_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        private TruffleString executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSFunctionObject) {
                JSFunctionObject arguments0Value_ = (JSFunctionObject)((Object)arguments0Value);
                this.state_0_ = state_0 |= 1;
                return this.toStringFunction(arguments0Value_);
            }
            if (this.isES2019OrLater() && !JSGuards.isJSFunction(arguments0Value)) {
                IsCallableNode isCallable_;
                IsCallableNode isCallable__shared = this.isCallable;
                if (isCallable__shared != null) {
                    isCallable_ = isCallable__shared;
                } else {
                    isCallable_ = (IsCallableNode)this.insert(IsCallableNode.create());
                    if (isCallable_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (isCallable_.executeBoolean(arguments0Value)) {
                    if (this.isCallable == null) {
                        VarHandle.storeStoreFence();
                        this.isCallable = isCallable_;
                    }
                    InteropLibrary interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.toStringCallable_interop_ = interop__;
                    InteropLibrary interopStr__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    Objects.requireNonNull(interopStr__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.toStringCallable_interopStr_ = interopStr__;
                    TruffleString.SwitchEncodingNode switchEncoding__ = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
                    Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.toStringCallable_switchEncoding_ = switchEncoding__;
                    this.state_0_ = state_0 |= 2;
                    return FunctionPrototypeBuiltins.JSFunctionToStringNode.toStringCallable(arguments0Value, isCallable_, interop__, interopStr__, switchEncoding__);
                }
            }
            if (this.isES2019OrLater()) {
                IsCallableNode isCallable_1;
                IsCallableNode isCallable_1_shared = this.isCallable;
                if (isCallable_1_shared != null) {
                    isCallable_1 = isCallable_1_shared;
                } else {
                    isCallable_1 = (IsCallableNode)this.insert(IsCallableNode.create());
                    if (isCallable_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (!isCallable_1.executeBoolean(arguments0Value)) {
                    if (this.isCallable == null) {
                        VarHandle.storeStoreFence();
                        this.isCallable = isCallable_1;
                    }
                    this.state_0_ = state_0 |= 4;
                    return FunctionPrototypeBuiltins.JSFunctionToStringNode.toStringNotCallable(arguments0Value, isCallable_1);
                }
            }
            if (!this.isES2019OrLater() && !JSGuards.isJSFunction(arguments0Value)) {
                this.state_0_ = state_0 |= 8;
                return FunctionPrototypeBuiltins.JSFunctionToStringNode.toStringNotFunction(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        @NeverDefault
        public static FunctionPrototypeBuiltins.JSFunctionToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSFunctionToStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=FunctionPrototypeBuiltins.JSBindNode.class)
    public static final class JSBindNodeGen
    extends FunctionPrototypeBuiltins.JSBindNode {
        private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
        private static final InlineSupport.StateField STATE_0_JSBindNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
        private static final InlinedConditionProfile INLINED_IS_CONSTRUCTOR_PROFILE = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(3, 2)}));
        private static final InlinedConditionProfile INLINED_SET_PROTO_PROFILE = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(7, 2)}));
        private static final InlinedConditionProfile INLINED_BIND_JS_FUNCTION_IS_ASYNC_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_JSBindNode_UPDATER.subUpdater(5, 2)}));
        private static final InlinedConditionProfile INLINED_BIND_OTHER_IS_PROXY_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_JSBindNode_UPDATER.subUpdater(9, 2)}));
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @Node.Child
        private GetPrototypeNode getPrototypeNode;
        @Node.Child
        private FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        @Node.Child
        private ForeignObjectPrototypeNode bindOther_foreignPrototypeNode_;
        @Node.Child
        private IsConstructorNode bindOther_isConstructorNode_;

        private JSBindNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 7) != 0 && arguments2Value_ instanceof Object[]) {
                Object[] arguments2Value__ = (Object[])arguments2Value_;
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSFunctionObject) {
                    FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode_;
                    JSFunctionObject arguments0Value__ = (JSFunctionObject)((Object)arguments0Value_);
                    GetPrototypeNode getPrototypeNode_ = this.getPrototypeNode;
                    if (getPrototypeNode_ != null && (copyNameAndLengthNode_ = this.copyNameAndLengthNode) != null) {
                        return this.bindJSFunction(arguments0Value__, arguments1Value_, arguments2Value__, getPrototypeNode_, copyNameAndLengthNode_, INLINED_IS_CONSTRUCTOR_PROFILE, INLINED_BIND_JS_FUNCTION_IS_ASYNC_PROFILE_, INLINED_SET_PROTO_PROFILE);
                    }
                }
                if ((state_0 & 6) != 0) {
                    IsCallableNode isCallableNode_1;
                    FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode_1;
                    IsConstructorNode isConstructorNode__;
                    ForeignObjectPrototypeNode foreignPrototypeNode__;
                    GetPrototypeNode getPrototypeNode_1;
                    IsCallableNode isCallableNode_;
                    if ((state_0 & 2) != 0 && (isCallableNode_ = this.isCallableNode) != null && (getPrototypeNode_1 = this.getPrototypeNode) != null && (foreignPrototypeNode__ = this.bindOther_foreignPrototypeNode_) != null && (isConstructorNode__ = this.bindOther_isConstructorNode_) != null && (copyNameAndLengthNode_1 = this.copyNameAndLengthNode) != null && !JSGuards.isJSFunction(arguments0Value_) && isCallableNode_.executeBoolean(arguments0Value_)) {
                        return this.bindOther(arguments0Value_, arguments1Value_, arguments2Value__, isCallableNode_, getPrototypeNode_1, foreignPrototypeNode__, isConstructorNode__, copyNameAndLengthNode_1, INLINED_BIND_OTHER_IS_PROXY_PROFILE_, INLINED_IS_CONSTRUCTOR_PROFILE, INLINED_SET_PROTO_PROFILE);
                    }
                    if ((state_0 & 4) != 0 && (isCallableNode_1 = this.isCallableNode) != null && !isCallableNode_1.executeBoolean(arguments0Value_)) {
                        return FunctionPrototypeBuiltins.JSBindNode.bindError(arguments0Value_, arguments1Value_, arguments2Value__, isCallableNode_1);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private JSDynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state_0 = this.state_0_;
            if (arguments2Value instanceof Object[]) {
                IsCallableNode isCallableNode_1;
                IsCallableNode isCallableNode_1_shared;
                Object[] arguments2Value_ = (Object[])arguments2Value;
                if (arguments0Value instanceof JSFunctionObject) {
                    FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode_;
                    FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode__shared;
                    GetPrototypeNode getPrototypeNode_;
                    JSFunctionObject arguments0Value_ = (JSFunctionObject)((Object)arguments0Value);
                    GetPrototypeNode getPrototypeNode__shared = this.getPrototypeNode;
                    if (getPrototypeNode__shared != null) {
                        getPrototypeNode_ = getPrototypeNode__shared;
                    } else {
                        getPrototypeNode_ = (GetPrototypeNode)this.insert(GetPrototypeNode.create());
                        if (getPrototypeNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.getPrototypeNode == null) {
                        VarHandle.storeStoreFence();
                        this.getPrototypeNode = getPrototypeNode_;
                    }
                    if ((copyNameAndLengthNode__shared = this.copyNameAndLengthNode) != null) {
                        copyNameAndLengthNode_ = copyNameAndLengthNode__shared;
                    } else {
                        copyNameAndLengthNode_ = (FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode)this.insert(FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode.create(this.getContext()));
                        if (copyNameAndLengthNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.copyNameAndLengthNode == null) {
                        VarHandle.storeStoreFence();
                        this.copyNameAndLengthNode = copyNameAndLengthNode_;
                    }
                    this.state_0_ = state_0 |= 1;
                    return this.bindJSFunction(arguments0Value_, arguments1Value, arguments2Value_, getPrototypeNode_, copyNameAndLengthNode_, INLINED_IS_CONSTRUCTOR_PROFILE, INLINED_BIND_JS_FUNCTION_IS_ASYNC_PROFILE_, INLINED_SET_PROTO_PROFILE);
                }
                if (!JSGuards.isJSFunction(arguments0Value)) {
                    IsCallableNode isCallableNode_;
                    IsCallableNode isCallableNode__shared = this.isCallableNode;
                    if (isCallableNode__shared != null) {
                        isCallableNode_ = isCallableNode__shared;
                    } else {
                        isCallableNode_ = (IsCallableNode)this.insert(IsCallableNode.create());
                        if (isCallableNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (isCallableNode_.executeBoolean(arguments0Value)) {
                        FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode_1;
                        GetPrototypeNode getPrototypeNode_1;
                        GetPrototypeNode getPrototypeNode_1_shared;
                        if (this.isCallableNode == null) {
                            VarHandle.storeStoreFence();
                            this.isCallableNode = isCallableNode_;
                        }
                        if ((getPrototypeNode_1_shared = this.getPrototypeNode) != null) {
                            getPrototypeNode_1 = getPrototypeNode_1_shared;
                        } else {
                            getPrototypeNode_1 = (GetPrototypeNode)this.insert(GetPrototypeNode.create());
                            if (getPrototypeNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getPrototypeNode == null) {
                            VarHandle.storeStoreFence();
                            this.getPrototypeNode = getPrototypeNode_1;
                        }
                        ForeignObjectPrototypeNode foreignPrototypeNode__ = (ForeignObjectPrototypeNode)this.insert(ForeignObjectPrototypeNode.create());
                        Objects.requireNonNull(foreignPrototypeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.bindOther_foreignPrototypeNode_ = foreignPrototypeNode__;
                        IsConstructorNode isConstructorNode__ = (IsConstructorNode)this.insert(IsConstructorNode.create());
                        Objects.requireNonNull(isConstructorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.bindOther_isConstructorNode_ = isConstructorNode__;
                        FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode copyNameAndLengthNode_1_shared = this.copyNameAndLengthNode;
                        if (copyNameAndLengthNode_1_shared != null) {
                            copyNameAndLengthNode_1 = copyNameAndLengthNode_1_shared;
                        } else {
                            copyNameAndLengthNode_1 = (FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode)this.insert(FunctionPrototypeBuiltins.CopyFunctionNameAndLengthNode.create(this.getContext()));
                            if (copyNameAndLengthNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.copyNameAndLengthNode == null) {
                            VarHandle.storeStoreFence();
                            this.copyNameAndLengthNode = copyNameAndLengthNode_1;
                        }
                        this.state_0_ = state_0 |= 2;
                        return this.bindOther(arguments0Value, arguments1Value, arguments2Value_, isCallableNode_, getPrototypeNode_1, foreignPrototypeNode__, isConstructorNode__, copyNameAndLengthNode_1, INLINED_BIND_OTHER_IS_PROXY_PROFILE_, INLINED_IS_CONSTRUCTOR_PROFILE, INLINED_SET_PROTO_PROFILE);
                    }
                }
                if ((isCallableNode_1_shared = this.isCallableNode) != null) {
                    isCallableNode_1 = isCallableNode_1_shared;
                } else {
                    isCallableNode_1 = (IsCallableNode)this.insert(IsCallableNode.create());
                    if (isCallableNode_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (!isCallableNode_1.executeBoolean(arguments0Value)) {
                    if (this.isCallableNode == null) {
                        VarHandle.storeStoreFence();
                        this.isCallableNode = isCallableNode_1;
                    }
                    this.state_0_ = state_0 |= 4;
                    return FunctionPrototypeBuiltins.JSBindNode.bindError(arguments0Value, arguments1Value, arguments2Value_, isCallableNode_1);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        @NeverDefault
        public static FunctionPrototypeBuiltins.JSBindNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSBindNodeGen(context, builtin, arguments);
        }
    }
}

