/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSLanguageOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;

public class DefaultESModuleLoader
implements JSModuleLoader {
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String DOT_SLASH = "./";
    public static final String DOT_DOT_SLASH = "../";
    private static final int JS_MODULE_TYPE = 1;
    private static final int JSON_MODULE_TYPE = 2;
    protected final JSRealm realm;
    protected final Map<String, JSModuleRecord> moduleMap = new HashMap<String, JSModuleRecord>();

    public static DefaultESModuleLoader create(JSRealm realm) {
        return new DefaultESModuleLoader(realm);
    }

    protected DefaultESModuleLoader(JSRealm realm) {
        this.realm = realm;
    }

    protected URI asURI(String specifier) {
        assert (specifier != null);
        if (specifier.indexOf(58) == -1) {
            return null;
        }
        try {
            URI uri = new URI(specifier);
            return uri.isAbsolute() ? uri : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public JSModuleRecord resolveImportedModule(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        String refPath = null;
        String refPathOrName = null;
        if (referrer != null) {
            Source referrerSource = referrer.getSource();
            refPath = referrerSource.getPath();
            refPathOrName = refPath != null ? refPath : referrerSource.getName();
        }
        try {
            TruffleFile moduleFile;
            String canonicalPath;
            TruffleString specifierTS = moduleRequest.getSpecifier();
            String specifier = Strings.toJavaString(specifierTS);
            URI maybeUri = this.asURI(specifier);
            TruffleString maybeCustomPath = this.realm.getCustomEsmPathMapping(refPath == null ? null : Strings.fromJavaString(refPath), specifierTS);
            TruffleLanguage.Env env = this.realm.getEnv();
            if (maybeCustomPath != null) {
                canonicalPath = maybeCustomPath.toJavaStringUncached();
                moduleFile = DefaultESModuleLoader.getCanonicalFileIfExists(env.getPublicTruffleFile(canonicalPath), env);
            } else {
                if (refPath == null) {
                    moduleFile = maybeUri != null ? env.getPublicTruffleFile(maybeUri) : env.getPublicTruffleFile(specifier);
                } else {
                    TruffleFile refFile = env.getPublicTruffleFile(refPath);
                    if (maybeUri != null) {
                        String uriFile = env.getPublicTruffleFile(maybeUri).getCanonicalFile(new LinkOption[0]).getPath();
                        moduleFile = refFile.resolveSibling(uriFile);
                    } else {
                        moduleFile = !env.isFileIOAllowed() || this.bareSpecifierDirectLookup(specifier) ? env.getPublicTruffleFile(specifier) : refFile.resolveSibling(specifier);
                    }
                }
                canonicalPath = null;
            }
            return this.loadModuleFromUrl(referrer, moduleRequest, moduleFile, canonicalPath);
        }
        catch (FileSystemException fsex) {
            throw this.createErrorFromFileSystemException(fsex, refPathOrName);
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            throw Errors.createErrorFromException(e);
        }
    }

    private JSException createErrorFromFileSystemException(FileSystemException fsex, String refPath) {
        String fileName = fsex.getFile();
        if (this.realm.getContext().getLanguageOptions().testV8Mode()) {
            String message = "d8: Error reading module from " + fileName;
            if (refPath != null) {
                message = message + " imported by " + refPath;
            }
            return Errors.createError(message, fsex);
        }
        String reason = fsex.getReason();
        Object message = null;
        if (reason == null) {
            if (fsex instanceof NoSuchFileException) {
                message = "Cannot find module";
            } else if (fsex instanceof AccessDeniedException) {
                message = "Cannot access module";
            }
        }
        if (message == null) {
            message = "Error reading module";
        }
        message = (String)message + " '" + fileName + "'";
        if (refPath != null) {
            message = (String)message + " imported from " + refPath;
        }
        if (reason != null) {
            message = ": " + reason;
        }
        return Errors.createError((String)message, fsex);
    }

    private boolean bareSpecifierDirectLookup(String specifier) {
        JSLanguageOptions options = this.realm.getContext().getLanguageOptions();
        if (options.esmBareSpecifierRelativeLookup()) {
            return false;
        }
        return !specifier.startsWith(SLASH) && !specifier.startsWith(DOT_SLASH) && !specifier.startsWith(DOT_DOT_SLASH);
    }

    protected JSModuleRecord loadModuleFromUrl(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, TruffleFile maybeModuleFile, String maybeCanonicalPath) throws IOException {
        JSModuleRecord newModule;
        TruffleFile moduleFile = maybeModuleFile;
        TruffleLanguage.Env env = this.realm.getEnv();
        String canonicalPath = maybeCanonicalPath == null ? DefaultESModuleLoader.getCanonicalFileIfExists(moduleFile, env).getPath() : maybeCanonicalPath;
        JSModuleRecord existingModule = this.moduleMap.get(canonicalPath);
        if (existingModule != null) {
            return existingModule;
        }
        Source source = Source.newBuilder((String)"js", (TruffleFile)moduleFile).name(Strings.toJavaString(moduleRequest.getSpecifier())).mimeType("application/javascript+module").build();
        Map<TruffleString, TruffleString> attributes = moduleRequest.getAttributes();
        int moduleType = this.getModuleType(moduleFile.getName());
        TruffleString assertedType = attributes.get(JSContext.getTypeImportAttribute());
        if (!DefaultESModuleLoader.doesModuleTypeMatchAssertionType(assertedType, moduleType)) {
            throw Errors.createTypeError("Invalid module type was asserted");
        }
        if (DefaultESModuleLoader.isModuleType(moduleType, 2)) {
            newModule = this.realm.getContext().getEvaluator().parseJSONModule(this.realm, source);
        } else {
            JSModuleData parsedModule = this.realm.getContext().getEvaluator().envParseModule(this.realm, source);
            newModule = new JSModuleRecord(parsedModule, this);
        }
        this.moduleMap.put(canonicalPath, newModule);
        if (referrer != null) {
            referrer.rememberImportedModuleSource(moduleRequest.getSpecifier(), source);
        }
        return newModule;
    }

    private static boolean doesModuleTypeMatchAssertionType(TruffleString assertedType, int moduleType) {
        if (assertedType == null) {
            return true;
        }
        if (Strings.equals(Strings.JSON, assertedType)) {
            return DefaultESModuleLoader.isModuleType(moduleType, 2);
        }
        return false;
    }

    private int getModuleType(String moduleName) {
        if (this.realm.getContext().getLanguageOptions().jsonModules() && moduleName.endsWith(".json")) {
            return 2;
        }
        return 1;
    }

    private static boolean isModuleType(int moduleType, int expectedType) {
        return (moduleType & expectedType) != 0;
    }

    @Override
    public JSModuleRecord loadModule(Source source, JSModuleData moduleData) {
        String canonicalPath = this.getCanonicalPath(source);
        return this.moduleMap.computeIfAbsent(canonicalPath, key -> new JSModuleRecord(moduleData, this));
    }

    private String getCanonicalPath(Source source) {
        String canonicalPath;
        String path = source.getPath();
        if (path == null) {
            canonicalPath = source.getName();
        } else {
            try {
                TruffleLanguage.Env env = this.realm.getEnv();
                if (env.getFileNameSeparator().equals("\\") && path.startsWith(SLASH)) {
                    path = path.substring(1);
                }
                TruffleFile moduleFile = env.getPublicTruffleFile(path);
                if (env.isFileIOAllowed() && moduleFile.exists(new LinkOption[0])) {
                    try {
                        canonicalPath = moduleFile.getCanonicalFile(new LinkOption[0]).getPath();
                    }
                    catch (NoSuchFileException ex) {
                        canonicalPath = path;
                    }
                } else {
                    canonicalPath = path;
                }
            }
            catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                throw Errors.createErrorFromException(e);
            }
        }
        return canonicalPath;
    }

    private static TruffleFile getCanonicalFileIfExists(TruffleFile file, TruffleLanguage.Env env) throws IOException {
        if (env.isFileIOAllowed() && file.exists(new LinkOption[0])) {
            try {
                return file.getCanonicalFile(new LinkOption[0]);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return file;
    }
}

