/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNodeGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class JSToObjectArrayNode
extends JavaScriptBaseNode {
    protected final boolean nullOrUndefinedAsEmptyArray;

    protected JSToObjectArrayNode(boolean nullOrUndefinedAsEmptyArray) {
        this.nullOrUndefinedAsEmptyArray = nullOrUndefinedAsEmptyArray;
    }

    public final Object[] executeObjectArray(Object value) {
        return this.executeObjectArray(value, 0x7FFFFFF7);
    }

    public abstract Object[] executeObjectArray(Object var1, int var2);

    @NeverDefault
    public static JSToObjectArrayNode create() {
        return JSToObjectArrayNode.create(false);
    }

    @NeverDefault
    public static JSToObjectArrayNode create(boolean nullOrUndefinedAsEmptyArray) {
        return JSToObjectArrayNodeGen.create(nullOrUndefinedAsEmptyArray);
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode operand) {
        class Unary
        extends JSUnaryNode {
            @Node.Child
            private JSToObjectArrayNode toObjectArray;
            final /* synthetic */ JSContext val$context;

            Unary(JavaScriptNode javaScriptNode) {
                this.val$context = javaScriptNode;
                super(operandNode);
                this.toObjectArray = JSToObjectArrayNode.create();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                return this.toObjectArray.executeObjectArray(this.operandNode.execute(frame), this.val$context.getLanguageOptions().maxApplyArgumentLength());
            }

            @Override
            protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
                return new Unary(Unary.cloneUninitialized(this.getOperand(), materializedTags), this.val$context);
            }
        }
        return new Unary(operand, context);
    }

    @Specialization
    protected Object[] toArray(JSObject obj, int arrayLengthLimit, @Bind(value="this") Node node, @Cached(value="create(getJSContext())") JSGetLengthNode getLengthNode, @Cached(value="create(getJSContext())") ReadElementNode readNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        long len = getLengthNode.executeLong((Object)obj);
        if (len > (long)arrayLengthLimit) {
            errorBranch.enter(node);
            throw Errors.createRangeErrorTooManyArguments();
        }
        int iLen = (int)len;
        assert (JSRuntime.longIsRepresentableAsInt(len));
        Object[] arr = new Object[iLen];
        for (int index = 0; index < iLen; ++index) {
            Object value;
            arr[index] = value = readNode.executeWithTargetAndIndex((Object)obj, index);
        }
        return arr;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected Object[] doUndefined(Object value, int arrayLengthLimit) {
        return this.emptyArrayOrObjectError(value);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected Object[] doNull(Object value, int arrayLengthLimit) {
        return this.emptyArrayOrObjectError(value);
    }

    private Object[] emptyArrayOrObjectError(Object value) {
        if (this.nullOrUndefinedAsEmptyArray) {
            return ScriptArray.EMPTY_OBJECT_ARRAY;
        }
        throw Errors.createTypeErrorNotAnObject(value);
    }

    @Specialization
    protected Object[] passArray(Object[] array, int arrayLengthLimit, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        if (array.length > arrayLengthLimit) {
            errorBranch.enter((Node)this);
            throw Errors.createRangeErrorTooManyArguments();
        }
        return array;
    }

    @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
    protected Object[] doForeignObject(Object obj, int arrayLengthLimit, @Bind(value="this") Node node, @CachedLibrary(value="obj") InteropLibrary interop, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached ImportValueNode foreignConvertNode) {
        try {
            if (!interop.hasArrayElements(obj)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("foreign object must be an array", (Node)this);
            }
            long len = interop.getArraySize(obj);
            if (len > (long)arrayLengthLimit) {
                errorBranch.enter(node);
                throw Errors.createRangeErrorTooManyArguments();
            }
            int iLen = (int)len;
            Object[] arr = new Object[iLen];
            for (int i = 0; i < iLen; ++i) {
                arr[i] = foreignConvertNode.executeWithTarget(interop.readArrayElement(obj, (long)i));
            }
            return arr;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            errorBranch.enter(node);
            throw Errors.createTypeErrorNotAnObject(obj);
        }
    }

    @Fallback
    protected Object[] doFallback(Object value, int arrayLengthLimit) {
        assert (!JSRuntime.isObject(value) && !JSRuntime.isNullOrUndefined(value));
        if (this.nullOrUndefinedAsEmptyArray && this.getJSContext().isOptionNashornCompatibilityMode()) {
            throw Errors.createTypeError("Function.prototype.apply expects an Array for second argument");
        }
        throw Errors.createTypeErrorNotAnObject(value);
    }
}

