// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.lang.invoke.MethodHandles;

/**
 * Debug Info: <pre>
 *   Specialization {@link RoundNode#roundInt}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link RoundNode#roundCornercase}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link RoundNode#roundDoubleInt}
 *     Activation probability: 0.20500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link RoundNode#roundDouble}
 *     Activation probability: 0.11500
 *     With/without class size: 6/1 bytes
 * </pre>
 */
@GeneratedBy(RoundNode.class)
@SuppressWarnings("javadoc")
public final class RoundNodeGen extends RoundNode {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    private static final StateField STATE_0_RoundNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link RoundNode#roundDoubleInt}
     *   Parameter: {@link InlinedConditionProfile} shiftProfile
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_SHIFT_PROFILE = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(8, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link RoundNode#roundDoubleInt}
     *   Parameter: {@link InlinedBranchProfile} negativeLongBitsProfile
     *   Inline method: {@link InlinedBranchProfile#inline}</pre>
     */
    private static final InlinedBranchProfile INLINED_NEGATIVE_LONG_BITS_PROFILE = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(10, 1)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link RoundNode#roundDouble}
     *   Parameter: {@link InlinedConditionProfile} profileA
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_ROUND_DOUBLE_PROFILE_A_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_RoundNode_UPDATER.subUpdater(11, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link RoundNode#roundDouble}
     *   Parameter: {@link InlinedConditionProfile} profileB
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_ROUND_DOUBLE_PROFILE_B_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_RoundNode_UPDATER.subUpdater(13, 2)));

    @Child private JavaScriptNode arguments0_;
    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link RoundNode#roundInt}
     *   1: SpecializationActive {@link RoundNode#roundCornercase}
     *   2: SpecializationActive {@link RoundNode#roundDoubleInt}
     *   3: SpecializationExcluded {@link RoundNode#roundDoubleInt}
     *   4: SpecializationActive {@link RoundNode#roundDouble}
     *   5-7: ImplicitCast[type=double, index=0]
     *   8-9: InlinedCache
     *        Specialization: {@link RoundNode#roundDoubleInt}
     *        Parameter: {@link InlinedConditionProfile} shiftProfile
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   10: InlinedCache
     *        Specialization: {@link RoundNode#roundDoubleInt}
     *        Parameter: {@link InlinedBranchProfile} negativeLongBitsProfile
     *        Inline method: {@link InlinedBranchProfile#inline}
     *   11-12: InlinedCache
     *        Specialization: {@link RoundNode#roundDouble}
     *        Parameter: {@link InlinedConditionProfile} profileA
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   13-14: InlinedCache
     *        Specialization: {@link RoundNode#roundDouble}
     *        Parameter: {@link InlinedConditionProfile} profileB
     *        Inline method: {@link InlinedConditionProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;

    private RoundNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[RoundNode.roundInt(int)] */ && ((state_0 & 0b10111) != 0  /* is-not SpecializationActive[RoundNode.roundInt(int)] && SpecializationActive[RoundNode.roundCornercase(double)] && SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] && SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b1) == 0 /* only-active SpecializationActive[RoundNode.roundCornercase(double)] && SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] && SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */ && ((state_0 & 0b10111) != 0  /* is-not SpecializationActive[RoundNode.roundInt(int)] && SpecializationActive[RoundNode.roundCornercase(double)] && SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] && SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[RoundNode.roundInt(int)] */;
        return RoundNode.roundInt(arguments0Value_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b10111) != 0  /* is-not SpecializationActive[RoundNode.roundInt(int)] && SpecializationActive[RoundNode.roundCornercase(double)] && SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] && SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b10111) != 0  /* is-not SpecializationActive[RoundNode.roundInt(int)] && SpecializationActive[RoundNode.roundCornercase(double)] && SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] && SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if ((state_0 & 0b10110) != 0 /* is SpecializationActive[RoundNode.roundCornercase(double)] || SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[RoundNode.roundCornercase(double)] */) {
                if ((RoundNode.isCornercase(arguments0Value_))) {
                    return RoundNode.roundCornercase(arguments0Value_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */) {
                if ((!(RoundNode.isCornercase(arguments0Value_))) && (JSGuards.isDoubleInInt32Range(arguments0Value_))) {
                    try {
                        return roundDoubleInt(arguments0Value_, INLINED_SHIFT_PROFILE, INLINED_NEGATIVE_LONG_BITS_PROFILE);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(arguments0Value_);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */) {
                if ((!(RoundNode.isCornercase(arguments0Value_)))) {
                    return roundDouble(arguments0Value_, INLINED_ROUND_DOUBLE_PROFILE_A_, INLINED_ROUND_DOUBLE_PROFILE_B_, INLINED_SHIFT_PROFILE, INLINED_NEGATIVE_LONG_BITS_PROFILE);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b10111) != 0  /* is-not SpecializationActive[RoundNode.roundInt(int)] && SpecializationActive[RoundNode.roundCornercase(double)] && SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] && SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */) ? (Object) arguments0Value_int : (Object) arguments0Value_));
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b10111) != 0 /* is SpecializationActive[RoundNode.roundInt(int)] || SpecializationActive[RoundNode.roundCornercase(double)] || SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[RoundNode.roundInt(int)] */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return RoundNode.roundInt(arguments0Value__);
            }
            if ((state_0 & 0b10110) != 0 /* is SpecializationActive[RoundNode.roundCornercase(double)] || SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[RoundNode.roundCornercase(double)] */) {
                    if ((RoundNode.isCornercase(arguments0Value__))) {
                        return RoundNode.roundCornercase(arguments0Value__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((!(RoundNode.isCornercase(arguments0Value__))) && (JSGuards.isDoubleInInt32Range(arguments0Value__))) {
                        try {
                            return roundDoubleInt(arguments0Value__, INLINED_SHIFT_PROFILE, INLINED_NEGATIVE_LONG_BITS_PROFILE);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(arguments0Value__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((!(RoundNode.isCornercase(arguments0Value__)))) {
                        return roundDouble(arguments0Value__, INLINED_ROUND_DOUBLE_PROFILE_A_, INLINED_ROUND_DOUBLE_PROFILE_B_, INLINED_SHIFT_PROFILE, INLINED_NEGATIVE_LONG_BITS_PROFILE);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        if (arguments0Value instanceof Integer) {
            int arguments0Value_ = (int) arguments0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[RoundNode.roundInt(int)] */;
            this.state_0_ = state_0;
            return RoundNode.roundInt(arguments0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                if ((RoundNode.isCornercase(arguments0Value_))) {
                    state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[RoundNode.roundCornercase(double)] */;
                    this.state_0_ = state_0;
                    return RoundNode.roundCornercase(arguments0Value_);
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    if ((!(RoundNode.isCornercase(arguments0Value_))) && (JSGuards.isDoubleInInt32Range(arguments0Value_))) {
                        state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */;
                        this.state_0_ = state_0;
                        try {
                            return roundDoubleInt(arguments0Value_, INLINED_SHIFT_PROFILE, INLINED_NEGATIVE_LONG_BITS_PROFILE);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(arguments0Value_);
                        }
                    }
                }
                if ((!(RoundNode.isCornercase(arguments0Value_)))) {
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[RoundNode.roundDoubleInt(double, InlinedConditionProfile, InlinedBranchProfile)] */;
                    state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[RoundNode.roundDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_ = state_0;
                    return roundDouble(arguments0Value_, INLINED_ROUND_DOUBLE_PROFILE_A_, INLINED_ROUND_DOUBLE_PROFILE_B_, INLINED_SHIFT_PROFILE, INLINED_NEGATIVE_LONG_BITS_PROFILE);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
    }

    @NeverDefault
    public static RoundNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new RoundNodeGen(context, builtin, arguments);
    }

}
