/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.runtime.interop.InteropBufferView;
import java.nio.ByteOrder;

@GeneratedBy(value=InteropBufferView.class)
final class InteropBufferViewGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private InteropBufferViewGen() {
    }

    static {
        LibraryExport.register(InteropBufferView.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=InteropBufferView.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet(INTEROP_LIBRARY_, (String[])new String[]{"hasBufferElements", "getBufferSize", "readBufferByte", "readBufferShort", "readBufferInt", "readBufferLong", "readBufferFloat", "readBufferDouble", "isBufferWritable", "writeBufferByte", "writeBufferShort", "writeBufferInt", "writeBufferLong", "writeBufferFloat", "writeBufferDouble"});
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropBufferView.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof InteropBufferView);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)UNCACHED);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof InteropBufferView);
            return (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=InteropBufferView.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((InteropBufferView)receiver_).arrayView;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropBufferView) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof InteropBufferView;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBufferView)receiver).hasBufferElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBufferView)receiver).getBufferSize();
            }

            @CompilerDirectives.TruffleBoundary
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                return arg0Value.readBufferByte(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.arrayBuffer));
            }

            @CompilerDirectives.TruffleBoundary
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                return arg0Value.readBufferShort(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.arrayBuffer));
            }

            @CompilerDirectives.TruffleBoundary
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                return arg0Value.readBufferInt(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.arrayBuffer));
            }

            @CompilerDirectives.TruffleBoundary
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                return arg0Value.readBufferLong(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.arrayBuffer));
            }

            @CompilerDirectives.TruffleBoundary
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                return arg0Value.readBufferFloat(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.arrayBuffer));
            }

            @CompilerDirectives.TruffleBoundary
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                return arg0Value.readBufferDouble(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.arrayBuffer));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBufferView)receiver).isBufferWritable();
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferByte(Object receiver, long byteOffset, byte value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferByte(byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferShort(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferInt(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferLong(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferFloat(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferDouble(order, byteOffset, value);
            }
        }

        @GeneratedBy(value=InteropBufferView.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverArrayBufferInteropLibrary_;
            @Node.Child
            private InteropLibrary receiverArrayViewInteropLibrary_;

            protected Cached(Object receiver) {
                InteropBufferView castReceiver = (InteropBufferView)receiver;
                this.receiverArrayBufferInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver.arrayBuffer);
                this.receiverArrayViewInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver.arrayView);
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((InteropBufferView)receiver_).arrayView;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverArrayViewInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropBufferView) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof InteropBufferView)) {
                    return false;
                }
                if (!this.receiverArrayBufferInteropLibrary_.accepts((Object)((InteropBufferView)receiver).arrayBuffer)) {
                    return false;
                }
                return this.receiverArrayViewInteropLibrary_.accepts((Object)((InteropBufferView)receiver).arrayView);
            }

            public boolean hasBufferElements(Object receiver) {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBufferView)receiver).hasBufferElements();
            }

            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBufferView)receiver).getBufferSize();
            }

            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (arg0Value_ instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                InteropLibrary bufferInterop__ = this.receiverArrayBufferInteropLibrary_;
                return arg0Value.readBufferByte(arg1Value, bufferInterop__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (arg0Value_ instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                InteropLibrary bufferInterop__ = this.receiverArrayBufferInteropLibrary_;
                return arg0Value.readBufferShort(arg1Value, arg2Value, bufferInterop__);
            }

            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (arg0Value_ instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                InteropLibrary bufferInterop__ = this.receiverArrayBufferInteropLibrary_;
                return arg0Value.readBufferInt(arg1Value, arg2Value, bufferInterop__);
            }

            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (arg0Value_ instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                InteropLibrary bufferInterop__ = this.receiverArrayBufferInteropLibrary_;
                return arg0Value.readBufferLong(arg1Value, arg2Value, bufferInterop__);
            }

            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (arg0Value_ instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                InteropLibrary bufferInterop__ = this.receiverArrayBufferInteropLibrary_;
                return arg0Value.readBufferFloat(arg1Value, arg2Value, bufferInterop__);
            }

            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (arg0Value_ instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                InteropBufferView arg0Value = (InteropBufferView)arg0Value_;
                InteropLibrary bufferInterop__ = this.receiverArrayBufferInteropLibrary_;
                return arg0Value.readBufferDouble(arg1Value, arg2Value, bufferInterop__);
            }

            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBufferView)receiver).isBufferWritable();
            }

            public void writeBufferByte(Object receiver, long byteOffset, byte value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferByte(byteOffset, value);
            }

            public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferShort(order, byteOffset, value);
            }

            public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferInt(order, byteOffset, value);
            }

            public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferLong(order, byteOffset, value);
            }

            public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferFloat(order, byteOffset, value);
            }

            public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (receiver instanceof InteropBufferView) : "Invalid library usage. Library does not accept given receiver.";
                ((InteropBufferView)receiver).writeBufferDouble(order, byteOffset, value);
            }
        }
    }
}

