/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSToInt32Node.class)
public final class JSToInt32NodeGen
extends JSToInt32Node {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private JSStringToNumberNode string_stringToNumberNode_;
    @Node.Child
    private JSToDoubleNode jSObject_toDoubleNode_;
    @Node.Child
    private ForeignObjectData foreignObject_cache;

    private JSToInt32NodeGen() {
    }

    @Override
    public int executeInt(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFFFF) != 0) {
            ForeignObjectData s15_;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return this.doInteger(arg0Value_);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                return this.doSafeInteger(arg0Value_);
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.doBoolean(arg0Value_);
            }
            if ((state_0 & 0x18) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if ((state_0 & 8) != 0 && JSRuntime.isSafeInteger(arg0Value_)) {
                    return JSToInt32Node.doLong(arg0Value_);
                }
                if ((state_0 & 0x10) != 0 && !JSRuntime.isSafeInteger(arg0Value_)) {
                    return JSToInt32Node.doLongNotSafeInteger(arg0Value_);
                }
            }
            if ((state_0 & 0x1E0) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x70000) >>> 16, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x70000) >>> 16, arg0Value);
                if ((state_0 & 0x20) != 0 && !JSGuards.isDoubleLargerThan2e32(arg0Value_)) {
                    return this.doDoubleFitsInt(arg0Value_);
                }
                if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(arg0Value_) && JSGuards.isDoubleRepresentableAsLong(arg0Value_) && JSGuards.isDoubleSafeInteger(arg0Value_)) {
                    return this.doDoubleRepresentableAsSafeInteger(arg0Value_);
                }
                if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(arg0Value_) && JSGuards.isDoubleRepresentableAsLong(arg0Value_)) {
                    return this.doDoubleRepresentableAsLong(arg0Value_);
                }
                if ((state_0 & 0x100) != 0 && JSGuards.isDoubleLargerThan2e32(arg0Value_) && !JSGuards.isDoubleRepresentableAsLong(arg0Value_)) {
                    return this.doDouble(arg0Value_);
                }
            }
            if ((state_0 & 0x600) != 0) {
                if ((state_0 & 0x200) != 0 && JSGuards.isUndefined(arg0Value)) {
                    return this.doUndefined(arg0Value);
                }
                if ((state_0 & 0x400) != 0 && JSGuards.isJSNull(arg0Value)) {
                    return this.doNull(arg0Value);
                }
            }
            if ((state_0 & 0x800) != 0 && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString)arg0Value;
                JSStringToNumberNode stringToNumberNode__ = this.string_stringToNumberNode_;
                if (stringToNumberNode__ != null) {
                    return this.doString(arg0Value_, stringToNumberNode__);
                }
            }
            if ((state_0 & 0x1000) != 0 && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                return this.doSymbol(arg0Value_);
            }
            if ((state_0 & 0x2000) != 0 && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                return this.doBigInt(arg0Value_);
            }
            if ((state_0 & 0x4000) != 0 && arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject)((Object)arg0Value);
                JSToDoubleNode toDoubleNode__ = this.jSObject_toDoubleNode_;
                if (toDoubleNode__ != null) {
                    return this.doJSObject(arg0Value_, toDoubleNode__);
                }
            }
            if ((state_0 & 0x8000) != 0 && (s15_ = this.foreignObject_cache) != null && JSRuntime.isForeignObject(arg0Value)) {
                return JSToInt32Node.doForeignObject(arg0Value, s15_.toPrimitiveNode_, s15_.toInt32Node_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private int executeAndSpecialize(Object arg0Value) {
        int doubleCast0;
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return this.doInteger(arg0Value_);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            this.state_0_ = state_0 |= 2;
            return this.doSafeInteger(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 4;
            return this.doBoolean(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            if (JSRuntime.isSafeInteger(arg0Value_)) {
                this.state_0_ = state_0 |= 8;
                return JSToInt32Node.doLong(arg0Value_);
            }
            if (!JSRuntime.isSafeInteger(arg0Value_)) {
                this.state_0_ = state_0 |= 0x10;
                return JSToInt32Node.doLongNotSafeInteger(arg0Value_);
            }
        }
        if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            if (!JSGuards.isDoubleLargerThan2e32(arg0Value_)) {
                state_0 |= doubleCast0 << 16;
                this.state_0_ = state_0 |= 0x20;
                return this.doDoubleFitsInt(arg0Value_);
            }
            if ((state_0 & 0x80) == 0 && JSGuards.isDoubleLargerThan2e32(arg0Value_) && JSGuards.isDoubleRepresentableAsLong(arg0Value_) && JSGuards.isDoubleSafeInteger(arg0Value_)) {
                state_0 |= doubleCast0 << 16;
                this.state_0_ = state_0 |= 0x40;
                return this.doDoubleRepresentableAsSafeInteger(arg0Value_);
            }
            if (JSGuards.isDoubleLargerThan2e32(arg0Value_) && JSGuards.isDoubleRepresentableAsLong(arg0Value_)) {
                state_0 &= 0xFFFFFFBF;
                state_0 |= doubleCast0 << 16;
                this.state_0_ = state_0 |= 0x80;
                return this.doDoubleRepresentableAsLong(arg0Value_);
            }
            if (JSGuards.isDoubleLargerThan2e32(arg0Value_) && !JSGuards.isDoubleRepresentableAsLong(arg0Value_)) {
                state_0 |= doubleCast0 << 16;
                this.state_0_ = state_0 |= 0x100;
                return this.doDouble(arg0Value_);
            }
        }
        if (JSGuards.isUndefined(arg0Value)) {
            this.state_0_ = state_0 |= 0x200;
            return this.doUndefined(arg0Value);
        }
        if (JSGuards.isJSNull(arg0Value)) {
            this.state_0_ = state_0 |= 0x400;
            return this.doNull(arg0Value);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString)arg0Value;
            JSStringToNumberNode stringToNumberNode__ = (JSStringToNumberNode)this.insert(JSStringToNumberNode.create());
            Objects.requireNonNull(stringToNumberNode__, "Specialization 'doString(TruffleString, JSStringToNumberNode)' cache 'stringToNumberNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.string_stringToNumberNode_ = stringToNumberNode__;
            this.state_0_ = state_0 |= 0x800;
            return this.doString(arg0Value_, stringToNumberNode__);
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            this.state_0_ = state_0 |= 0x1000;
            return this.doSymbol(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            this.state_0_ = state_0 |= 0x2000;
            return this.doBigInt(arg0Value_);
        }
        if (arg0Value instanceof JSObject) {
            JSObject arg0Value_ = (JSObject)((Object)arg0Value);
            JSToDoubleNode toDoubleNode__ = (JSToDoubleNode)this.insert(JSToDoubleNode.create());
            Objects.requireNonNull(toDoubleNode__, "Specialization 'doJSObject(JSObject, JSToDoubleNode)' cache 'toDoubleNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.jSObject_toDoubleNode_ = toDoubleNode__;
            this.state_0_ = state_0 |= 0x4000;
            return this.doJSObject(arg0Value_, toDoubleNode__);
        }
        if (JSRuntime.isForeignObject(arg0Value)) {
            ForeignObjectData s15_ = (ForeignObjectData)this.insert(new ForeignObjectData());
            JSToPrimitiveNode toPrimitiveNode__ = (JSToPrimitiveNode)s15_.insert(JSToPrimitiveNode.createHintNumber());
            Objects.requireNonNull(toPrimitiveNode__, "Specialization 'doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)' cache 'toPrimitiveNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s15_.toPrimitiveNode_ = toPrimitiveNode__;
            JSToInt32Node toInt32Node__ = (JSToInt32Node)s15_.insert(JSToInt32Node.create());
            Objects.requireNonNull(toInt32Node__, "Specialization 'doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)' cache 'toInt32Node' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s15_.toInt32Node_ = toInt32Node__;
            VarHandle.storeStoreFence();
            this.foreignObject_cache = s15_;
            this.state_0_ = state_0 |= 0x8000;
            return JSToInt32Node.doForeignObject(arg0Value, toPrimitiveNode__, toInt32Node__);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xFFFF & (state_0 & 0xFFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @NeverDefault
    public static JSToInt32Node create() {
        return new JSToInt32NodeGen();
    }

    @NeverDefault
    public static JSToInt32Node getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JSToInt32Node.class)
    @DenyReplace
    private static final class ForeignObjectData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        JSToPrimitiveNode toPrimitiveNode_;
        @Node.Child
        JSToInt32Node toInt32Node_;

        ForeignObjectData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=JSToInt32Node.class)
    @DenyReplace
    private static final class Uncached
    extends JSToInt32Node {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int executeInt(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return this.doInteger(arg0Value_);
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                return this.doSafeInteger(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.doBoolean(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if (JSRuntime.isSafeInteger(arg0Value_)) {
                    return JSToInt32Node.doLong(arg0Value_);
                }
                if (!JSRuntime.isSafeInteger(arg0Value_)) {
                    return JSToInt32Node.doLongNotSafeInteger(arg0Value_);
                }
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                if (!JSGuards.isDoubleLargerThan2e32(arg0Value_)) {
                    return this.doDoubleFitsInt(arg0Value_);
                }
                if (JSGuards.isDoubleLargerThan2e32(arg0Value_) && JSGuards.isDoubleRepresentableAsLong(arg0Value_)) {
                    return this.doDoubleRepresentableAsLong(arg0Value_);
                }
                if (JSGuards.isDoubleLargerThan2e32(arg0Value_) && !JSGuards.isDoubleRepresentableAsLong(arg0Value_)) {
                    return this.doDouble(arg0Value_);
                }
            }
            if (JSGuards.isUndefined(arg0Value)) {
                return this.doUndefined(arg0Value);
            }
            if (JSGuards.isJSNull(arg0Value)) {
                return this.doNull(arg0Value);
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString)arg0Value;
                return this.doString(arg0Value_, JSStringToNumberNodeGen.getUncached());
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                return this.doSymbol(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                return this.doBigInt(arg0Value_);
            }
            if (arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject)((Object)arg0Value);
                return this.doJSObject(arg0Value_, JSToDoubleNodeGen.getUncached());
            }
            if (JSRuntime.isForeignObject(arg0Value)) {
                return JSToInt32Node.doForeignObject(arg0Value, JSToPrimitiveNode.getUncachedHintNumber(), JSToInt32NodeGen.getUncached());
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=JSToInt32Node.JSToInt32UnaryNode.class)
    public static final class JSToInt32UnaryNodeGen
    extends JSToInt32Node.JSToInt32UnaryNode {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private JSStringToNumberNode string_stringToNumberNode_;
        @Node.Child
        private JSOverloadedBinaryNode overloadedOperator_overloadedOperatorNode_;
        @Node.Child
        private JSToDoubleNode jSObject_toDoubleNode_;
        @Node.Child
        private ForeignObjectData foreignObject_cache;

        private JSToInt32UnaryNodeGen(JavaScriptNode operand, boolean bitwiseOr) {
            super(operand, bitwiseOr);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFFF) != 0) {
                ForeignObjectData s16_;
                if ((state_0 & 1) != 0 && operandNodeValue instanceof Integer) {
                    int operandNodeValue_ = (Integer)operandNodeValue;
                    return this.doInteger(operandNodeValue_);
                }
                if ((state_0 & 2) != 0 && operandNodeValue instanceof SafeInteger) {
                    SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
                    return this.doSafeInteger(operandNodeValue_);
                }
                if ((state_0 & 4) != 0 && operandNodeValue instanceof Boolean) {
                    boolean operandNodeValue_ = (Boolean)operandNodeValue;
                    return this.doBoolean(operandNodeValue_);
                }
                if ((state_0 & 0x18) != 0 && operandNodeValue instanceof Long) {
                    long operandNodeValue_ = (Long)operandNodeValue;
                    if ((state_0 & 8) != 0 && JSRuntime.isSafeInteger(operandNodeValue_)) {
                        return JSToInt32Node.JSToInt32UnaryNode.doLong(operandNodeValue_);
                    }
                    if ((state_0 & 0x10) != 0 && !JSRuntime.isSafeInteger(operandNodeValue_)) {
                        return JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(operandNodeValue_);
                    }
                }
                if ((state_0 & 0x1E0) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xE0000) >>> 17, operandNodeValue)) {
                    double operandNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0xE0000) >>> 17, operandNodeValue);
                    if ((state_0 & 0x20) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) {
                        return this.doDoubleFitsInt(operandNodeValue_);
                    }
                    if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_) && JSGuards.isDoubleSafeInteger(operandNodeValue_)) {
                        return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_);
                    }
                    if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
                        return this.doDoubleRepresentableAsLong(operandNodeValue_);
                    }
                    if ((state_0 & 0x100) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
                        return this.doDouble(operandNodeValue_);
                    }
                }
                if ((state_0 & 0x600) != 0) {
                    if ((state_0 & 0x200) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                        return this.doUndefined(operandNodeValue);
                    }
                    if ((state_0 & 0x400) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                        return this.doNull(operandNodeValue);
                    }
                }
                if ((state_0 & 0x800) != 0 && operandNodeValue instanceof TruffleString) {
                    TruffleString operandNodeValue_ = (TruffleString)operandNodeValue;
                    JSStringToNumberNode stringToNumberNode__ = this.string_stringToNumberNode_;
                    if (stringToNumberNode__ != null) {
                        return this.doString(operandNodeValue_, stringToNumberNode__);
                    }
                }
                if ((state_0 & 0x1000) != 0 && operandNodeValue instanceof Symbol) {
                    Symbol operandNodeValue_ = (Symbol)operandNodeValue;
                    return this.doSymbol(operandNodeValue_);
                }
                if ((state_0 & 0x2000) != 0 && operandNodeValue instanceof BigInt) {
                    BigInt operandNodeValue_ = (BigInt)operandNodeValue;
                    return this.doBigInt(operandNodeValue_);
                }
                if ((state_0 & 0x4000) != 0 && operandNodeValue instanceof JSOverloadedOperatorsObject) {
                    JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject)operandNodeValue;
                    JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloadedOperator_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        assert (DSLSupport.assertIdempotence((boolean)this.isBitwiseOr()));
                        return this.doOverloadedOperator(operandNodeValue_, overloadedOperatorNode__);
                    }
                }
                if ((state_0 & 0x8000) != 0 && operandNodeValue instanceof JSObject) {
                    JSObject operandNodeValue_ = (JSObject)((Object)operandNodeValue);
                    JSToDoubleNode toDoubleNode__ = this.jSObject_toDoubleNode_;
                    if (!(toDoubleNode__ == null || this.isBitwiseOr() && this.hasOverloadedOperators((Object)operandNodeValue_))) {
                        return this.doJSObject(operandNodeValue_, toDoubleNode__);
                    }
                }
                if ((state_0 & 0x10000) != 0 && (s16_ = this.foreignObject_cache) != null && JSRuntime.isForeignObject(operandNodeValue)) {
                    return JSToInt32Node.JSToInt32UnaryNode.doForeignObject(operandNodeValue, s16_.toPrimitiveNode_, s16_.toInt32Node_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1BFFE) == 0 && (state_0 & 0x1BFFF) != 0) {
                return this.executeInt_int0(state_0, frameValue);
            }
            if ((state_0 & 0x1BFFB) == 0 && (state_0 & 0x1BFFF) != 0) {
                return this.executeInt_boolean1(state_0, frameValue);
            }
            if ((state_0 & 0x1BFE7) == 0 && (state_0 & 0x1BFFF) != 0) {
                return this.executeInt_long2(state_0, frameValue);
            }
            if ((state_0 & 0x1BE1F) == 0 && (state_0 & 0x1BFFF) != 0) {
                return this.executeInt_double3(state_0, frameValue);
            }
            return this.executeInt_generic4(state_0, frameValue);
        }

        private int executeInt_int0(int state_0__, VirtualFrame frameValue) {
            int operandNodeValue_;
            int state_0 = state_0__;
            try {
                operandNodeValue_ = this.operandNode.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return (Integer)this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            return this.doInteger(operandNodeValue_);
        }

        private int executeInt_boolean1(int state_0__, VirtualFrame frameValue) {
            boolean operandNodeValue_;
            int state_0 = state_0__;
            try {
                operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return (Integer)this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doBoolean(operandNodeValue_);
        }

        private int executeInt_long2(int state_0__, VirtualFrame frameValue) {
            long operandNodeValue_;
            int state_0 = state_0__;
            try {
                operandNodeValue_ = this.operandNode.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return (Integer)this.executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0x18) != 0) {
                if ((state_0 & 8) != 0 && JSRuntime.isSafeInteger(operandNodeValue_)) {
                    return JSToInt32Node.JSToInt32UnaryNode.doLong(operandNodeValue_);
                }
                if ((state_0 & 0x10) != 0 && !JSRuntime.isSafeInteger(operandNodeValue_)) {
                    return JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(operandNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Integer)this.executeAndSpecialize(operandNodeValue_);
        }

        private int executeInt_double3(int state_0__, VirtualFrame frameValue) {
            double operandNodeValue_;
            int state_0 = state_0__;
            int operandNodeValue_int = 0;
            try {
                if ((state_0 & 0xC0000) == 0 && (state_0 & 0x1FFFF) != 0) {
                    operandNodeValue_ = this.operandNode.executeDouble(frameValue);
                } else if ((state_0 & 0xA0000) == 0 && (state_0 & 0x1FFFF) != 0) {
                    operandNodeValue_int = this.operandNode.executeInt(frameValue);
                    operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
                } else {
                    Object operandNodeValue__ = this.operandNode.execute(frameValue);
                    operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0xE0000) >>> 17, operandNodeValue__);
                }
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return (Integer)this.executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0x1E0) != 0) {
                if ((state_0 & 0x20) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) {
                    return this.doDoubleFitsInt(operandNodeValue_);
                }
                if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_) && JSGuards.isDoubleSafeInteger(operandNodeValue_)) {
                    return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_);
                }
                if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
                    return this.doDoubleRepresentableAsLong(operandNodeValue_);
                }
                if ((state_0 & 0x100) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
                    return this.doDouble(operandNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Integer)this.executeAndSpecialize((state_0 & 0xA0000) == 0 && (state_0 & 0x1FFFF) != 0 ? (Number)operandNodeValue_int : (Number)operandNodeValue_);
        }

        private int executeInt_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            if ((state_0 & 0x1BFFF) != 0) {
                ForeignObjectData s16_;
                if ((state_0 & 1) != 0 && operandNodeValue_ instanceof Integer) {
                    int operandNodeValue__ = (Integer)operandNodeValue_;
                    return this.doInteger(operandNodeValue__);
                }
                if ((state_0 & 2) != 0 && operandNodeValue_ instanceof SafeInteger) {
                    SafeInteger operandNodeValue__ = (SafeInteger)operandNodeValue_;
                    return this.doSafeInteger(operandNodeValue__);
                }
                if ((state_0 & 4) != 0 && operandNodeValue_ instanceof Boolean) {
                    boolean operandNodeValue__ = (Boolean)operandNodeValue_;
                    return this.doBoolean(operandNodeValue__);
                }
                if ((state_0 & 0x18) != 0 && operandNodeValue_ instanceof Long) {
                    long operandNodeValue__ = (Long)operandNodeValue_;
                    if ((state_0 & 8) != 0 && JSRuntime.isSafeInteger(operandNodeValue__)) {
                        return JSToInt32Node.JSToInt32UnaryNode.doLong(operandNodeValue__);
                    }
                    if ((state_0 & 0x10) != 0 && !JSRuntime.isSafeInteger(operandNodeValue__)) {
                        return JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(operandNodeValue__);
                    }
                }
                if ((state_0 & 0x1E0) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xE0000) >>> 17, operandNodeValue_)) {
                    double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0xE0000) >>> 17, operandNodeValue_);
                    if ((state_0 & 0x20) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue__)) {
                        return this.doDoubleFitsInt(operandNodeValue__);
                    }
                    if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue__) && JSGuards.isDoubleSafeInteger(operandNodeValue__)) {
                        return this.doDoubleRepresentableAsSafeInteger(operandNodeValue__);
                    }
                    if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue__)) {
                        return this.doDoubleRepresentableAsLong(operandNodeValue__);
                    }
                    if ((state_0 & 0x100) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue__)) {
                        return this.doDouble(operandNodeValue__);
                    }
                }
                if ((state_0 & 0x600) != 0) {
                    if ((state_0 & 0x200) != 0 && JSGuards.isUndefined(operandNodeValue_)) {
                        return this.doUndefined(operandNodeValue_);
                    }
                    if ((state_0 & 0x400) != 0 && JSGuards.isJSNull(operandNodeValue_)) {
                        return this.doNull(operandNodeValue_);
                    }
                }
                if ((state_0 & 0x800) != 0 && operandNodeValue_ instanceof TruffleString) {
                    TruffleString operandNodeValue__ = (TruffleString)operandNodeValue_;
                    JSStringToNumberNode stringToNumberNode__ = this.string_stringToNumberNode_;
                    if (stringToNumberNode__ != null) {
                        return this.doString(operandNodeValue__, stringToNumberNode__);
                    }
                }
                if ((state_0 & 0x1000) != 0 && operandNodeValue_ instanceof Symbol) {
                    Symbol operandNodeValue__ = (Symbol)operandNodeValue_;
                    return this.doSymbol(operandNodeValue__);
                }
                if ((state_0 & 0x2000) != 0 && operandNodeValue_ instanceof BigInt) {
                    BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
                    return this.doBigInt(operandNodeValue__);
                }
                if ((state_0 & 0x8000) != 0 && operandNodeValue_ instanceof JSObject) {
                    JSObject operandNodeValue__ = (JSObject)((Object)operandNodeValue_);
                    JSToDoubleNode toDoubleNode__ = this.jSObject_toDoubleNode_;
                    if (!(toDoubleNode__ == null || this.isBitwiseOr() && this.hasOverloadedOperators((Object)operandNodeValue__))) {
                        return this.doJSObject(operandNodeValue__, toDoubleNode__);
                    }
                }
                if ((state_0 & 0x10000) != 0 && (s16_ = this.foreignObject_cache) != null && JSRuntime.isForeignObject(operandNodeValue_)) {
                    return JSToInt32Node.JSToInt32UnaryNode.doForeignObject(operandNodeValue_, s16_.toPrimitiveNode_, s16_.toInt32Node_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Integer)this.executeAndSpecialize(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x4000) == 0 && (state_0 & 0x1FFFF) != 0) {
                this.executeInt(frameValue);
                return;
            }
            this.executeInt(frameValue);
        }

        private Object executeAndSpecialize(Object operandNodeValue) {
            int doubleCast0;
            int state_0 = this.state_0_;
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (Integer)operandNodeValue;
                this.state_0_ = state_0 |= 1;
                return this.doInteger(operandNodeValue_);
            }
            if (operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doSafeInteger(operandNodeValue_);
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_ = (Boolean)operandNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doBoolean(operandNodeValue_);
            }
            if (operandNodeValue instanceof Long) {
                long operandNodeValue_ = (Long)operandNodeValue;
                if (JSRuntime.isSafeInteger(operandNodeValue_)) {
                    this.state_0_ = state_0 |= 8;
                    return JSToInt32Node.JSToInt32UnaryNode.doLong(operandNodeValue_);
                }
                if (!JSRuntime.isSafeInteger(operandNodeValue_)) {
                    this.state_0_ = state_0 |= 0x10;
                    return JSToInt32Node.JSToInt32UnaryNode.doLongNotSafeInteger(operandNodeValue_);
                }
            }
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if (!JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) {
                    state_0 |= doubleCast0 << 17;
                    this.state_0_ = state_0 |= 0x20;
                    return this.doDoubleFitsInt(operandNodeValue_);
                }
                if ((state_0 & 0x80) == 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_) && JSGuards.isDoubleSafeInteger(operandNodeValue_)) {
                    state_0 |= doubleCast0 << 17;
                    this.state_0_ = state_0 |= 0x40;
                    return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_);
                }
                if (JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
                    state_0 &= 0xFFFFFFBF;
                    state_0 |= doubleCast0 << 17;
                    this.state_0_ = state_0 |= 0x80;
                    return this.doDoubleRepresentableAsLong(operandNodeValue_);
                }
                if (JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
                    state_0 |= doubleCast0 << 17;
                    this.state_0_ = state_0 |= 0x100;
                    return this.doDouble(operandNodeValue_);
                }
            }
            if (JSGuards.isUndefined(operandNodeValue)) {
                this.state_0_ = state_0 |= 0x200;
                return this.doUndefined(operandNodeValue);
            }
            if (JSGuards.isJSNull(operandNodeValue)) {
                this.state_0_ = state_0 |= 0x400;
                return this.doNull(operandNodeValue);
            }
            if (operandNodeValue instanceof TruffleString) {
                TruffleString operandNodeValue_ = (TruffleString)operandNodeValue;
                JSStringToNumberNode stringToNumberNode__ = (JSStringToNumberNode)this.insert(JSStringToNumberNode.create());
                Objects.requireNonNull(stringToNumberNode__, "Specialization 'doString(TruffleString, JSStringToNumberNode)' cache 'stringToNumberNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.string_stringToNumberNode_ = stringToNumberNode__;
                this.state_0_ = state_0 |= 0x800;
                return this.doString(operandNodeValue_, stringToNumberNode__);
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_ = (Symbol)operandNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doSymbol(operandNodeValue_);
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt)operandNodeValue;
                this.state_0_ = state_0 |= 0x2000;
                return this.doBigInt(operandNodeValue_);
            }
            if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject)operandNodeValue;
                if (this.isBitwiseOr()) {
                    JSOverloadedBinaryNode overloadedOperatorNode__ = (JSOverloadedBinaryNode)this.insert(JSOverloadedBinaryNode.createNumeric(this.getOverloadedOperatorName()));
                    Objects.requireNonNull(overloadedOperatorNode__, "Specialization 'doOverloadedOperator(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)' cache 'overloadedOperatorNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.overloadedOperator_overloadedOperatorNode_ = overloadedOperatorNode__;
                    this.state_0_ = state_0 |= 0x4000;
                    return this.doOverloadedOperator(operandNodeValue_, overloadedOperatorNode__);
                }
            }
            if (operandNodeValue instanceof JSObject) {
                JSObject operandNodeValue_ = (JSObject)((Object)operandNodeValue);
                if (!this.isBitwiseOr() || !this.hasOverloadedOperators((Object)operandNodeValue_)) {
                    JSToDoubleNode toDoubleNode__ = (JSToDoubleNode)this.insert(JSToDoubleNode.create());
                    Objects.requireNonNull(toDoubleNode__, "Specialization 'doJSObject(JSObject, JSToDoubleNode)' cache 'toDoubleNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.jSObject_toDoubleNode_ = toDoubleNode__;
                    this.state_0_ = state_0 |= 0x8000;
                    return this.doJSObject(operandNodeValue_, toDoubleNode__);
                }
            }
            if (JSRuntime.isForeignObject(operandNodeValue)) {
                ForeignObjectData s16_ = (ForeignObjectData)this.insert(new ForeignObjectData());
                JSToPrimitiveNode toPrimitiveNode__ = (JSToPrimitiveNode)s16_.insert(JSToPrimitiveNode.createHintNumber());
                Objects.requireNonNull(toPrimitiveNode__, "Specialization 'doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)' cache 'toPrimitiveNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s16_.toPrimitiveNode_ = toPrimitiveNode__;
                JSToInt32Node toInt32Node__ = (JSToInt32Node)s16_.insert(JSToInt32Node.create());
                Objects.requireNonNull(toInt32Node__, "Specialization 'doForeignObject(Object, JSToPrimitiveNode, JSToInt32Node)' cache 'toInt32Node' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s16_.toInt32Node_ = toInt32Node__;
                VarHandle.storeStoreFence();
                this.foreignObject_cache = s16_;
                this.state_0_ = state_0 |= 0x10000;
                return JSToInt32Node.JSToInt32UnaryNode.doForeignObject(operandNodeValue, toPrimitiveNode__, toInt32Node__);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFFF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FFFF & (state_0 & 0x1FFFF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static JSToInt32Node.JSToInt32UnaryNode create(JavaScriptNode operand, boolean bitwiseOr) {
            return new JSToInt32UnaryNodeGen(operand, bitwiseOr);
        }

        @GeneratedBy(value=JSToInt32Node.JSToInt32UnaryNode.class)
        @DenyReplace
        private static final class ForeignObjectData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            JSToPrimitiveNode toPrimitiveNode_;
            @Node.Child
            JSToInt32Node toInt32Node_;

            ForeignObjectData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }
}

