/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CachedSetPropertyNodeGen;
import com.oracle.truffle.js.nodes.access.FrequencyBasedPolymorphicAccessNode;
import com.oracle.truffle.js.nodes.access.JSProxyPropertySetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNoToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

@ImportStatic(value={JSRuntime.class})
abstract class CachedSetPropertyNode
extends JavaScriptBaseNode {
    static final int MAX_DEPTH = 1;
    protected final JSContext context;
    protected final boolean strict;
    protected final boolean setOwn;
    protected final boolean superProperty;

    CachedSetPropertyNode(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        this.context = context;
        this.strict = strict;
        this.setOwn = setOwn;
        this.superProperty = superProperty;
    }

    public abstract void execute(JSDynamicObject var1, Object var2, Object var3, Object var4);

    static CachedSetPropertyNode create(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        return CachedSetPropertyNodeGen.create(context, strict, setOwn, superProperty);
    }

    @Specialization(guards={"cachedKey != null", "!isArrayIndex(cachedKey)", "propertyKeyEquals(equalsNode, cachedKey, key)"}, limit="MAX_DEPTH")
    void doCachedKey(JSDynamicObject target, Object key, Object value, Object receiver, @Cached(value="propertyKeyOrNull(key)") Object cachedKey, @Cached(value="createSet(cachedKey)") PropertySetNode propertyNode, @Cached @Cached.Shared(value="strEq") TruffleString.EqualNode equalsNode) {
        propertyNode.setValue((Object)target, value, receiver);
    }

    @Specialization(guards={"isArrayIndex(index)", "!isJSProxy(target)"})
    void doIntIndex(JSDynamicObject target, int index, Object value, Object receiver, @Cached @Cached.Shared(value="jsclassProf") JSClassProfile jsclassProfile) {
        this.doArrayIndexLong(target, index, value, receiver, jsclassProfile.getJSClass(target));
    }

    @Specialization(guards={"!isJSProxy(target)", "index >= 0"}, replaces={"doIntIndex"}, limit="1")
    void doArrayIndex(JSDynamicObject target, Object key, Object value, Object receiver, @Cached ToArrayIndexNoToPropertyKeyNode toArrayIndexNode, @Bind(value="toArrayIndexNode.executeLong(this, key)") long index, @Cached @Cached.Shared(value="jsclassProf") JSClassProfile jsclassProfile) {
        assert (JSRuntime.isArrayIndex(index)) : index;
        this.doArrayIndexLong(target, index, value, receiver, jsclassProfile.getJSClass(target));
    }

    private void doArrayIndexLong(JSDynamicObject target, long index, Object value, Object receiver, JSClass jsclass) {
        if (this.setOwn) {
            CachedSetPropertyNode.createDataPropertyOrThrow(target, Strings.fromLong(index), value);
        } else {
            jsclass.set(target, index, value, receiver, this.strict, (Node)this);
        }
    }

    @Specialization(guards={"isJSProxy(target)"})
    void doProxy(JSDynamicObject target, Object index, Object value, Object receiver, @Cached(value="create(context, strict)") JSProxyPropertySetNode proxySet) {
        if (this.setOwn) {
            CachedSetPropertyNode.createDataPropertyOrThrow(target, proxySet.toPropertyKey(index), value);
        } else {
            proxySet.executeWithReceiverAndValue((Object)target, receiver, value, index);
        }
    }

    @Specialization(replaces={"doCachedKey", "doArrayIndex", "doProxy"})
    void doGeneric(JSDynamicObject target, Object key, Object value, Object receiver, @Bind(value="this") Node node, @Cached ToArrayIndexNode toArrayIndexNode, @Cached InlinedConditionProfile getType, @Cached @Cached.Shared(value="jsclassProf") JSClassProfile jsclassProfile, @Cached InlinedConditionProfile highFrequency, @Cached(value="create(context, setOwn, strict, superProperty)") FrequencyBasedPolymorphicAccessNode.FrequencyBasedPropertySetNode hotKey, @Cached @Cached.Shared(value="strEq") TruffleString.EqualNode equalsNode) {
        Object arrayIndex = toArrayIndexNode.execute(key);
        if (getType.profile(node, arrayIndex instanceof Long)) {
            long index = (Long)arrayIndex;
            this.doArrayIndexLong(target, index, value, receiver, jsclassProfile.getJSClass(target));
        } else {
            if (highFrequency.profile(node, hotKey.executeFastSet(target, arrayIndex, value, receiver, equalsNode))) {
                return;
            }
            if (this.setOwn) {
                CachedSetPropertyNode.createDataPropertyOrThrow(target, arrayIndex, value);
            } else {
                JSObject.setWithReceiver(target, arrayIndex, value, receiver, this.strict, jsclassProfile, (Node)this);
            }
        }
    }

    private static void createDataPropertyOrThrow(JSDynamicObject target, Object propertyKey, Object value) {
        JSObject.defineOwnProperty(target, propertyKey, PropertyDescriptor.createDataDefault(value), true);
    }

    @NeverDefault
    PropertySetNode createSet(Object key) {
        return PropertySetNode.createImpl(key, false, this.context, this.strict, this.setOwn, JSAttributes.getDefault(), false, this.superProperty);
    }

    static Object propertyKeyOrNull(Object key) {
        return JSRuntime.isPropertyKey(key) ? key : null;
    }
}

