/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import org.graalvm.buildtools.utils.SharedConstants;

public class NativeImageUtils {
    public static void maybeCreateConfigureUtilSymlink(File configureUtilFile, Path nativeImageExecutablePath) {
        if (!configureUtilFile.exists()) {
            Path target = configureUtilFile.toPath();
            Path source = nativeImageExecutablePath.getParent().getParent().resolve("lib/svm/bin/" + NativeImageUtils.nativeImageConfigureFileName());
            if (Files.exists(source, new LinkOption[0])) {
                try {
                    Files.createLink(target, source);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String nativeImageConfigureFileName() {
        return "native-image-configure" + SharedConstants.GRAALVM_EXE_EXTENSION;
    }

    public static List<String> convertToArgsFile(List<String> cliArgs) {
        try {
            File tmpFile = File.createTempFile("native-image", "args");
            tmpFile.deleteOnExit();
            Files.write(tmpFile.toPath(), cliArgs, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            return Collections.singletonList("@" + tmpFile.getAbsolutePath());
        }
        catch (IOException e) {
            return Collections.unmodifiableList(cliArgs);
        }
    }
}

