/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class JarMetadata {
    private final List<String> packageList;

    public JarMetadata(List<String> packageList) {
        this.packageList = packageList;
    }

    public List<String> getPackageList() {
        return this.packageList;
    }

    public static JarMetadata readFrom(Path propertiesFile) {
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(propertiesFile, new OpenOption[0]);){
            props.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read metadata from properties file " + String.valueOf(propertiesFile), e);
        }
        String packages = (String)props.get("packages");
        List<String> packageList = packages == null ? List.of() : Arrays.asList(packages.split(","));
        return new JarMetadata(packageList);
    }
}

