/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.model.resources;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.graalvm.buildtools.model.resources.NamedValue;
import org.graalvm.buildtools.model.resources.PatternValue;
import org.graalvm.buildtools.model.resources.ResourcesConfigModel;
import org.graalvm.buildtools.model.resources.ResourcesModel;

public class ResourcesConfigModelSerializer {
    public static void serialize(ResourcesConfigModel model, File outputFile) throws IOException {
        JSONObject json = ResourcesConfigModelSerializer.toJson(model);
        String pretty = json.toString(2);
        File outputDir = outputFile.getParentFile();
        if (outputDir.isDirectory() || outputDir.mkdirs()) {
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);){
                out.append(pretty);
            }
        }
    }

    private static JSONObject toJson(ResourcesConfigModel model) {
        JSONObject json = new JSONObject();
        json.put("resources", (Object)ResourcesConfigModelSerializer.toJson(model.getResources()));
        JSONArray namedValues = new JSONArray();
        model.getBundles().forEach(namedValue -> namedValues.put((Object)ResourcesConfigModelSerializer.toJson(namedValue)));
        json.put("bundles", (Object)namedValues);
        return json;
    }

    private static JSONObject toJson(ResourcesModel model) {
        JSONObject json = new JSONObject();
        JSONArray includes = new JSONArray();
        model.getIncludes().forEach(patternValue -> includes.put((Object)ResourcesConfigModelSerializer.toJson(patternValue)));
        json.put("includes", (Object)includes);
        JSONArray excludes = new JSONArray();
        model.getExcludes().forEach(patternValue -> excludes.put((Object)ResourcesConfigModelSerializer.toJson(patternValue)));
        json.put("excludes", (Object)excludes);
        return json;
    }

    private static JSONObject toJson(PatternValue patternValue) {
        JSONObject json = new JSONObject();
        json.put("pattern", (Object)patternValue.getPattern());
        return json;
    }

    private static JSONObject toJson(NamedValue namedValue) {
        JSONObject json = new JSONObject();
        json.put("name", (Object)namedValue.getName());
        return json;
    }
}

