/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.DisabledAgentMode;

public class AgentConfiguration
implements Serializable {
    private static final String ACCESS_FILTER_PREFIX = "access-filter";
    private static final String ACCESS_FILTER_SUFFIX = ".json";
    private static final String DEFAULT_ACCESS_FILTER_FILE_LOCATION = "/access-filter.json";
    private static final Logger logger = Logger.getGlobal();
    private final Collection<String> callerFilterFiles;
    private final Collection<String> accessFilterFiles;
    private final Boolean builtinCallerFilter;
    private final Boolean builtinHeuristicFilter;
    private final Boolean experimentalPredefinedClasses;
    private final Boolean experimentalUnsafeAllocationTracing;
    private final Boolean trackReflectionMetadata;
    private final AgentMode agentMode;

    public AgentConfiguration(AgentMode ... modes) {
        this.callerFilterFiles = null;
        this.accessFilterFiles = null;
        this.builtinCallerFilter = null;
        this.builtinHeuristicFilter = null;
        this.experimentalPredefinedClasses = null;
        this.experimentalUnsafeAllocationTracing = null;
        this.trackReflectionMetadata = null;
        this.agentMode = modes.length == 1 ? modes[0] : new DisabledAgentMode();
    }

    public AgentConfiguration(Collection<String> callerFilterFiles, Collection<String> accessFilterFiles, Boolean builtinCallerFilter, Boolean builtinHeuristicFilter, Boolean experimentalPredefinedClasses, Boolean experimentalUnsafeAllocationTracing, Boolean trackReflectionMetadata, AgentMode agentMode) {
        this.callerFilterFiles = callerFilterFiles;
        this.accessFilterFiles = accessFilterFiles;
        this.builtinCallerFilter = builtinCallerFilter;
        this.builtinHeuristicFilter = builtinHeuristicFilter;
        this.experimentalPredefinedClasses = experimentalPredefinedClasses;
        this.experimentalUnsafeAllocationTracing = experimentalUnsafeAllocationTracing;
        this.trackReflectionMetadata = trackReflectionMetadata;
        this.agentMode = agentMode;
    }

    public List<String> getAgentCommandLine() {
        this.addDefaultAccessFilter();
        ArrayList<String> cmdLine = new ArrayList<String>(this.agentMode.getAgentCommandLine());
        AgentConfiguration.appendOptionToValues("caller-filter-file=", this.callerFilterFiles, cmdLine);
        AgentConfiguration.appendOptionToValues("access-filter-file=", this.accessFilterFiles, cmdLine);
        this.addToCmd("builtin-caller-filter=", this.builtinCallerFilter, cmdLine);
        this.addToCmd("builtin-heuristic-filter=", this.builtinHeuristicFilter, cmdLine);
        this.addToCmd("experimental-class-define-support=", this.experimentalPredefinedClasses, cmdLine);
        this.addToCmd("experimental-unsafe-allocation-support=", this.experimentalUnsafeAllocationTracing, cmdLine);
        this.addToCmd("track-reflection-metadata=", this.trackReflectionMetadata, cmdLine);
        return cmdLine;
    }

    public Collection<String> getAgentFiles() {
        ArrayList<String> files = new ArrayList<String>(this.callerFilterFiles.size() + this.accessFilterFiles.size());
        files.addAll(this.callerFilterFiles);
        files.addAll(this.accessFilterFiles);
        files.addAll(this.agentMode.getInputFiles());
        return files;
    }

    public boolean isEnabled() {
        return !(this.agentMode instanceof DisabledAgentMode);
    }

    public static void appendOptionToValues(String option, Collection<String> values, Collection<String> target) {
        if (values != null) {
            values.stream().map(value -> option + value).forEach(target::add);
        }
    }

    public AgentMode getAgentMode() {
        return this.agentMode;
    }

    private void addToCmd(String option, Boolean value, List<String> cmdLine) {
        if (value != null) {
            cmdLine.add(option + value);
        }
    }

    private void addDefaultAccessFilter() {
        if (this.accessFilterFiles == null) {
            return;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        Path agentDir = Path.of(tempDir, new String[0]).resolve("agent-config");
        Path accessFilterFile = agentDir.resolve("access-filter.json");
        if (Files.exists(accessFilterFile, new LinkOption[0])) {
            this.accessFilterFiles.add(accessFilterFile.toString());
            return;
        }
        try (InputStream accessFilterData = AgentConfiguration.class.getResourceAsStream(DEFAULT_ACCESS_FILTER_FILE_LOCATION);){
            if (accessFilterData == null) {
                throw new IOException("Cannot access data from: /access-filter.json");
            }
            try {
                Files.createDirectory(agentDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                logger.info("Skip creation of directory " + agentDir + " (already created).");
            }
            long pid = ProcessHandle.current().pid();
            long time = System.nanoTime();
            Path tmpAccessFilter = agentDir.resolve("access-filter_" + pid + "_" + time + "_.json");
            Files.copy(accessFilterData, tmpAccessFilter, new CopyOption[0]);
            try {
                Files.move(tmpAccessFilter, accessFilterFile, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (FileAlreadyExistsException e) {
                Files.delete(tmpAccessFilter);
                logger.info(accessFilterFile + " already exists. Delete " + tmpAccessFilter);
            }
            this.accessFilterFiles.add(accessFilterFile.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot add default access-filter.json", e);
        }
    }
}

