/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.Utils;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="native-build-tools")
public class NativeExtension
extends AbstractMavenLifecycleParticipant {
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED = "junit.platform.listeners.uid.tracking.enabled";
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR = "junit.platform.listeners.uid.tracking.output.dir";
    private static final String NATIVEIMAGE_IMAGECODE = "org.graalvm.nativeimage.imagecode";

    static String testIdsDirectory(String baseDir) {
        return baseDir + File.separator + "test-ids";
    }

    static String buildAgentOption(String context, String baseDir) {
        String subdir = NativeExtension.agentOutputDirectoryFor(context, baseDir);
        return "-agentlib:native-image-agent=experimental-class-loader-support,config-output-dir=" + subdir;
    }

    private static String agentOutputDirectoryFor(String context, String baseDir) {
        return (baseDir + "/native/agent-output/" + context).replace('/', File.separatorChar);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Build build = session.getCurrentProject().getBuild();
        boolean hasAgent = NativeExtension.hasAgent(session);
        String target = build.getDirectory();
        String testIdsDir = NativeExtension.testIdsDirectory(target);
        NativeExtension.withPlugin(build, "maven-surefire-plugin", surefirePlugin -> {
            NativeExtension.configureJunitListener(surefirePlugin, testIdsDir);
            if (hasAgent) {
                NativeExtension.configureAgentForSurefire(surefirePlugin, "test", target);
            }
        });
        if (hasAgent) {
            NativeExtension.withPlugin(build, "exec-maven-plugin", execPlugin -> NativeExtension.updatePluginConfiguration(execPlugin, (exec, config) -> {
                if ("java-agent".equals(exec.getId())) {
                    Xpp3Dom commandlineArgs = NativeExtension.findOrAppend(config, "arguments");
                    Xpp3Dom[] arrayOfChildren = commandlineArgs.getChildren();
                    for (int i = 0; i < arrayOfChildren.length; ++i) {
                        commandlineArgs.removeChild(0);
                    }
                    ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>();
                    Collections.addAll(children, arrayOfChildren);
                    Xpp3Dom arg = new Xpp3Dom("argument");
                    arg.setValue(NativeExtension.buildAgentOption("exec", target));
                    children.add(0, arg);
                    arg = new Xpp3Dom("argument");
                    arg.setValue("-Dorg.graalvm.nativeimage.imagecode=agent");
                    children.add(1, arg);
                    for (Xpp3Dom child : children) {
                        commandlineArgs.addChild(child);
                    }
                    Xpp3Dom executable = NativeExtension.findOrAppend(config, "executable");
                    try {
                        executable.setValue(Utils.getNativeImage().getParent().resolve("java").toString());
                    }
                    catch (MojoExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
            NativeExtension.withPlugin(build, "native-maven-plugin", nativePlugin -> NativeExtension.updatePluginConfiguration(nativePlugin, (exec, configuration) -> {
                String context = exec.getGoals().stream().anyMatch("test"::equals) ? "test" : "exec";
                Xpp3Dom agentResourceDirectory = NativeExtension.findOrAppend(configuration, "agentResourceDirectory");
                agentResourceDirectory.setValue(NativeExtension.agentOutputDirectoryFor(context, target));
            }));
        }
    }

    private static boolean hasAgent(MavenSession session) {
        Properties systemProperties = session.getSystemProperties();
        return Boolean.parseBoolean(String.valueOf(systemProperties.getOrDefault((Object)"agent", "false")));
    }

    private static void withPlugin(Build build, String artifactId, Consumer<? super Plugin> consumer) {
        build.getPlugins().stream().filter(p -> artifactId.equals(p.getArtifactId())).findFirst().ifPresent(consumer);
    }

    private static void configureAgentForSurefire(Plugin surefirePlugin, String context, String targetDir) {
        NativeExtension.updatePluginConfiguration(surefirePlugin, (exec, configuration) -> {
            Xpp3Dom systemProperties = NativeExtension.findOrAppend(configuration, "systemProperties");
            Xpp3Dom agent = NativeExtension.findOrAppend(systemProperties, NATIVEIMAGE_IMAGECODE);
            agent.setValue("agent");
            Xpp3Dom argLine = new Xpp3Dom("argLine");
            argLine.setValue(NativeExtension.buildAgentOption(context, targetDir));
            configuration.addChild(argLine);
        });
    }

    private static void configureJunitListener(Plugin surefirePlugin, String testIdsDir) {
        NativeExtension.updatePluginConfiguration(surefirePlugin, (exec, configuration) -> {
            Xpp3Dom systemProperties = NativeExtension.findOrAppend(configuration, "systemProperties");
            Xpp3Dom junitTracking = NativeExtension.findOrAppend(systemProperties, JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED);
            Xpp3Dom testIdsProperty = NativeExtension.findOrAppend(systemProperties, JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR);
            junitTracking.setValue("true");
            testIdsProperty.setValue(testIdsDir);
        });
    }

    private static void updatePluginConfiguration(Plugin plugin, BiConsumer<PluginExecution, ? super Xpp3Dom> consumer) {
        plugin.getExecutions().forEach(exec -> {
            Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
            if (configuration == null) {
                configuration = new Xpp3Dom("configuration");
                exec.setConfiguration((Object)configuration);
            }
            consumer.accept((PluginExecution)exec, (Xpp3Dom)configuration);
        });
    }

    private static Xpp3Dom findOrAppend(Xpp3Dom parent, String childName) {
        Xpp3Dom child = parent.getChild(childName);
        if (child == null) {
            child = new Xpp3Dom(childName);
            parent.addChild(child);
        }
        return child;
    }
}

