/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.graalvm.buildtools.utils.SharedConstants;

public abstract class Utils
implements SharedConstants {
    public static final String NATIVE_IMAGE_EXE = "native-image" + (IS_WINDOWS ? ".cmd" : "");
    public static final String NATIVE_TESTS_EXE = "native-tests" + EXECUTABLE_EXTENSION;
    public static final String MAVEN_GROUP_ID = "org.graalvm.buildtools";

    public static Path getJavaHomeNativeImage(String javaHomeVariable, Boolean failFast) {
        String graalHome = System.getenv(javaHomeVariable);
        if (graalHome == null) {
            return null;
        }
        Path graalExe = Paths.get(graalHome, new String[0]).resolve("bin").resolve(NATIVE_IMAGE_EXE);
        if (!Files.exists(graalExe, new LinkOption[0]) && failFast.booleanValue()) {
            throw new RuntimeException("native-image is not installed in your " + javaHomeVariable + ".You should install it using `gu install native-image`");
        }
        return graalExe;
    }

    public static Path getNativeImageFromPath() {
        Optional<Path> exePath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> Files.exists(path.resolve(NATIVE_IMAGE_EXE), new LinkOption[0])).findFirst();
        return exePath.map(path -> path.resolve(NATIVE_IMAGE_EXE)).orElse(null);
    }

    public static Path getNativeImage() {
        Path nativeImage = Utils.getJavaHomeNativeImage("JAVA_HOME", false);
        if (nativeImage == null) {
            nativeImage = Utils.getNativeImageFromPath();
        }
        if (nativeImage == null) {
            nativeImage = Utils.getJavaHomeNativeImage("GRAALVM_HOME", true);
        }
        if (nativeImage == null) {
            throw new RuntimeException("GraalVM native-image is missing from your system.\n Make sure that GRAALVM_HOME environment variable is present.");
        }
        return nativeImage;
    }
}

