/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.graalvm.buildtools.Utils;
import org.graalvm.buildtools.maven.config.ExcludeConfigConfiguration;
import org.graalvm.buildtools.maven.config.MetadataRepositoryConfiguration;
import org.graalvm.buildtools.utils.FileUtils;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.graalvm.buildtools.utils.SharedConstants;
import org.graalvm.reachability.GraalVMReachabilityMetadataRepository;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.FileSystemRepository;

public abstract class AbstractNativeMojo
extends AbstractMojo {
    protected static final String NATIVE_IMAGE_META_INF = "META-INF/native-image";
    protected static final String NATIVE_IMAGE_PROPERTIES_FILENAME = "native-image.properties";
    protected static final String NATIVE_IMAGE_DRY_RUN = "nativeDryRun";
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution mojoExecution;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    protected File outputDirectory;
    @Parameter(property="mainClass")
    protected String mainClass;
    @Parameter(property="imageName", defaultValue="${project.artifactId}")
    protected String imageName;
    @Parameter(property="classpath")
    protected List<String> classpath;
    @Parameter(property="classesDirectory")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File defaultClassesDirectory;
    protected final List<Path> imageClasspath = new ArrayList<Path>();
    protected final Set<Path> metadataRepositoryPaths = new HashSet<Path>();
    @Parameter(property="debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="fallback", defaultValue="false")
    protected boolean fallback;
    @Parameter(property="verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="sharedLibrary", defaultValue="false")
    protected boolean sharedLibrary;
    @Parameter(property="quickBuild", defaultValue="false")
    protected boolean quickBuild;
    @Parameter(property="useArgFile")
    protected Boolean useArgFile = SharedConstants.IS_WINDOWS;
    @Parameter(property="buildArgs")
    protected List<String> buildArgs;
    @Parameter(defaultValue="${project.build.directory}/native/generated", property="resourcesConfigDirectory", required=true)
    protected File resourcesConfigDirectory;
    @Parameter(property="agentResourceDirectory")
    protected File agentResourceDirectory;
    @Parameter(property="excludeConfig")
    protected List<ExcludeConfigConfiguration> excludeConfig;
    @Parameter(property="environmentVariables")
    protected Map<String, String> environment;
    @Parameter(property="systemPropertyVariables")
    protected Map<String, String> systemProperties;
    @Parameter(property="configurationFileDirectories")
    protected List<String> configFiles;
    @Parameter(property="jvmArgs")
    protected List<String> jvmArgs;
    @Parameter(alias="metadataRepository")
    protected MetadataRepositoryConfiguration metadataRepositoryConfiguration;
    @Parameter(property="nativeDryRun", defaultValue="false")
    protected boolean dryRun;
    protected GraalVMReachabilityMetadataRepository metadataRepository;
    @Component
    protected Logger logger;
    @Component
    protected ToolchainManager toolchainManager;

    @Inject
    protected AbstractNativeMojo() {
    }

    protected List<String> getBuildArgs() throws MojoExecutionException {
        String quickBuildEnv;
        ArrayList<String> cliArgs = new ArrayList<String>();
        if (this.excludeConfig != null) {
            this.excludeConfig.forEach(entry -> {
                cliArgs.add("--exclude-config");
                cliArgs.add(entry.getJarPath());
                cliArgs.add(String.format("\"%s\"", entry.getResourcePattern()));
            });
        }
        cliArgs.add("-cp");
        cliArgs.add(this.getClasspath());
        if (this.debug) {
            cliArgs.add("-g");
        }
        if (!this.fallback) {
            cliArgs.add("--no-fallback");
        }
        if (this.verbose) {
            cliArgs.add("--verbose");
        }
        if (this.sharedLibrary) {
            cliArgs.add("--shared");
        }
        if ((quickBuildEnv = System.getenv("GRAALVM_QUICK_BUILD")) != null) {
            this.logger.warn("Quick build environment variable is set.");
            boolean bl = this.quickBuild = quickBuildEnv.isEmpty() || Boolean.parseBoolean(quickBuildEnv);
        }
        if (this.quickBuild) {
            cliArgs.add("-Ob");
        }
        cliArgs.add("-H:Path=" + this.outputDirectory.toPath().toAbsolutePath());
        cliArgs.add("-H:Name=" + this.imageName);
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry2 : this.systemProperties.entrySet()) {
                cliArgs.add("-D" + entry2.getKey() + "=" + entry2.getValue());
            }
        }
        if (this.jvmArgs != null) {
            this.jvmArgs.forEach(jvmArg -> cliArgs.add("-J" + jvmArg));
        }
        this.maybeAddGeneratedResourcesConfig(this.buildArgs);
        this.maybeAddReachabilityMetadata(this.configFiles);
        if (this.configFiles != null && !this.configFiles.isEmpty()) {
            cliArgs.add("-H:ConfigurationFileDirectories=" + this.configFiles.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(",")));
        }
        if (this.mainClass != null && !this.mainClass.equals(".")) {
            cliArgs.add("-H:Class=" + this.mainClass);
        }
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            for (String buildArg : this.buildArgs) {
                cliArgs.addAll(Arrays.asList(buildArg.split("\\s+")));
            }
        }
        if (this.useArgFile.booleanValue()) {
            return NativeImageUtils.convertToArgsFile(cliArgs);
        }
        return Collections.unmodifiableList(cliArgs);
    }

    protected Path processArtifact(Artifact artifact, String artifactType) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        if (!artifactType.equals(artifact.getType())) {
            this.logger.warn("Ignoring non-jar type ImageClasspath Entry " + artifact);
            return null;
        }
        if (!artifactFile.exists()) {
            throw new MojoExecutionException("Missing jar-file for " + artifact + ". Ensure that " + this.plugin.getArtifactId() + " runs in package phase.");
        }
        Path jarFilePath = artifactFile.toPath();
        this.logger.info("ImageClasspath Entry: " + artifact + " (" + jarFilePath.toUri() + ")");
        this.warnIfWrongMetaInfLayout(jarFilePath, artifact);
        return jarFilePath;
    }

    protected void addArtifactToClasspath(Artifact artifact) throws MojoExecutionException {
        Optional.ofNullable(this.processArtifact(artifact, "jar")).ifPresent(this.imageClasspath::add);
    }

    protected void warnIfWrongMetaInfLayout(Path jarFilePath, Artifact artifact) throws MojoExecutionException {
        block28: {
            if (jarFilePath.toFile().isDirectory()) {
                this.logger.warn("Artifact `" + jarFilePath + "` is a directory.");
                return;
            }
            URI jarFileURI = URI.create("jar:" + jarFilePath.toUri());
            try (FileSystem jarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());){
                Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                if (!Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) break block28;
                try (Stream<Path> stream = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]);){
                    List nativeImageProperties = stream.filter(p -> p.endsWith(NATIVE_IMAGE_PROPERTIES_FILENAME)).collect(Collectors.toList());
                    for (Path nativeImageProperty : nativeImageProperties) {
                        Path relativeSubDir = nativeImageMetaInfBase.relativize(nativeImageProperty).getParent();
                        boolean valid = relativeSubDir != null && relativeSubDir.getNameCount() == 2;
                        valid = valid && relativeSubDir.getName(0).toString().equals(artifact.getGroupId());
                        if (valid = valid && relativeSubDir.getName(1).toString().equals(artifact.getArtifactId())) continue;
                        String example = "META-INF/native-image/${groupId}/${artifactId}/native-image.properties";
                        this.logger.warn(nativeImageProperty.toUri() + " does not match recommended " + example + " layout.");
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Artifact " + artifact + "cannot be added to image classpath", (Exception)e);
            }
        }
    }

    protected abstract List<String> getDependencyScopes();

    protected void addDependenciesToClasspath() throws MojoExecutionException {
        this.configureMetadataRepository();
        for (Artifact dependency : this.project.getArtifacts().stream().filter(artifact -> this.getDependencyScopes().contains(artifact.getScope())).collect(Collectors.toSet())) {
            this.addArtifactToClasspath(dependency);
            this.maybeAddDependencyMetadata(dependency);
        }
    }

    protected Path getMainBuildPath() throws MojoExecutionException {
        if (this.classesDirectory != null) {
            return this.classesDirectory.toPath();
        }
        Path artifactPath = this.processArtifact(this.project.getArtifact(), this.project.getPackaging());
        if (artifactPath != null) {
            return artifactPath;
        }
        return this.defaultClassesDirectory.toPath();
    }

    protected void populateApplicationClasspath() throws MojoExecutionException {
        this.imageClasspath.add(this.getMainBuildPath());
    }

    protected void populateClasspath() throws MojoExecutionException {
        if (this.classpath != null && !this.classpath.isEmpty()) {
            this.imageClasspath.addAll(this.classpath.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toSet()));
        } else {
            this.populateApplicationClasspath();
            this.addDependenciesToClasspath();
        }
    }

    protected String getClasspath() throws MojoExecutionException {
        this.populateClasspath();
        if (this.imageClasspath.isEmpty()) {
            throw new MojoExecutionException("Image classpath is empty. Check if your classpath configuration is correct.");
        }
        return this.imageClasspath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }

    protected void buildImage() throws MojoExecutionException {
        Path nativeImageExecutable = Utils.getNativeImage(this.logger);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString());
            processBuilder.command().addAll(this.getBuildArgs());
            if (this.environment != null) {
                processBuilder.environment().putAll(this.environment);
            }
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Failed creating output directory");
            }
            processBuilder.directory(this.outputDirectory);
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.logger.info("Executing: " + commandString);
            if (this.dryRun) {
                this.logger.warn("Skipped native-image building due to `nativeDryRun` being specified.");
                return;
            }
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
        }
    }

    protected void maybeAddGeneratedResourcesConfig(List<String> into) {
        File[] dirs;
        Stream<File> configDirs;
        String value;
        if ((this.resourcesConfigDirectory.exists() || this.agentResourceDirectory != null) && !(value = (configDirs = Stream.concat((dirs = this.resourcesConfigDirectory.listFiles()) == null ? Stream.empty() : Arrays.stream(dirs), this.agentResourceDirectory == null ? Stream.empty() : Stream.of(this.agentResourceDirectory).filter(File::isDirectory))).map(File::getAbsolutePath).collect(Collectors.joining(","))).isEmpty()) {
            into.add("-H:ConfigurationFileDirectories=" + value);
            if (this.agentResourceDirectory != null && this.agentResourceDirectory.isDirectory()) {
                into.add("-H:+AllowIncompleteClasspath");
            }
        }
    }

    protected boolean isMetadataRepositoryEnabled() {
        return this.metadataRepositoryConfiguration != null && this.metadataRepositoryConfiguration.isEnabled();
    }

    protected void configureMetadataRepository() {
        if (this.isMetadataRepositoryEnabled()) {
            Path repoPath = null;
            Path destinationRoot = this.outputDirectory.toPath().resolve("graalvm-reachability-metadata");
            if (Files.exists(destinationRoot, new LinkOption[0]) && !Files.isDirectory(destinationRoot, new LinkOption[0])) {
                throw new RuntimeException("Metadata repository must be a directory, please remove regular file at: " + destinationRoot);
            }
            try {
                Files.createDirectories(destinationRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.metadataRepositoryConfiguration.getLocalPath() != null) {
                Path localPath = this.metadataRepositoryConfiguration.getLocalPath().toPath();
                Path destination = this.outputDirectory.toPath().resolve(FileUtils.hashFor((URI)localPath.toUri()));
                repoPath = this.unzipLocalMetadata(localPath, destination);
            } else {
                Path destination;
                URL targetUrl = this.metadataRepositoryConfiguration.getUrl();
                if (targetUrl == null) {
                    String version = this.metadataRepositoryConfiguration.getVersion();
                    if (version == null) {
                        version = "0.1.0";
                    }
                    String metadataUrl = String.format("https://github.com/oracle/graalvm-reachability-metadata/releases/download/%1$s/graalvm-reachability-metadata-%1$s.zip", version);
                    try {
                        targetUrl = new URI(metadataUrl).toURL();
                        this.metadataRepositoryConfiguration.setUrl(targetUrl);
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    destination = destinationRoot.resolve(FileUtils.hashFor((URI)targetUrl.toURI()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (Files.exists(destination, new LinkOption[0])) {
                    repoPath = destination;
                } else {
                    Optional<Path> download = this.downloadMetadata(targetUrl, destination);
                    if (download.isPresent()) {
                        this.logger.info("Downloaded GraalVM reachability metadata repository from " + targetUrl);
                        repoPath = this.unzipLocalMetadata(download.get(), destination);
                    }
                }
            }
            if (repoPath == null) {
                this.logger.warn("GraalVM reachability metadata repository is enabled, but no repository has been configured");
            } else {
                this.metadataRepository = new FileSystemRepository(repoPath, new FileSystemRepository.Logger(){

                    public void log(String groupId, String artifactId, String version, Supplier<String> message) {
                        AbstractNativeMojo.this.logger.info(String.format("[graalvm reachability metadata repository for %s:%s:%s]: %s", groupId, artifactId, version, message.get()));
                    }
                });
            }
        }
    }

    public boolean isArtifactExcludedFromMetadataRepository(Artifact dependency) {
        if (this.metadataRepositoryConfiguration == null) {
            return false;
        }
        return this.metadataRepositoryConfiguration.isArtifactExcluded(dependency);
    }

    protected void maybeAddReachabilityMetadata(List<String> configDirs) {
        String arg;
        if (this.isMetadataRepositoryEnabled() && !this.metadataRepositoryPaths.isEmpty() && !(arg = this.metadataRepositoryPaths.stream().map(Path::toAbsolutePath).map(Path::toFile).map(File::getAbsolutePath).collect(Collectors.joining(","))).isEmpty()) {
            configDirs.add(arg);
        }
    }

    protected void maybeAddDependencyMetadata(Artifact dependency) {
        if (this.isMetadataRepositoryEnabled() && this.metadataRepository != null && !this.isArtifactExcludedFromMetadataRepository(dependency)) {
            this.metadataRepositoryPaths.addAll(this.metadataRepository.findConfigurationDirectoriesFor(q -> {
                q.useLatestConfigWhenVersionIsUntested();
                q.forArtifact(artifact -> {
                    artifact.gav(String.join((CharSequence)":", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
                    this.getMetadataVersion(dependency).ifPresent(arg_0 -> ((Query.ArtifactQuery)artifact).forceConfigVersion(arg_0));
                });
            }));
        }
    }

    protected Optional<String> getMetadataVersion(Artifact dependency) {
        if (this.metadataRepositoryConfiguration == null) {
            return Optional.empty();
        }
        return this.metadataRepositoryConfiguration.getMetadataVersion(dependency);
    }

    protected Optional<Path> downloadMetadata(URL url, Path destination) {
        return FileUtils.download((URL)url, (Path)destination, arg_0 -> ((Logger)this.logger).error(arg_0));
    }

    protected Path unzipLocalMetadata(Path localPath, Path destination) {
        if (Files.exists(localPath, new LinkOption[0])) {
            if (FileUtils.isZip((Path)localPath)) {
                if (!Files.exists(destination, new LinkOption[0]) && !destination.toFile().mkdirs()) {
                    throw new RuntimeException("Failed creating destination directory");
                }
                FileUtils.extract((Path)localPath, (Path)destination, arg_0 -> ((Logger)this.logger).error(arg_0));
                return destination;
            }
            if (Files.isDirectory(localPath, new LinkOption[0])) {
                return localPath;
            }
            this.logger.warn("Unable to extract metadata repository from " + localPath + ". It needs to be either a ZIP file or an exploded directory");
        } else {
            this.logger.error("GraalVM reachability metadata repository path does not exist: " + localPath);
        }
        return null;
    }
}

